#include "random.h"

#include <stdio.h>
#include <stdlib.h>

#define	RAND_TABLE_MAX	0x8000

const unsigned char rand_table[ RAND_TABLE_MAX ] = {
		0x29,0x23,0xbe,0x84,0xe1,0x6c,0xd6,0xae,0x52,0x90,0x49,0xf1,0xf1,0xbb,0xe9,0xeb,		// 0000 - 000F
		0xb3,0xa6,0xdb,0x3c,0x87,0x0c,0x3e,0x99,0x24,0x5e,0x0d,0x1c,0x06,0xb7,0x47,0xde,		// 0010 - 001F
		0xb3,0x12,0x4d,0xc8,0x43,0xbb,0x8b,0xa6,0x1f,0x03,0x5a,0x7d,0x09,0x38,0x25,0x1f,		// 0020 - 002F
		0x5d,0xd4,0xcb,0xfc,0x96,0xf5,0x45,0x3b,0x13,0x0d,0x89,0x0a,0x1c,0xdb,0xae,0x32,		// 0030 - 003F
		0x20,0x9a,0x50,0xee,0x40,0x78,0x36,0xfd,0x12,0x49,0x32,0xf6,0x9e,0x7d,0x49,0xdc,		// 0040 - 004F
		0xad,0x4f,0x14,0xf2,0x44,0x40,0x66,0xd0,0x6b,0xc4,0x30,0xb7,0x32,0x3b,0xa1,0x22,		// 0050 - 005F
		0xf6,0x22,0x91,0x9d,0xe1,0x8b,0x1f,0xda,0xb0,0xca,0x99,0x02,0xb9,0x72,0x9d,0x49,		// 0060 - 006F
		0x2c,0x80,0x7e,0xc5,0x99,0xd5,0xe9,0x80,0xb2,0xea,0xc9,0xcc,0x53,0xbf,0x67,0xd6,		// 0070 - 007F
		0xbf,0x14,0xd6,0x7e,0x2d,0xdc,0x8e,0x66,0x83,0xef,0x57,0x49,0x61,0xff,0x69,0x8f,		// 0080 - 008F
		0x61,0xcd,0xd1,0x1e,0x9d,0x9c,0x16,0x72,0x72,0xe6,0x1d,0xf0,0x84,0x4f,0x4a,0x77,		// 0090 - 009F
		0x02,0xd7,0xe8,0x39,0x2c,0x53,0xcb,0xc9,0x12,0x1e,0x33,0x74,0x9e,0x0c,0xf4,0xd5,		// 00A0 - 00AF
		0xd4,0x9f,0xd4,0xa4,0x59,0x7e,0x35,0xcf,0x32,0x22,0xf4,0xcc,0xcf,0xd3,0x90,0x2d,		// 00B0 - 00BF
		0x48,0xd3,0x8f,0x75,0xe6,0xd9,0x1d,0x2a,0xe5,0xc0,0xf7,0x2b,0x78,0x81,0x87,0x44,		// 00C0 - 00CF
		0x0e,0x5f,0x50,0x00,0xd4,0x61,0x8d,0xbe,0x7b,0x05,0x15,0x07,0x3b,0x33,0x82,0x1f,		// 00D0 - 00DF
		0x18,0x70,0x92,0xda,0x64,0x54,0xce,0xb1,0x85,0x3e,0x69,0x15,0xf8,0x46,0x6a,0x04,		// 00E0 - 00EF
		0x96,0x73,0x0e,0xd9,0x16,0x2f,0x67,0x68,0xd4,0xf7,0x4a,0x4a,0xd0,0x57,0x68,0x76,		// 00F0 - 00FF
		0xfa,0x16,0xbb,0x11,0xad,0xae,0x24,0x88,0x79,0xfe,0x52,0xdb,0x25,0x43,0xe5,0x3c,		// 0100 - 010F
		0xf4,0x45,0xd3,0xd8,0x28,0xce,0x0b,0xf5,0xc5,0x60,0x59,0x3d,0x97,0x27,0x8a,0x59,		// 0110 - 011F
		0x76,0x2d,0xd0,0xc2,0xc9,0xcd,0x68,0xd4,0x49,0x6a,0x79,0x25,0x08,0x61,0x40,0x14,		// 0120 - 012F
		0xb1,0x3b,0x6a,0xa5,0x11,0x28,0xc1,0x8c,0xd6,0xa9,0x0b,0x87,0x97,0x8c,0x2f,0xf1,		// 0130 - 013F
		0x15,0x1d,0x9a,0x95,0xc1,0x9b,0xe1,0xc0,0x7e,0xe9,0xa8,0x9a,0xa7,0x86,0xc2,0xb5,		// 0140 - 014F
		0x54,0xbf,0x9a,0xe7,0xd9,0x23,0xd1,0x55,0x90,0x38,0x28,0xd1,0xd9,0x6c,0xa1,0x66,		// 0150 - 015F
		0x5e,0x4e,0xe1,0x30,0x9c,0xfe,0xd9,0x71,0x9f,0xe2,0xa5,0xe2,0x0c,0x9b,0xb4,0x47,		// 0160 - 016F
		0x65,0x38,0x2a,0x46,0x89,0xa9,0x82,0x79,0x7a,0x76,0x78,0xc2,0x63,0xb1,0x26,0xdf,		// 0170 - 017F
		0xda,0x29,0x6d,0x3e,0x62,0xe0,0x96,0x12,0x34,0xbf,0x39,0xa6,0x3f,0x89,0x5e,0xf1,		// 0180 - 018F
		0x6d,0x0e,0xe3,0x6c,0x28,0xa1,0x1e,0x20,0x1d,0xcb,0xc2,0x03,0x3f,0x41,0x07,0x84,		// 0190 - 019F
		0x0f,0x14,0x05,0x65,0x1b,0x28,0x61,0xc9,0xc5,0xe7,0x2c,0x8e,0x46,0x36,0x08,0xdc,		// 01A0 - 01AF
		0xf3,0xa8,0x8d,0xfe,0xbe,0xf2,0xeb,0x71,0xff,0xa0,0xd0,0x3b,0x75,0x06,0x8c,0x7e,		// 01B0 - 01BF
		0x87,0x78,0x73,0x4d,0xd0,0xbe,0x82,0xbe,0xdb,0xc2,0x46,0x41,0x2b,0x8c,0xfa,0x30,		// 01C0 - 01CF
		0x7f,0x70,0xf0,0xa7,0x54,0x86,0x32,0x95,0xaa,0x5b,0x68,0x13,0x0b,0xe6,0xfc,0xf5,		// 01D0 - 01DF
		0xca,0xbe,0x7d,0x9f,0x89,0x8a,0x41,0x1b,0xfd,0xb8,0x4f,0x68,0xf6,0x72,0x7b,0x14,		// 01E0 - 01EF
		0x99,0xcd,0xd3,0x0d,0xf0,0x44,0x3a,0xb4,0xa6,0x66,0x53,0x33,0x0b,0xcb,0xa1,0x10,		// 01F0 - 01FF
		0x5e,0x4c,0xec,0x03,0x4c,0x73,0xe6,0x05,0xb4,0x31,0x0e,0xaa,0xad,0xcf,0xd5,0xb0,		// 0200 - 020F
		0xca,0x27,0xff,0xd8,0x9d,0x14,0x4d,0xf4,0x79,0x27,0x59,0x42,0x7c,0x9c,0xc1,0xf8,		// 0210 - 021F
		0xcd,0x8c,0x87,0x20,0x23,0x64,0xb8,0xa6,0x87,0x95,0x4c,0xb0,0x5a,0x8d,0x4e,0x2d,		// 0220 - 022F
		0x99,0xe7,0x3d,0xb1,0x60,0xde,0xb1,0x80,0xad,0x08,0x41,0xe9,0x67,0x41,0xa5,0xd5,		// 0230 - 023F
		0x9f,0xe4,0x18,0x9f,0x15,0x42,0x00,0x26,0xfe,0x4c,0xd1,0x21,0x04,0x93,0x2f,0xb3,		// 0240 - 024F
		0x8f,0x73,0x53,0x40,0x43,0x8a,0xaf,0x7e,0xca,0x6f,0xd5,0xcf,0xd3,0xa1,0x95,0xce,		// 0250 - 025F
		0x5a,0xbe,0x65,0x27,0x2a,0xf6,0x07,0xad,0xa1,0xbe,0x65,0xa6,0xb4,0xc9,0xc0,0x69,		// 0260 - 026F
		0x32,0x34,0x09,0x2c,0x4d,0x01,0x8f,0x17,0x56,0xc6,0xdb,0x9d,0xc8,0xa6,0xd8,0x0b,		// 0270 - 027F
		0x88,0x81,0x38,0x61,0x6b,0x68,0x12,0x62,0xf9,0x54,0xd0,0xe7,0x71,0x17,0x48,0x78,		// 0280 - 028F
		0x0d,0x92,0x29,0x1d,0x86,0x29,0x99,0x72,0xdb,0x74,0x1c,0xfa,0x4f,0x37,0xb8,0xb5,		// 0290 - 029F
		0xb0,0x95,0x57,0xf5,0xdf,0x80,0x6c,0x6d,0x8d,0x74,0xd9,0x8b,0x43,0x65,0x11,0x08,		// 02A0 - 02AF
		0xa5,0xf6,0x79,0xbd,0xf7,0xeb,0x15,0xb8,0xe0,0xe1,0x60,0x8f,0x6e,0x3c,0x7b,0xf4,		// 02B0 - 02BF
		0x5b,0x62,0x8a,0x8a,0x8f,0x27,0x5c,0xf7,0xe5,0x87,0x4a,0x3b,0x32,0x9b,0x61,0x40,		// 02C0 - 02CF
		0x84,0xc6,0xc3,0xb1,0xa7,0x30,0x4a,0x10,0xee,0x75,0x6f,0x03,0x2f,0x9e,0x6a,0xef,		// 02D0 - 02DF
		0x10,0x50,0x9b,0xc8,0x81,0x43,0x29,0x28,0x8a,0xf6,0xe9,0x9e,0x47,0xa1,0x81,0x48,		// 02E0 - 02EF
		0x31,0x6c,0xcd,0xa4,0x9e,0xde,0x81,0xa3,0x8c,0x98,0x10,0xff,0x9a,0x43,0xcd,0xcf,		// 02F0 - 02FF
		0x57,0xc7,0x50,0x59,0xbf,0xbd,0x1c,0x27,0x03,0x28,0x7f,0x5d,0x89,0x5f,0xb9,0x49,		// 0300 - 030F
		0x34,0x4e,0x60,0x3c,0xe5,0xde,0x02,0x98,0x42,0xb2,0x0d,0x2b,0xb6,0x14,0xec,0xbb,		// 0310 - 031F
		0xb8,0x2f,0x73,0xe2,0x51,0x7e,0x7d,0x1d,0xd8,0x84,0xd3,0x1f,0x01,0xbe,0x50,0x6b,		// 0320 - 032F
		0x16,0xd6,0x43,0x21,0x83,0x19,0x15,0x18,0x98,0x2b,0x2c,0x2e,0x8b,0xf9,0x0e,0xdc,		// 0330 - 033F
		0xbc,0xf0,0xca,0x0e,0x3d,0x6d,0x94,0x31,0x92,0x74,0xaf,0x8d,0xb5,0xa4,0x90,0xd5,		// 0340 - 034F
		0x5e,0x6a,0x40,0xfc,0x80,0x76,0x02,0x4b,0x17,0x6b,0x36,0xb1,0x21,0xdb,0x7d,0x5a,		// 0350 - 035F
		0xea,0x72,0x1e,0x82,0x8d,0x71,0xa8,0x8c,0xb8,0x5e,0xd9,0x4e,0xaf,0xfa,0xbf,0xb0,		// 0360 - 036F
		0x94,0x74,0x1d,0x75,0xe5,0xdc,0x10,0x58,0x46,0xda,0xf2,0x5b,0x81,0xa0,0x7f,0x5c,		// 0370 - 037F
		0xcb,0x1d,0x36,0xe9,0x49,0x74,0x02,0x55,0xd2,0xac,0x1a,0x0b,0xf7,0xa9,0x26,0x23,		// 0380 - 038F
		0x40,0x5b,0xa3,0x33,0xb9,0x35,0x88,0x68,0xad,0xe1,0x2a,0xd5,0xb2,0x32,0x5d,0x0a,		// 0390 - 039F
		0xe5,0x5a,0xdc,0xe9,0x77,0x5d,0xeb,0xb5,0x69,0xc5,0x3a,0x6c,0x93,0x98,0x0d,0x57,		// 03A0 - 03AF
		0xeb,0x87,0x9a,0xdf,0x04,0x68,0xb2,0xa2,0xd5,0xe6,0xa4,0xc6,0xbc,0x77,0x5f,0x8d,		// 03B0 - 03BF
		0xc3,0x8f,0xd6,0x2a,0x21,0x14,0xa9,0xd4,0x04,0x11,0x01,0x18,0x8d,0xae,0xbb,0x73,		// 03C0 - 03CF
		0x1c,0x60,0xca,0x20,0xcf,0x5d,0xd6,0x2f,0x45,0x53,0x29,0xd7,0xa8,0x59,0xcc,0x0d,		// 03D0 - 03DF
		0xea,0x26,0xed,0x55,0x4e,0x80,0x84,0xd9,0x2b,0xf8,0x37,0xb8,0xed,0xd5,0x7a,0xa0,		// 03E0 - 03EF
		0x5c,0x4e,0xfa,0x9f,0x21,0xfc,0x3c,0x36,0x85,0x8e,0x81,0xb0,0x7d,0xbf,0xee,0xb1,		// 03F0 - 03FF
		0xe4,0x85,0xe9,0x12,0x07,0x8b,0xc6,0xec,0x66,0xe2,0xa3,0xf3,0xb9,0xf4,0x90,0x06,		// 0400 - 040F
		0x32,0xb9,0xf4,0x04,0x02,0x2d,0x2c,0xe0,0x1e,0x01,0x74,0xf8,0x43,0x90,0x0b,0xa2,		// 0410 - 041F
		0x37,0x16,0x92,0x08,0x53,0x1c,0xb5,0x37,0x3e,0x37,0x0e,0x72,0xfb,0xf2,0x46,0xcc,		// 0420 - 042F
		0x26,0x09,0x7e,0xf6,0x7a,0xd8,0xed,0x55,0x97,0x12,0xca,0x57,0x02,0xb6,0x6c,0x08,		// 0430 - 043F
		0x6e,0x3f,0xb0,0xe0,0x3a,0x1c,0x9b,0xdf,0x3a,0x5f,0x40,0xdd,0xba,0xb9,0xe4,0x1b,		// 0440 - 044F
		0xc0,0xa6,0x61,0x1d,0x92,0xe5,0xc8,0xbc,0x78,0x2b,0x4a,0x77,0xc3,0x18,0x59,0x0a,		// 0450 - 045F
		0x0e,0x6a,0x0a,0x42,0xc4,0x71,0xbe,0x0f,0xe3,0xc3,0x01,0xdb,0xff,0x30,0xb2,0x1a,		// 0460 - 046F
		0x89,0xf8,0x65,0x22,0x51,0x3c,0x05,0x3d,0x4a,0xb3,0xbe,0xfd,0x8d,0x9e,0x19,0xd0,		// 0470 - 047F
		0xa1,0xfe,0x69,0xd4,0xfa,0x04,0x67,0xed,0xbf,0xc9,0x19,0x14,0xd1,0x3f,0xf8,0xf2,		// 0480 - 048F
		0x08,0x68,0x51,0xad,0xc0,0xc5,0xec,0x02,0x94,0x12,0xec,0x94,0x69,0x30,0xf6,0x83,		// 0490 - 049F
		0xaf,0x63,0x95,0x41,0xe3,0xbd,0xdd,0xa1,0x58,0xda,0x4f,0x31,0x38,0xce,0xfd,0xca,		// 04A0 - 04AF
		0xc5,0x5c,0xef,0x65,0xe5,0x69,0xc4,0x30,0xde,0xaf,0x9c,0xe2,0x5e,0xb6,0x36,0x4b,		// 04B0 - 04BF
		0xbe,0x00,0x56,0x2f,0x87,0x84,0x6a,0x54,0x36,0x5f,0x6c,0xda,0x3c,0xc5,0x0a,0xcb,		// 04C0 - 04CF
		0x49,0x3d,0x05,0xf3,0xca,0x0e,0xd7,0xf2,0xb1,0xf4,0x98,0x8f,0x74,0x18,0x22,0x4f,		// 04D0 - 04DF
		0x58,0x3f,0x74,0x47,0xef,0x42,0x54,0x2e,0xdf,0xbe,0x39,0xb6,0xe6,0x0c,0x67,0x1c,		// 04E0 - 04EF
		0x1b,0x74,0x5c,0xfe,0x77,0x9d,0x6b,0x6e,0x93,0x48,0xa7,0x44,0xb3,0x3e,0x02,0xb8,		// 04F0 - 04FF
		0x04,0x87,0xb6,0x30,0x22,0xdd,0xe4,0x56,0xdd,0x61,0x7b,0x6e,0x3d,0x8c,0x5c,0xe7,		// 0500 - 050F
		0xc4,0x67,0xbc,0x2f,0xf2,0xff,0xc9,0xcc,0x0f,0x13,0x90,0xa9,0x24,0x11,0x1e,0xad,		// 0510 - 051F
		0x4b,0x41,0xe5,0x92,0x28,0x3f,0x62,0xf5,0xb8,0xae,0xfd,0xa9,0x49,0x2b,0x31,0x51,		// 0520 - 052F
		0xca,0x80,0xec,0x2e,0x45,0x1a,0x39,0x35,0xaa,0xbe,0x1c,0x65,0xce,0x77,0xbd,0x57,		// 0530 - 053F
		0xb3,0xd3,0xc9,0x17,0x0a,0x4e,0x16,0x32,0xf6,0x0f,0x86,0x10,0x13,0xd2,0x2d,0x84,		// 0540 - 054F
		0xb7,0x26,0xb6,0xa2,0x78,0xd8,0x02,0xd1,0xee,0xaf,0x13,0x21,0xba,0x59,0x29,0xde,		// 0550 - 055F
		0xc6,0xa6,0x2a,0x65,0xcf,0xf4,0x47,0x36,0x21,0xeb,0xdd,0x4b,0xa2,0x6a,0x99,0xa8,		// 0560 - 056F
		0x12,0xc0,0xe0,0x34,0x91,0x20,0x6e,0xc7,0x62,0x4f,0x3d,0x84,0xee,0xa0,0xa8,0x69,		// 0570 - 057F
		0x0c,0x22,0xd0,0x24,0x7f,0x18,0x3f,0x28,0xc0,0xa9,0xcb,0x01,0xff,0xd9,0xbd,0xe4,		// 0580 - 058F
		0x64,0xb8,0x33,0x8b,0x9a,0xd9,0xc3,0x40,0x8e,0x06,0x61,0x37,0x74,0x32,0x83,0x20,		// 0590 - 059F
		0x0c,0xaf,0x83,0xfd,0x23,0xa2,0x44,0x31,0x5c,0xb3,0x18,0xda,0x30,0x09,0xe1,0x61,		// 05A0 - 05AF
		0x34,0x75,0x77,0x50,0x9a,0xed,0x4a,0x63,0xfb,0x3d,0x49,0xe1,0x54,0xf9,0x02,0x2c,		// 05B0 - 05BF
		0x4e,0xb6,0x0a,0x97,0xc2,0x79,0x9f,0x79,0x7c,0x70,0x8c,0x80,0x3f,0xe0,0x4d,0x47,		// 05C0 - 05CF
		0x0a,0x5f,0x74,0x2a,0x9a,0x43,0x4b,0x59,0x30,0x5a,0xbb,0x2b,0x94,0xdc,0x6c,0xb5,		// 05D0 - 05DF
		0x5a,0x9d,0x2e,0x9c,0x64,0x87,0x98,0x27,0xa8,0x48,0xee,0x98,0x33,0x48,0x48,0xbd,		// 05E0 - 05EF
		0x6e,0xde,0xf1,0xc2,0xa1,0xc3,0x0e,0x49,0xb5,0xc7,0x80,0xbc,0x3e,0xc2,0x0b,0xe2,		// 05F0 - 05FF
		0xb9,0xce,0xb7,0xb1,0x11,0xb3,0x76,0x64,0x69,0xa3,0x08,0xcd,0x15,0x28,0x1c,0xeb,		// 0600 - 060F
		0xe9,0x5a,0xb8,0xbf,0xb7,0x55,0xda,0x5c,0x13,0xea,0x60,0x3e,0x59,0x95,0x25,0xdc,		// 0610 - 061F
		0xf2,0xaf,0x6d,0x80,0xd2,0xe5,0x83,0x57,0x45,0xe9,0xa0,0xc4,0xec,0x67,0x0f,0xfa,		// 0620 - 062F
		0x02,0x3b,0x8f,0xca,0xe4,0xe1,0xf9,0xb9,0xd1,0x2d,0x22,0x56,0xee,0x3c,0x03,0xcb,		// 0630 - 063F
		0x8d,0xaa,0x17,0xb1,0xae,0x05,0x05,0x29,0xc6,0x82,0x7f,0x28,0xc0,0xef,0x6a,0x12,		// 0640 - 064F
		0x42,0xe9,0x3f,0x8b,0x31,0x4f,0xb1,0x8a,0x77,0xf7,0x90,0xae,0x04,0x9f,0xed,0xd6,		// 0650 - 065F
		0x12,0x26,0x7f,0xec,0xae,0xfc,0x45,0x01,0x74,0xd7,0x6d,0x9f,0x9a,0xa7,0x75,0x5a,		// 0660 - 066F
		0x30,0xcd,0x90,0xa9,0xa5,0x87,0x4b,0xf4,0x8e,0xaf,0x70,0xee,0xa3,0xa6,0x2a,0x25,		// 0670 - 067F
		0x0a,0x8b,0x6b,0xd8,0xd9,0xb0,0x8b,0x08,0xd6,0x4e,0x32,0xd1,0x81,0x77,0x77,0xfb,		// 0680 - 068F
		0x54,0x4d,0x49,0xcd,0x49,0x72,0x0e,0x21,0x9d,0xbf,0x8b,0xbe,0xd3,0x39,0x04,0xe1,		// 0690 - 069F
		0xfd,0x40,0xa4,0x1d,0x37,0x0a,0x1f,0x65,0x74,0x50,0x95,0x68,0x7d,0x47,0xba,0x1d,		// 06A0 - 06AF
		0x36,0xd2,0x34,0x9e,0x23,0xf6,0x44,0x39,0x2c,0x8e,0xa9,0xc4,0x9d,0x40,0xc1,0x32,		// 06B0 - 06BF
		0x71,0xaf,0xf2,0x64,0xd0,0xf2,0x48,0x41,0xd6,0x46,0x5f,0x09,0x96,0xff,0x84,0xe6,		// 06C0 - 06CF
		0x5f,0xc5,0x17,0xc5,0x3e,0xfc,0x33,0x63,0xc3,0x84,0x92,0xab,0x08,0xa3,0xaa,0x3f,		// 06D0 - 06DF
		0xf0,0x3f,0x1c,0x55,0xad,0x51,0x4f,0xc4,0x85,0x96,0x58,0x5e,0xd5,0x88,0x1e,0x81,		// 06E0 - 06EF
		0x56,0x8c,0xbb,0xe9,0x9f,0x6d,0x25,0xc8,0xeb,0x09,0x0d,0x19,0x1d,0x4a,0x07,0x31,		// 06F0 - 06FF
		0x01,0x58,0xec,0x97,0xd5,0x0d,0x7c,0x15,0x08,0xaa,0x48,0x0f,0x41,0xc8,0xd0,0x14,		// 0700 - 070F
		0xa3,0x91,0xe8,0xb3,0x50,0x2f,0x60,0x90,0x2b,0x85,0xe3,0xb7,0xe3,0x1d,0x20,0x2f,		// 0710 - 071F
		0x2d,0x62,0x28,0xd3,0x50,0x10,0x17,0x5d,0xe7,0xe8,0xf7,0xc4,0xe2,0xa8,0xe1,0xc8,		// 0720 - 072F
		0xcf,0x3a,0x65,0xca,0x58,0x2c,0x2d,0xe2,0x0c,0x60,0xdc,0x2c,0x62,0x05,0x3c,0x62,		// 0730 - 073F
		0xfa,0xc5,0x99,0xb0,0x27,0x40,0x68,0xc3,0xab,0xba,0x2d,0x24,0xc1,0x10,0x9b,0xc4,		// 0740 - 074F
		0x61,0xf1,0xfc,0xd8,0xbf,0x4a,0xd3,0xe6,0x15,0x02,0xc0,0x20,0xa2,0xe8,0xa5,0xf2,		// 0750 - 075F
		0xf2,0xea,0x07,0xd7,0x61,0x87,0xb7,0x70,0xdb,0x87,0xb1,0xd7,0xe5,0xe9,0x44,0x31,		// 0760 - 076F
		0xe1,0x1d,0x73,0x82,0x8d,0x73,0x9c,0xc6,0xce,0xd4,0x57,0x3d,0xac,0xb0,0xa1,0x06,		// 0770 - 077F
		0x9d,0x37,0x3a,0xef,0x06,0xcc,0x4b,0x8c,0xff,0xb6,0x4c,0x86,0x57,0x19,0x25,0x36,		// 0780 - 078F
		0xd7,0x25,0x93,0x72,0xcb,0x8e,0xce,0xa7,0xbf,0x3c,0x69,0x28,0x87,0x43,0x79,0xc6,		// 0790 - 079F
		0x82,0x15,0xf9,0xa1,0x1f,0xf7,0x6d,0x3e,0x9f,0xb1,0xc6,0xd9,0x1d,0x8a,0x86,0xfc,		// 07A0 - 07AF
		0xcc,0x73,0x24,0x50,0x81,0x83,0xb2,0xb4,0x71,0xa3,0xbd,0x8c,0x3b,0x8b,0x75,0x5b,		// 07B0 - 07BF
		0x29,0xed,0x0d,0x95,0xb2,0xef,0x65,0xae,0x44,0xdf,0xe7,0x77,0x41,0x22,0xaf,0xaa,		// 07C0 - 07CF
		0x48,0x6e,0xee,0xc3,0xb5,0x3a,0x90,0x12,0x6b,0x72,0x1c,0x0f,0xd1,0x6e,0xdc,0xed,		// 07D0 - 07DF
		0x1a,0x25,0x3f,0x72,0xca,0x9e,0x7b,0x05,0x75,0xa8,0x76,0x09,0xca,0xcb,0xe7,0x69,		// 07E0 - 07EF
		0xd1,0x7e,0xb8,0x74,0x71,0x9a,0xb0,0xec,0x35,0x0f,0x4e,0x59,0x50,0xd6,0xf8,0xa3,		// 07F0 - 07FF
		0xde,0x27,0x55,0xe0,0x6c,0xeb,0xf7,0x6b,0xbb,0x74,0x3d,0x36,0xc1,0x6c,0x77,0x61,		// 0800 - 080F
		0xf1,0x0b,0x4c,0x0b,0xbc,0x8d,0x59,0x68,0x58,0xe4,0x1b,0x13,0xc0,0xaa,0x0f,0xa6,		// 0810 - 081F
		0xfc,0x59,0x17,0x89,0xa2,0xbe,0x20,0x07,0x9d,0xab,0x02,0xa7,0x2d,0xed,0xa7,0xb9,		// 0820 - 082F
		0x2f,0x7d,0x70,0x2f,0x9f,0xfb,0xd4,0xae,0x5b,0x57,0x4b,0xe5,0x29,0xd2,0x6a,0x1e,		// 0830 - 083F
		0xfc,0x25,0x4f,0x12,0x73,0xff,0x3f,0x02,0xa3,0xb5,0x8e,0x03,0x16,0x35,0xbf,0x9a,		// 0840 - 084F
		0x13,0x3d,0xed,0x88,0x20,0xca,0x6a,0xe7,0xc6,0xd2,0xa5,0x76,0x94,0x35,0x51,0x32,		// 0850 - 085F
		0x67,0xf2,0xc3,0x26,0xe8,0x96,0x9c,0x83,0x55,0xfb,0xa9,0xf3,0x85,0x2e,0x07,0x2b,		// 0860 - 086F
		0x26,0xb1,0x8b,0xbf,0x4a,0xe3,0x60,0x3b,0x22,0xbc,0xf2,0x6f,0x08,0xbd,0x0b,0x0a,		// 0870 - 087F
		0xc3,0x27,0x3c,0x6b,0x07,0x6c,0x7f,0xb3,0x3c,0xe3,0x1a,0x1f,0x80,0xbf,0xc7,0x95,		// 0880 - 088F
		0xef,0x42,0x11,0x7c,0x22,0x2e,0x01,0xd1,0xf5,0x7d,0xfa,0x77,0x8e,0x51,0xe2,0xcf,		// 0890 - 089F
		0x9b,0x2e,0x82,0x89,0xda,0x67,0x30,0xba,0xdf,0xd6,0xab,0x2e,0x12,0xd0,0x46,0xff,		// 08A0 - 08AF
		0xf7,0x58,0x49,0x66,0xb2,0x93,0x94,0xd2,0xca,0x7d,0x85,0x37,0x2d,0xd9,0x1c,0xa9,		// 08B0 - 08BF
		0x74,0x6e,0x5d,0x29,0x69,0x70,0xf6,0xbf,0xc6,0x3d,0x22,0xc9,0x40,0x4a,0xcd,0x92,		// 08C0 - 08CF
		0xc4,0x5c,0xf9,0x26,0x01,0xfb,0x60,0x65,0x26,0x23,0x5b,0x57,0xed,0x3e,0x02,0xbf,		// 08D0 - 08DF
		0xd8,0x4f,0x95,0xf3,0xba,0x70,0x1b,0xea,0x7a,0x7e,0x48,0x97,0x14,0x13,0xa4,0x75,		// 08E0 - 08EF
		0xe0,0xb4,0xea,0x64,0x17,0x4c,0xae,0xb3,0x93,0xd9,0x43,0x7e,0xd6,0x66,0xdc,0x3a,		// 08F0 - 08FF
		0x4e,0x39,0xf1,0x8e,0xd8,0x4d,0xe5,0x64,0x82,0x03,0xe5,0x41,0x95,0x14,0x13,0xd1,		// 0900 - 090F
		0xd3,0xca,0xe4,0xc7,0xfd,0x70,0xc6,0xe4,0x98,0x07,0x07,0x54,0xf1,0x3a,0xf2,0x41,		// 0910 - 091F
		0x5f,0x94,0x3b,0xa3,0xc8,0xf1,0x9d,0x55,0x66,0x32,0xc1,0x6e,0xcb,0x35,0x62,0xce,		// 0920 - 092F
		0x23,0x05,0xaf,0xf7,0xba,0x4d,0xf0,0x1f,0xbe,0x13,0x6d,0x83,0x45,0xa2,0x8b,0xfd,		// 0930 - 093F
		0x91,0xc8,0x39,0xd9,0x93,0x42,0x8a,0xe5,0xaf,0x75,0xa3,0xc7,0xbf,0x5f,0xd8,0x93,		// 0940 - 094F
		0x5a,0xcc,0x12,0x9d,0x56,0xcd,0x74,0x8c,0x8b,0x66,0x3e,0xb0,0xda,0x87,0xf1,0x96,		// 0950 - 095F
		0x6f,0x3d,0xb4,0xd9,0x42,0x2a,0xf6,0x3a,0xe4,0x33,0x55,0xf3,0x78,0x78,0xbe,0x49,		// 0960 - 096F
		0xff,0x89,0xd6,0x61,0xda,0xd7,0x99,0x54,0x89,0x68,0x41,0x85,0xb9,0xcf,0x6a,0x33,		// 0970 - 097F
		0x7e,0x5c,0x73,0x4a,0xdd,0x90,0x27,0x7f,0x8d,0xd3,0x9d,0x9b,0xfe,0x69,0x5c,0x17,		// 0980 - 098F
		0x9b,0xa3,0xc3,0xea,0x4d,0x52,0xa9,0x9f,0x40,0x81,0x40,0xaa,0xe9,0x64,0x3f,0xfc,		// 0990 - 099F
		0x48,0x8b,0x40,0xd5,0x6a,0x5b,0x66,0xda,0x33,0xbf,0x44,0x67,0x5a,0x1b,0xfa,0x26,		// 09A0 - 09AF
		0xb5,0x82,0xa1,0xe1,0xb7,0x28,0xea,0x94,0x37,0x1a,0x01,0xc7,0x72,0x2c,0xb8,0x1a,		// 09B0 - 09BF
		0x54,0x33,0xe1,0x22,0xf3,0x75,0xfb,0x73,0x5d,0x5e,0x12,0xfe,0x93,0x75,0xe0,0x9e,		// 09C0 - 09CF
		0xd5,0x8e,0x38,0xed,0x20,0x40,0xa5,0x5c,0xf6,0x99,0x4e,0x83,0x5d,0x11,0x1c,0xb5,		// 09D0 - 09DF
		0x2a,0xbd,0x1f,0xd8,0x7f,0xc5,0x2e,0x73,0x93,0x18,0xce,0x09,0xb1,0x5e,0x56,0xa6,		// 09E0 - 09EF
		0x84,0x2f,0x50,0xb7,0x91,0x82,0x21,0x1e,0x05,0x68,0xed,0x86,0xb1,0xfa,0xb5,0xf4,		// 09F0 - 09FF
		0x53,0x8f,0xc2,0x9f,0x17,0x33,0x47,0x02,0x5d,0x55,0x42,0x2f,0xbd,0xc0,0xa3,0x66,		// 0A00 - 0A0F
		0x48,0xcd,0xb0,0xe6,0x11,0xd6,0xa8,0x03,0xed,0xed,0xa6,0x79,0x76,0xce,0xc9,0x00,		// 0A10 - 0A1F
		0x56,0x13,0x92,0x21,0xc2,0xa7,0x8d,0x47,0x44,0x7d,0x34,0x19,0xbe,0x82,0x10,0x07,		// 0A20 - 0A2F
		0xac,0xd0,0x21,0x23,0xa9,0x24,0x80,0x33,0x35,0x92,0x43,0x04,0xb5,0x77,0xa1,0x01,		// 0A30 - 0A3F
		0xbb,0xb0,0x57,0x03,0x88,0x09,0x49,0x6b,0xcf,0xf8,0x6d,0x6f,0xbc,0x8c,0xe5,0xb1,		// 0A40 - 0A4F
		0x35,0xa0,0x6b,0x16,0x60,0x54,0xf2,0xd5,0x65,0xbe,0x8a,0xce,0x75,0xdc,0x85,0x1e,		// 0A50 - 0A5F
		0x0b,0xcd,0xd8,0xf0,0x71,0x41,0xc4,0x95,0x87,0x2f,0xb5,0xd8,0xc0,0xc6,0x6a,0x8b,		// 0A60 - 0A6F
		0x6d,0xa5,0x56,0x66,0x3e,0x4e,0x46,0x12,0x05,0xd8,0x45,0x80,0xbe,0xe5,0xbc,0x7f,		// 0A70 - 0A7F
		0xcd,0xd4,0xde,0x8e,0x86,0x38,0x43,0xee,0xf2,0x88,0xd3,0xfc,0xd0,0x18,0xe6,0xbe,		// 0A80 - 0A8F
		0xdb,0x47,0xaa,0xbc,0x4b,0xfa,0xc4,0x11,0x9e,0x4a,0x3a,0xc1,0x98,0x7a,0x90,0x4d,		// 0A90 - 0A9F
		0x89,0x2c,0x31,0x85,0xce,0xd4,0x11,0x9e,0x9a,0x6c,0x91,0x84,0xf7,0x6a,0xa3,0x71,		// 0AA0 - 0AAF
		0x07,0xef,0x2e,0xbf,0x90,0x41,0xb4,0xfb,0xb7,0x7b,0x32,0x3a,0x0c,0x83,0x47,0xb0,		// 0AB0 - 0ABF
		0xc7,0x3d,0x99,0x7e,0x51,0xfe,0x75,0xcc,0x07,0x44,0xb5,0x18,0x3a,0xa4,0xe7,0xcd,		// 0AC0 - 0ACF
		0x7a,0x03,0xab,0x18,0x14,0x09,0x5d,0xf7,0xd9,0xd3,0xf4,0x93,0x21,0xe8,0x2a,0xcf,		// 0AD0 - 0ADF
		0x10,0x6f,0xde,0x21,0x18,0x9f,0xb6,0xa1,0xbf,0x76,0x08,0x5f,0xa3,0xae,0xfb,0xfa,		// 0AE0 - 0AEF
		0xbb,0xed,0xe9,0x6e,0xdf,0x3c,0x08,0x2e,0x8b,0xba,0x4a,0x73,0xe0,0x91,0x81,0xd3,		// 0AF0 - 0AFF
		0xeb,0x2a,0xc7,0x15,0x2a,0x9d,0x1d,0x44,0x4c,0x6c,0x52,0x02,0x39,0x70,0x27,0x1f,		// 0B00 - 0B0F
		0x52,0x13,0xb0,0x6a,0xfa,0xc0,0xfd,0xc7,0x55,0x98,0xfa,0x82,0x4f,0x67,0x94,0xe3,		// 0B10 - 0B1F
		0xe1,0xd6,0x1d,0x03,0x90,0xe2,0xf2,0xdd,0x36,0x8c,0x5b,0xa8,0x04,0xd2,0xb2,0x65,		// 0B20 - 0B2F
		0xc8,0xdf,0xc8,0xb4,0x6c,0x7f,0x84,0xeb,0xbf,0xd5,0xcd,0x69,0x79,0x50,0xaa,0x28,		// 0B30 - 0B3F
		0x79,0xdb,0xa8,0x92,0x50,0x54,0x7d,0x96,0x03,0x40,0xea,0xfa,0x0d,0xbd,0xe6,0xf3,		// 0B40 - 0B4F
		0xa4,0xb7,0xf8,0xf3,0x3d,0x5f,0xe5,0xc2,0x52,0xd9,0x8b,0xd0,0x63,0x35,0x0d,0xca,		// 0B50 - 0B5F
		0x3b,0xa1,0x30,0x6b,0x74,0xdd,0x05,0x95,0x3d,0xef,0xc9,0xa0,0x5b,0x17,0x09,0xf2,		// 0B60 - 0B6F
		0x6e,0x05,0x09,0xcf,0x76,0x4a,0x67,0x73,0x95,0x0d,0xfc,0x5e,0x17,0xff,0x03,0xf0,		// 0B70 - 0B7F
		0xaf,0x91,0x7d,0x35,0x03,0x64,0xd4,0x02,0x6b,0x00,0xbe,0x41,0xf6,0xca,0x64,0x89,		// 0B80 - 0B8F
		0xaf,0x30,0xc4,0xf2,0x1e,0x27,0x53,0x27,0x11,0xd7,0xe7,0xbc,0x9c,0x94,0xd5,0xc2,		// 0B90 - 0B9F
		0x5e,0x11,0x56,0x99,0x06,0xd0,0x30,0x06,0x16,0xdd,0x92,0x85,0xe7,0xbc,0x3f,0xe1,		// 0BA0 - 0BAF
		0xed,0xa0,0xee,0x01,0x3d,0xde,0xf1,0x05,0x4c,0xa0,0x16,0x92,0xfa,0xde,0xcb,0x69,		// 0BB0 - 0BBF
		0xcf,0x8a,0x85,0x3f,0x84,0x0b,0x62,0xc9,0xc5,0xed,0x0d,0x16,0x35,0xd7,0xe2,0x21,		// 0BC0 - 0BCF
		0xb3,0xbd,0x52,0xa7,0xdc,0x56,0x89,0x36,0xd0,0xd1,0x4f,0x87,0x39,0xc4,0x2c,0x0d,		// 0BD0 - 0BDF
		0x8a,0x65,0xd0,0xce,0x85,0xfc,0xb1,0x72,0x00,0x98,0xf6,0x99,0xe8,0x01,0x94,0x72,		// 0BE0 - 0BEF
		0x86,0xef,0xb7,0x8a,0x01,0x79,0x63,0xe1,0x25,0xd0,0x5b,0x43,0x62,0x2d,0x42,0xd5,		// 0BF0 - 0BFF
		0x18,0x08,0x00,0xef,0x12,0x8b,0x67,0x29,0x50,0x46,0x17,0xb9,0x09,0x24,0x9e,0xfc,		// 0C00 - 0C0F
		0xf0,0x9e,0xe4,0x52,0xb7,0x2e,0xc7,0x2f,0xd1,0x07,0x02,0x6f,0x7d,0x03,0x53,0xea,		// 0C10 - 0C1F
		0x00,0xdd,0xdd,0x49,0x31,0xa0,0xcb,0x18,0x3b,0x5f,0x36,0x1c,0x9f,0x27,0x48,0xe6,		// 0C20 - 0C2F
		0x78,0x32,0xa2,0xa8,0x03,0x5d,0xfc,0x48,0x5e,0xdc,0x0b,0xb3,0x90,0x2d,0xa8,0x74,		// 0C30 - 0C3F
		0xca,0x4a,0x2e,0x85,0xed,0x23,0x24,0x64,0x4b,0x4b,0x1c,0x6a,0xb2,0xf2,0xda,0x59,		// 0C40 - 0C4F
		0xa7,0x13,0xb9,0x34,0xef,0xee,0x4b,0x53,0x54,0xb9,0x40,0xb6,0xa5,0x93,0x89,0x9a,		// 0C50 - 0C5F
		0xff,0xb9,0xbd,0x4a,0x4b,0xfc,0xbb,0x38,0x08,0x73,0x91,0x4c,0x4b,0x6d,0x9c,0x7c,		// 0C60 - 0C6F
		0x03,0xa9,0xf1,0x9d,0x82,0xca,0xfc,0x78,0x39,0x05,0x67,0x21,0xc3,0x1d,0x3d,0x84,		// 0C70 - 0C7F
		0x26,0x91,0x50,0x41,0x55,0x14,0xd8,0xba,0xf9,0x3d,0x5c,0x69,0x70,0x80,0xd6,0x78,		// 0C80 - 0C8F
		0x16,0x5d,0x12,0x8b,0xc4,0xd7,0x57,0xe1,0x97,0x28,0x49,0x9b,0xf3,0xb3,0x0e,0x5b,		// 0C90 - 0C9F
		0xc7,0x3a,0xb0,0x11,0x12,0x51,0xc2,0x12,0xa6,0x12,0x47,0x6b,0x2c,0x13,0xcf,0x74,		// 0CA0 - 0CAF
		0x68,0x95,0xe3,0xa8,0xbe,0xfe,0xa3,0xb3,0xf5,0x8a,0xae,0xcd,0x3c,0x3d,0x42,0x47,		// 0CB0 - 0CBF
		0x6a,0x1c,0xa5,0x63,0x8a,0x9c,0xc3,0x69,0x97,0x5b,0x18,0xf7,0x84,0x0e,0xd0,0x99,		// 0CC0 - 0CCF
		0x7f,0xba,0x2d,0x99,0x77,0x28,0x2a,0x19,0xdc,0x93,0x5e,0x5e,0xa6,0xa3,0x22,0x6f,		// 0CD0 - 0CDF
		0x98,0x9f,0xf6,0xdf,0xc6,0xde,0x21,0xe7,0x55,0x7e,0x98,0xb8,0x82,0x59,0x21,0x0e,		// 0CE0 - 0CEF
		0xe5,0x35,0xb8,0x09,0xf7,0x3b,0x32,0x39,0xd3,0xab,0x20,0xf7,0x39,0xcd,0xf6,0xfc,		// 0CF0 - 0CFF
		0xd8,0x2b,0x6d,0x2c,0xcd,0xfd,0x25,0xb3,0x67,0xe5,0x8f,0x53,0x2d,0xdc,0x0a,0xfc,		// 0D00 - 0D0F
		0x22,0x6c,0x4c,0x9e,0x47,0x21,0x04,0x3b,0x62,0x3a,0xbd,0x40,0xfe,0xa3,0x06,0x15,		// 0D10 - 0D1F
		0xb3,0x28,0xd0,0xf3,0xa7,0xe3,0x17,0xf6,0x55,0xf6,0xc5,0x73,0x8d,0x80,0xd3,0x8b,		// 0D20 - 0D2F
		0xbc,0xc9,0xb1,0x00,0x6e,0xc0,0xe8,0x48,0x11,0xa8,0xfe,0xe0,0xfc,0x0e,0x99,0xe3,		// 0D30 - 0D3F
		0xb0,0xfe,0xe8,0xdb,0x5d,0x76,0x3f,0xd7,0xa8,0x1b,0x01,0xbe,0xab,0x2b,0xc3,0xe2,		// 0D40 - 0D4F
		0x3d,0xb3,0xae,0xd8,0x74,0x02,0x25,0x88,0x69,0x5d,0xa8,0x80,0x3b,0xf4,0xf9,0x8e,		// 0D50 - 0D5F
		0x57,0x15,0x7d,0x8d,0xf6,0xa0,0xe4,0x7f,0xe7,0xbb,0x0d,0xdc,0x8e,0xc6,0x23,0x2a,		// 0D60 - 0D6F
		0x2d,0x92,0x0d,0xce,0x62,0xcd,0x05,0x22,0xf1,0xc1,0x86,0xc7,0xc4,0x3f,0x6c,0x3d,		// 0D70 - 0D7F
		0x30,0xd5,0x57,0xb0,0x7a,0x47,0x50,0x15,0x9a,0x3d,0xaf,0x76,0x3e,0x3a,0x3b,0x8a,		// 0D80 - 0D8F
		0x12,0xcd,0x94,0x89,0x3f,0x0b,0xce,0x3e,0x31,0x3c,0x5f,0x5e,0x9e,0xd5,0x3b,0x18,		// 0D90 - 0D9F
		0xc4,0xa7,0x3d,0xed,0xf2,0x55,0xc9,0xc2,0x49,0x0b,0xb0,0x34,0xc4,0x6d,0x53,0x2b,		// 0DA0 - 0DAF
		0x76,0xce,0x0c,0xb2,0x13,0xa3,0xc9,0x06,0xb2,0x37,0xfa,0xec,0xd1,0xa0,0xae,0x48,		// 0DB0 - 0DBF
		0x9a,0xf1,0xf8,0xec,0x65,0xb1,0x98,0xae,0x7d,0x8c,0xd7,0xbd,0x27,0x49,0xb3,0x35,		// 0DC0 - 0DCF
		0xe0,0xfc,0x3c,0xf0,0xe7,0x7d,0x3e,0xa0,0xfb,0x18,0x20,0x1a,0x66,0x86,0x0c,0xf5,		// 0DD0 - 0DDF
		0x3a,0x1c,0x51,0x54,0xdb,0x43,0x05,0x00,0xbd,0x28,0xee,0xba,0x6f,0xb5,0xa3,0xcf,		// 0DE0 - 0DEF
		0xd9,0xbf,0xee,0xec,0xc2,0x81,0x75,0x34,0x95,0x49,0x99,0x90,0x64,0x71,0x9f,0x46,		// 0DF0 - 0DFF
		0x2d,0x91,0x0d,0xce,0x5c,0xf3,0x57,0xe1,0x92,0x47,0xbb,0xd2,0xa5,0x98,0x6a,0x21,		// 0E00 - 0E0F
		0xe8,0x7f,0xe8,0x4e,0xac,0x97,0xb5,0xeb,0x06,0x30,0x2d,0xf5,0xd3,0x48,0xad,0x64,		// 0E10 - 0E1F
		0xfa,0xb7,0xf7,0x01,0xf1,0xa9,0xd8,0x78,0x83,0x51,0x08,0xae,0xd0,0xdc,0x51,0x54,		// 0E20 - 0E2F
		0x95,0xa4,0xf3,0xbd,0xad,0xa7,0x48,0xec,0xd8,0x37,0xa4,0xf2,0xbc,0xf3,0x7f,0x77,		// 0E30 - 0E3F
		0x29,0xf5,0xd6,0x96,0xa1,0x4d,0xce,0xee,0x18,0xae,0x9b,0xf5,0xf8,0x68,0xa0,0x90,		// 0E40 - 0E4F
		0x68,0x96,0xd7,0xe1,0xce,0x99,0x74,0x60,0x92,0xc5,0xc5,0x2e,0x26,0x59,0x5d,0xa6,		// 0E50 - 0E5F
		0x43,0xb5,0x71,0x34,0x75,0xc7,0x82,0x6a,0xd9,0xc7,0x3c,0x50,0x25,0x24,0x9f,0xfc,		// 0E60 - 0E6F
		0xea,0xbe,0x5c,0x63,0x16,0x55,0x82,0x6f,0xbd,0x41,0x59,0x52,0x19,0x64,0x8e,0x19,		// 0E70 - 0E7F
		0xcf,0x5e,0x91,0x84,0x73,0xff,0x3c,0x15,0x4f,0x02,0xb5,0x67,0x60,0xf8,0x95,0xc1,		// 0E80 - 0E8F
		0xa2,0x82,0x4a,0xeb,0x8e,0xc3,0xba,0x40,0xe0,0x15,0x28,0x05,0x9d,0xfb,0x5c,0xf9,		// 0E90 - 0E9F
		0x55,0x58,0xfe,0x2d,0xa5,0xde,0x44,0x16,0x01,0xc8,0xcd,0xe1,0xb0,0xcc,0xcc,0x06,		// 0EA0 - 0EAF
		0x18,0x4b,0x68,0x20,0x3c,0xcc,0x63,0xfc,0x83,0xa8,0xfa,0xf0,0xbb,0x06,0x0d,0x6e,		// 0EB0 - 0EBF
		0x5d,0x0a,0x80,0xd8,0x13,0x4a,0xe1,0x96,0x77,0x82,0x4b,0x67,0x1e,0x88,0x8a,0xf4,		// 0EC0 - 0ECF
		0xd5,0x82,0x7f,0xab,0x2a,0x56,0xc6,0xca,0x2f,0x62,0x97,0xba,0x7a,0x6e,0xea,0x9f,		// 0ED0 - 0EDF
		0x70,0xde,0xdf,0x2d,0xc4,0x2c,0x5c,0xbd,0x3a,0x96,0xf8,0xa0,0xb1,0x14,0x18,0xb3,		// 0EE0 - 0EEF
		0x60,0x8d,0x57,0x33,0x60,0x4a,0x2c,0xd3,0x6a,0xab,0xc7,0x0c,0xe3,0x19,0x3b,0xb5,		// 0EF0 - 0EFF
		0x15,0x3b,0xe2,0xd3,0xc0,0x6d,0xfd,0xb2,0xd1,0x6e,0x9c,0x35,0x71,0x58,0xbe,0x6a,		// 0F00 - 0F0F
		0x41,0xd6,0xb8,0x61,0xe4,0x91,0xdb,0x3f,0xbf,0xeb,0x51,0x8e,0xfc,0xf0,0x48,0xd7,		// 0F10 - 0F1F
		0xd5,0x89,0x53,0x73,0x0f,0xf3,0x0c,0x9e,0xc4,0x70,0xff,0xcd,0x66,0x3d,0xc3,0x42,		// 0F20 - 0F2F
		0x01,0xc3,0x6a,0xdd,0xc0,0x11,0x1c,0x35,0xb3,0x8a,0xfe,0xe7,0xcf,0xdb,0x58,0x2e,		// 0F30 - 0F3F
		0x37,0x31,0xf8,0xb4,0xba,0xa8,0xd1,0xa8,0x9c,0x06,0xe8,0x11,0x99,0xa9,0x71,0x62,		// 0F40 - 0F4F
		0x27,0xbe,0x34,0x4e,0xfc,0xb4,0x36,0xdd,0xd0,0xf0,0x96,0xc0,0x64,0xc3,0xb5,0xe2,		// 0F50 - 0F5F
		0xc3,0x99,0x99,0x3f,0xc7,0x73,0x94,0xf9,0xe0,0x97,0x20,0xa8,0x11,0x85,0x0e,0xf2,		// 0F60 - 0F6F
		0x3b,0x2e,0xe0,0x5d,0x9e,0x61,0x73,0x60,0x9d,0x86,0xe1,0xc0,0xc1,0x8e,0xa5,0x1a,		// 0F70 - 0F7F
		0x01,0x2a,0x00,0xbb,0x41,0x3b,0x9c,0xb8,0x18,0x8a,0x70,0x3c,0xd6,0xba,0xe3,0x1c,		// 0F80 - 0F8F
		0xc6,0x7b,0x34,0xb1,0xb0,0x00,0x19,0xe6,0xa2,0xb2,0xa6,0x90,0xf0,0x26,0x71,0xfe,		// 0F90 - 0F9F
		0x7a,0x4c,0xf4,0xd1,0x2d,0xea,0x32,0x0e,0xcd,0x49,0x9e,0x72,0xf1,0x2f,0x38,0x06,		// 0FA0 - 0FAF
		0x4f,0x0c,0xf9,0xf3,0x39,0x78,0x71,0x96,0x68,0xdd,0xaf,0xd7,0xf9,0x71,0x61,0xb7,		// 0FB0 - 0FBF
		0xb5,0x68,0x3c,0x29,0x95,0x67,0x9e,0x23,0x85,0x3b,0x72,0xf4,0x69,0xcb,0x55,0xd8,		// 0FC0 - 0FCF
		0x5e,0x4b,0xf6,0xca,0x42,0xb3,0xc3,0x99,0x76,0x70,0xc2,0x3e,0xe2,0x59,0xbc,0x6d,		// 0FD0 - 0FDF
		0x3a,0xe4,0xa1,0x6a,0x80,0x9a,0x28,0x1e,0xcb,0xc8,0xb6,0x6a,0x46,0x78,0x81,0xbb,		// 0FE0 - 0FEF
		0x7b,0x9f,0xf5,0xdf,0xd2,0x98,0x57,0x17,0x54,0xd1,0xa8,0x6d,0xb5,0xc5,0xcc,0x47,		// 0FF0 - 0FFF
		0x92,0x2a,0xeb,0x3d,0xf7,0x6b,0x18,0x28,0x24,0x58,0x30,0x7b,0x91,0x1d,0x05,0xd7,		// 1000 - 100F
		0x2f,0x70,0xbc,0xd9,0xf1,0x0f,0x74,0x37,0x8b,0x6a,0x29,0x0b,0x7a,0x9c,0xd7,0x6e,		// 1010 - 101F
		0x44,0xa0,0xe2,0x49,0x01,0xc2,0xb5,0x68,0x1a,0x53,0xa9,0xd0,0x51,0xa1,0x29,0x53,		// 1020 - 102F
		0x01,0x27,0x15,0x61,0xa7,0x00,0x63,0x21,0xa2,0xa2,0x0c,0xc0,0x37,0xc8,0x26,0x0a,		// 1030 - 103F
		0xd8,0xb0,0x4d,0x37,0xa6,0x87,0x48,0x07,0x34,0x22,0xea,0x11,0x8e,0xee,0x35,0x57,		// 1040 - 104F
		0x7a,0x2a,0xc6,0x1f,0xfd,0x53,0x6d,0xfe,0x21,0xe0,0x1b,0x36,0xf6,0x30,0x01,0x42,		// 1050 - 105F
		0xd7,0xc1,0xf6,0xae,0xee,0xa2,0x19,0x2c,0xfb,0x2b,0xb8,0xe5,0x50,0xeb,0x71,0x0d,		// 1060 - 106F
		0x20,0xe2,0x97,0xba,0xfa,0xf0,0xd8,0xf6,0x91,0x8e,0x1c,0x12,0xbe,0xbc,0xaf,0x3e,		// 1070 - 107F
		0xc8,0x3a,0xa3,0x57,0xe2,0xfb,0x70,0x00,0xf5,0xd7,0xde,0xf4,0xa0,0x80,0x25,0x9b,		// 1080 - 108F
		0x7e,0xb7,0x52,0xdb,0xa7,0xc0,0xec,0x30,0x79,0x13,0xd8,0xff,0x98,0x54,0x7a,0x27,		// 1090 - 109F
		0x33,0x85,0x1d,0xda,0x89,0x7b,0x95,0xab,0xac,0x8e,0x22,0xe7,0x85,0x95,0x98,0x29,		// 10A0 - 10AF
		0x19,0x12,0xbd,0x29,0x0a,0xa9,0xf3,0xd5,0x61,0xd7,0x17,0xa3,0x8a,0xe0,0xa8,0x25,		// 10B0 - 10BF
		0xa0,0x09,0x2c,0xde,0xec,0x08,0xcf,0x54,0xa8,0xb9,0x4e,0x66,0x08,0x12,0x13,0xe0,		// 10C0 - 10CF
		0x7b,0x59,0xa2,0x4d,0x2e,0x94,0x33,0x0c,0xd1,0x42,0xa0,0xa6,0x9f,0x48,0x82,0x5f,		// 10D0 - 10DF
		0x98,0x2e,0x97,0x0b,0x11,0x8b,0x68,0x23,0x6f,0xbe,0x28,0x18,0x30,0xdf,0xde,0xe7,		// 10E0 - 10EF
		0x2b,0xf6,0xc7,0xee,0x18,0x6a,0xf5,0xfe,0x52,0xbc,0x3d,0xb1,0xdc,0x74,0x50,0xfe,		// 10F0 - 10FF
		0xa2,0x5c,0x28,0x0a,0x02,0xed,0xa6,0x41,0x8b,0x07,0x79,0xa6,0x05,0xe5,0x41,0x67,		// 1100 - 110F
		0xb1,0x4f,0xf4,0xb5,0xd2,0x11,0x81,0xd2,0x6b,0xad,0xb4,0x6c,0x4b,0x4d,0x5a,0x29,		// 1110 - 111F
		0x47,0xfb,0xa5,0x83,0xc7,0x14,0xd2,0xd6,0x84,0xfa,0x08,0xb7,0x8f,0x0a,0x84,0x88,		// 1120 - 112F
		0x96,0xce,0xf3,0x49,0x63,0x73,0x1f,0xb1,0xa5,0x7d,0xce,0x7e,0xf3,0xb9,0xe7,0x09,		// 1130 - 113F
		0x0e,0x73,0xd7,0x1d,0x66,0xea,0x33,0x09,0xe0,0x01,0x9f,0xf4,0xd7,0x37,0xee,0x71,		// 1140 - 114F
		0x61,0xd9,0x8b,0x54,0xd3,0x77,0x17,0xc3,0x87,0x94,0x53,0x90,0xdc,0xa1,0x41,0xc6,		// 1150 - 115F
		0x7f,0x2d,0x86,0x81,0xe9,0x56,0x13,0x03,0x29,0x83,0x04,0x05,0xe4,0x55,0xc8,0x4b,		// 1160 - 116F
		0x9a,0xda,0x83,0x7b,0x2a,0x04,0xb0,0x2f,0x99,0x5a,0x0b,0x49,0x0f,0xee,0xae,0x87,		// 1170 - 117F
		0x22,0x8f,0x7a,0x57,0x57,0x3f,0xb8,0xec,0xe6,0xe8,0x00,0x91,0xbe,0x4a,0x5a,0x3d,		// 1180 - 118F
		0xc9,0x38,0xa4,0x68,0x71,0x04,0x34,0x1e,0x63,0x38,0xbe,0x52,0x93,0x86,0x77,0x74,		// 1190 - 119F
		0x80,0x02,0x7a,0x46,0xb9,0x8f,0x6b,0xeb,0xa0,0x97,0x5b,0x40,0x6e,0x00,0xec,0x70,		// 11A0 - 11AF
		0x77,0x5b,0xb6,0xc3,0xb0,0x5e,0xe9,0xb7,0x6e,0x94,0x33,0x52,0x70,0x53,0xe4,0xb6,		// 11B0 - 11BF
		0x20,0xef,0x50,0xf6,0x16,0x2d,0x74,0x28,0xde,0xfa,0xdd,0xbc,0xfb,0x5d,0xc6,0x0c,		// 11C0 - 11CF
		0x2b,0xab,0x81,0x33,0xed,0xfa,0x18,0x23,0x41,0xd7,0x33,0xf2,0xaf,0x3c,0x3c,0x75,		// 11D0 - 11DF
		0x8a,0xbc,0xc2,0x10,0x76,0x01,0x1b,0xcc,0x28,0x78,0x4e,0xaa,0x6d,0x4b,0x30,0x38,		// 11E0 - 11EF
		0x6e,0x90,0xcc,0x61,0x32,0xc0,0x08,0x89,0x64,0x6a,0x86,0xda,0x57,0x28,0xc9,0xd8,		// 11F0 - 11FF
		0x47,0xd3,0x99,0x3c,0xe2,0xf3,0xa8,0xff,0x06,0x79,0x75,0xb5,0xcd,0xb1,0x71,0x1c,		// 1200 - 120F
		0xc7,0x72,0x61,0xf5,0x86,0x98,0x03,0x12,0x60,0xb3,0xf4,0xb1,0x70,0x01,0xd1,0x08,		// 1210 - 121F
		0xde,0x9a,0x9c,0x21,0x60,0xeb,0x62,0xe8,0x01,0x65,0x1b,0x83,0x22,0x76,0xd2,0xe1,		// 1220 - 122F
		0xbe,0xb9,0x06,0x96,0xf2,0x6a,0x4f,0xe6,0xbc,0x1c,0x45,0x1f,0x03,0xae,0x9d,0x2d,		// 1230 - 123F
		0xd7,0x7b,0x95,0x68,0xfb,0xd1,0x93,0xb0,0xa0,0xa5,0x08,0xbc,0x74,0x84,0x9b,0xaf,		// 1240 - 124F
		0xdb,0xcd,0x84,0xec,0x7c,0x1e,0x35,0x2c,0x00,0x0c,0x40,0xce,0x16,0x17,0x75,0x6e,		// 1250 - 125F
		0xbb,0xdc,0x4a,0xb8,0xb8,0x8d,0x81,0x7e,0x6c,0x9f,0x04,0x09,0xcb,0xc2,0x14,0xad,		// 1260 - 126F
		0xa7,0x16,0xa2,0xa0,0x2f,0x9c,0xfd,0x0d,0xb5,0xeb,0xae,0x63,0xb4,0x24,0xa0,0xf3,		// 1270 - 127F
		0x11,0x27,0x85,0xba,0xa1,0x07,0x74,0x7b,0xec,0xbc,0xd7,0x12,0x30,0x18,0x84,0x04,		// 1280 - 128F
		0xa9,0xfd,0x2a,0x5a,0x10,0xcc,0xef,0xb0,0x62,0x20,0x57,0x89,0xe2,0xbd,0x68,0xe5,		// 1290 - 129F
		0x61,0xc3,0x0c,0x16,0xbd,0x28,0xb6,0xcf,0xa8,0x64,0x48,0x7e,0xaa,0x6e,0x35,0xdb,		// 12A0 - 12AF
		0x69,0xe8,0xe2,0xc1,0x29,0x96,0x53,0x3e,0x8f,0x15,0x03,0xe6,0xaa,0xca,0x13,0x6c,		// 12B0 - 12BF
		0x34,0x18,0xa7,0x73,0x14,0xd6,0x8e,0xa1,0x28,0x00,0x21,0xf5,0x42,0xac,0x6d,0x5b,		// 12C0 - 12CF
		0x70,0x40,0x94,0x7e,0x81,0xe3,0x70,0xde,0xc4,0x31,0x7a,0x22,0x13,0x33,0xea,0xaf,		// 12D0 - 12DF
		0x10,0x8e,0x20,0x79,0xaf,0xfa,0x43,0x19,0xf5,0xf6,0x28,0x21,0xff,0xbb,0x75,0xac,		// 12E0 - 12EF
		0x45,0x6e,0x06,0x39,0x20,0x99,0x8f,0xb9,0x8a,0xdc,0x83,0xe6,0x25,0xe0,0x35,0xd7,		// 12F0 - 12FF
		0x80,0x8d,0x3e,0xd1,0x95,0x7d,0x1e,0x61,0x96,0xb0,0x26,0xa7,0xe9,0x81,0x95,0xf5,		// 1300 - 130F
		0x71,0xd8,0x01,0x99,0x0f,0xa2,0xf8,0xf6,0x68,0x7e,0xe8,0xda,0xe9,0xb9,0x3c,0x0b,		// 1310 - 131F
		0x09,0x7d,0xc8,0x23,0xce,0x45,0x67,0x9e,0x93,0x94,0xe2,0x32,0x08,0xe7,0x14,0x5f,		// 1320 - 132F
		0x7a,0xe8,0x4c,0x46,0x55,0xe4,0xf3,0xbe,0xe7,0x7f,0x6f,0xa5,0x66,0xa7,0x46,0x74,		// 1330 - 133F
		0x35,0xc6,0x87,0x16,0x63,0x3c,0x66,0xfb,0x75,0x0c,0x26,0x68,0x65,0xd5,0x3c,0x11,		// 1340 - 134F
		0xea,0x05,0xb1,0xe9,0xfa,0x49,0xc8,0x39,0x8d,0x48,0xe1,0xef,0xa5,0x90,0x9d,0x39,		// 1350 - 135F
		0x8b,0xd0,0x43,0x53,0x5b,0x49,0x62,0x9e,0xc2,0x7f,0xb8,0xf1,0x07,0x34,0x53,0x33,		// 1360 - 136F
		0x48,0x96,0xf6,0x2a,0x07,0xb8,0xbe,0x8e,0xe5,0x3f,0x05,0x62,0xac,0x5e,0x87,0x84,		// 1370 - 137F
		0x93,0x04,0xc3,0x82,0xbe,0x53,0xa5,0xaf,0x05,0x55,0x61,0x76,0xf6,0xea,0xa2,0xef,		// 1380 - 138F
		0x1d,0x05,0xe4,0xb0,0x83,0x18,0x1e,0xe6,0x74,0xcd,0xa5,0xa4,0x85,0xf7,0x4d,0x7a,		// 1390 - 139F
		0xd6,0xc8,0xd1,0x4a,0x95,0x44,0x75,0x57,0xc3,0xf5,0xe9,0x9f,0x3b,0xe1,0x71,0x6b,		// 13A0 - 13AF
		0xf0,0xb9,0x43,0x24,0x76,0x53,0x30,0x68,0xc4,0x5a,0x87,0x5d,0x38,0x45,0x37,0x45,		// 13B0 - 13BF
		0xdb,0x85,0x33,0x53,0xe7,0x03,0x1b,0xbd,0x86,0xc9,0x18,0x13,0xdd,0xff,0x08,0xcf,		// 13C0 - 13CF
		0x49,0x1a,0xdb,0x2d,0xe8,0x50,0x3c,0x3d,0x5c,0x4f,0x74,0x36,0xcb,0x2e,0x8c,0x0d,		// 13D0 - 13DF
		0x2a,0xa4,0xb2,0x46,0xbc,0x78,0xdf,0x0b,0xd5,0x38,0xb6,0x7b,0xe4,0x2e,0xae,0x44,		// 13E0 - 13EF
		0xb0,0x90,0x73,0x74,0xe2,0xf7,0x8a,0x8c,0xc4,0x12,0x34,0xd6,0x48,0x9c,0x96,0xf9,		// 13F0 - 13FF
		0x4c,0x8b,0x16,0xcb,0x1c,0x8b,0x08,0x66,0x39,0xaa,0x8a,0x7e,0x59,0x55,0xac,0xf2,		// 1400 - 140F
		0xae,0x83,0xd5,0xa0,0x6b,0x30,0x62,0x7e,0x85,0x0d,0x8f,0xe7,0xb6,0x76,0x9b,0x32,		// 1410 - 141F
		0xc8,0xa4,0x27,0x89,0x10,0x24,0xe0,0xf8,0x39,0x87,0x5d,0xc5,0x43,0x5c,0x4a,0x00,		// 1420 - 142F
		0xca,0x5b,0xc7,0x5a,0x8c,0xe3,0x0b,0x3b,0x26,0xa7,0x4d,0x0e,0x1e,0xa4,0xe4,0xe0,		// 1430 - 143F
		0x26,0x56,0xad,0x29,0x9f,0x2b,0xad,0xe9,0x5d,0x38,0xf7,0xf7,0xaa,0x2a,0xd0,0x96,		// 1440 - 144F
		0x8d,0x80,0x12,0x4a,0x4c,0xf8,0xce,0xea,0x2f,0x47,0x35,0xf5,0x87,0x0d,0xb9,0x29,		// 1450 - 145F
		0xef,0x08,0x6f,0x52,0xd2,0x88,0xb8,0x61,0x2d,0x23,0x20,0xbd,0x96,0xa9,0x86,0xde,		// 1460 - 146F
		0x7e,0x5b,0x7e,0x17,0xb3,0x57,0xf3,0xb3,0x28,0x57,0x11,0x44,0xf9,0x9b,0x61,0x38,		// 1470 - 147F
		0xaa,0x24,0x36,0xad,0xb0,0x23,0x49,0x87,0x32,0xb1,0xa0,0xbf,0x10,0xc0,0xb4,0xfd,		// 1480 - 148F
		0x25,0x52,0xd2,0x6a,0xc9,0xe9,0xc2,0xbf,0x9a,0x3e,0xa7,0xa3,0x7d,0x35,0x26,0x33,		// 1490 - 149F
		0xdf,0x11,0xca,0xe2,0x41,0xe4,0xa7,0x83,0xf3,0x4a,0x3e,0xa4,0x1f,0x57,0xa1,0x1e,		// 14A0 - 14AF
		0x0a,0xce,0xd8,0xea,0x97,0x94,0x82,0x36,0x0d,0x64,0xbf,0xb8,0x19,0xc3,0x4e,0x43,		// 14B0 - 14BF
		0x17,0x37,0xf3,0x98,0x8d,0xb4,0x1c,0x7e,0xf8,0x57,0xc3,0x15,0xcc,0x57,0x96,0x67,		// 14C0 - 14CF
		0xb6,0x38,0x56,0x40,0x24,0x41,0x7d,0x40,0x07,0x31,0x23,0x2e,0xd7,0x2e,0x22,0x8f,		// 14D0 - 14DF
		0xd8,0xfe,0x79,0x77,0x9d,0x79,0xee,0xa0,0xca,0x3e,0xf8,0xb9,0x1e,0xa6,0xdb,0x00,		// 14E0 - 14EF
		0xb0,0xf6,0x15,0x13,0x78,0xd9,0xf9,0x03,0x12,0x0d,0x9a,0xab,0xbf,0x5c,0xea,0x40,		// 14F0 - 14FF
		0xad,0xce,0x23,0x29,0x78,0x1d,0x66,0x10,0xf0,0x69,0xa2,0x39,0x1d,0x2d,0xb8,0x12,		// 1500 - 150F
		0x80,0x72,0xdd,0x0c,0x9c,0x42,0x3f,0xaa,0xb5,0x60,0xeb,0xd7,0xd8,0x36,0xee,0x7d,		// 1510 - 151F
		0x1b,0x0f,0xba,0x53,0x26,0x86,0xcc,0xf7,0xf2,0x3e,0x8c,0x3c,0xd1,0xd4,0x75,0xc5,		// 1520 - 152F
		0xaf,0x12,0x75,0xd3,0x97,0x66,0x97,0x5b,0x79,0x92,0xdf,0x5c,0x2a,0xa4,0x75,0x6f,		// 1530 - 153F
		0xac,0x29,0x07,0xa0,0xb0,0x9e,0x68,0x7c,0x59,0x27,0x7d,0x6b,0x43,0x84,0x59,0x40,		// 1540 - 154F
		0xc4,0x40,0xa7,0x0f,0x71,0x2b,0x48,0x3e,0xe4,0x0b,0x3e,0xdf,0xbd,0x8f,0xc9,0x3d,		// 1550 - 155F
		0xe7,0x84,0xcf,0xb5,0x1d,0x4b,0x81,0xc8,0xac,0x8b,0x3c,0x6e,0x7a,0x23,0xad,0xac,		// 1560 - 156F
		0x47,0x63,0x39,0x68,0x33,0x7b,0x9c,0x7d,0x80,0x33,0xd0,0x0b,0x9a,0xdd,0x30,0x10,		// 1570 - 157F
		0x54,0x88,0xdd,0x3d,0x75,0x77,0x61,0x02,0x73,0xd2,0x92,0xec,0x7e,0x9a,0xb9,0x30,		// 1580 - 158F
		0xc0,0xe2,0xf4,0x88,0xe4,0x3d,0xd9,0x3d,0xd5,0x73,0x5c,0x85,0xc8,0x78,0xf3,0x10,		// 1590 - 159F
		0x7c,0x9e,0xf8,0xde,0xc0,0x09,0x4e,0x53,0x37,0x63,0x47,0x8d,0x58,0xd2,0xc5,0xf5,		// 15A0 - 15AF
		0xb8,0x27,0xa0,0x14,0x8c,0x59,0x48,0xa9,0x69,0x31,0xac,0xf8,0x4f,0x46,0x5a,0x64,		// 15B0 - 15BF
		0xe6,0x2c,0xe7,0x40,0x07,0xe9,0x91,0xe3,0x7e,0xa8,0x23,0xfa,0x0f,0xb2,0x19,0x23,		// 15C0 - 15CF
		0xb7,0x99,0x05,0xb7,0x33,0xb6,0x31,0xe6,0xc7,0xd6,0x86,0x0a,0x38,0x31,0xac,0x35,		// 15D0 - 15DF
		0x1a,0x9c,0x73,0x0c,0x52,0xff,0x72,0xd9,0xd3,0x08,0xee,0xdb,0xab,0x21,0xfd,0xe1,		// 15E0 - 15EF
		0x43,0xa0,0xea,0x17,0xe2,0x3e,0xdc,0x1f,0x74,0xcb,0xb3,0x63,0x8a,0x20,0x33,0xaa,		// 15F0 - 15FF
		0xa1,0x54,0x64,0xea,0xa7,0x33,0x38,0x5d,0xbb,0xeb,0x6f,0xd7,0x35,0x09,0xb8,0x57,		// 1600 - 160F
		0xe6,0xa4,0x19,0xdc,0xa1,0xd8,0x90,0x7a,0xf9,0x77,0xfb,0xac,0x4d,0xfa,0x35,0xec,		// 1610 - 161F
		0x02,0xbe,0x82,0x81,0x10,0x6d,0x2d,0x99,0xc0,0xb9,0x6f,0x97,0xb4,0x51,0x93,0xae,		// 1620 - 162F
		0x27,0x0d,0x58,0xaf,0x76,0x6c,0x97,0x1f,0xdf,0x41,0x25,0x8d,0x89,0xa9,0xfb,0x22,		// 1630 - 163F
		0xc5,0x40,0x94,0x7a,0x94,0x95,0x97,0xb2,0x69,0xdb,0xb6,0xc3,0x30,0xe1,0xd6,0x0e,		// 1640 - 164F
		0x8e,0x44,0x70,0x38,0x6b,0xe3,0x37,0x37,0xae,0x93,0xfb,0xad,0x47,0x14,0xcd,0x75,		// 1650 - 165F
		0x73,0x44,0x64,0x7c,0x3b,0x93,0xbf,0xd3,0x3e,0xb7,0x0c,0x02,0xb1,0xa1,0xc9,0x9e,		// 1660 - 166F
		0xa4,0xaf,0x29,0x1e,0x87,0x23,0xb9,0xea,0xec,0xd4,0x43,0xb5,0x8f,0x23,0xf2,0x0d,		// 1670 - 167F
		0x93,0x31,0xb8,0x30,0x0e,0x4f,0xed,0x22,0xc8,0xb6,0x39,0xfc,0x40,0x79,0xb3,0x87,		// 1680 - 168F
		0xf0,0xb7,0x4a,0x09,0xd2,0x15,0x65,0x5f,0x23,0x6b,0xc6,0x4c,0x67,0xbe,0xb4,0x11,		// 1690 - 169F
		0xad,0x6f,0x59,0x3e,0x14,0xb1,0x69,0xc7,0x8e,0x40,0x04,0x5a,0xe4,0x51,0xde,0xf0,		// 16A0 - 16AF
		0xfb,0xc4,0x9d,0xa3,0x55,0xa1,0x82,0xbf,0xda,0xc2,0x4c,0x1b,0xd9,0xcd,0x59,0xaa,		// 16B0 - 16BF
		0x4a,0x66,0x0f,0x4d,0x56,0xa2,0x7a,0xeb,0x19,0xbe,0x36,0xc4,0xa6,0x11,0x90,0x02,		// 16C0 - 16CF
		0x4b,0x3f,0xe8,0x91,0x17,0xb0,0x5a,0x31,0x9a,0x40,0x9d,0xca,0xec,0x38,0x2a,0xff,		// 16D0 - 16DF
		0xf1,0x7e,0xa1,0x05,0xda,0x08,0x69,0xb6,0xef,0x96,0x97,0xe1,0x8c,0xa1,0x12,0xe5,		// 16E0 - 16EF
		0x6a,0x8e,0xf4,0x7e,0x20,0x28,0x33,0xde,0xea,0x4d,0x80,0x00,0xa8,0xe7,0x6f,0x39,		// 16F0 - 16FF
		0x2a,0x1f,0xd9,0x10,0xaa,0xcd,0x7f,0x4f,0x9a,0x32,0xef,0x5a,0xa1,0xe9,0xac,0xc0,		// 1700 - 170F
		0xe0,0x1b,0x89,0x10,0x79,0xf3,0x56,0xee,0x52,0x51,0xbe,0x65,0x16,0xc3,0x70,0x7f,		// 1710 - 171F
		0x7d,0xb1,0x7d,0x13,0xce,0xd7,0x01,0xdf,0xa2,0xf8,0x06,0xd6,0xea,0xd1,0xa5,0xbb,		// 1720 - 172F
		0x33,0x4d,0x6e,0xef,0x29,0xf7,0x0b,0x88,0x5a,0xb4,0x1f,0xa2,0x3d,0xb2,0x74,0xfa,		// 1730 - 173F
		0x73,0x9c,0x56,0xb9,0x4c,0x10,0x3a,0x8d,0x8d,0x52,0xa4,0xfe,0x71,0x42,0x47,0x00,		// 1740 - 174F
		0xed,0x8b,0x6d,0xc4,0x38,0x1e,0x99,0xd4,0x8b,0xdf,0x6b,0x5f,0x26,0x9d,0xc5,0xd1,		// 1750 - 175F
		0x93,0x48,0x2c,0xa7,0x2e,0x5e,0x71,0x82,0xe5,0xa7,0x90,0x7a,0x3d,0x22,0xd8,0xb4,		// 1760 - 176F
		0x95,0x3f,0x4c,0x37,0xaf,0x4e,0x4a,0xfb,0x6c,0x38,0x6a,0x43,0xd7,0x6d,0xa9,0x2d,		// 1770 - 177F
		0x65,0x1d,0xc7,0x88,0x7c,0xab,0xed,0xe5,0x31,0x5f,0x93,0xf1,0x56,0x5b,0xa1,0x02,		// 1780 - 178F
		0xb4,0xd0,0xd4,0xef,0x95,0x71,0x64,0x25,0x86,0x28,0xe4,0xf7,0x5a,0x08,0x69,0x36,		// 1790 - 179F
		0x72,0x84,0xee,0x02,0x3c,0xde,0xf7,0xdf,0xfa,0xe2,0x75,0x0c,0xc5,0xd3,0xea,0x10,		// 17A0 - 17AF
		0xd1,0xa6,0xcd,0x95,0xf2,0x6e,0x30,0x79,0x5f,0x18,0xa0,0x23,0xb7,0x58,0x4d,0x13,		// 17B0 - 17BF
		0x41,0xe3,0x6b,0xbd,0x78,0xdf,0xd7,0x98,0xc7,0x97,0xfe,0x72,0x91,0x74,0xfb,0x06,		// 17C0 - 17CF
		0x74,0x29,0xff,0xd0,0xcf,0x2d,0xf6,0x20,0x81,0x6e,0x67,0x6e,0xf4,0x44,0x9c,0xed,		// 17D0 - 17DF
		0x5b,0xa3,0x04,0x62,0x37,0x96,0xd5,0x37,0x20,0xe8,0xf5,0xcb,0xc2,0x24,0x1b,0x0d,		// 17E0 - 17EF
		0x26,0xc1,0x32,0x49,0x33,0x96,0xfe,0x42,0x74,0x94,0x01,0x80,0x1b,0xb3,0xa0,0xeb,		// 17F0 - 17FF
		0x46,0x2d,0x82,0x99,0x82,0xeb,0x39,0xe5,0x8d,0x3c,0x24,0xc1,0x61,0xcd,0x93,0x4d,		// 1800 - 180F
		0x6d,0xd6,0x2d,0xa8,0x26,0x91,0x8f,0x05,0xbe,0xf0,0x36,0x02,0x33,0x8f,0x9f,0x36,		// 1810 - 181F
		0x8c,0xe8,0xac,0x09,0x60,0xc6,0x4a,0xc9,0x97,0xfc,0x51,0xfa,0x74,0x56,0xac,0xed,		// 1820 - 182F
		0xd4,0xd0,0xb9,0x94,0xb0,0x06,0xf2,0x94,0xe9,0xec,0xce,0x9c,0x45,0xbf,0xe2,0xf5,		// 1830 - 183F
		0xb4,0x3b,0x4c,0x5b,0xd9,0x0f,0x51,0x0c,0xc5,0x8e,0x45,0x1e,0x06,0xa7,0xab,0x15,		// 1840 - 184F
		0xe0,0x17,0x9e,0xb5,0xda,0xdd,0x70,0x15,0x7d,0xee,0x90,0xf5,0x58,0x2b,0xb1,0x51,		// 1850 - 185F
		0x47,0x90,0x28,0x37,0xf5,0xae,0x96,0xd5,0xa0,0x5b,0xc8,0xd6,0x1c,0xa8,0xdb,0xef,		// 1860 - 186F
		0x1b,0x13,0xa4,0xb4,0xab,0xfe,0x4f,0xb1,0x00,0x60,0x45,0xb6,0x74,0xbb,0x54,0x72,		// 1870 - 187F
		0xcc,0x4e,0x0a,0x43,0xbd,0x8b,0x61,0x4d,0xaf,0xcb,0xa2,0xca,0xc0,0x41,0x83,0xa0,		// 1880 - 188F
		0x0c,0x2c,0x92,0x39,0x2c,0x51,0xd7,0x8f,0xfc,0xa9,0xb5,0x86,0xa1,0x57,0x12,0x7f,		// 1890 - 189F
		0xcb,0xdc,0xb8,0x2a,0x38,0x8e,0xfa,0x9b,0x7a,0x47,0x9a,0xa1,0xf9,0x5a,0xea,0x53,		// 18A0 - 18AF
		0x3b,0xcb,0x32,0xeb,0x63,0xbf,0x52,0xd8,0xf8,0x31,0xa8,0x0e,0xe8,0xe7,0x34,0xa1,		// 18B0 - 18BF
		0xcd,0xa4,0xfa,0x92,0x6e,0xa0,0xa8,0xe9,0x89,0x35,0x79,0x03,0xd0,0xdb,0x59,0x2e,		// 18C0 - 18CF
		0x31,0x56,0x4a,0x73,0x5a,0x2e,0x06,0xb3,0x7d,0x60,0xe6,0xf6,0x50,0x53,0x02,0xff,		// 18D0 - 18DF
		0x59,0x0d,0x9a,0x24,0x68,0xa7,0xb5,0x5c,0x65,0xfe,0x07,0x9a,0x4b,0xac,0x18,0x59,		// 18E0 - 18EF
		0x75,0x37,0xa3,0x78,0x19,0x87,0x3c,0x49,0x12,0x9e,0x36,0xe5,0xe2,0x83,0xc4,0xc2,		// 18F0 - 18FF
		0xf7,0x7f,0x5e,0x87,0x2d,0x8c,0x67,0x1e,0x95,0x0b,0x0c,0x0b,0x75,0xb5,0x6f,0xfd,		// 1900 - 190F
		0x8f,0xd4,0x05,0xa3,0xa6,0xb3,0x3c,0xc1,0x3f,0x53,0x62,0x83,0xa5,0x5f,0xc2,0x11,		// 1910 - 191F
		0x2f,0x62,0x10,0x63,0xc5,0x38,0x07,0x57,0xa1,0xc3,0x50,0x01,0x53,0xdf,0xa6,0x42,		// 1920 - 192F
		0x08,0x97,0x38,0x9c,0x0b,0x99,0x4e,0x44,0x8c,0xe7,0x30,0x79,0xa1,0xd0,0x44,0x15,		// 1930 - 193F
		0x8a,0x1f,0x76,0x62,0x39,0x92,0xdc,0x2e,0x12,0x8d,0x9a,0x22,0xef,0x10,0x04,0x4f,		// 1940 - 194F
		0x67,0xe7,0x03,0x0a,0x50,0x20,0xba,0xfa,0x82,0xc2,0x69,0x6f,0xde,0xbc,0x91,0xf5,		// 1950 - 195F
		0x8f,0x1c,0x59,0x2a,0x90,0x81,0x30,0xcc,0x6e,0xd3,0xb4,0x16,0x50,0x31,0xd2,0x4d,		// 1960 - 196F
		0x34,0x2b,0x2f,0x96,0x7b,0x32,0xc7,0x0a,0xa8,0x4c,0xd5,0x0c,0x65,0x0d,0xf2,0xda,		// 1970 - 197F
		0xc7,0xc2,0x80,0x63,0xd2,0xef,0x49,0x59,0x40,0xfc,0x64,0x86,0x7e,0x2b,0x59,0x63,		// 1980 - 198F
		0xf8,0xcd,0x84,0xe7,0x96,0xb6,0xbf,0x9d,0x86,0xee,0x3b,0xf9,0x3d,0xa9,0xaf,0xec,		// 1990 - 199F
		0xb8,0x79,0xb5,0xb6,0x08,0xc3,0x70,0xfc,0x0d,0x70,0x73,0x1a,0x82,0xe4,0xde,0xba,		// 19A0 - 19AF
		0x39,0x34,0xca,0xa6,0xa8,0x93,0xe8,0xda,0xa5,0x0e,0x64,0xde,0x6e,0x7a,0x10,0x52,		// 19B0 - 19BF
		0xec,0xaa,0xbe,0xca,0x39,0xe5,0xed,0xdd,0x5f,0x96,0xa9,0x79,0x63,0x46,0xac,0x79,		// 19C0 - 19CF
		0x82,0xc8,0xc9,0x7a,0xba,0xb3,0x8b,0xea,0x8c,0x16,0x19,0x61,0x01,0x66,0x5c,0x35,		// 19D0 - 19DF
		0xeb,0xbb,0x64,0x49,0x6d,0x3c,0x08,0x25,0xbd,0xd8,0xcd,0x4c,0x29,0x38,0x0a,0xc9,		// 19E0 - 19EF
		0x58,0xf1,0x49,0x0c,0xd3,0xfd,0xef,0xf4,0xc3,0x6c,0x20,0x2d,0xfd,0x57,0xdd,0xbc,		// 19F0 - 19FF
		0x3b,0x16,0x6f,0xd8,0xac,0xb2,0x09,0xfc,0xb0,0x9d,0xa9,0x3a,0xdc,0xa1,0x3f,0xd2,		// 1A00 - 1A0F
		0x45,0x17,0x11,0x03,0xfb,0x59,0x5e,0x21,0xd3,0x7a,0x41,0xe8,0x6a,0x34,0xd9,0x10,		// 1A10 - 1A1F
		0x66,0x21,0xa7,0x21,0xff,0x2e,0x37,0x89,0xbf,0x4e,0x03,0xec,0x85,0x6b,0x94,0xbb,		// 1A20 - 1A2F
		0xd0,0xa2,0xea,0x08,0x3a,0xaf,0x1e,0x99,0x43,0xa6,0x46,0x3b,0x50,0xe5,0x99,0x58,		// 1A30 - 1A3F
		0xf4,0x46,0xd4,0xcc,0x6d,0x99,0xdc,0xf5,0x72,0x51,0xa4,0x09,0x2c,0x7d,0x51,0xad,		// 1A40 - 1A4F
		0x82,0xfa,0x9c,0xc3,0x99,0xe7,0x78,0x83,0x9b,0x5a,0xf5,0xcd,0xb8,0x51,0x65,0xbd,		// 1A50 - 1A5F
		0x6b,0xec,0xbd,0x81,0xff,0xd9,0x3e,0x67,0x51,0x0f,0x54,0x3a,0xd7,0xbf,0xbe,0xcf,		// 1A60 - 1A6F
		0xe1,0x87,0xef,0xdb,0x1f,0xea,0xb4,0x07,0x64,0xfd,0x18,0x47,0xa9,0x62,0x85,0x67,		// 1A70 - 1A7F
		0x55,0x7a,0x2b,0xe7,0xbc,0xd7,0xa5,0x08,0xe5,0xf0,0xda,0x27,0x90,0x19,0x22,0x4a,		// 1A80 - 1A8F
		0x77,0xb2,0xab,0xf9,0xd5,0x9e,0x1a,0x4f,0x25,0xf7,0x75,0x50,0x2c,0xff,0x40,0x7d,		// 1A90 - 1A9F
		0x39,0x5a,0xe6,0xa6,0xac,0x7b,0x5b,0x00,0xb5,0x5d,0x00,0x77,0x5e,0x73,0xc7,0x45,		// 1AA0 - 1AAF
		0xcc,0xe1,0x97,0xc4,0xc1,0xec,0xf2,0x80,0x66,0xaf,0xd5,0x91,0x48,0x10,0xdf,0x28,		// 1AB0 - 1ABF
		0xa0,0xf3,0xb6,0x67,0xd7,0xae,0xa7,0x76,0x49,0xbc,0x8c,0xd3,0x4a,0xb5,0xf3,0xe9,		// 1AC0 - 1ACF
		0x66,0x7d,0x7c,0xe5,0xed,0xbc,0x83,0xc5,0xb0,0x8f,0xff,0xb1,0x05,0x7e,0xaa,0x8f,		// 1AD0 - 1ADF
		0x11,0xad,0x63,0xd2,0x46,0x56,0xd0,0x92,0x2a,0x76,0x47,0xe2,0x5a,0xc7,0xef,0x5e,		// 1AE0 - 1AEF
		0xcf,0xef,0x22,0x03,0x61,0xf7,0x16,0x44,0x89,0xfe,0xbd,0x59,0x6b,0x2f,0xe9,0xdb,		// 1AF0 - 1AFF
		0x14,0xf0,0xb4,0x8e,0x00,0x5c,0x1f,0x7e,0xdf,0xf4,0xf9,0x4d,0x98,0x91,0x03,0xcb,		// 1B00 - 1B0F
		0x8f,0x9e,0x51,0xc7,0x24,0x83,0xf3,0x25,0x7c,0x64,0xd5,0x31,0x83,0x0c,0xe4,0x33,		// 1B10 - 1B1F
		0x31,0x24,0x72,0x44,0x0d,0xa9,0xdc,0x5f,0xf0,0x9d,0x6a,0xbb,0x0c,0xfc,0x76,0x58,		// 1B20 - 1B2F
		0x2c,0xf1,0xd1,0xd8,0x3d,0x4a,0x62,0x91,0x0e,0x2a,0x10,0xe0,0x54,0xfd,0xe3,0xc0,		// 1B30 - 1B3F
		0xf1,0xb1,0x65,0x9b,0x76,0x24,0x4f,0x60,0xe6,0xd8,0x61,0xd5,0xbd,0xee,0x92,0x2f,		// 1B40 - 1B4F
		0x30,0x52,0x69,0xe0,0xb7,0x33,0xab,0xb0,0xc9,0xb6,0x36,0x0f,0xe6,0xeb,0x2d,0xa9,		// 1B50 - 1B5F
		0xdb,0x00,0x55,0x3c,0x42,0xb4,0xbf,0xa6,0x48,0x0f,0xa8,0x43,0xb3,0x50,0x9d,0x75,		// 1B60 - 1B6F
		0x23,0x28,0xe3,0x84,0x97,0x25,0x15,0xa9,0x34,0x71,0x0f,0x65,0x42,0xbc,0x0b,0x17,		// 1B70 - 1B7F
		0x78,0x77,0x0a,0xce,0x79,0x43,0x76,0x5c,0x9e,0xa9,0x05,0xac,0xf6,0x0b,0xe0,0x55,		// 1B80 - 1B8F
		0x8b,0xda,0x05,0x6e,0xe7,0x0a,0xe9,0xa5,0xd7,0xc3,0x62,0x8b,0x6f,0x5a,0xc5,0x32,		// 1B90 - 1B9F
		0x4e,0x7f,0x4b,0xfa,0x24,0xb8,0xba,0xa8,0x71,0x0e,0x41,0xb8,0x8f,0x05,0xa3,0xf5,		// 1BA0 - 1BAF
		0xf2,0xd2,0x98,0x46,0xaf,0xc9,0x70,0xcb,0x3b,0x15,0xf9,0x28,0x75,0xab,0xa3,0x21,		// 1BB0 - 1BBF
		0xe7,0x81,0xe2,0x68,0x49,0xfa,0xd4,0xb2,0x47,0xa5,0x24,0x10,0x85,0x28,0x2e,0x7d,		// 1BC0 - 1BCF
		0xdf,0x77,0x63,0xb3,0xf5,0x4a,0xef,0x44,0xe7,0xcd,0x9a,0xe5,0x5d,0x99,0xec,0x0d,		// 1BD0 - 1BDF
		0xcb,0xe3,0x95,0xbf,0xf3,0xf3,0x0c,0xa3,0xab,0xd8,0x75,0x5c,0xe0,0x5b,0xc8,0x16,		// 1BE0 - 1BEF
		0xdb,0x31,0x30,0x5e,0xc3,0x75,0xb1,0x37,0x63,0x55,0x0e,0x6a,0x2e,0x0b,0xea,0x1d,		// 1BF0 - 1BFF
		0x80,0x0f,0x2d,0xa7,0x27,0x8a,0xa9,0xa3,0x22,0x0e,0xfe,0x43,0xa8,0x85,0xba,0xe8,		// 1C00 - 1C0F
		0x6d,0x68,0xc5,0xef,0x20,0x32,0xfd,0xcd,0x38,0x13,0x1d,0x5e,0xf0,0xe8,0xe3,0x7a,		// 1C10 - 1C1F
		0x90,0x6b,0x72,0xca,0xef,0xa7,0xf5,0xd9,0x36,0xb0,0x85,0x6e,0xe6,0x90,0x4d,0x1a,		// 1C20 - 1C2F
		0x1d,0x84,0xeb,0x0d,0x15,0x69,0x1a,0x2d,0xed,0x71,0x8e,0x6a,0xac,0x1a,0x20,0x4b,		// 1C30 - 1C3F
		0x83,0x61,0x2b,0xcd,0x52,0x32,0x36,0x6e,0x6e,0x24,0xd3,0x85,0xa2,0x63,0xc6,0xd4,		// 1C40 - 1C4F
		0x73,0xed,0x6a,0x60,0xa8,0x02,0x51,0x81,0x0a,0xd5,0x2b,0x35,0x69,0x88,0xe9,0xb9,		// 1C50 - 1C5F
		0xdf,0x57,0x22,0x5b,0x59,0x14,0xb5,0x8a,0x52,0xd3,0xb0,0x2f,0xe2,0xe6,0x70,0x40,		// 1C60 - 1C6F
		0xf8,0x0c,0x0a,0x91,0xe3,0xe5,0xea,0xee,0x18,0xa9,0xba,0x68,0x2f,0x1a,0x86,0xec,		// 1C70 - 1C7F
		0x2e,0xb7,0x1d,0x1a,0x0a,0x33,0xba,0x53,0x6b,0x25,0xe3,0x14,0xb0,0x01,0x92,0x83,		// 1C80 - 1C8F
		0x33,0x47,0x93,0x48,0xce,0xfa,0x2d,0x9e,0x9e,0x54,0x04,0xaa,0x06,0xb8,0x3e,0x0b,		// 1C90 - 1C9F
		0xf7,0xe8,0xe5,0xb2,0x6f,0x78,0x8c,0xf4,0x40,0x83,0x36,0xdd,0x13,0x9c,0x73,0xc8,		// 1CA0 - 1CAF
		0xac,0x07,0xcc,0x2c,0x70,0x2a,0x61,0xb9,0x24,0x3e,0xd1,0xa4,0xf7,0x4a,0x5a,0x3f,		// 1CB0 - 1CBF
		0xc3,0x52,0x42,0xcc,0x90,0xcb,0x75,0x93,0x5a,0x53,0x6f,0x32,0x14,0x9f,0x5c,0x35,		// 1CC0 - 1CCF
		0xec,0xb5,0x7e,0xe6,0xd1,0x5b,0xd0,0x66,0x32,0xcf,0xe9,0xfd,0x09,0xb8,0x22,0xaf,		// 1CD0 - 1CDF
		0x19,0x5d,0xfb,0x10,0x73,0x15,0xbb,0x59,0x3f,0xfe,0x57,0xba,0xb9,0xf2,0x95,0xf2,		// 1CE0 - 1CEF
		0x7a,0xb7,0x71,0x1e,0xf9,0x76,0xc0,0xce,0x51,0x6f,0x13,0x5e,0x45,0xea,0xde,0x84,		// 1CF0 - 1CFF
		0x81,0x71,0xda,0x25,0x22,0x3c,0xa7,0x6d,0x79,0xed,0xb6,0x1e,0x0c,0x7e,0x66,0x28,		// 1D00 - 1D0F
		0xde,0x77,0x6d,0x7b,0xf1,0x64,0x7a,0x19,0x08,0x86,0x19,0x6f,0xb1,0xc9,0xd6,0xe5,		// 1D10 - 1D1F
		0x83,0xf6,0xa5,0xb4,0xa5,0x2a,0x81,0xf7,0x90,0x87,0x54,0x06,0x15,0x29,0x17,0xff,		// 1D20 - 1D2F
		0xa1,0x5b,0x3a,0xa5,0xc0,0x0b,0x46,0x6e,0xe0,0x7c,0xc1,0xd7,0x58,0x3b,0x52,0xfb,		// 1D30 - 1D3F
		0xa8,0x54,0x25,0x64,0x02,0xc5,0x91,0x21,0x0a,0x33,0xf8,0x18,0xdb,0xdc,0xef,0x9e,		// 1D40 - 1D4F
		0x4a,0xcd,0x9f,0x45,0x6e,0x55,0x6b,0xf5,0x60,0xb9,0xd4,0x3f,0x3f,0x29,0x99,0xed,		// 1D50 - 1D5F
		0x77,0xf3,0x22,0xde,0x43,0xf7,0x1e,0x11,0x71,0x5b,0x6c,0xff,0x66,0x80,0x37,0x2e,		// 1D60 - 1D6F
		0x61,0x34,0x66,0x03,0x04,0x29,0x33,0xd8,0x10,0xa5,0x19,0x4e,0x70,0x7c,0xf4,0xe4,		// 1D70 - 1D7F
		0x79,0x3c,0x64,0xc9,0x70,0xa7,0x72,0xef,0x4c,0x66,0x76,0x61,0xbe,0xfb,0x38,0xd6,		// 1D80 - 1D8F
		0x6f,0xf8,0x55,0x86,0x89,0x6e,0xe4,0x3c,0x78,0xa9,0x5a,0xad,0xf2,0x1a,0xab,0x08,		// 1D90 - 1D9F
		0x34,0x95,0xb2,0xce,0x8f,0xbd,0xd3,0xe4,0x24,0xbc,0xdf,0xe7,0xec,0x37,0x37,0xbf,		// 1DA0 - 1DAF
		0xfb,0x80,0x35,0x77,0x05,0x0e,0xc7,0x4b,0x21,0x2b,0x5d,0x03,0xcd,0xed,0x06,0x80,		// 1DB0 - 1DBF
		0x32,0x67,0xd5,0x95,0xaa,0x20,0x8a,0x18,0x80,0xc5,0x6e,0x38,0xf7,0x1a,0x7f,0x10,		// 1DC0 - 1DCF
		0x8d,0x36,0xcd,0x7d,0x80,0xf0,0x24,0x2d,0x92,0x95,0xeb,0xf9,0x09,0xdc,0x4c,0x75,		// 1DD0 - 1DDF
		0xfb,0x1b,0x96,0xc5,0xc8,0xba,0xdf,0xb2,0xe8,0xe8,0xed,0xfd,0xe7,0x8e,0x57,0xf2,		// 1DE0 - 1DEF
		0xad,0x81,0xe7,0x41,0x03,0xfc,0x43,0x0a,0x53,0x4d,0xcc,0x37,0xaf,0xce,0xc7,0x0e,		// 1DF0 - 1DFF
		0x15,0x17,0xbb,0x06,0xf2,0x72,0x19,0xda,0xe4,0x90,0x22,0xdd,0xc4,0x7a,0x06,0x8d,		// 1E00 - 1E0F
		0xe4,0xc9,0x49,0x6a,0x95,0x1a,0x6b,0x09,0xed,0xbd,0xc8,0x64,0xc7,0xad,0xbd,0x74,		// 1E10 - 1E1F
		0x0a,0xc5,0x0c,0x02,0x2f,0x30,0x82,0xba,0xfd,0x22,0xd7,0x81,0x97,0xc5,0xd5,0x08,		// 1E20 - 1E2F
		0xb9,0x77,0xbc,0xa1,0x3f,0x32,0xe6,0x52,0xe7,0x4b,0xa7,0x28,0x57,0x60,0x77,0xce,		// 1E30 - 1E3F
		0x62,0x8c,0x53,0x5e,0x87,0xdc,0x60,0x77,0xba,0x07,0xd2,0x90,0x68,0x59,0x0c,0x8c,		// 1E40 - 1E4F
		0xb5,0xf1,0x08,0x8e,0x08,0x2c,0xfa,0x0e,0xc9,0x61,0x30,0x2d,0x69,0xcf,0x3d,0x45,		// 1E50 - 1E5F
		0xa3,0xd3,0x56,0xc5,0x02,0x5f,0xfc,0x3c,0xa4,0xa7,0xdc,0xb3,0x3d,0x1d,0xf3,0x40,		// 1E60 - 1E6F
		0x5e,0xa0,0xf5,0xd8,0xf8,0xf0,0xf0,0x65,0x1c,0x66,0x2c,0x18,0x04,0xe2,0x57,0x01,		// 1E70 - 1E7F
		0x57,0x04,0xde,0xdd,0xa9,0x9f,0x9e,0x2f,0x41,0x6a,0xbc,0x92,0x20,0xf9,0xd1,0x4d,		// 1E80 - 1E8F
		0x3f,0xec,0x4b,0x28,0x17,0x67,0x10,0x7e,0x66,0xc2,0x64,0x94,0x31,0x81,0x0c,0x29,		// 1E90 - 1E9F
		0x05,0x86,0xb3,0x4e,0x83,0x85,0x8e,0x78,0x1c,0xb9,0x3c,0xd4,0x18,0xd5,0xf0,0xda,		// 1EA0 - 1EAF
		0xdd,0x3e,0xd1,0x25,0x6e,0x77,0xa1,0x82,0x32,0xdc,0x9d,0x47,0xf7,0x94,0xa5,0xe6,		// 1EB0 - 1EBF
		0x36,0xc1,0x9d,0xc1,0x98,0xf9,0x13,0x40,0xba,0xfa,0x22,0x21,0x2d,0x99,0x96,0x10,		// 1EC0 - 1ECF
		0xc2,0xfc,0x50,0x78,0x04,0x09,0xed,0x98,0x05,0x1e,0xa2,0xd9,0x5e,0x03,0x6a,0x5f,		// 1ED0 - 1EDF
		0x71,0x1d,0x64,0xde,0xf1,0xe4,0x76,0xaf,0xa5,0x97,0x37,0x23,0x68,0x2e,0x0c,0x17,		// 1EE0 - 1EEF
		0x75,0x90,0x91,0xc8,0xe1,0x06,0x3a,0xe9,0x69,0xef,0x3a,0xf3,0x6e,0xb6,0xa3,0xbd,		// 1EF0 - 1EFF
		0x3e,0x02,0xcf,0x4c,0x95,0x2c,0x00,0xec,0x64,0xf6,0x43,0x7f,0xd0,0x7a,0x9a,0x16,		// 1F00 - 1F0F
		0x7e,0x60,0x59,0xbe,0x0e,0x54,0xd1,0x9d,0xe5,0xb7,0x2c,0x3d,0x30,0x95,0x98,0x27,		// 1F10 - 1F1F
		0x25,0xd8,0xa8,0xb4,0x8c,0xbb,0xf6,0x20,0x7f,0x81,0x0e,0xe0,0x6e,0x66,0x87,0x35,		// 1F20 - 1F2F
		0x66,0xd6,0x73,0x02,0x92,0xdd,0xfa,0xdb,0x02,0xdf,0x41,0x5e,0xab,0x89,0x91,0xc6,		// 1F30 - 1F3F
		0xaf,0x07,0xb5,0xbd,0xdf,0x77,0xa3,0x72,0x7e,0x9e,0x5f,0xec,0x48,0xda,0x1d,0x9e,		// 1F40 - 1F4F
		0xb3,0x58,0xa6,0x3b,0x75,0x87,0xfc,0xcb,0x46,0xcd,0x41,0xff,0xe7,0x78,0xd5,0xc1,		// 1F50 - 1F5F
		0x63,0xf7,0xbf,0x10,0x95,0x4a,0x4e,0x0b,0xea,0xb7,0xff,0x4b,0x69,0xbf,0xa2,0x76,		// 1F60 - 1F6F
		0xf0,0x50,0xb9,0x11,0xc0,0x3c,0x21,0x96,0x3b,0xea,0xf4,0xc7,0xed,0x4c,0xad,0x41,		// 1F70 - 1F7F
		0xca,0x10,0x8d,0x54,0xb6,0x1b,0x3e,0x12,0x4b,0x33,0xb7,0xa6,0xd6,0xfb,0x5f,0xe8,		// 1F80 - 1F8F
		0xa2,0x25,0x75,0x2e,0x7a,0xe3,0xaf,0x64,0x69,0x9e,0x21,0x5f,0xc4,0xeb,0x61,0x6e,		// 1F90 - 1F9F
		0x6a,0xbb,0xe9,0x32,0x4b,0xd1,0xbc,0xb0,0x27,0x7a,0x4d,0xa5,0x98,0x78,0x9c,0x19,		// 1FA0 - 1FAF
		0x53,0x3f,0xa2,0x37,0xab,0x64,0xef,0x5c,0x57,0x52,0x92,0x6e,0x74,0x3f,0x39,0x6f,		// 1FB0 - 1FBF
		0xce,0x5e,0x99,0x52,0x5b,0x56,0x10,0x0d,0x08,0xf4,0x89,0xef,0xb8,0x1c,0xa1,0x34,		// 1FC0 - 1FCF
		0x8a,0x06,0x08,0xd7,0x5b,0xa7,0x29,0xa7,0x8d,0x6c,0x0d,0x9d,0x06,0x2e,0x7c,0x6d,		// 1FD0 - 1FDF
		0x7b,0x63,0x66,0x5b,0xee,0x91,0x82,0x50,0x75,0x09,0x35,0x2d,0x3e,0xd1,0xb5,0x5f,		// 1FE0 - 1FEF
		0xd0,0xe2,0x6e,0xb4,0x93,0x93,0xa5,0x6c,0x93,0x56,0x5b,0x94,0x81,0xa2,0x74,0x8f,		// 1FF0 - 1FFF
		0xfb,0x30,0x18,0xf6,0x0c,0x6a,0x5a,0xa2,0xf7,0x21,0x17,0x06,0x30,0x7e,0x21,0xc2,		// 2000 - 200F
		0xac,0x3b,0x9d,0x76,0x5a,0x12,0xaa,0xd4,0xf2,0x76,0x44,0xfa,0xed,0x82,0x67,0xfe,		// 2010 - 201F
		0xd4,0x2f,0x77,0xca,0xbe,0xc9,0xdf,0x2a,0x15,0xa4,0xf9,0x23,0x98,0x0b,0x2e,0x87,		// 2020 - 202F
		0xa6,0x79,0x5e,0xc6,0xb9,0x0c,0x81,0x07,0x31,0x36,0x8f,0x77,0x53,0xb6,0x9e,0xe1,		// 2030 - 203F
		0x91,0xc6,0x4a,0x80,0x0b,0x96,0x5a,0x11,0x57,0xfa,0xa1,0x2b,0x7d,0x5f,0x21,0xd3,		// 2040 - 204F
		0x46,0x04,0x77,0x4c,0xb7,0x67,0x73,0x2c,0xd8,0xfd,0x06,0xb5,0xba,0x25,0x61,0x61,		// 2050 - 205F
		0xb7,0x5f,0x5b,0xbf,0xfc,0xb9,0x13,0x7e,0x45,0x8b,0xd7,0xc7,0xe8,0x64,0x45,0xd1,		// 2060 - 206F
		0x15,0x44,0xb0,0xaf,0x5c,0x0c,0xc6,0x6c,0x6f,0x32,0x6f,0x59,0x2a,0xb9,0xf8,0xa6,		// 2070 - 207F
		0xd0,0x61,0x70,0x30,0x98,0x1b,0x52,0x9a,0x68,0xbf,0x65,0x9f,0xe0,0x01,0xe1,0xa6,		// 2080 - 208F
		0x9a,0xa2,0xd3,0x97,0xb0,0xe3,0xc2,0xee,0x7f,0x3f,0x93,0x0e,0xab,0x59,0xaa,0xd7,		// 2090 - 209F
		0x64,0x34,0x52,0x7a,0xe7,0xa2,0x5f,0x8c,0x47,0xff,0x12,0x5a,0x6d,0x1e,0x3c,0x7d,		// 20A0 - 20AF
		0x5d,0x84,0xa6,0xae,0xbc,0xd4,0xb1,0xdb,0x8f,0x8b,0x3a,0x7a,0x46,0xed,0xc0,0x1d,		// 20B0 - 20BF
		0xf9,0x40,0xc9,0x46,0xf1,0x37,0x81,0x7d,0x6a,0xb1,0xa5,0xa1,0x97,0xa4,0x9f,0x7c,		// 20C0 - 20CF
		0xe7,0x53,0xf3,0x99,0x87,0xc8,0xd9,0x5a,0x28,0x7e,0x2b,0x45,0x02,0x5e,0x82,0x9f,		// 20D0 - 20DF
		0x19,0xec,0x9d,0x3c,0xbf,0xc3,0x02,0x95,0x5a,0x3f,0xe7,0x1b,0x67,0x79,0x52,0xcb,		// 20E0 - 20EF
		0xbf,0x78,0x80,0x03,0x19,0xa5,0x84,0x94,0xd1,0x80,0x30,0x18,0xe8,0x92,0x38,0x86,		// 20F0 - 20FF
		0x4b,0xa2,0x95,0x03,0x58,0x2c,0x28,0xfb,0x9e,0x0f,0xa0,0x71,0xe4,0x86,0x9d,0x93,		// 2100 - 210F
		0x6d,0x59,0x15,0x92,0x7b,0x55,0xf8,0xb0,0x12,0xf9,0x0f,0x9b,0xfe,0x72,0x2a,0xf9,		// 2110 - 211F
		0x18,0xca,0x7a,0x44,0xc4,0x5c,0x3c,0xd8,0xbe,0x8b,0x97,0x4a,0x17,0xb3,0xc8,0xfc,		// 2120 - 212F
		0x7a,0x60,0x7c,0xee,0xb4,0xbe,0x7d,0xd7,0x73,0x51,0x91,0x75,0x4e,0xe6,0xa0,0x21,		// 2130 - 213F
		0x06,0xca,0x14,0xa6,0x0c,0x39,0x85,0x53,0x43,0x19,0x96,0x4f,0x06,0xe9,0x1a,0x2d,		// 2140 - 214F
		0x6d,0xf4,0x7c,0xc0,0xcc,0xca,0x5d,0x31,0x7d,0xf0,0x7e,0x4e,0xe0,0xd7,0xe1,0x25,		// 2150 - 215F
		0x9f,0x0b,0x2b,0xd2,0x37,0xad,0x4d,0x95,0xb4,0x23,0x63,0x28,0xbb,0x0e,0xdc,0x4f,		// 2160 - 216F
		0xce,0x7c,0xdc,0xb0,0xcc,0x60,0xde,0xe5,0xb7,0x3f,0x9e,0xd0,0xba,0x2b,0x36,0x2e,		// 2170 - 217F
		0x6b,0xf5,0x87,0x6f,0x4d,0x9f,0xda,0xc6,0x99,0x10,0xc7,0x7c,0x3e,0x0b,0x57,0x89,		// 2180 - 218F
		0x26,0x62,0x65,0x65,0xbb,0x67,0x4a,0x1c,0xaa,0xa4,0xb9,0xa1,0xe6,0xcc,0xe7,0x64,		// 2190 - 219F
		0xf1,0xf1,0xef,0x26,0x57,0xf6,0x76,0x0c,0x7b,0x48,0x8a,0xf3,0x95,0xc9,0xd0,0x04,		// 21A0 - 21AF
		0xfc,0x0d,0xdf,0x88,0xa1,0xc9,0xe7,0xfd,0xdc,0x88,0x96,0x69,0x6c,0xa0,0x3c,0xee,		// 21B0 - 21BF
		0xb9,0x65,0x2d,0x9f,0x5b,0x9c,0x67,0x92,0xe0,0x33,0x74,0x36,0xca,0x2f,0x92,0xe7,		// 21C0 - 21CF
		0xd8,0xe5,0x12,0xc0,0x87,0x6d,0xfe,0xb1,0xd7,0x54,0xfe,0xd1,0x52,0x91,0x7c,0xf5,		// 21D0 - 21DF
		0x4b,0xba,0x07,0x81,0x64,0x78,0xf5,0x7e,0x53,0x39,0x4d,0xed,0xe5,0x24,0xe4,0x5b,		// 21E0 - 21EF
		0x42,0x52,0xc5,0xb6,0x74,0x3b,0xd6,0x5f,0x23,0x6e,0xb9,0x80,0xa2,0x86,0xf1,0xa0,		// 21F0 - 21FF
		0x30,0x59,0x46,0x75,0x77,0x72,0x6a,0xf9,0x59,0xc2,0xdc,0xc0,0xec,0x92,0x0d,0x88,		// 2200 - 220F
		0xc3,0xbc,0xc2,0x12,0x70,0x1b,0xb9,0x30,0x46,0x40,0x8f,0x20,0x64,0x66,0xe1,0x18,		// 2210 - 221F
		0xef,0xa8,0xb2,0x22,0x9e,0x72,0x0c,0x2a,0x7c,0x36,0xea,0x55,0xe9,0x60,0x56,0x95,		// 2220 - 222F
		0xe2,0x8b,0xcf,0x7b,0x83,0xf5,0xed,0x4c,0xca,0x30,0x48,0x56,0x9e,0x1b,0x95,0x84,		// 2230 - 223F
		0x10,0x11,0x12,0x31,0xe0,0x60,0x25,0x3a,0x43,0xfd,0x3f,0x57,0xe3,0x76,0x07,0xab,		// 2240 - 224F
		0x28,0x27,0xb5,0x99,0xb6,0xb1,0xbb,0xda,0x37,0xa8,0xab,0xcc,0x5a,0x8c,0x55,0x0d,		// 2250 - 225F
		0x1b,0xfb,0x2f,0x49,0x46,0x24,0xfb,0x50,0x36,0x7f,0xa3,0x6c,0xe3,0xbc,0x68,0xf1,		// 2260 - 226F
		0x1c,0xf9,0x3b,0x15,0x10,0x37,0x6b,0x02,0x13,0x0f,0x81,0x2a,0x9f,0xa1,0x69,0xdb,		// 2270 - 227F
		0x99,0xce,0xd2,0x13,0xd6,0xa7,0xd6,0x95,0xde,0x24,0xde,0x3c,0xf0,0x1a,0xc0,0x90,		// 2280 - 228F
		0x46,0x67,0x2b,0x97,0x99,0x6f,0x45,0xee,0xe8,0xcd,0x92,0x17,0x76,0x42,0x18,0x15,		// 2290 - 229F
		0x12,0xf1,0xc1,0x36,0x9a,0xcf,0x00,0x31,0xc2,0x55,0xb7,0x70,0x12,0x78,0x59,0xaf,		// 22A0 - 22AF
		0x2e,0xda,0x4c,0xc6,0x5a,0x42,0x91,0xc3,0x3d,0x4a,0xa6,0x3c,0xe5,0x57,0xab,0xe4,		// 22B0 - 22BF
		0x0c,0xce,0xc5,0x5b,0x9a,0x85,0xc0,0x4b,0x6b,0x78,0xf8,0xb0,0x51,0xbe,0x79,0x77,		// 22C0 - 22CF
		0x5d,0xbb,0x65,0x4b,0x5a,0x96,0x96,0xac,0x9b,0xed,0x85,0x41,0xf7,0xc8,0x6a,0x6f,		// 22D0 - 22DF
		0x11,0xcc,0xa5,0x2a,0xdd,0xb2,0x5d,0x0b,0x5f,0xf7,0x67,0xa3,0xb6,0xd4,0x69,0x10,		// 22E0 - 22EF
		0x5a,0x70,0x3f,0xcd,0xa2,0x55,0x9d,0xcf,0x89,0x20,0xf6,0xcd,0xb1,0x7d,0x9d,0xdf,		// 22F0 - 22FF
		0xa8,0x53,0x2b,0x4a,0x6b,0x3c,0x20,0x9a,0x28,0x38,0xcd,0xf2,0x48,0xa2,0x71,0xa1,		// 2300 - 230F
		0xad,0x63,0xa2,0xf5,0x38,0x65,0xee,0x54,0x8f,0x4b,0xc3,0x88,0x1d,0x5f,0x8c,0x5b,		// 2310 - 231F
		0x5a,0xcb,0x1d,0x64,0x4c,0x0d,0x51,0x20,0x4e,0xa5,0xf1,0x45,0x10,0x10,0xd8,0x52,		// 2320 - 232F
		0xdf,0xfa,0x55,0x6b,0x26,0xb0,0xd1,0x64,0x35,0xd4,0xb2,0x1c,0x42,0x54,0x7f,0x0c,		// 2330 - 233F
		0xad,0x9c,0x44,0x1f,0x89,0x0b,0x38,0xc4,0x57,0xa4,0x9d,0x42,0x14,0x07,0xe8,0x4d,		// 2340 - 234F
		0x77,0x9f,0x22,0xd6,0x74,0x1c,0x8e,0x27,0x04,0x24,0x8c,0x2e,0x28,0x45,0xbd,0x19,		// 2350 - 235F
		0x2b,0x2f,0x68,0x24,0x28,0x20,0x1c,0xaf,0xcd,0x9f,0x97,0x94,0x5e,0x6d,0xe7,0xb7,		// 2360 - 236F
		0xfd,0xb9,0xcf,0xdf,0x28,0x93,0x6c,0xc4,0x83,0xa3,0x18,0x69,0xd8,0x1b,0x8f,0xab,		// 2370 - 237F
		0x5c,0xea,0x51,0x1a,0x34,0x33,0x47,0x09,0x37,0xfd,0xa8,0xe1,0xf6,0x2c,0x1e,0xbb,		// 2380 - 238F
		0xf9,0xb0,0x25,0x2d,0x4c,0xfc,0xb4,0x63,0x3b,0xb9,0x20,0x72,0x59,0xbc,0x3d,0xea,		// 2390 - 239F
		0xc7,0x36,0xc6,0xaa,0xb2,0x2b,0xff,0xf9,0x1e,0x26,0x98,0xd2,0xe2,0x2a,0xd5,0x7e,		// 23A0 - 23AF
		0xf4,0xeb,0xec,0x69,0xe7,0x3e,0xaf,0x2e,0xb2,0xcf,0x6a,0xf4,0xb3,0x12,0x0f,0xfd,		// 23B0 - 23BF
		0xf4,0x7c,0x90,0x7c,0xac,0xf2,0x8d,0xa7,0x09,0x82,0x2f,0x0e,0x2c,0x51,0x54,0x2b,		// 23C0 - 23CF
		0x76,0xd4,0xec,0x3a,0x02,0x43,0xa2,0x4b,0x72,0x4b,0xc0,0x95,0xef,0x04,0x4c,0x0d,		// 23D0 - 23DF
		0x6b,0x22,0x77,0x37,0x29,0x6f,0x39,0x3c,0x80,0x79,0x35,0x3e,0xdc,0x87,0xe2,0xe8,		// 23E0 - 23EF
		0x05,0xd2,0xec,0x49,0xa4,0xf2,0xd8,0xe2,0x03,0x97,0xe8,0xfd,0x14,0x79,0x3e,0x41,		// 23F0 - 23FF
		0xb5,0x92,0x43,0x84,0x32,0x8a,0x4a,0xe0,0x0b,0x73,0x71,0x09,0xf8,0xb6,0xc8,0xdd,		// 2400 - 240F
		0x2b,0x4d,0xb6,0x3d,0xd5,0x33,0x98,0x1c,0xeb,0x19,0xaa,0xd5,0x2a,0x5b,0x2b,0xc2,		// 2410 - 241F
		0x59,0x32,0xbc,0x0a,0xce,0x2b,0x0a,0xba,0x33,0xd8,0xac,0x18,0x8a,0xc5,0x4f,0x34,		// 2420 - 242F
		0x6f,0xad,0x10,0xbf,0x9d,0xee,0x29,0x20,0xb4,0x3b,0xd0,0xc5,0x3a,0x91,0x5c,0xb7,		// 2430 - 243F
		0xdf,0x6c,0xaa,0x72,0x05,0x3a,0xbf,0xf3,0x7f,0x10,0xae,0x12,0x99,0x9c,0xbc,0x12,		// 2440 - 244F
		0x59,0x5b,0xc3,0x77,0x05,0x0b,0xd4,0x17,0xe5,0x64,0x20,0x74,0x4a,0x03,0x19,0x49,		// 2450 - 245F
		0xd0,0xa7,0xd4,0x63,0xdf,0x9f,0xb2,0xb2,0x78,0x83,0x3f,0xa0,0x2e,0x23,0x5a,0xa1,		// 2460 - 246F
		0x72,0xbd,0x97,0x0c,0x14,0x73,0xe1,0x29,0x07,0xfb,0x64,0x8b,0x65,0x99,0xaa,0xa0,		// 2470 - 247F
		0xb2,0x4a,0x03,0x86,0x65,0x42,0x2b,0x20,0xa4,0x99,0x27,0x6a,0x50,0x42,0x70,0x09,		// 2480 - 248F
		0x41,0x3c,0x53,0x27,0xd3,0x0c,0x98,0x7d,0xa1,0x6a,0x62,0xb1,0x90,0x3b,0x56,0xe3,		// 2490 - 249F
		0x10,0xbf,0xff,0x83,0x9e,0x0c,0x71,0x65,0x8d,0xbb,0x2d,0x17,0x07,0xe1,0x45,0x72,		// 24A0 - 24AF
		0x4f,0x41,0xc1,0x6f,0x48,0xbf,0x40,0x3c,0x3b,0x18,0xe3,0x8f,0xd5,0xd1,0x66,0x3b,		// 24B0 - 24BF
		0x6f,0x6d,0x90,0x01,0x93,0xe3,0xce,0xa8,0xbb,0x4f,0x1b,0x4f,0x5b,0xe8,0x22,0x03,		// 24C0 - 24CF
		0x22,0x32,0xa7,0x8d,0x7d,0x75,0x23,0x8d,0x5e,0x6d,0xae,0xcd,0x3b,0x43,0x22,0xcf,		// 24D0 - 24DF
		0x59,0xbc,0x7e,0xa8,0x4a,0xb1,0x88,0x11,0xb5,0xbf,0xb7,0xbc,0x55,0x3f,0x4f,0xe4,		// 24E0 - 24EF
		0x44,0x78,0xce,0x28,0x7a,0x14,0x87,0x99,0x90,0xd1,0x8d,0x12,0xca,0x79,0xd2,0xc8,		// 24F0 - 24FF
		0x55,0x14,0x90,0x21,0xcd,0x5c,0xe8,0xca,0x03,0x71,0xca,0x04,0xfc,0xce,0x14,0x3e,		// 2500 - 250F
		0x3d,0x7c,0xfe,0xe9,0x45,0x85,0xb5,0x88,0x5c,0xac,0x46,0x06,0x8b,0x5b,0xbe,0x4d,		// 2510 - 251F
		0xec,0xdd,0x8f,0x14,0x24,0xcd,0x36,0xf8,0x2d,0xcf,0x1b,0xcf,0x59,0x7e,0xb9,0x39,		// 2520 - 252F
		0x93,0xa5,0xfe,0x77,0xe8,0xb1,0xf5,0x81,0x47,0x66,0xa2,0x52,0x85,0xd2,0x2e,0x87,		// 2530 - 253F
		0xa4,0x7f,0x44,0x28,0x55,0xed,0xba,0xc6,0xbb,0x3f,0x74,0xc6,0x72,0x35,0x85,0xfc,		// 2540 - 254F
		0xd0,0x5a,0x98,0x7c,0x6b,0x7f,0x8f,0xac,0xdb,0x67,0x69,0x9e,0xc1,0xc4,0x69,0x9d,		// 2550 - 255F
		0x08,0x62,0x74,0x06,0x6a,0xa3,0xbc,0x5a,0x36,0x2b,0x9b,0x90,0x51,0xdc,0xc1,0xb0,		// 2560 - 256F
		0x7b,0x05,0x92,0x9d,0xd4,0xd6,0xca,0x32,0x9f,0x18,0x63,0x91,0x45,0x1b,0xb8,0xb8,		// 2570 - 257F
		0x9d,0xef,0xea,0x56,0x6a,0xd6,0x83,0xdc,0x26,0xfa,0x59,0xd6,0xfe,0x5c,0xb6,0x7c,		// 2580 - 258F
		0x1d,0x0d,0xb5,0x84,0x2d,0xa0,0xef,0x3b,0x1b,0xdf,0x57,0xd4,0x1b,0xbd,0x63,0x00,		// 2590 - 259F
		0xed,0x8c,0x6d,0xbf,0x5e,0x70,0x58,0x75,0x11,0x14,0x76,0x40,0x7f,0x9b,0xa9,0x89,		// 25A0 - 25AF
		0x3d,0xda,0xc9,0xd9,0x7e,0xc4,0x46,0xee,0xd8,0x25,0x0f,0x0f,0x4b,0x94,0xb2,0x9c,		// 25B0 - 25BF
		0x7f,0xa2,0xc4,0xe9,0x4d,0x58,0x83,0x4c,0x81,0xe1,0xba,0x75,0xde,0x83,0xe5,0xfe,		// 25C0 - 25CF
		0x63,0xd4,0x96,0x43,0xcd,0x2a,0x17,0x74,0x5d,0x53,0x51,0xe9,0xdb,0x86,0xec,0xb5,		// 25D0 - 25DF
		0xdb,0x9a,0xb8,0x7d,0x3f,0x76,0x4c,0x8b,0xfd,0xc9,0xed,0x1e,0x23,0xfb,0xb1,0x04,		// 25E0 - 25EF
		0x18,0x63,0xe3,0x6b,0x24,0xba,0xaa,0xf5,0x32,0xcf,0xe6,0x0a,0xd5,0x7d,0x5b,0x72,		// 25F0 - 25FF
		0x8a,0xda,0x11,0x23,0x3d,0xb2,0xfa,0x57,0x0e,0x34,0xd6,0xe2,0x54,0xea,0x54,0xc3,		// 2600 - 260F
		0xe2,0xef,0x7a,0xf9,0x8a,0x5c,0x46,0x98,0xe0,0x03,0x96,0x1b,0x40,0x60,0x45,0xfc,		// 2610 - 261F
		0x13,0xcc,0x97,0x82,0x4d,0xf4,0xd7,0xdb,0x3a,0x8a,0x3e,0x6a,0x7b,0x3a,0x17,0x62,		// 2620 - 262F
		0x4c,0xe0,0x21,0x94,0x08,0xf8,0x35,0x85,0xee,0x55,0x28,0xc4,0x25,0x17,0xf3,0x7a,		// 2630 - 263F
		0xfe,0xd7,0x11,0x43,0x7a,0x24,0x29,0x3c,0x0c,0x33,0xed,0x5e,0x9f,0xd2,0x42,0x0a,		// 2640 - 264F
		0xdb,0x9e,0xa1,0xe4,0xa4,0x76,0xbd,0xe5,0xe4,0x2f,0x66,0xac,0x8b,0x89,0xad,0x15,		// 2650 - 265F
		0xd4,0x62,0x49,0x0d,0xc9,0x2a,0x39,0xa5,0x09,0x97,0xab,0x65,0xc9,0x9a,0x1d,0xe2,		// 2660 - 266F
		0x19,0x91,0xc2,0x92,0x68,0xbe,0x27,0xe0,0x4b,0xf8,0x16,0x7c,0x7a,0xa0,0xbb,0xf5,		// 2670 - 267F
		0x1b,0xd7,0x05,0x89,0x44,0xee,0x4f,0x3c,0xbb,0x1e,0x40,0x27,0x00,0x7a,0xef,0x13,		// 2680 - 268F
		0x8d,0x21,0x4b,0x46,0x5c,0xb8,0xbb,0x9d,0xaa,0x18,0x01,0xdb,0xfb,0x43,0x64,0x41,		// 2690 - 269F
		0x5e,0x9d,0x0e,0x5f,0xf2,0x59,0xb3,0x29,0xa9,0x31,0x73,0x4d,0x4c,0x5a,0x02,0xc4,		// 26A0 - 26AF
		0xbf,0xb7,0x06,0xa7,0x87,0x4d,0xc0,0x45,0x89,0xf7,0xef,0x72,0x14,0x5a,0xf1,0x22,		// 26B0 - 26BF
		0x22,0x1c,0x2c,0x36,0xdb,0x51,0xac,0x95,0x5b,0x36,0x0d,0x7f,0xb5,0x22,0x9c,0x1e,		// 26C0 - 26CF
		0x38,0xb9,0xb9,0x5e,0xf1,0x63,0x80,0xff,0x70,0xfd,0xa8,0xe9,0xcf,0xce,0xaa,0xbf,		// 26D0 - 26DF
		0xf1,0xbc,0x26,0xb6,0x08,0xbf,0x83,0xa8,0x5a,0x97,0xd7,0x64,0x44,0xba,0x06,0x49,		// 26E0 - 26EF
		0x7f,0x91,0x2d,0x13,0xa2,0xe3,0x41,0xf4,0xe8,0x92,0xf3,0xe7,0x34,0x85,0xd7,0x41,		// 26F0 - 26FF
		0x52,0xe5,0xc6,0x88,0x80,0x8c,0x81,0x89,0x2d,0xba,0x96,0xa5,0x00,0x0a,0x88,0x6c,		// 2700 - 270F
		0x1c,0xa5,0x2a,0x6d,0xa3,0xb6,0x4c,0x4b,0x78,0x1e,0x99,0x14,0x4a,0x68,0xc0,0xcf,		// 2710 - 271F
		0xce,0xff,0xd2,0x54,0x4b,0x9e,0xeb,0x61,0x5c,0x09,0x15,0xe9,0xf2,0xfb,0x69,0xaf,		// 2720 - 272F
		0x98,0x5f,0x78,0x14,0xfb,0xc2,0xe9,0x2d,0xa9,0x09,0x63,0x19,0x19,0x5f,0xad,0x92,		// 2730 - 273F
		0xec,0x72,0x13,0xc1,0x72,0xdf,0x0c,0x57,0x70,0xea,0x1b,0xd9,0x20,0x73,0xf3,0x3b,		// 2740 - 274F
		0x7a,0x26,0xde,0xb1,0xb2,0xf1,0x5f,0xc2,0x02,0xbb,0x16,0x9e,0xa9,0x53,0xe5,0xb1,		// 2750 - 275F
		0x34,0xa6,0x51,0x78,0xfc,0x36,0x2b,0x94,0xf0,0xc7,0x6f,0x1d,0x94,0x5b,0x6c,0x38,		// 2760 - 276F
		0x4a,0x61,0x25,0xec,0xd1,0x2a,0xf8,0x31,0x0b,0x9c,0x7d,0x4a,0x03,0x2a,0xb1,0x55,		// 2770 - 277F
		0x2e,0x04,0x54,0x21,0xf1,0x8a,0x8f,0x3f,0x64,0x07,0xda,0x5c,0x56,0x9c,0x1d,0xce,		// 2780 - 278F
		0x91,0x7a,0x15,0x6c,0x5e,0x54,0xfa,0xa3,0x4c,0x15,0x5f,0xc6,0x2e,0xce,0x59,0xa6,		// 2790 - 279F
		0x63,0xf2,0xe3,0x63,0x5a,0xc5,0x81,0x81,0x54,0x12,0x24,0x3e,0x6c,0x1c,0x4e,0x23,		// 27A0 - 27AF
		0xd5,0xd8,0x76,0xda,0x64,0x59,0xae,0x3f,0x4e,0x8c,0x83,0xb9,0x32,0x25,0x25,0xcb,		// 27B0 - 27BF
		0x5a,0xd9,0xc8,0xe6,0x3e,0xce,0x49,0x82,0x49,0x50,0x15,0x6d,0xe0,0xc5,0x47,0x62,		// 27C0 - 27CF
		0xa1,0xe3,0x10,0xdd,0xe8,0x20,0x5c,0x2e,0x98,0x6a,0xb2,0xcc,0x18,0x19,0x5c,0xed,		// 27D0 - 27DF
		0x9b,0x22,0xc9,0x53,0xa5,0x8d,0x2f,0x69,0xcb,0x29,0x74,0x8e,0xba,0x7e,0x4f,0xb1,		// 27E0 - 27EF
		0x7a,0x03,0xab,0x1e,0xf4,0x91,0x4c,0x97,0xb2,0x18,0xb4,0xa7,0xe7,0x91,0x48,0x33,		// 27F0 - 27FF
		0xaf,0x33,0xaf,0x52,0x97,0xea,0x7b,0x5f,0x60,0x05,0x0b,0x4c,0x00,0x2e,0xaf,0x38,		// 2800 - 280F
		0xea,0xa0,0x0e,0x44,0x8f,0x94,0xc5,0xa3,0x25,0xfc,0x51,0xf1,0xa7,0x74,0x2f,0xc6,		// 2810 - 281F
		0x1d,0x76,0x41,0x8a,0x1d,0xcd,0x74,0x8b,0x92,0x4c,0xa0,0x4c,0xbc,0xbf,0xb0,0x21,		// 2820 - 282F
		0x78,0x22,0x02,0xf8,0xc2,0x11,0x11,0x7a,0x78,0x80,0x51,0x53,0x60,0xac,0x5a,0xcd,		// 2830 - 283F
		0x6d,0x51,0x49,0xa4,0x3e,0x1e,0x63,0x16,0xe8,0x66,0xfc,0x39,0xf5,0x18,0x98,0x91,		// 2840 - 284F
		0xad,0xf1,0x4f,0xe2,0x94,0xf0,0x76,0x43,0x33,0x0b,0x7b,0x74,0x1b,0x20,0x11,0x71,		// 2850 - 285F
		0x28,0x2e,0x8d,0x47,0x03,0xc5,0x90,0x27,0xea,0xbb,0xe7,0xb9,0xb4,0x21,0xaf,0xb2,		// 2860 - 286F
		0x0f,0x75,0xbd,0xa9,0x0d,0x19,0x3d,0x27,0xdf,0x04,0x98,0xfd,0xe0,0xb8,0x9c,0xda,		// 2870 - 287F
		0xd5,0x74,0xd7,0x1c,0x72,0xaa,0x43,0xe7,0x21,0xb3,0x29,0x74,0x00,0xc2,0x3f,0xac,		// 2880 - 288F
		0x28,0x17,0x13,0xf6,0x35,0x75,0xad,0x4d,0x03,0xd5,0x70,0x95,0xb5,0x5c,0x42,0x2f,		// 2890 - 289F
		0xfc,0x8b,0xed,0xcb,0x96,0xb6,0xc4,0x7d,0x14,0xb7,0x89,0x14,0xe1,0xe3,0x8e,0xa7,		// 28A0 - 28AF
		0x80,0x3d,0x1b,0x70,0x15,0xea,0x10,0xdd,0x27,0xe5,0xcb,0xe5,0xa4,0xf4,0x4c,0x99,		// 28B0 - 28BF
		0x25,0xdb,0x97,0xfb,0x74,0xcf,0x5a,0x12,0x4c,0x2d,0xd0,0x3e,0x5f,0x6c,0xe5,0xca,		// 28C0 - 28CF
		0x9d,0x51,0x9b,0xc0,0xb4,0x61,0xac,0x01,0xd3,0x9c,0x71,0x94,0xb4,0x68,0x02,0x3f,		// 28D0 - 28DF
		0xd9,0xcc,0x9f,0x54,0x16,0xde,0x4f,0xce,0x4f,0x7f,0xc6,0x9c,0x83,0x45,0x8c,0x3d,		// 28E0 - 28EF
		0x09,0xb9,0x5c,0x8d,0x1a,0xc3,0xcb,0xdf,0x90,0x62,0x2a,0x4b,0xed,0xa0,0xac,0x4a,		// 28F0 - 28FF
		0x9f,0xc6,0xcc,0x80,0x83,0xcc,0xe9,0xd8,0xa7,0x13,0x33,0xd6,0x54,0x57,0xcb,0x29,		// 2900 - 290F
		0x4c,0xdf,0x26,0x80,0x50,0xf6,0xb3,0x9f,0xe5,0x9f,0xbd,0xb2,0x58,0x85,0x92,0xe1,		// 2910 - 291F
		0x00,0x31,0xe5,0x24,0xc3,0x7f,0x71,0x59,0xdb,0x53,0xdf,0x94,0xda,0x88,0xea,0xb6,		// 2920 - 292F
		0xec,0x29,0xc1,0x41,0x5d,0xe4,0xac,0x6a,0x5b,0xbb,0xf3,0x70,0xfc,0xfd,0xfc,0x2d,		// 2930 - 293F
		0x83,0x75,0xb3,0xeb,0xdf,0xe1,0x2e,0x78,0x74,0xa6,0x92,0x7d,0x1e,0xc1,0x30,0x0b,		// 2940 - 294F
		0x73,0x01,0xf4,0x77,0x49,0x73,0x00,0x68,0x79,0x1e,0x94,0x2e,0xe2,0xf1,0x31,0x55,		// 2950 - 295F
		0xb0,0xfa,0xfe,0x7a,0xde,0xd9,0x6a,0x5e,0xf9,0x73,0x13,0x39,0x27,0xeb,0xe7,0x51,		// 2960 - 296F
		0x69,0xce,0x88,0xca,0x1d,0x8d,0xf5,0xc0,0xc7,0x31,0x68,0x93,0x10,0x4a,0x7a,0x82,		// 2970 - 297F
		0x0f,0x28,0x8d,0x7c,0xc8,0x4e,0x6b,0x32,0xf2,0x24,0x2b,0x71,0xfe,0xec,0x55,0xaf,		// 2980 - 298F
		0x54,0xf7,0x46,0xe4,0xe0,0x19,0xd5,0x9b,0xcd,0x5a,0x36,0x48,0x90,0xee,0x1f,0xdc,		// 2990 - 299F
		0x29,0x68,0x2a,0x97,0xa5,0x2a,0x7b,0x1d,0xe8,0x20,0xa2,0xcd,0xa9,0xae,0xc2,0x4e,		// 29A0 - 29AF
		0xbe,0xe6,0xf3,0x6a,0x9a,0xff,0xe6,0x20,0x14,0x02,0xc8,0xf4,0x6a,0xc7,0x68,0x8a,		// 29B0 - 29BF
		0x85,0x20,0x9b,0x73,0x7e,0x54,0xe0,0x47,0x62,0xcf,0x40,0xf4,0x32,0x17,0x78,0x55,		// 29C0 - 29CF
		0x2e,0x02,0x5a,0x07,0x53,0x27,0x71,0x78,0x23,0x92,0xe4,0x40,0xa4,0xbc,0x9c,0xb5,		// 29D0 - 29DF
		0xab,0xba,0xa9,0xb9,0x5a,0xb4,0xe2,0xd7,0xe8,0x99,0xcc,0x8f,0xa0,0x11,0xbe,0xed,		// 29E0 - 29EF
		0x2d,0xb3,0x42,0x61,0x14,0x79,0xbd,0xca,0x82,0x70,0x53,0xd4,0x48,0xb4,0x05,0x84,		// 29F0 - 29FF
		0x24,0x9c,0x1c,0x11,0x42,0x32,0xcb,0xf6,0x02,0xe6,0x10,0x45,0xfc,0x83,0xdb,0x3e,		// 2A00 - 2A0F
		0x42,0x61,0x72,0x20,0xe4,0xdd,0x14,0x3f,0xba,0x06,0xdc,0x57,0x5d,0x99,0xe9,0x20,		// 2A10 - 2A1F
		0x77,0x30,0xbc,0x22,0x3d,0xb6,0xe1,0xcb,0x39,0x1e,0xd2,0xbf,0x4d,0x54,0x18,0x6f,		// 2A20 - 2A2F
		0xf5,0x74,0xb3,0xed,0xcc,0x3b,0xbc,0xff,0x52,0xbb,0x49,0x72,0xec,0x52,0x91,0xb0,		// 2A30 - 2A3F
		0x2c,0xdc,0x51,0x95,0x53,0x28,0x6e,0x7f,0x14,0xa9,0xdb,0xa4,0x9b,0x6e,0xbd,0xa9,		// 2A40 - 2A4F
		0xce,0x54,0xcd,0x70,0xd3,0x7b,0xfe,0x31,0xd2,0xf6,0x61,0xcc,0xfc,0xc7,0x45,0x5d,		// 2A50 - 2A5F
		0xcc,0x0a,0xa2,0x11,0x8c,0x70,0xb8,0x39,0x1c,0xef,0xf3,0x9d,0xef,0xb8,0x12,0x13,		// 2A60 - 2A6F
		0x56,0x6a,0x88,0x50,0x01,0x85,0x22,0xfd,0xc2,0x21,0xeb,0x0e,0x95,0xe0,0x4d,0x4f,		// 2A70 - 2A7F
		0xde,0x21,0x78,0x3f,0xf1,0x76,0x08,0x22,0xd7,0x59,0xe1,0x52,0x50,0x1a,0x5e,0xd6,		// 2A80 - 2A8F
		0x14,0x1c,0xac,0x35,0x5e,0x41,0x70,0x8c,0xab,0xa3,0xb0,0xdf,0xbf,0x85,0xf0,0xad,		// 2A90 - 2A9F
		0xea,0x89,0x9b,0xc7,0x89,0x23,0xa5,0x62,0xcf,0x4d,0x6f,0x6a,0xc6,0x7c,0xeb,0x19,		// 2AA0 - 2AAF
		0x90,0xd3,0x00,0xc9,0xf3,0x97,0x30,0x06,0x15,0xe4,0x78,0xe8,0x83,0x9e,0x77,0x9f,		// 2AB0 - 2ABF
		0x78,0xa9,0xd3,0x50,0x5d,0x5d,0xd9,0x20,0x8c,0x34,0x63,0x8e,0x59,0xc6,0xff,0x05,		// 2AC0 - 2ACF
		0x53,0xf8,0x4d,0xb1,0xc7,0x70,0xa9,0x93,0x86,0x4c,0x0a,0xd0,0xe8,0x13,0x2a,0x4f,		// 2AD0 - 2ADF
		0x11,0xeb,0xe8,0x82,0x73,0x0d,0xea,0x84,0x94,0x77,0x86,0x65,0x12,0xe0,0xe3,0xc2,		// 2AE0 - 2AEF
		0xe4,0xf1,0x5b,0x98,0xe2,0xb2,0x24,0x59,0x88,0x43,0x30,0x40,0xf7,0xcc,0x51,0xe2,		// 2AF0 - 2AFF
		0x3c,0xb6,0xa1,0x07,0xd5,0x1c,0x21,0xb7,0x71,0x7c,0xa0,0x98,0xf8,0xb3,0xdf,0x77,		// 2B00 - 2B0F
		0xcb,0x28,0xf2,0x24,0x4d,0x47,0xe9,0x83,0xa2,0x31,0xb0,0xe0,0xb7,0xb1,0x34,0x83,		// 2B10 - 2B1F
		0x82,0x73,0xc7,0x84,0x8b,0x70,0xc6,0xe1,0xab,0xad,0x79,0xce,0x13,0x25,0x3a,0x4c,		// 2B20 - 2B2F
		0x91,0x03,0xda,0xfd,0x0f,0x15,0x40,0x37,0x5d,0x7e,0x53,0x57,0x30,0xab,0x1b,0x58,		// 2B30 - 2B3F
		0x6a,0x88,0x22,0xa4,0x9b,0xf3,0x21,0x29,0xc8,0x71,0xd8,0xb0,0x6c,0x1f,0x3e,0x6a,		// 2B40 - 2B4F
		0xbd,0xec,0xda,0xcc,0x30,0x06,0x71,0x9d,0x3f,0x92,0xe1,0x4e,0x6a,0xa0,0x4d,0x89,		// 2B50 - 2B5F
		0x7c,0x5e,0x7a,0x0c,0x0f,0x8b,0x79,0xb8,0x52,0x2f,0x87,0xe5,0x0a,0x8a,0x31,0xf9,		// 2B60 - 2B6F
		0xd7,0x4a,0xbc,0x39,0xb9,0x01,0xc3,0xdf,0xd2,0xd5,0x22,0x6c,0x6e,0x7a,0x13,0x3f,		// 2B70 - 2B7F
		0x40,0x5d,0x97,0x67,0xee,0x22,0x18,0xb6,0xd1,0x51,0x4c,0x16,0xf6,0x4c,0x5c,0x20,		// 2B80 - 2B8F
		0x68,0x85,0x46,0xeb,0xb1,0xed,0x80,0x22,0x9e,0xb0,0xde,0x5a,0x43,0x1f,0xb5,0xa2,		// 2B90 - 2B9F
		0x3f,0xed,0x41,0x5b,0x41,0x9f,0x44,0x4a,0xcb,0x3e,0xf0,0xeb,0x36,0x4f,0x07,0x08,		// 2BA0 - 2BAF
		0xf7,0x05,0x41,0x8b,0x20,0xb4,0xee,0x91,0x2a,0x89,0xdc,0xbf,0xf1,0x79,0x7b,0xd9,		// 2BB0 - 2BBF
		0x00,0x77,0x3f,0x90,0x0f,0xea,0x46,0x9c,0xca,0x5e,0x3b,0x0b,0xd4,0x79,0x7a,0xd9,		// 2BC0 - 2BCF
		0x0c,0x31,0x74,0xc0,0x0f,0x3d,0x55,0x51,0xfe,0xc9,0xe5,0x44,0x81,0x6e,0xac,0x0d,		// 2BD0 - 2BDF
		0x0b,0x61,0x5a,0xb0,0x60,0xeb,0x66,0xd5,0x55,0x19,0xf4,0x1f,0xd7,0xb4,0xfc,0xba,		// 2BE0 - 2BEF
		0x2f,0x73,0xa9,0x33,0x84,0x70,0xff,0x8d,0xa2,0xd9,0xc1,0x91,0xfa,0xe8,0x92,0x65,		// 2BF0 - 2BFF
		0xe9,0x15,0x5a,0x60,0x3d,0x8a,0xeb,0x1d,0xf5,0xd7,0xe5,0xce,0x48,0xe7,0xd6,0xd3,		// 2C00 - 2C0F
		0xe9,0x32,0xa6,0x8c,0x8a,0x35,0x33,0x6b,0x9f,0x1f,0x38,0x4d,0x64,0xce,0x73,0x0a,		// 2C10 - 2C1F
		0x21,0xf9,0x07,0x4a,0xac,0xaf,0x1f,0x9b,0x30,0x00,0xd4,0xc1,0x2e,0xfa,0x51,0x4d,		// 2C20 - 2C2F
		0xc1,0xd7,0x34,0x72,0x26,0x74,0x38,0x13,0x7b,0x05,0x11,0x20,0xc7,0x08,0x98,0x23,		// 2C30 - 2C3F
		0x3b,0x77,0x28,0x16,0xb8,0x42,0x48,0x78,0x91,0xfc,0x8a,0xa0,0x91,0xd4,0xb3,0x50,		// 2C40 - 2C4F
		0x40,0xc8,0x1b,0x8d,0x62,0x15,0x57,0xae,0xc1,0xf2,0x16,0xb4,0x2c,0x7d,0x49,0xd9,		// 2C50 - 2C5F
		0xc0,0xf6,0x87,0x6c,0x66,0x2b,0xaf,0xdb,0x9d,0x33,0xcf,0x12,0x7a,0x5f,0x44,0x03,		// 2C60 - 2C6F
		0xec,0x6e,0x23,0x86,0x45,0x00,0xd8,0x64,0xf6,0x4e,0x0d,0xae,0x9a,0x17,0xce,0x54,		// 2C70 - 2C7F
		0x37,0xde,0xea,0xf2,0xc0,0x52,0x9c,0xed,0xde,0x0e,0x6a,0xbf,0xef,0x82,0x4e,0x8f,		// 2C80 - 2C8F
		0x50,0x31,0x14,0x05,0xd7,0x1e,0x03,0x5c,0xa4,0x80,0xbf,0xb9,0x1a,0xbd,0x6e,0xbb,		// 2C90 - 2C9F
		0x28,0x96,0x1a,0x53,0xcd,0x9f,0x56,0xd6,0xdb,0xf3,0x25,0x50,0xfb,0x25,0x17,0x1c,		// 2CA0 - 2CAF
		0xf1,0x7a,0xb5,0xb1,0x21,0x55,0x1f,0xbf,0x52,0xf2,0xf4,0x7b,0xb3,0x57,0x72,0x36,		// 2CB0 - 2CBF
		0x1b,0x88,0xdf,0x35,0x95,0xfb,0x27,0xbd,0x1c,0x4b,0xc6,0x6d,0xa3,0x30,0xe8,0xd1,		// 2CC0 - 2CCF
		0x59,0xaf,0xcf,0x33,0x2a,0x8e,0x76,0xb4,0x89,0x0b,0x74,0x9c,0x6d,0xce,0x22,0xef,		// 2CD0 - 2CDF
		0x99,0x1b,0x00,0x41,0x21,0x4c,0x55,0xca,0x2a,0x7f,0x16,0xbd,0xf1,0x8c,0x09,0xd6,		// 2CE0 - 2CEF
		0x0f,0x3a,0x2a,0x32,0xfb,0xb2,0x4e,0x64,0xd0,0x33,0x06,0xc5,0x50,0x08,0xc6,0x0b,		// 2CF0 - 2CFF
		0x29,0xb7,0x47,0x1e,0x78,0x7c,0x29,0x27,0x8c,0xf5,0xdd,0xe9,0xec,0x1f,0xc2,0x54,		// 2D00 - 2D0F
		0x9b,0x81,0x8e,0x57,0x9a,0xa7,0xf0,0xf7,0xaf,0xd2,0x74,0x9e,0x65,0xee,0xa6,0xb5,		// 2D10 - 2D1F
		0x54,0xc4,0x7a,0x74,0xa2,0x71,0xeb,0xf9,0xca,0x17,0xe3,0x98,0x9c,0xd2,0x5b,0x73,		// 2D20 - 2D2F
		0x86,0xee,0xc3,0x4a,0x11,0x57,0xa4,0x94,0xae,0x50,0x84,0xce,0xb3,0x68,0x0a,0x13,		// 2D30 - 2D3F
		0xa1,0xaa,0x62,0xed,0xa8,0x15,0xe3,0x6b,0x6d,0x4c,0xef,0x73,0x0a,0x8e,0x1b,0x5a,		// 2D40 - 2D4F
		0x56,0xe7,0x90,0xb2,0x68,0xa8,0xb2,0x63,0x56,0x16,0xff,0xfe,0x42,0x5f,0x39,0x4d,		// 2D50 - 2D5F
		0x98,0xd2,0xc7,0x2f,0x91,0x4e,0x59,0xa2,0xfc,0xfb,0xcb,0x22,0x3d,0x39,0x4c,0x32,		// 2D60 - 2D6F
		0x96,0xd6,0xbf,0x38,0xa5,0x84,0x61,0x8d,0x2e,0x8a,0xac,0xd5,0x1b,0xb9,0x7c,0x8c,		// 2D70 - 2D7F
		0xc1,0xa2,0x71,0xe2,0x65,0x06,0x94,0xc9,0xff,0x8e,0x3d,0x4c,0x3d,0xbc,0x34,0x22,		// 2D80 - 2D8F
		0xcb,0x22,0x16,0x83,0xd2,0xd2,0xfa,0x3a,0xbf,0x15,0x55,0xfc,0x45,0x60,0x1b,0xf8,		// 2D90 - 2D9F
		0xa5,0x83,0x27,0xaf,0x2d,0x24,0xdd,0x06,0xfe,0x6c,0x0e,0x99,0x13,0x00,0x1b,0x53,		// 2DA0 - 2DAF
		0x7f,0x33,0x5e,0x3c,0xf6,0x7a,0xc5,0x91,0x8f,0x20,0xc0,0x1a,0xc8,0x3a,0x5e,0xb8,		// 2DB0 - 2DBF
		0xcb,0xde,0xb3,0x3e,0xf0,0x90,0x7c,0x81,0x82,0xfd,0x06,0xb3,0xc6,0xec,0x4b,0xec,		// 2DC0 - 2DCF
		0x39,0x71,0x5e,0x0a,0x1a,0x63,0x0a,0xbb,0x28,0x11,0xb6,0xd8,0xad,0x31,0x8c,0xf5,		// 2DD0 - 2DDF
		0xbb,0x19,0xdb,0x36,0xb6,0x32,0xb9,0x64,0x12,0xa9,0xec,0x3f,0x5e,0x67,0x0b,0x16,		// 2DE0 - 2DEF
		0x82,0x44,0xe0,0x96,0x45,0x77,0x11,0xe0,0x12,0x51,0xff,0xde,0xfb,0x2c,0xef,0xd6,		// 2DF0 - 2DFF
		0xfe,0x9e,0x68,0x3f,0x87,0xf2,0xdb,0xd4,0x37,0xd8,0x8a,0xe8,0xe4,0x5b,0xa2,0xf9,		// 2E00 - 2E0F
		0xe1,0x14,0xaa,0x87,0x7f,0x9d,0x21,0x26,0xd3,0x49,0x63,0xd3,0xba,0x12,0xcd,0x84,		// 2E10 - 2E1F
		0x1b,0xd3,0x21,0x03,0x6c,0xb8,0x2c,0xfb,0x78,0xf2,0xa6,0x53,0x5f,0xaf,0x59,0xbc,		// 2E20 - 2E2F
		0xde,0x49,0x86,0x86,0xd0,0xbd,0x84,0xb8,0xf5,0x60,0xaa,0x5f,0xf3,0xcd,0x6f,0x26,		// 2E30 - 2E3F
		0x9a,0x22,0xd0,0x27,0x6c,0x6c,0xf2,0x01,0x5d,0x5f,0x09,0x2b,0xd7,0x4b,0x78,0x88,		// 2E40 - 2E4F
		0x01,0x4b,0x3a,0x3b,0x41,0xc0,0x80,0xbc,0x00,0xfd,0x9b,0x2b,0xad,0x44,0x1d,0xe5,		// 2E50 - 2E5F
		0x04,0xf2,0x3b,0x56,0x90,0xf6,0x76,0x0e,0x6e,0x87,0x7b,0x16,0x55,0x17,0x47,0x84,		// 2E60 - 2E6F
		0xd3,0x82,0x8e,0x4d,0xd9,0x8c,0x5e,0x5b,0x7a,0x8a,0x00,0xdf,0xf0,0x5f,0x1f,0xe9,		// 2E70 - 2E7F
		0xe0,0xaa,0x2b,0x36,0xdf,0x3e,0x00,0x48,0x34,0xd3,0xc3,0xbc,0xdf,0xfb,0x0d,0xd9,		// 2E80 - 2E8F
		0xdb,0x57,0x4c,0x65,0xa1,0x0a,0x66,0xbc,0xed,0x6e,0x9f,0x23,0xc4,0x06,0xbc,0x59,		// 2E90 - 2E9F
		0xb6,0xb4,0x68,0x6f,0x61,0x2c,0xd8,0xda,0x36,0xa9,0xab,0xc7,0x80,0xdf,0x14,0xae,		// 2EA0 - 2EAF
		0xa1,0x30,0x3a,0x2a,0x9f,0x22,0xdf,0x08,0xe0,0x11,0x40,0x9d,0x32,0x21,0x3d,0x5d,		// 2EB0 - 2EBF
		0x0f,0x77,0xba,0xaa,0x1e,0xa9,0x45,0xea,0xfc,0x72,0xf9,0xdc,0x3d,0xab,0xa2,0x2c,		// 2EC0 - 2ECF
		0xae,0x76,0x22,0x45,0xdd,0xbd,0x13,0x66,0xdc,0xdb,0xad,0xf8,0x41,0x98,0xea,0x1f,		// 2ED0 - 2EDF
		0x71,0x5b,0xe9,0x8f,0x1f,0x9b,0x90,0xa1,0x0f,0x97,0x76,0xa5,0x20,0x47,0x00,0x7a,		// 2EE0 - 2EEF
		0x89,0x92,0xca,0x5d,0x63,0xc1,0x48,0xff,0x68,0x34,0xad,0xda,0xfa,0x53,0x0b,0xc4,		// 2EF0 - 2EFF
		0x67,0xc8,0xbc,0xc5,0x6b,0xec,0x02,0x26,0xf6,0x7e,0xea,0xca,0x30,0x9b,0x76,0xc2,		// 2F00 - 2F0F
		0xba,0xea,0xfa,0x1b,0x37,0x18,0xc7,0xfa,0x0c,0x84,0x07,0xec,0x63,0x3b,0xe8,0x77,		// 2F10 - 2F1F
		0x76,0x26,0xfd,0xf5,0x0a,0x82,0xe1,0xa2,0x39,0x91,0x1d,0xf3,0x75,0x8f,0x4b,0x29,		// 2F20 - 2F2F
		0xca,0xe8,0x7c,0x27,0x63,0xa8,0xd8,0x80,0x50,0x33,0x84,0xd5,0x87,0x36,0xc9,0x5e,		// 2F30 - 2F3F
		0x28,0xdd,0x72,0xc6,0x05,0x47,0x75,0x3c,0x61,0x37,0xd6,0xc7,0xf8,0x0c,0xc9,0xd9,		// 2F40 - 2F4F
		0x40,0xf3,0x17,0x28,0xef,0x5b,0xc2,0xb9,0xbd,0xa9,0xec,0x3d,0x6b,0x2d,0xf5,0xa1,		// 2F50 - 2F5F
		0x04,0x55,0xe4,0xe1,0x63,0x21,0x08,0x1d,0xf5,0xd7,0xdf,0xee,0xc0,0xf8,0x36,0xfa,		// 2F60 - 2F6F
		0xa4,0x72,0x92,0xc6,0xe1,0x17,0xcf,0xcc,0xda,0x4e,0x07,0xce,0x19,0x09,0xb5,0x69,		// 2F70 - 2F7F
		0x92,0xf7,0x1a,0xed,0x2c,0xfa,0xe0,0x6c,0x7d,0xdb,0xfe,0x11,0xd5,0x3d,0xdb,0xb3,		// 2F80 - 2F8F
		0x7f,0xcf,0xb6,0xaa,0x43,0xc6,0x45,0xe2,0x2f,0x8b,0x9c,0x2e,0x98,0xb0,0x51,0xde,		// 2F90 - 2F9F
		0x5b,0x29,0xde,0x93,0x68,0xb9,0x46,0x52,0x82,0xaa,0xfc,0xd8,0x40,0xc1,0x00,0x2d,		// 2FA0 - 2FAF
		0x58,0x71,0x4b,0x7c,0x1c,0x4f,0x6d,0x22,0x45,0xc6,0x75,0x05,0xf0,0x0c,0x11,0x27,		// 2FB0 - 2FBF
		0xe6,0x54,0xf6,0x7b,0x20,0x46,0x82,0xf7,0x8b,0xac,0xa0,0xea,0x08,0x6e,0xed,0x90,		// 2FC0 - 2FCF
		0xb7,0xc0,0x19,0xe3,0x75,0x9a,0x8f,0xb5,0xa3,0x68,0x58,0xfc,0x2a,0x04,0x3c,0x6d,		// 2FD0 - 2FDF
		0xbb,0xe1,0x2b,0x4c,0x5c,0x89,0xdc,0x82,0x20,0x49,0xb4,0xf0,0x35,0x2a,0xe9,0x03,		// 2FE0 - 2FEF
		0x24,0x24,0xe7,0x88,0x55,0x8f,0xf3,0xc2,0xd2,0xda,0x0e,0xba,0x4c,0x7f,0x1c,0xd7,		// 2FF0 - 2FFF
		0x63,0x36,0x45,0xae,0x22,0x6a,0x9c,0x1b,0xc9,0xe9,0xfe,0x91,0xd0,0xdf,0x3d,0xae,		// 3000 - 300F
		0x28,0x05,0x7e,0x13,0xc4,0x16,0xe0,0x72,0x58,0x83,0x5f,0xe8,0x61,0x67,0xf7,0x8e,		// 3010 - 301F
		0x65,0xbd,0x0c,0x4b,0x7c,0xd1,0x09,0xec,0x0f,0xf4,0x48,0x76,0xe0,0x74,0x32,0xba,		// 3020 - 302F
		0x4a,0xcb,0xa7,0x2b,0xcb,0x17,0xa0,0xed,0xbf,0xca,0x12,0x2e,0x6e,0xa3,0x16,0xb9,		// 3030 - 303F
		0x49,0xdd,0x48,0xc8,0x71,0xa6,0x6c,0x1a,0x79,0xd2,0x58,0x46,0x6d,0xd1,0x0e,0x4f,		// 3040 - 304F
		0x13,0xde,0x28,0x78,0x70,0x7a,0x79,0x5a,0x8e,0x19,0xf1,0x33,0x7d,0x1b,0xc1,0x81,		// 3050 - 305F
		0x98,0xfd,0xc0,0xd0,0x09,0xd1,0x0d,0xd0,0x90,0xeb,0xf6,0xaa,0x80,0xde,0x19,0x94,		// 3060 - 306F
		0x0a,0xa7,0xc9,0xa4,0xbd,0x27,0xb4,0xe1,0x4e,0xd7,0xc2,0xa0,0x95,0xb7,0x40,0x0e,		// 3070 - 307F
		0xd9,0x87,0x3d,0x09,0x4d,0x3a,0x34,0x34,0xda,0xa8,0xec,0x4a,0x1f,0x83,0x9d,0xb2,		// 3080 - 308F
		0xb7,0x8c,0x54,0x54,0xba,0x06,0x98,0xac,0x86,0x6b,0x4e,0x1c,0xbf,0x5f,0xda,0x87,		// 3090 - 309F
		0x94,0xe2,0x87,0x1b,0x44,0xc9,0x29,0x6e,0xe1,0x6f,0x01,0xcd,0x55,0xa8,0xe0,0xd1,		// 30A0 - 30AF
		0xa2,0xf6,0x8f,0x32,0x6e,0x00,0x6f,0xe0,0xbe,0x3f,0x5d,0x50,0x02,0xfb,0xd8,0x14,		// 30B0 - 30BF
		0x52,0x76,0x66,0xaf,0xf7,0x67,0x33,0xa7,0x2d,0xa9,0xfc,0xdc,0x27,0x35,0x2b,0x17,		// 30C0 - 30CF
		0x54,0x4e,0x44,0xe6,0xe1,0xfb,0x7f,0xa8,0x7f,0xba,0xb7,0xe4,0x66,0x73,0x82,0xdf,		// 30D0 - 30DF
		0x99,0xab,0xa2,0x6d,0x6c,0xfa,0x9c,0x07,0x44,0xbf,0xa6,0x1e,0x9f,0x12,0xc6,0xaf,		// 30E0 - 30EF
		0x54,0xfa,0x39,0x18,0x1b,0xe0,0x12,0x2a,0x4f,0x44,0x23,0x7f,0xf3,0xaf,0x20,0x0d,		// 30F0 - 30FF
		0xf4,0xe9,0x02,0xfc,0xad,0x6b,0xaa,0xb5,0xb0,0x17,0xc7,0x3c,0xc4,0x27,0xf9,0xbf,		// 3100 - 310F
		0x2a,0x64,0x37,0x6f,0x25,0x98,0x6e,0x8e,0xb9,0x45,0x6a,0xc9,0xb2,0x97,0xfa,0xc9,		// 3110 - 311F
		0xe8,0x98,0x4f,0x05,0xc2,0xa3,0xa6,0xda,0xf9,0x1b,0x27,0xdd,0x9e,0x5c,0x0c,0x70,		// 3120 - 312F
		0x5f,0xf2,0x05,0x93,0x06,0x0a,0xdb,0xfd,0x42,0x25,0x54,0x6c,0xaa,0x14,0x58,0x39,		// 3130 - 313F
		0xff,0x20,0x51,0x2f,0xb1,0x89,0xd8,0x9d,0xa5,0x32,0x8d,0xaa,0x36,0x9a,0x46,0xe9,		// 3140 - 314F
		0x7a,0x0e,0x6d,0x2d,0xc6,0x1d,0xa3,0x9f,0x74,0x4d,0xa9,0x0d,0xe3,0x0c,0x81,0x85,		// 3150 - 315F
		0xc0,0xe9,0xd0,0x23,0x84,0x04,0x87,0x27,0x3e,0xc3,0xc2,0x4a,0x93,0xc7,0xf1,0x53,		// 3160 - 316F
		0x03,0x1f,0x35,0xe5,0x6e,0xbb,0x0d,0x9b,0xd6,0x23,0x31,0x57,0x66,0x69,0xbe,0xd6,		// 3170 - 317F
		0xb3,0x5b,0x94,0x88,0x43,0xfe,0xfc,0x9f,0x4c,0x38,0x8f,0x66,0xbd,0xcd,0x53,0xd5,		// 3180 - 318F
		0x82,0x8d,0x26,0x62,0x04,0xcb,0x60,0x19,0xf0,0x10,0xb4,0xef,0x3a,0x11,0x57,0x54,		// 3190 - 319F
		0x61,0xdf,0x64,0x07,0xf4,0x5e,0x80,0x2e,0x55,0xf8,0xba,0xa6,0xbd,0x92,0xb4,0x98,		// 31A0 - 31AF
		0x80,0xbf,0x08,0x4d,0x93,0x34,0xe5,0x43,0x4b,0x7d,0xf9,0x80,0x67,0xee,0x94,0x26,		// 31B0 - 31BF
		0x51,0xdb,0x0a,0x48,0xa1,0x0c,0x59,0xfc,0xe3,0x6b,0x0b,0xb1,0x9a,0x00,0x5e,0xc3,		// 31C0 - 31CF
		0x85,0x1f,0xa3,0x4d,0x20,0xe0,0xe4,0x3f,0x6e,0xd0,0xc9,0xb0,0xf6,0xe6,0xbc,0x75,		// 31D0 - 31DF
		0x0b,0xb9,0x4c,0xf2,0x51,0xef,0xcf,0x30,0x7d,0xf9,0x4c,0x30,0x5c,0xfe,0x98,0x7f,		// 31E0 - 31EF
		0x17,0x14,0xbe,0x0b,0xb5,0xb6,0xa4,0x35,0xe1,0x73,0xec,0x27,0xee,0xe3,0x19,0x68,		// 31F0 - 31FF
		0x18,0xdf,0xf3,0xad,0x0d,0xf1,0x2c,0xf3,0xac,0x0a,0x43,0xca,0x0c,0x73,0xa9,0xf4,		// 3200 - 320F
		0xc0,0x06,0x23,0x2e,0x59,0x9e,0x6f,0x4e,0x2d,0xcc,0x2a,0x8e,0x57,0xcc,0xf1,0x28,		// 3210 - 321F
		0xff,0xb7,0xc7,0x23,0xdc,0xf9,0xb6,0x6c,0xf6,0x06,0xb9,0x28,0xb1,0x49,0xda,0x49,		// 3220 - 322F
		0x07,0x5d,0x98,0x5f,0x15,0x80,0x8b,0xb1,0xd9,0x45,0x4b,0x8d,0x3a,0x89,0x8d,0xdc,		// 3230 - 323F
		0x48,0xa7,0x8f,0xf9,0xc6,0xf0,0xb7,0xc4,0xe6,0x55,0x77,0xf2,0x53,0x67,0x73,0xa7,		// 3240 - 324F
		0x74,0x82,0xe6,0x46,0xf0,0x44,0x41,0x88,0x6d,0x44,0x16,0xcb,0x9e,0x01,0x35,0xad,		// 3250 - 325F
		0x7c,0x19,0x15,0xda,0xd3,0xbc,0x75,0x22,0x01,0x5f,0x42,0xcf,0xfa,0xb5,0xbc,0x35,		// 3260 - 326F
		0x90,0xdb,0xd5,0x8a,0xf2,0xd3,0xd9,0xf8,0x72,0x33,0x54,0xf1,0x8b,0x1e,0x31,0xc3,		// 3270 - 327F
		0x22,0x74,0x1f,0x6c,0x0c,0x46,0x39,0xaf,0xd1,0x8d,0xe5,0x67,0xaf,0x1b,0xfc,0x1c,		// 3280 - 328F
		0xe2,0xd1,0x2c,0xd4,0x23,0x13,0x9b,0x2b,0x6f,0x79,0xcd,0xa6,0x09,0xc7,0xc8,0x45,		// 3290 - 329F
		0xc2,0x20,0x76,0x57,0x78,0x76,0x4a,0x92,0xdd,0x45,0x26,0x63,0x79,0x81,0x7d,0x83,		// 32A0 - 32AF
		0xf3,0xcd,0xb5,0xcb,0x8c,0xed,0xcf,0x49,0xec,0x7e,0x49,0x93,0x21,0xe4,0x43,0x5b,		// 32B0 - 32BF
		0xe5,0x85,0xe2,0x44,0x1f,0x35,0xf2,0xf4,0xad,0xf0,0xcf,0x6b,0x61,0xcf,0x85,0x93,		// 32C0 - 32CF
		0x49,0x35,0x36,0x18,0x34,0x49,0xbc,0x79,0x71,0xaa,0x90,0x60,0xda,0x5e,0xea,0x2f,		// 32D0 - 32DF
		0x12,0x0b,0x2a,0xdb,0x0a,0x69,0x77,0xfd,0xca,0xf7,0xa6,0x26,0x6e,0xed,0x5d,0x73,		// 32E0 - 32EF
		0x6e,0x72,0x78,0x62,0x23,0x10,0xab,0xe4,0x87,0x65,0x69,0xb4,0x3d,0x1b,0x05,0xe6,		// 32F0 - 32FF
		0xd1,0x1a,0x18,0xc3,0x40,0xfb,0x22,0xd4,0xbb,0xc0,0x74,0x3d,0xa8,0xc3,0x4d,0x4d,		// 3300 - 330F
		0xea,0xed,0x43,0x52,0x62,0x28,0xe4,0xb2,0xb5,0x17,0x9e,0x37,0x50,0x04,0xdc,0xab,		// 3310 - 331F
		0xaa,0x1a,0x72,0xa5,0xc9,0xd4,0x3b,0xa2,0x08,0xb5,0x00,0x57,0x17,0x3a,0x9c,0x46,		// 3320 - 332F
		0x43,0x0d,0x5e,0x90,0xf8,0x7b,0xaf,0x0a,0x84,0x28,0xf5,0x92,0x1d,0x01,0xb7,0xa4,		// 3330 - 333F
		0x26,0x73,0x01,0x28,0xae,0xda,0x0a,0x8e,0x3a,0x3d,0x14,0x1d,0xc4,0x38,0x94,0x88,		// 3340 - 334F
		0x03,0x39,0x93,0xc3,0xed,0xf0,0x54,0x14,0x7b,0x00,0x37,0x6d,0xac,0xfb,0xdd,0xf9,		// 3350 - 335F
		0xcc,0x8d,0x8d,0xf5,0xf6,0xf7,0xd6,0xc1,0xd8,0xbf,0x76,0x37,0xb6,0xa6,0x7b,0x3b,		// 3360 - 336F
		0xb1,0xdb,0xa8,0x93,0x4a,0x6e,0x1a,0xfa,0x22,0x07,0x2c,0x6f,0x03,0xd8,0x97,0xd3,		// 3370 - 337F
		0x24,0xd0,0xde,0xb3,0xa9,0x12,0xe9,0x63,0x6a,0xa5,0xef,0x4c,0xf5,0x6d,0x9a,0x86,		// 3380 - 338F
		0xd6,0x5a,0x66,0xaa,0x16,0xdf,0x4b,0xe1,0x01,0xa6,0x9b,0x41,0x2c,0x82,0x2d,0x5a,		// 3390 - 339F
		0xb7,0xa5,0xbb,0x0b,0xd0,0x13,0x89,0x9b,0x78,0x56,0x47,0x04,0x8a,0x73,0x39,0x92,		// 33A0 - 33AF
		0xf9,0x1e,0x95,0xad,0x59,0x2a,0x2d,0xf3,0xa1,0x43,0x4d,0x8b,0x2f,0xdf,0xe7,0xb5,		// 33B0 - 33BF
		0x0c,0x72,0xed,0xa5,0x72,0xe1,0xff,0x91,0x8b,0x3a,0x46,0x09,0x7c,0xa2,0xa0,0x87,		// 33C0 - 33CF
		0xa2,0x8f,0xfd,0x47,0x1b,0x37,0x09,0x58,0x89,0x48,0x0b,0xf4,0x12,0xd9,0x0c,0x0d,		// 33D0 - 33DF
		0xac,0xa0,0x3d,0x28,0x97,0x66,0x93,0x6e,0x2a,0xb9,0xb4,0x00,0xd3,0xe1,0x16,0x8c,		// 33E0 - 33EF
		0x5a,0x15,0x65,0x1e,0x65,0xee,0x26,0x38,0x41,0x1b,0x9b,0x24,0xdf,0x57,0xe6,0x89,		// 33F0 - 33FF
		0x1d,0x98,0x70,0x3d,0x47,0x89,0x8c,0x5a,0xde,0x3b,0x58,0x94,0x98,0x17,0xe4,0xc9,		// 3400 - 340F
		0xa7,0x18,0x97,0xda,0x3e,0x37,0xce,0xba,0x52,0x26,0xc5,0xc4,0x9e,0x40,0xbb,0x52,		// 3410 - 341F
		0xe9,0xc1,0x51,0x8b,0x8b,0x32,0x34,0x7c,0x2e,0x28,0xfb,0x6b,0xd2,0x2e,0x53,0x67,		// 3420 - 342F
		0x14,0x00,0x59,0x24,0xaf,0xfa,0x47,0x06,0x43,0xcf,0x53,0x7c,0x55,0x7e,0xd4,0x8f,		// 3430 - 343F
		0x97,0x82,0xa7,0xbb,0x6a,0x49,0xd1,0xfd,0xa2,0xe8,0x65,0x2d,0x89,0x0d,0xa9,0x8e,		// 3440 - 344F
		0x26,0x35,0x74,0xa4,0xbf,0x1f,0xda,0x45,0x9c,0x80,0x0b,0xf3,0x0e,0xf8,0x79,0x69,		// 3450 - 345F
		0xb0,0x45,0x39,0x74,0xed,0xb7,0xac,0x04,0xc2,0xe3,0x5e,0x83,0xc5,0x9c,0x2e,0x65,		// 3460 - 346F
		0x67,0x1f,0xb0,0x01,0x76,0x8e,0xcf,0x9f,0xe6,0xa0,0xb7,0xd2,0xd0,0x96,0xf2,0x08,		// 3470 - 347F
		0xbb,0x71,0xd0,0x5f,0x1b,0x62,0x0d,0xba,0x17,0x82,0xae,0x15,0x8f,0xc3,0x2c,0x15,		// 3480 - 348F
		0x5e,0x26,0xd4,0xe3,0xdc,0x2f,0x6e,0x3b,0xa7,0x97,0x1d,0xc0,0xa4,0x40,0x86,0x93,		// 3490 - 349F
		0x40,0x6e,0x34,0x23,0xfc,0x33,0x3b,0x47,0x28,0x2b,0x1c,0x8a,0xee,0x6a,0xe9,0xc5,		// 34A0 - 34AF
		0x93,0xb3,0xaa,0xf4,0xfa,0xea,0xfe,0x42,0x6a,0xcc,0x06,0x66,0x90,0xde,0x7e,0x32,		// 34B0 - 34BF
		0xc8,0xa3,0x2d,0x69,0x98,0x12,0x80,0xd2,0x7d,0x47,0x72,0x8a,0xeb,0x79,0xae,0x9e,		// 34C0 - 34CF
		0x8f,0x2c,0xf8,0xd9,0xd7,0xa8,0xc9,0xdb,0xb4,0xa9,0x39,0x6b,0x9f,0x58,0x22,0x0f,		// 34D0 - 34DF
		0xda,0x7a,0x83,0xd9,0xf8,0xe8,0x22,0x83,0x9f,0x3f,0x76,0xbf,0x8d,0xd8,0xc3,0xc8,		// 34E0 - 34EF
		0xd9,0xfb,0x87,0x3d,0x7b,0x4f,0x15,0x2f,0x0f,0x95,0x80,0x79,0xd6,0x96,0xba,0x4f,		// 34F0 - 34FF
		0xfe,0x5a,0xfd,0x1a,0x23,0x9b,0x6a,0x83,0x15,0x79,0xf1,0xce,0xdc,0x70,0x70,0x6a,		// 3500 - 350F
		0xf9,0x86,0x1f,0xc6,0xef,0xc9,0x2b,0x66,0x02,0xf8,0xa1,0x35,0x3f,0x81,0x8e,0x1d,		// 3510 - 351F
		0xbc,0xab,0x65,0xd5,0x21,0x15,0xa0,0xfa,0x67,0x5f,0xaa,0x62,0xe0,0x27,0xfd,0xad,		// 3520 - 352F
		0x78,0x37,0x87,0x1c,0x3a,0xfc,0x53,0xa7,0x16,0x3b,0x65,0x49,0xe1,0xff,0xe6,0x9f,		// 3530 - 353F
		0x9d,0xd6,0x81,0xb1,0xfb,0x3c,0x0c,0x10,0x1e,0x58,0x6b,0x21,0xa2,0xe6,0xb1,0xb8,		// 3540 - 354F
		0xdd,0x75,0x89,0xe8,0x64,0xd2,0xd5,0x1a,0xd1,0xc4,0x94,0x5d,0xc4,0xf9,0x09,0xfd,		// 3550 - 355F
		0x28,0x41,0x1a,0x57,0xb8,0xfa,0xf6,0xeb,0xc1,0xcb,0xfa,0xb3,0x29,0x96,0xd6,0xb4,		// 3560 - 356F
		0xb0,0xa7,0xeb,0xd2,0x76,0x32,0xf8,0xe8,0xbe,0xfc,0xf6,0x18,0xf1,0x58,0x40,0x60,		// 3570 - 357F
		0xe6,0x55,0xf7,0x6e,0x60,0x36,0xa5,0xb6,0xd8,0x22,0x20,0xc1,0x7d,0x1d,0xb2,0xc8,		// 3580 - 358F
		0x7a,0x37,0x76,0x81,0x77,0x03,0x05,0x39,0x62,0x4b,0x52,0x23,0x6f,0x02,0xd3,0xf0,		// 3590 - 359F
		0x5d,0x7a,0xe2,0x9f,0xfc,0xd8,0x62,0x97,0xec,0xc4,0xa5,0xf3,0xa7,0x65,0x8d,0x1d,		// 35A0 - 35AF
		0xc1,0x8c,0xf2,0x9e,0x6f,0x2f,0x44,0x34,0x47,0x1a,0x72,0x25,0x46,0xe1,0x0a,0xd4,		// 35B0 - 35BF
		0x17,0x19,0xa1,0x92,0x92,0xc7,0x75,0xb6,0x84,0x19,0x51,0xf0,0xae,0x54,0xb1,0xda,		// 35C0 - 35CF
		0x10,0x0e,0x27,0xd0,0x67,0x9d,0xfd,0x02,0xf4,0xcf,0x1c,0xc7,0x7f,0xdc,0x2c,0x35,		// 35D0 - 35DF
		0x9c,0x98,0xfd,0xee,0x2d,0xed,0x26,0x3c,0x28,0x89,0xec,0x61,0x9a,0xd4,0x65,0x28,		// 35E0 - 35EF
		0xec,0x25,0xdd,0xc0,0x65,0x35,0x78,0xca,0xf1,0xd4,0x19,0xb1,0x21,0xda,0x83,0x3a,		// 35F0 - 35FF
		0x72,0x61,0xbe,0x5c,0xd2,0x31,0xbd,0x51,0x60,0x7c,0x3d,0xed,0x74,0xcc,0xf0,0x2f,		// 3600 - 360F
		0xdf,0x39,0xdb,0x16,0x74,0xdf,0xfc,0xb5,0xc7,0x8f,0x31,0x8a,0x34,0xc5,0x55,0x0c,		// 3610 - 361F
		0x23,0xda,0xac,0x83,0x8b,0x7b,0x81,0x1c,0xb5,0x5a,0x0d,0x3d,0x43,0x23,0x9b,0x16,		// 3620 - 362F
		0x70,0xb2,0xea,0x79,0x99,0x83,0xd3,0xeb,0xfd,0x6a,0x2b,0xfb,0xc1,0x84,0xeb,0xd2,		// 3630 - 363F
		0x37,0x6d,0x8e,0x0c,0x5f,0xb3,0xbb,0xc6,0xae,0x8b,0x24,0xf8,0x0f,0xc3,0xae,0x06,		// 3640 - 364F
		0x28,0xf8,0xd2,0x91,0xde,0x09,0x43,0x93,0x1b,0xcb,0xd1,0xab,0xce,0xff,0x8d,0xb5,		// 3650 - 365F
		0x34,0x81,0x2e,0x9e,0x57,0xc2,0xb3,0x76,0xd4,0x77,0x4a,0xc7,0xe0,0x93,0x71,0x26,		// 3660 - 366F
		0x8d,0x73,0x5b,0x07,0x4a,0x59,0x95,0xd6,0xa9,0x1c,0xe9,0x43,0x66,0x1e,0x83,0xdd,		// 3670 - 367F
		0xa4,0x7d,0x52,0xe2,0x79,0x8e,0xb1,0x55,0xad,0x87,0x47,0x52,0xbf,0x7b,0x2b,0x9f,		// 3680 - 368F
		0x29,0x8c,0x4c,0x83,0xe5,0x5c,0x11,0xdb,0x30,0xc4,0x3c,0x6a,0x8e,0xc9,0x14,0x71,		// 3690 - 369F
		0x0e,0xcb,0xc3,0x7f,0xcf,0x00,0xfd,0x8b,0xc3,0x21,0xe2,0x40,0xb3,0x63,0x26,0x98,		// 36A0 - 36AF
		0x84,0xa9,0x6f,0xac,0xb8,0xf8,0xfe,0xcb,0x38,0x2b,0x92,0xc9,0x50,0xe8,0x89,0x99,		// 36B0 - 36BF
		0xfb,0xd2,0x49,0x1e,0x61,0x00,0xde,0x3f,0x9e,0xaf,0xe4,0x3a,0xc5,0x33,0xa8,0x3a,		// 36C0 - 36CF
		0x24,0x34,0x8a,0x2b,0xca,0x16,0xa6,0xcd,0x47,0xb9,0xb3,0x07,0xb3,0x63,0x2a,0x7f,		// 36D0 - 36DF
		0xf2,0xfa,0xab,0x67,0x35,0x77,0x9e,0x9a,0xc4,0x97,0x16,0xe7,0xfc,0xd3,0xfa,0xac,		// 36E0 - 36EF
		0x93,0x93,0x66,0xa7,0x24,0x9f,0x4f,0x0a,0xe7,0xd6,0x66,0xcd,0xbf,0x22,0x3f,0x48,		// 36F0 - 36FF
		0x7b,0xab,0xb3,0x01,0x55,0x4b,0x83,0xc3,0xbf,0x43,0x3d,0xf0,0x60,0x2c,0x64,0x17,		// 3700 - 370F
		0x59,0x30,0xcb,0xc9,0xcc,0x79,0x42,0xa9,0x9f,0xea,0x74,0xc3,0x7d,0x0d,0x10,0x1f,		// 3710 - 371F
		0x1e,0x4d,0x27,0x95,0xc9,0x66,0xd6,0xe2,0x17,0x19,0x24,0xfc,0xf9,0x24,0x2d,0xa3,		// 3720 - 372F
		0xfc,0x71,0x81,0x39,0xcc,0x8e,0xc7,0xd3,0xf7,0x5d,0xa6,0x90,0xf4,0x0d,0xe5,0x2a,		// 3730 - 373F
		0x64,0x48,0xd0,0xca,0x97,0xae,0xde,0x21,0x52,0x83,0x92,0xb4,0xd0,0xa4,0x9f,0x77,		// 3740 - 374F
		0x06,0xc0,0x4f,0x9e,0x2c,0xc4,0x25,0xb0,0x78,0x97,0xc2,0xdd,0x2d,0x08,0x05,0x91,		// 3750 - 375F
		0xd4,0x05,0x76,0x49,0xc9,0x0d,0xe5,0xa6,0xfa,0xe7,0x4e,0xbf,0xec,0x95,0x00,0xbc,		// 3760 - 376F
		0xff,0x84,0xfe,0xa1,0xf2,0x05,0xa6,0x67,0xa9,0x01,0x90,0x51,0x2e,0xe7,0xb9,0x7d,		// 3770 - 377F
		0xf7,0xea,0xe1,0xba,0x67,0x6a,0x31,0x99,0x96,0xaf,0x21,0xc7,0x55,0xdd,0x99,0x99,		// 3780 - 378F
		0x6d,0x24,0x56,0xe9,0x28,0x38,0x90,0x21,0x13,0x01,0xda,0x95,0x01,0x93,0x49,0x16,		// 3790 - 379F
		0x53,0x60,0xd8,0xc3,0x77,0xac,0x0b,0x23,0xaf,0x42,0xd3,0x71,0x14,0x66,0xb2,0x37,		// 37A0 - 37AF
		0xda,0x0a,0x1f,0x1f,0xd5,0x45,0x2c,0x05,0x3c,0x00,0x66,0x50,0xae,0xf3,0xfd,0x83,		// 37B0 - 37BF
		0x72,0xd0,0x25,0x0f,0x03,0xbd,0xbb,0x6c,0xcc,0x08,0x2c,0x67,0x30,0x16,0x93,0xbe,		// 37C0 - 37CF
		0xcd,0x9d,0x21,0xea,0x02,0x13,0xc2,0x3c,0xae,0x67,0xfd,0x2b,0x3b,0xee,0x1c,0xed,		// 37D0 - 37DF
		0xdc,0xa0,0x8e,0x44,0x12,0x84,0x89,0x9b,0x75,0x69,0xf4,0x51,0xb1,0xd7,0x83,0x55,		// 37E0 - 37EF
		0xcf,0x45,0x24,0xf3,0xb6,0x8c,0x9a,0xed,0xf1,0x9c,0x67,0xce,0xb2,0x6e,0xf0,0x7b,		// 37F0 - 37FF
		0x17,0x3a,0xdc,0x0b,0xad,0xe9,0xbd,0xd8,0x33,0xcd,0xf2,0xd6,0xa0,0x90,0xcc,0x24,		// 3800 - 380F
		0x67,0x6a,0xef,0xe1,0xf9,0x97,0xfb,0x41,0x8b,0x09,0x6c,0xe0,0x1a,0x5a,0xbf,0x56,		// 3810 - 381F
		0xad,0x04,0xd7,0x0b,0xdb,0xd4,0x9e,0x4d,0x8c,0x9c,0xef,0x9f,0x04,0x29,0xb4,0x54,		// 3820 - 382F
		0x1d,0x74,0x4b,0x5d,0xd3,0x1c,0x2f,0x60,0x06,0x14,0xd4,0x0a,0x7c,0x99,0xd2,0xa5,		// 3830 - 383F
		0x26,0x68,0x46,0xed,0xa4,0x2d,0x75,0x1f,0x0a,0x3e,0xb3,0x54,0xe5,0x89,0x84,0x0d,		// 3840 - 384F
		0x79,0xcc,0x00,0x0f,0x4d,0x04,0x7c,0x71,0xea,0x27,0x66,0xf3,0xdf,0x15,0x71,0x91,		// 3850 - 385F
		0x08,0xcc,0xf2,0x58,0x10,0xdc,0x8a,0x79,0x35,0x1c,0x06,0x9c,0x4b,0x9a,0x83,0x76,		// 3860 - 386F
		0x04,0xd8,0xd6,0x9e,0x6e,0x35,0x2b,0x9c,0xbd,0xa9,0xeb,0x43,0x4b,0xb5,0xe4,0x42,		// 3870 - 387F
		0xdd,0x9a,0xa4,0xf5,0x28,0xca,0x25,0x81,0x94,0x9c,0xb0,0x1f,0x3f,0x43,0xfb,0xb8,		// 3880 - 388F
		0x45,0x01,0x95,0xb3,0x3f,0x98,0x83,0x0b,0x09,0x02,0x2c,0xa4,0xc9,0x61,0x72,0xdf,		// 3890 - 389F
		0x2c,0x39,0x22,0x6c,0xf3,0xdd,0x8e,0x5f,0xaf,0x27,0x78,0x86,0xc8,0x6c,0x32,0xfa,		// 38A0 - 38AF
		0xc4,0xaf,0x04,0xf5,0xc6,0x15,0xce,0xe3,0x55,0x99,0xee,0xbc,0x5f,0x01,0x64,0x90,		// 38B0 - 38BF
		0x7e,0x11,0x34,0x64,0x79,0xfe,0x0c,0x3c,0x0e,0x26,0x27,0x79,0xef,0xfd,0x71,0x65,		// 38C0 - 38CF
		0x0a,0x4b,0xec,0x0d,0x0d,0x95,0x52,0x4f,0x2a,0xd8,0xfc,0x33,0x18,0x7e,0x02,0x7f,		// 38D0 - 38DF
		0x5a,0x8a,0xa4,0x85,0xc3,0x16,0xe9,0x40,0x3a,0xff,0x85,0x9f,0xbb,0xdf,0x00,0x21,		// 38E0 - 38EF
		0x9e,0x3b,0x15,0xa2,0x1c,0xfe,0x59,0x75,0x0f,0x26,0x1d,0xb2,0xf9,0xbe,0x94,0xd1,		// 38F0 - 38FF
		0x48,0x0c,0x39,0x78,0xd8,0x0b,0x6b,0x92,0xba,0x1c,0x5a,0xa1,0x34,0xf8,0x27,0x55,		// 3900 - 390F
		0x08,0xe9,0x47,0x5d,0xf9,0x3a,0x29,0x7d,0x8c,0xeb,0x18,0xe1,0x0c,0xaa,0x62,0xb1,		// 3910 - 391F
		0xd0,0xff,0xba,0xe5,0xc1,0xc7,0xdb,0x5b,0x16,0xe3,0x6e,0x26,0x62,0x31,0x2e,0x2a,		// 3920 - 392F
		0xd1,0xbb,0x4a,0xe6,0xae,0x2f,0x0a,0x90,0x29,0x90,0xb6,0x67,0x58,0x2a,0xb4,0x45,		// 3930 - 393F
		0x7b,0xcb,0xf0,0x73,0x84,0x30,0x81,0xc2,0xd7,0xbe,0x89,0xd7,0x4e,0x73,0x5c,0xc7,		// 3940 - 394F
		0x80,0x1b,0xe5,0xe4,0x43,0xc7,0x46,0xd6,0x6f,0x7b,0xbf,0xed,0xe5,0x27,0xd1,0xb5,		// 3950 - 395F
		0xd0,0xd8,0xa3,0xcb,0x2b,0x30,0xa4,0xf0,0x84,0x14,0x72,0x5c,0xff,0xa4,0xfb,0x54,		// 3960 - 396F
		0x9d,0x70,0xe2,0xff,0xbe,0xe8,0x24,0x76,0xe5,0x15,0xfb,0x1a,0xbc,0x87,0x02,0x2a,		// 3970 - 397F
		0x58,0x8f,0x9a,0x95,0xbd,0xae,0x8d,0x0c,0xa5,0x4c,0xf2,0x5c,0x7d,0xad,0x51,0xfb,		// 3980 - 398F
		0xb1,0x22,0x07,0xe0,0x29,0x7c,0xeb,0x98,0x14,0xc6,0x31,0x97,0xe4,0x34,0x8f,0xcc,		// 3990 - 399F
		0x99,0x56,0x9f,0x78,0x43,0x91,0x85,0x3f,0xc2,0xd0,0xd1,0x80,0xd1,0x77,0xa7,0xe2,		// 39A0 - 39AF
		0x43,0x99,0x1d,0x2f,0x8b,0x6a,0xe4,0x66,0x82,0xf7,0x2b,0x0b,0x65,0x14,0xc0,0xc2,		// 39B0 - 39BF
		0x1d,0x96,0x78,0x1c,0xc4,0xc3,0xd2,0xb1,0x64,0x07,0xd7,0x6f,0x02,0xe9,0x44,0x31,		// 39C0 - 39CF
		0xdb,0x3c,0xeb,0x93,0xed,0x9a,0x57,0x05,0xb9,0x0e,0xaf,0x1f,0x48,0x11,0xdc,0x35,		// 39D0 - 39DF
		0x6c,0xb8,0xee,0x2a,0x48,0x2b,0xbc,0x89,0x12,0x59,0xcb,0xd1,0x18,0xea,0x72,0x11,		// 39E0 - 39EF
		0x01,0x75,0x3b,0xb5,0x56,0xf4,0x8b,0xa0,0x41,0x75,0x86,0x7b,0x94,0x12,0x2d,0x4c,		// 39F0 - 39FF
		0x0c,0x22,0xc9,0x4a,0xd8,0xb1,0x8d,0xf0,0x55,0x2e,0x77,0x50,0x1c,0x64,0x77,0xaa,		// 3A00 - 3A0F
		0x3e,0xac,0xd3,0x3d,0xce,0x60,0xca,0x5d,0xa0,0x92,0x78,0xc6,0x51,0xfe,0xf9,0x30,		// 3A10 - 3A1F
		0x87,0x3e,0xd1,0x23,0x7a,0x3d,0x8b,0x0d,0xb4,0xee,0xa1,0x92,0x15,0x3e,0x9c,0x23,		// 3A20 - 3A2F
		0x19,0x47,0x7c,0xd2,0x5e,0xc6,0x5a,0x64,0x60,0xcf,0x4c,0xa8,0x87,0xbf,0x89,0x08,		// 3A30 - 3A3F
		0x65,0x73,0xce,0x5e,0x38,0xb7,0x00,0x09,0xb7,0x01,0x12,0x3f,0x0b,0x60,0x29,0xa4,		// 3A40 - 3A4F
		0x1b,0xaf,0xfe,0x1c,0x0c,0x0e,0x84,0xde,0x08,0x93,0xcc,0xcb,0x3f,0x3c,0x25,0xfd,		// 3A50 - 3A5F
		0x2c,0x28,0x87,0xa2,0x1a,0x07,0x32,0x0b,0xe6,0xd0,0x92,0x00,0x06,0xb2,0x66,0x57,		// 3A60 - 3A6F
		0xca,0x4c,0x21,0xc5,0xe2,0x20,0x90,0xf3,0x21,0x45,0xbe,0xd4,0x81,0x5d,0x15,0x37,		// 3A70 - 3A7F
		0x66,0xc7,0xc5,0x98,0x27,0x16,0x6a,0x3c,0xca,0xc1,0xe9,0x7d,0x0f,0x1b,0x9a,0x62,		// 3A80 - 3A8F
		0xb1,0x86,0xad,0x72,0xe8,0xe4,0xc6,0xca,0x32,0x4f,0xeb,0x6e,0x53,0x0a,0xa0,0xdd,		// 3A90 - 3A9F
		0x9a,0xb7,0x50,0xe8,0x67,0xca,0xef,0xc3,0xea,0x3d,0xde,0x5d,0x2d,0x86,0x0f,0xed,		// 3AA0 - 3AAF
		0x55,0xc6,0x69,0xcd,0x25,0x43,0x6e,0x8c,0xc3,0x18,0x1b,0x3f,0xbf,0x2b,0x0f,0x17,		// 3AB0 - 3ABF
		0x51,0x60,0xf0,0x39,0xe2,0x0c,0x0b,0xc9,0xce,0xad,0x3a,0x48,0x69,0xd8,0x0b,0x21,		// 3AC0 - 3ACF
		0x40,0x72,0x1e,0x7e,0xa1,0x23,0xcf,0x60,0x5d,0x08,0x15,0xef,0xcc,0xa8,0xaa,0x0f,		// 3AD0 - 3ADF
		0x12,0x2a,0x6d,0x33,0xa1,0xc5,0x04,0x76,0xff,0x77,0xc5,0xe8,0xca,0xfa,0xd7,0x25,		// 3AE0 - 3AEF
		0xf9,0xf4,0x94,0x2d,0x64,0x6e,0x32,0x6f,0x87,0x87,0xa3,0x27,0x82,0x69,0xb9,0xea,		// 3AF0 - 3AFF
		0x65,0x7d,0x8e,0x7f,0xab,0xdb,0x23,0xf1,0x04,0x05,0x47,0xe2,0x58,0xd4,0xbb,0x22,		// 3B00 - 3B0F
		0x08,0xb2,0x93,0x81,0x77,0x0a,0xdf,0xe1,0xc9,0xfd,0x8b,0x8f,0xea,0x57,0x84,0xd3,		// 3B10 - 3B1F
		0xd2,0xc1,0x1c,0xc5,0x08,0x38,0xb0,0x63,0x65,0xbd,0x88,0xe1,0x1b,0x4e,0xfe,0x40,		// 3B20 - 3B2F
		0xf6,0x16,0xe3,0x22,0xe1,0xe1,0x1e,0xdd,0xab,0xd2,0x96,0xce,0x0b,0x58,0x53,0xf0,		// 3B30 - 3B3F
		0xe2,0x5e,0xe0,0xac,0xc1,0xc2,0xf3,0xf3,0xab,0x09,0x4f,0x8b,0x1c,0x51,0xea,0xa6,		// 3B40 - 3B4F
		0x49,0x86,0x4b,0xb9,0xaa,0xd9,0x37,0x8b,0xb6,0x6e,0x8c,0x8d,0xee,0x55,0x6d,0x69,		// 3B50 - 3B5F
		0x1c,0xbc,0x9f,0xdd,0xdd,0x63,0x33,0xca,0x5d,0x50,0x66,0x88,0x62,0xc3,0xc5,0x7d,		// 3B60 - 3B6F
		0x8c,0x6c,0x95,0xee,0xdb,0xdc,0x71,0x14,0x71,0x3a,0x35,0x73,0x99,0x37,0x1b,0x67,		// 3B70 - 3B7F
		0x09,0x43,0x24,0x00,0x64,0x02,0xba,0x0f,0x03,0xf9,0x93,0x81,0xf5,0x8e,0xd8,0xec,		// 3B80 - 3B8F
		0x44,0x2f,0x87,0x68,0x7a,0xd1,0x16,0xa0,0x64,0x9c,0x59,0x29,0x16,0xe4,0xa5,0x12,		// 3B90 - 3B9F
		0x2f,0x5c,0x36,0xbc,0x5f,0x86,0xce,0xeb,0x26,0x6e,0x9f,0x1e,0xde,0x98,0x6b,0x1c,		// 3BA0 - 3BAF
		0xfb,0x37,0xea,0xd0,0x92,0x9f,0x6c,0x56,0x18,0xfd,0xbf,0x56,0x6d,0x46,0x53,0x91,		// 3BB0 - 3BBF
		0x18,0x6d,0x9c,0xb9,0xd5,0xd9,0xb8,0x86,0x4d,0x16,0x52,0x06,0x24,0xcb,0xc6,0x35,		// 3BC0 - 3BCF
		0x38,0xec,0x85,0xcd,0x28,0x30,0xbc,0x5f,0x14,0xc6,0x30,0xa3,0xa4,0x44,0x6c,0x0d,		// 3BD0 - 3BDF
		0x4c,0xe0,0x1f,0xa0,0xce,0xe2,0xc0,0x07,0x00,0x59,0x73,0xe2,0xcf,0x0d,0x30,0x5e,		// 3BE0 - 3BEF
		0x84,0xb6,0x22,0x08,0x46,0x6b,0x4d,0xe3,0xe0,0x5d,0x74,0xb7,0xc5,0xc5,0x3a,0xad,		// 3BF0 - 3BFF
		0x51,0x1b,0x87,0x19,0x52,0x89,0x2d,0x97,0xc7,0x9f,0xcc,0x59,0xe8,0x48,0xf3,0xbf,		// 3C00 - 3C0F
		0x66,0xfd,0x87,0x28,0xf3,0x38,0x69,0x09,0x05,0x2c,0x53,0x3c,0xd7,0xb3,0x03,0x9a,		// 3C10 - 3C1F
		0xb1,0x88,0x9c,0xcb,0x6a,0xb6,0x49,0x5d,0x2b,0x50,0x23,0x14,0x75,0x63,0x55,0x81,		// 3C20 - 3C2F
		0x66,0x29,0x7d,0xd6,0x38,0x7f,0x56,0xf9,0x0a,0x99,0x95,0xd7,0xe3,0xf5,0x10,0xfb,		// 3C30 - 3C3F
		0xf4,0x8d,0x25,0x5f,0x1d,0x51,0x5a,0x82,0xb3,0xd4,0x41,0xba,0x81,0x46,0x9f,0xcc,		// 3C40 - 3C4F
		0x0c,0xa2,0xcc,0xba,0x1c,0x28,0x5d,0xdc,0x77,0x0e,0x01,0x32,0xf0,0x73,0xa9,0xf9,		// 3C50 - 3C5F
		0xa0,0x94,0xec,0x7c,0x74,0x42,0xa9,0x2d,0xe8,0x94,0xee,0xf4,0x11,0xd9,0x18,0xc7,		// 3C60 - 3C6F
		0xe1,0xd0,0x3c,0x7b,0xa7,0x1c,0xc6,0xda,0xd5,0xf2,0x60,0xf5,0x06,0x15,0x16,0xbc,		// 3C70 - 3C7F
		0x3f,0x04,0xb7,0xcb,0x75,0x71,0x7e,0x87,0x50,0xf6,0xf1,0x6a,0x2f,0x04,0x0a,0x9b,		// 3C80 - 3C8F
		0x6c,0x1c,0x95,0xc2,0xe1,0x41,0xd9,0x1a,0xab,0xad,0x7a,0xc8,0x2d,0xc3,0x9e,0x6b,		// 3C90 - 3C9F
		0x58,0x45,0x4f,0xf4,0x2a,0xc7,0x21,0xb8,0x75,0x63,0x14,0xc3,0xe2,0xaf,0xbb,0x6f,		// 3CA0 - 3CAF
		0x35,0xec,0x9e,0x36,0xd3,0x80,0xde,0xc5,0x81,0xa7,0x17,0x51,0x6e,0x65,0x8a,0x2e,		// 3CB0 - 3CBF
		0x74,0xbf,0x7c,0x9e,0x9b,0x2a,0xd9,0xe7,0xdf,0x44,0x1d,0xa8,0x33,0xc2,0x74,0x6c,		// 3CC0 - 3CCF
		0xc5,0xa9,0x20,0x80,0x84,0xc2,0x1c,0x02,0xe0,0x47,0xff,0x3b,0xd0,0xe3,0x22,0x2f,		// 3CD0 - 3CDF
		0x1a,0xda,0x05,0x71,0xcf,0x83,0xef,0x3c,0x14,0xff,0xd5,0xc0,0x28,0x25,0x7d,0xba,		// 3CE0 - 3CEF
		0xa3,0xbc,0xe4,0x47,0xfc,0xed,0xdc,0xfa,0x4e,0xf7,0xf9,0x2c,0x5c,0x25,0xae,0x93,		// 3CF0 - 3CFF
		0xd2,0xfe,0xb4,0x17,0xce,0xbb,0xab,0xe0,0x9e,0xfe,0x04,0xb4,0xcc,0xc0,0x1e,0x80,		// 3D00 - 3D0F
		0x57,0x8b,0xaf,0x34,0x44,0xea,0x66,0xd4,0x55,0x1f,0xcf,0xcc,0x19,0x13,0x76,0x85,		// 3D10 - 3D1F
		0x25,0x93,0x4f,0x35,0xa0,0xb8,0x55,0xfb,0x05,0xa7,0x72,0x2b,0x24,0x7b,0x9f,0xe7,		// 3D20 - 3D2F
		0x6a,0x80,0x4c,0xef,0x63,0xa2,0x02,0xb9,0x7d,0x25,0x47,0xc5,0x0f,0x96,0xc2,0x2b,		// 3D30 - 3D3F
		0x99,0x01,0x9f,0x76,0x4e,0x64,0x35,0xb4,0xcf,0x64,0xe6,0xce,0x3a,0x3f,0x47,0x16,		// 3D40 - 3D4F
		0x63,0x02,0x81,0x1f,0x61,0xfc,0xf8,0xd1,0x4d,0x72,0x2a,0xbc,0x46,0x94,0xd9,0xad,		// 3D50 - 3D5F
		0xb8,0xb0,0x6c,0x7f,0xde,0xa6,0x93,0x34,0x86,0x9c,0x2a,0x45,0x15,0xf2,0x60,0x35,		// 3D60 - 3D6F
		0xca,0x78,0x18,0x6c,0x47,0xdf,0x8f,0x43,0x4d,0x6e,0x3f,0x5c,0xc7,0xf6,0x04,0x34,		// 3D70 - 3D7F
		0x0a,0x08,0x7e,0xfb,0x5b,0x65,0xb6,0xa3,0xb1,0xb6,0x04,0x37,0xbd,0x7e,0x30,0x6e,		// 3D80 - 3D8F
		0x28,0x4c,0xd7,0x80,0x1c,0x35,0x10,0x38,0x05,0x81,0x50,0x4a,0x99,0xa5,0x8b,0xe8,		// 3D90 - 3D9F
		0x16,0x72,0x9c,0x90,0xca,0x8b,0xe7,0x28,0xd9,0x1c,0x3d,0x4c,0x3b,0xc9,0x00,0xe7,		// 3DA0 - 3DAF
		0x04,0xe5,0x87,0x00,0xe8,0xe5,0xc3,0xd7,0xfe,0x14,0x23,0x31,0xc4,0x88,0xb6,0xf0,		// 3DB0 - 3DBF
		0x64,0x54,0x90,0xe6,0x35,0xff,0x6e,0xeb,0x85,0x35,0x9d,0x2d,0x96,0xbd,0x17,0xc8,		// 3DC0 - 3DCF
		0xe6,0xab,0xf0,0x97,0xb3,0xd7,0xf0,0x49,0xbf,0x8d,0x82,0xb7,0x51,0x86,0xcc,0x74,		// 3DD0 - 3DDF
		0x7c,0x17,0x20,0xa6,0xa3,0xa9,0x93,0x15,0x3d,0x69,0xeb,0x82,0xd6,0x41,0xbf,0x3a,		// 3DE0 - 3DEF
		0x56,0x06,0xd9,0xeb,0x86,0xf3,0xdf,0xb5,0xd0,0x56,0x33,0x84,0x47,0x89,0x17,0x9e,		// 3DF0 - 3DFF
		0xe7,0x24,0x15,0x78,0x1d,0x71,0x9e,0xce,0x8a,0x20,0xf1,0xf2,0x04,0x3c,0x3e,0x65,		// 3E00 - 3E0F
		0xdd,0x5e,0x0b,0xa4,0x68,0x21,0xd8,0x44,0xba,0xd5,0xfe,0x41,0xae,0x78,0xdd,0x94,		// 3E10 - 3E1F
		0x2c,0xe2,0x36,0x03,0xaa,0x3f,0xd6,0x3d,0xf2,0xc2,0x75,0x26,0x26,0x98,0xdd,0x70,		// 3E20 - 3E2F
		0x02,0x1b,0x4f,0x6b,0x62,0x49,0x22,0x1e,0x04,0x74,0xad,0x96,0x8e,0x3a,0x67,0x7e,		// 3E30 - 3E3F
		0xd3,0xb8,0x4d,0xf0,0x52,0xfb,0x84,0x8b,0xff,0xb7,0x40,0xc6,0x47,0x3c,0xe4,0x83,		// 3E40 - 3E4F
		0x4e,0xa5,0x6b,0xe8,0x7b,0x53,0x06,0x6a,0x36,0x9a,0x06,0x2a,0xf0,0xb9,0xfd,0x85,		// 3E50 - 3E5F
		0x64,0x10,0x20,0xe6,0x1d,0x8d,0xf0,0xdf,0x39,0x68,0x1a,0x79,0x6c,0x10,0x9b,0xc8,		// 3E60 - 3E6F
		0x48,0x65,0x27,0xc2,0xbb,0x27,0xcc,0x51,0xd9,0xae,0xd3,0xa6,0xdb,0xdc,0xe7,0xd1,		// 3E70 - 3E7F
		0x68,0x51,0x79,0x8e,0x14,0xdd,0x62,0x62,0x27,0x3b,0xca,0xe7,0x9f,0xfc,0x49,0x64,		// 3E80 - 3E8F
		0x78,0xc1,0x4d,0xa1,0x2a,0xad,0xbc,0xfa,0x74,0x1a,0xda,0xb1,0x58,0x8b,0x6c,0x89,		// 3E90 - 3E9F
		0x67,0xe2,0x1e,0x90,0x3e,0xd4,0x22,0x3c,0x51,0x99,0x1a,0xb9,0xe7,0xe8,0x38,0x82,		// 3EA0 - 3EAF
		0x66,0x22,0xa3,0x2f,0xd1,0xce,0x1d,0x8d,0x8f,0x45,0xe4,0xf4,0x6e,0xae,0xd5,0xd5,		// 3EB0 - 3EBF
		0xe7,0x2d,0xd7,0x93,0xa4,0x58,0x77,0x94,0x3f,0xeb,0xd0,0x97,0x4d,0xbc,0xae,0x48,		// 3EC0 - 3ECF
		0x9b,0xf1,0xf3,0x11,0xb7,0x70,0x39,0x34,0xb2,0x97,0xb8,0x17,0x25,0x2e,0x6a,0xde,		// 3ED0 - 3EDF
		0x72,0x99,0x6e,0x3f,0x4c,0x52,0xab,0x92,0x7a,0x97,0xb5,0x28,0xd7,0x60,0xf4,0xde,		// 3EE0 - 3EEF
		0x9e,0x94,0x03,0xf2,0xe4,0x7c,0x56,0x15,0x66,0x78,0x20,0xc1,0x85,0xf1,0x73,0xcc,		// 3EF0 - 3EFF
		0x8f,0x8e,0xa9,0x3e,0x40,0xab,0x04,0x60,0x89,0x07,0x91,0x15,0x8f,0xbc,0x52,0x6d,		// 3F00 - 3F0F
		0xf7,0x75,0x9b,0x78,0x61,0xdb,0xbd,0x58,0x32,0x50,0xe2,0x9a,0x97,0xe0,0x38,0xc7,		// 3F10 - 3F1F
		0xc7,0x74,0x52,0x35,0x88,0x49,0xcb,0x23,0xf4,0xa1,0x2c,0x05,0x7d,0xb9,0x0f,0x1d,		// 3F20 - 3F2F
		0x2f,0xfa,0x85,0x4b,0x35,0x73,0xb6,0x26,0x9f,0x87,0xc7,0x4b,0x62,0xe3,0x01,0xf6,		// 3F30 - 3F3F
		0xa0,0xb4,0x2f,0xcf,0x2a,0x16,0x47,0x06,0x44,0xcf,0x4d,0xa1,0xa8,0x3d,0x75,0x15,		// 3F40 - 3F4F
		0xcd,0x8d,0x88,0x14,0x68,0x2e,0x88,0xa7,0x34,0x85,0x97,0x7c,0xee,0xe3,0x15,0x81,		// 3F50 - 3F5F
		0xa4,0xb4,0x09,0xb2,0x30,0xf9,0xc2,0x2e,0x00,0xf8,0xbe,0x91,0x18,0x31,0xca,0x7e,		// 3F60 - 3F6F
		0x59,0x95,0x6b,0x7b,0x03,0xf3,0x7d,0x02,0x79,0xb3,0x1a,0xd4,0x44,0xc6,0xbd,0x91,		// 3F70 - 3F7F
		0x5b,0xdd,0xa7,0x86,0xa1,0xd9,0x82,0xc6,0xb0,0x83,0x45,0x7c,0xd5,0x7e,0x57,0x7f,		// 3F80 - 3F8F
		0x5b,0x7a,0xf7,0x27,0x0d,0xa9,0xdb,0x60,0xf6,0x77,0x17,0xfc,0x6b,0x76,0x41,0x4e,		// 3F90 - 3F9F
		0x4c,0x97,0xd3,0xf4,0x86,0xa0,0xd0,0xf4,0xdc,0xda,0xab,0x0b,0xe8,0x0a,0x64,0x41,		// 3FA0 - 3FAF
		0x5c,0xa3,0xf4,0xc1,0x8e,0x3a,0xeb,0xe8,0x34,0x3a,0x58,0x9c,0x6b,0xd9,0xe9,0xdf,		// 3FB0 - 3FBF
		0xff,0x4b,0x53,0xa3,0xe6,0x35,0xf4,0xe0,0x0d,0x64,0xb7,0xe5,0x58,0xbf,0x39,0xec,		// 3FC0 - 3FCF
		0xe4,0x7a,0x2a,0xf0,0x8f,0x8d,0xf5,0xc3,0xba,0x65,0xa3,0x5b,0x4d,0xd9,0xfc,0x6c,		// 3FD0 - 3FDF
		0xfc,0x5f,0xf0,0x3d,0xc9,0x80,0x36,0xb4,0xca,0x89,0x33,0xb2,0x2d,0x84,0x1d,0xa7,		// 3FE0 - 3FEF
		0x79,0x66,0x60,0x5d,0x16,0x8a,0x41,0x18,0x10,0x5e,0xc1,0xe1,0x18,0x5d,0xc4,0x1f,		// 3FF0 - 3FFF
		0xcc,0x3d,0x72,0x67,0x38,0x69,0xde,0x95,0x9c,0xb1,0xe5,0x1c,0x6f,0x40,0x5a,0x9a,		// 4000 - 400F
		0xa5,0xcf,0x60,0xb0,0x2e,0x19,0x16,0x10,0xbf,0x8f,0x7a,0xd7,0xd4,0x4c,0x87,0x1e,		// 4010 - 401F
		0xf6,0x4b,0xa1,0xcb,0x39,0xd8,0x33,0xad,0x0a,0x44,0x97,0xc9,0x27,0xdd,0x36,0xee,		// 4020 - 402F
		0xef,0x1d,0xf0,0x90,0xdc,0x22,0xbe,0xd3,0x4e,0x5e,0x95,0xe5,0x8a,0x90,0x8e,0x91,		// 4030 - 403F
		0x02,0xf3,0x45,0x11,0xd7,0xb5,0x7e,0x24,0x9c,0xaa,0x0f,0x61,0x5d,0x42,0xfa,0xcb,		// 4040 - 404F
		0xdf,0xb9,0xd9,0xa5,0x2a,0x8d,0x7f,0x88,0x45,0x35,0xdc,0xb2,0x41,0x10,0x21,0xa1,		// 4050 - 405F
		0x78,0x9c,0x25,0xe1,0x17,0xe8,0x07,0x22,0xda,0x4c,0x16,0x8d,0x17,0x57,0xed,0x58,		// 4060 - 406F
		0xfe,0x09,0xe2,0x98,0x1f,0x42,0xa2,0x57,0x2d,0x7b,0x15,0xe7,0x01,0xb4,0x88,0x75,		// 4070 - 407F
		0xe1,0xad,0x0a,0xe1,0x03,0x59,0x16,0xce,0x4d,0x90,0x73,0xf5,0x5f,0x04,0x59,0xbe,		// 4080 - 408F
		0xd3,0x76,0xd5,0x11,0xc3,0x2a,0x6e,0x69,0x8c,0x98,0x09,0x2b,0xd2,0x64,0x0a,0x37,		// 4090 - 409F
		0xc5,0x90,0xbc,0xbc,0xa2,0xf1,0xf3,0x50,0x7c,0xdf,0xf0,0x40,0x3c,0x31,0x84,0x24,		// 40A0 - 40AF
		0xe7,0x69,0x79,0xb7,0x1f,0x2b,0x2d,0xe6,0xed,0xf4,0x80,0x27,0xbd,0x08,0xf0,0x0c,		// 40B0 - 40BF
		0xaa,0xac,0x03,0x18,0xfc,0x96,0xe6,0xd1,0xef,0xa2,0x53,0x16,0xb7,0xc6,0xb7,0xb3,		// 40C0 - 40CF
		0xc0,0x48,0x95,0x33,0x3a,0x2e,0x25,0xf6,0xd5,0xf7,0x42,0x83,0xc9,0x88,0x83,0x1e,		// 40D0 - 40DF
		0x1a,0x69,0xa7,0x9e,0x1a,0x31,0x36,0x79,0x2f,0x3f,0x65,0x21,0xd6,0xab,0x3a,0x93,		// 40E0 - 40EF
		0xe8,0x7c,0xf2,0x2c,0x1d,0x1c,0xa0,0xbf,0xce,0x09,0x16,0xe6,0xff,0xcc,0x08,0x95,		// 40F0 - 40FF
		0x9c,0x2f,0x6f,0xf5,0x03,0xab,0x2c,0x6f,0xc3,0x20,0xee,0x06,0xa3,0xc9,0x55,0xeb,		// 4100 - 410F
		0xe7,0x6e,0x58,0x4b,0xce,0xdb,0xe4,0x6c,0x5f,0x92,0xc5,0xf8,0x65,0xbd,0xca,0x99,		// 4110 - 411F
		0xb9,0x66,0x24,0xc5,0xbf,0xea,0x10,0xdc,0x33,0xab,0xb6,0x70,0x26,0x06,0x50,0xe3,		// 4120 - 412F
		0x43,0x85,0x8e,0x38,0x57,0x55,0x39,0x23,0x11,0xfa,0x18,0x62,0x06,0x41,0x10,0x50,		// 4130 - 413F
		0xf7,0x76,0x8e,0xb8,0x57,0xd8,0x2a,0xe7,0x08,0x4a,0x84,0x05,0x66,0x4b,0x72,0xa5,		// 4140 - 414F
		0x86,0x28,0x5e,0x9a,0xbf,0x70,0xe9,0x0c,0x6a,0xa9,0xd4,0xcc,0xe7,0x41,0x21,0xe5,		// 4150 - 415F
		0xe1,0xc8,0x75,0x74,0xd2,0x5c,0xc1,0xb9,0xc9,0x64,0x21,0x6d,0x6b,0x81,0x05,0x56,		// 4160 - 416F
		0x37,0xc1,0x8e,0x1a,0x0f,0x16,0x3b,0x51,0xf4,0x07,0xc4,0xdd,0x12,0xa6,0x46,0x7e,		// 4170 - 417F
		0xfc,0xc2,0xa1,0xa1,0x38,0x5d,0x1e,0x79,0xfe,0x60,0x56,0x51,0x3d,0x8e,0x4f,0x21,		// 4180 - 418F
		0xdf,0xb7,0xe7,0x5f,0x4e,0x2e,0x76,0x17,0x37,0x7d,0xaf,0x3e,0x8e,0x56,0xc7,0x44,		// 4190 - 419F
		0xd2,0xcd,0xda,0xe8,0x92,0xc5,0x8a,0x50,0x30,0xa8,0xe9,0x59,0xe5,0x5c,0x99,0x2c,		// 41A0 - 41AF
		0x05,0x72,0x31,0x12,0x84,0xa0,0xe3,0x89,0xba,0x71,0x5c,0x97,0x63,0x3b,0xec,0x5e,		// 41B0 - 41BF
		0xea,0x52,0xe7,0xf1,0xe7,0x7b,0x4b,0x66,0xe6,0xa3,0xa2,0x2c,0x6a,0xd1,0x2a,0x9f,		// 41C0 - 41CF
		0x31,0x5a,0x34,0xda,0xba,0x54,0xca,0xcc,0x05,0x4c,0x94,0x8f,0x9a,0x3c,0xfd,0xf4,		// 41D0 - 41DF
		0xcc,0xb7,0x91,0x63,0x3f,0x67,0xa9,0xe2,0xa8,0xb9,0x4b,0x73,0xd4,0xd7,0x4c,0xa3,		// 41E0 - 41EF
		0xec,0xd7,0xb7,0x60,0xf7,0x31,0x73,0x0b,0xa0,0x77,0x1f,0xce,0x39,0x40,0x41,0x30,		// 41F0 - 41FF
		0x01,0x66,0xa0,0xe6,0xa2,0x71,0xee,0xec,0xfe,0x52,0xaa,0xd5,0x2b,0x55,0x45,0x60,		// 4200 - 420F
		0xbc,0x51,0x84,0x4b,0x43,0x21,0x25,0x6c,0x14,0x58,0xc5,0xfd,0x4b,0x31,0x01,0x38,		// 4210 - 421F
		0x10,0xc5,0xdc,0x24,0x19,0x81,0x60,0xae,0x71,0xd6,0x89,0xfb,0x78,0x32,0x5e,0xfd,		// 4220 - 422F
		0x2c,0x30,0x61,0x44,0xa6,0x0c,0x29,0x17,0xe7,0x59,0x4e,0xc4,0xd5,0xf6,0x85,0x34,		// 4230 - 423F
		0x81,0x3e,0x0c,0xc2,0xab,0x7f,0x49,0x4d,0x88,0xad,0xae,0x8c,0xc3,0x58,0xdf,0xa2,		// 4240 - 424F
		0xc1,0xdc,0x17,0xf3,0x29,0xd8,0xc8,0x35,0xa4,0xe1,0x81,0xca,0xe1,0x77,0x15,0x4d,		// 4250 - 425F
		0xdd,0x37,0xfa,0x6b,0x61,0x53,0xef,0xf4,0xcc,0x40,0xe1,0x31,0x12,0xae,0x10,0x79,		// 4260 - 426F
		0x05,0xbd,0x6e,0xff,0xd3,0x6e,0x47,0xee,0xd0,0x57,0x27,0xb8,0x76,0x9c,0xf9,0xaa,		// 4270 - 427F
		0xaa,0x1a,0x6c,0xc5,0x41,0xe5,0x9b,0xc9,0xc3,0xf5,0xec,0x92,0x6f,0x1c,0x38,0xa7,		// 4280 - 428F
		0x7f,0x3b,0x2d,0x11,0xad,0xb6,0xf1,0x69,0xf5,0x25,0x08,0x35,0x9d,0x4d,0x78,0x75,		// 4290 - 429F
		0x73,0x4e,0x2b,0x78,0x56,0x1d,0x94,0xf4,0xf7,0x35,0x96,0x56,0xe1,0x8a,0xa1,0x57,		// 42A0 - 42AF
		0xb7,0xbf,0x1e,0xd0,0xbd,0x98,0x0d,0xcf,0x9a,0xb2,0xec,0xea,0x5d,0x72,0xdb,0xd3,		// 42B0 - 42BF
		0xbd,0x3b,0xff,0x2d,0xa5,0xe4,0x24,0x9e,0xf0,0x69,0xa6,0x26,0x71,0xe0,0x91,0xaf,		// 42C0 - 42CF
		0x36,0xaf,0x07,0xe5,0x0d,0xfd,0xe2,0x47,0x48,0x66,0x9b,0x7e,0xbe,0xf3,0x6b,0xee,		// 42D0 - 42DF
		0x12,0x49,0xaf,0x8c,0x38,0x20,0x91,0xef,0x34,0xf7,0xe5,0xa9,0x25,0x06,0x51,0xd7,		// 42E0 - 42EF
		0x83,0x75,0xb1,0xf7,0xa5,0xcb,0xb9,0xfa,0x86,0xa9,0xdc,0x9a,0xc8,0xb8,0x6d,0xee,		// 42F0 - 42FF
		0xf9,0xe0,0x05,0x3c,0x16,0xbb,0x24,0x0e,0x4d,0x49,0x1b,0x88,0x07,0xe5,0x29,0xf8,		// 4300 - 430F
		0x26,0x77,0xe4,0xaf,0x8b,0xec,0xda,0x10,0xdc,0xe3,0x79,0xe6,0x84,0xa9,0x2c,0xfb,		// 4310 - 431F
		0xfb,0x68,0xc7,0xe6,0x47,0x9b,0x25,0x24,0xc3,0xc5,0x0f,0x6a,0x1f,0x63,0x60,0x3a,		// 4320 - 432F
		0xa8,0x1f,0x67,0xb5,0xc9,0x46,0x8d,0xb0,0xd2,0x7c,0x38,0x09,0xf9,0xaf,0xef,0x3b,		// 4330 - 433F
		0x9f,0x49,0xbe,0x31,0xd4,0xaa,0xdc,0x58,0x1c,0xd5,0x8b,0xf8,0x73,0x69,0x40,0xc4,		// 4340 - 434F
		0x90,0xd4,0x04,0xb0,0x67,0xc3,0x1a,0x02,0xf1,0xdc,0xe2,0xac,0x2f,0xb0,0xfd,0xd9,		// 4350 - 435F
		0x6d,0xeb,0xb2,0xc6,0xc4,0xce,0x90,0xd3,0xe2,0xe0,0x55,0xda,0x0e,0xe0,0x0f,0xbf,		// 4360 - 436F
		0x66,0xfd,0x81,0x48,0x6b,0x4a,0xc8,0x2f,0xc0,0x6c,0x3f,0x76,0x2f,0x95,0x9f,0xfb,		// 4370 - 437F
		0xed,0xb7,0x6b,0x4c,0x1f,0xf1,0x8b,0xbc,0x9c,0x4e,0x36,0xb7,0xf5,0xae,0x16,0x52,		// 4380 - 438F
		0xb3,0x04,0xa7,0x26,0xdf,0xc2,0xe1,0x5f,0xc8,0x92,0x16,0x10,0x00,0x47,0x1d,0xca,		// 4390 - 439F
		0xa8,0x13,0xb0,0x6c,0xed,0xfa,0x13,0x3c,0xd3,0x86,0xf6,0x37,0x32,0xbd,0x9d,0xa6,		// 43A0 - 43AF
		0xfd,0x50,0x3e,0xf2,0xca,0x15,0xab,0xb9,0x8f,0xb7,0x30,0x21,0xaa,0xad,0xbf,0x6d,		// 43B0 - 43BF
		0x25,0x68,0x4a,0xce,0x37,0xd1,0x71,0x7b,0x0e,0xf2,0x5d,0x03,0xcb,0xf3,0xec,0xe2,		// 43C0 - 43CF
		0xcf,0x49,0x0e,0x53,0x35,0x2a,0x6f,0x66,0x9f,0x44,0x56,0x52,0x36,0xae,0xcd,0x0c,		// 43D0 - 43DF
		0xec,0x1f,0x02,0x19,0x05,0x5e,0xed,0xa0,0xd5,0xf9,0x33,0xc3,0xcb,0x3a,0x4a,0x2f,		// 43E0 - 43EF
		0xae,0x57,0xde,0xf2,0x27,0xe9,0x74,0x8e,0x80,0x9f,0x4e,0x4b,0xab,0x34,0x8e,0xd1,		// 43F0 - 43FF
		0x86,0x9e,0x9e,0xf5,0x5d,0x89,0xce,0xd4,0xb0,0x03,0x3f,0x1e,0x37,0x79,0x01,0xb5,		// 4400 - 440F
		0x24,0xe2,0x78,0x77,0xa8,0x3a,0x04,0x57,0xb8,0x32,0xe0,0xb3,0x11,0x26,0x4b,0xe2,		// 4410 - 441F
		0x7a,0x4f,0xe6,0x0c,0x49,0x3a,0x5e,0x3e,0x28,0x78,0x4a,0xbd,0x19,0x98,0x57,0x9b,		// 4420 - 442F
		0xb8,0x52,0xa2,0x89,0xc0,0x05,0x65,0xec,0xd1,0x64,0xd6,0x33,0x71,0x6b,0x4c,0x67,		// 4430 - 443F
		0x50,0x99,0xa4,0x03,0xd0,0x59,0xe3,0x07,0xc4,0xc1,0x1c,0x48,0x78,0x7e,0x95,0x0a,		// 4440 - 444F
		0xf3,0x0f,0x25,0xd0,0x78,0x32,0xe0,0x73,0x53,0x9c,0xf7,0x72,0xd2,0xed,0xd9,0x89,		// 4450 - 445F
		0x91,0xe3,0x9e,0x85,0xfa,0xce,0xa6,0x56,0x0d,0x44,0x7d,0x66,0x5d,0x15,0x02,0x29,		// 4460 - 446F
		0x5b,0x81,0xc9,0xf6,0xd7,0xa9,0xbd,0x15,0xc4,0x44,0x0a,0x19,0x3c,0x93,0x3a,0x6f,		// 4470 - 447F
		0xc4,0x97,0x9d,0x38,0xd0,0x81,0xef,0x54,0x8a,0x6a,0x35,0xbf,0xcf,0x44,0xe8,0x21,		// 4480 - 448F
		0x7a,0x11,0x55,0xa0,0xe6,0x53,0x44,0xf9,0xae,0xc3,0xd8,0xcf,0xb7,0x45,0xb6,0x43,		// 4490 - 449F
		0x71,0x1c,0x69,0xc4,0x59,0x5a,0x06,0x28,0xc3,0x9b,0x0b,0xfc,0xd6,0xf3,0x8d,0x19,		// 44A0 - 44AF
		0xd8,0x25,0x93,0x78,0xac,0x16,0xbd,0x48,0x98,0x81,0x29,0x3d,0x4c,0xeb,0x96,0x2a,		// 44B0 - 44BF
		0x20,0xda,0xca,0xd2,0x9e,0x42,0x32,0xfc,0x40,0x40,0xc9,0xc5,0x7a,0x0a,0x3a,0x3a,		// 44C0 - 44CF
		0xfb,0x27,0x49,0x26,0x31,0xdb,0x6f,0x29,0x0b,0xe6,0xc4,0x0a,0x02,0x6e,0x23,0x4e,		// 44D0 - 44DF
		0x5a,0x39,0x88,0x0a,0xa5,0x1f,0xbc,0xf5,0x8a,0xbf,0x35,0xc1,0xc4,0x72,0x37,0xac,		// 44E0 - 44EF
		0x6d,0x7d,0x40,0x52,0x7d,0x8b,0xa3,0xc5,0x8e,0x5a,0x73,0xdf,0xe2,0xb4,0xa2,0xd7,		// 44F0 - 44FF
		0xa6,0xa1,0x6a,0x13,0x78,0xdb,0xec,0x3d,0x28,0x82,0x18,0x99,0xbb,0x11,0xcc,0x96,		// 4500 - 450F
		0xb6,0x91,0x40,0xa3,0x99,0x0c,0xa1,0x43,0xa9,0x45,0xfc,0x64,0xf2,0xa6,0x5e,0xed,		// 4510 - 451F
		0x8d,0x7a,0x3a,0x96,0x1f,0x5c,0x0a,0xfc,0xa2,0xef,0x39,0xf5,0x68,0xd0,0x41,0x20,		// 4520 - 452F
		0x5c,0xc9,0x11,0xc1,0x8c,0x48,0xb1,0xcc,0xe4,0x0f,0x28,0x40,0x3c,0x2c,0x9e,0xb6,		// 4530 - 453F
		0x96,0x2c,0xbe,0x3a,0xa0,0x8c,0x5e,0x59,0x81,0x70,0x62,0x7b,0xd1,0x97,0xdd,0x74,		// 4540 - 454F
		0xe9,0x8f,0x7a,0x55,0x5e,0x25,0x1b,0x88,0xc8,0x20,0xbf,0x1c,0xc8,0x2f,0xa9,0x5d,		// 4550 - 455F
		0x49,0x1f,0xbf,0xa8,0x05,0x51,0x30,0x7d,0x4b,0x6c,0x59,0xd6,0x00,0x4f,0xea,0xb7,		// 4560 - 456F
		0xe5,0x4a,0x44,0x07,0x17,0x8d,0x26,0x9e,0xdc,0xe0,0x89,0x9f,0x9c,0x95,0xc8,0x08,		// 4570 - 457F
		0x2e,0xbb,0x04,0x87,0x56,0x95,0xc7,0x90,0x8b,0x4b,0xe7,0xac,0xfd,0xde,0xae,0x14,		// 4580 - 458F
		0xd6,0x61,0x37,0x7e,0xc0,0x67,0x1b,0x37,0xa8,0xb8,0x4e,0x72,0xc2,0x48,0x43,0xe0,		// 4590 - 459F
		0xce,0x69,0x57,0x80,0x99,0x3f,0x6c,0xb9,0xc6,0x74,0xd4,0xa6,0xce,0x2e,0x72,0xb1,		// 45A0 - 45AF
		0x46,0x3e,0x1b,0x63,0x61,0x9b,0x42,0x7a,0xb5,0x0e,0xd5,0x3c,0x42,0x2e,0x62,0x0c,		// 45B0 - 45BF
		0xb0,0x8f,0x7e,0x3b,0xd8,0x37,0x67,0x20,0x86,0x51,0xe8,0x6b,0x7d,0x26,0x7d,0xb6,		// 45C0 - 45CF
		0xbc,0x48,0xb8,0x5d,0x00,0x10,0xe3,0x90,0x8a,0x4b,0xe7,0xa6,0x22,0x31,0x6d,0xb4,		// 45D0 - 45DF
		0x5c,0x97,0x42,0x5f,0x1a,0x65,0x00,0xee,0x52,0x49,0xeb,0xa4,0x12,0xad,0x19,0x4c,		// 45E0 - 45EF
		0xc1,0xe7,0xd6,0x15,0xa7,0xb0,0x46,0xa0,0xb0,0xd8,0x4c,0x58,0x6c,0x38,0xab,0x02,		// 45F0 - 45FF
		0x5b,0xe7,0x6b,0x94,0x68,0xb1,0x7f,0x4b,0xb3,0xc4,0xa4,0xf8,0x93,0xad,0x8c,0x9b,		// 4600 - 460F
		0xdc,0x83,0x3c,0x32,0x5d,0x62,0xb3,0xd3,0xad,0x1b,0xcc,0xf9,0x28,0x2a,0x65,0x1c,		// 4610 - 461F
		0x34,0xe9,0xc1,0x84,0xc9,0x03,0x2b,0x5e,0x30,0x2a,0xdc,0x10,0x0a,0x0d,0x1f,0xca,		// 4620 - 462F
		0x95,0x84,0xb3,0x5d,0x2b,0x0e,0x71,0x51,0x0b,0x7e,0x2e,0x31,0x5c,0xf1,0xe3,0x2a,		// 4630 - 463F
		0x6f,0x03,0x0c,0xd5,0x45,0x43,0x4d,0x50,0x51,0xe4,0x5b,0x93,0x7e,0xb5,0x1a,0x01,		// 4640 - 464F
		0x74,0x53,0x03,0x3e,0x17,0x9c,0xc9,0x41,0x51,0x68,0x3c,0xaa,0x12,0x74,0x6d,0x55,		// 4650 - 465F
		0x95,0x9f,0x13,0x2f,0xe4,0x59,0x2d,0x48,0x9e,0x58,0xe9,0x2a,0xf8,0x8c,0xc5,0x6a,		// 4660 - 466F
		0x02,0x56,0xf4,0x7c,0x2c,0xf5,0x03,0xcb,0x08,0x41,0xbc,0x09,0x51,0x9b,0x4b,0xc4,		// 4670 - 467F
		0x2d,0x24,0x9f,0x3b,0xaf,0x2d,0x13,0x6f,0xa0,0xef,0x4e,0x7d,0x7f,0x7c,0x67,0x2a,		// 4680 - 468F
		0xc6,0xf6,0x4d,0xc0,0x6f,0xff,0x67,0x19,0xb7,0x70,0x77,0xf9,0x22,0x4e,0xc4,0xa1,		// 4690 - 469F
		0xbf,0xfa,0x78,0xa0,0xad,0xa7,0x47,0xed,0xde,0x11,0x51,0x33,0x1b,0x6d,0x4a,0x6c,		// 46A0 - 46AF
		0x48,0x9b,0xd8,0xb1,0xea,0xa3,0x3c,0x50,0xe6,0x5f,0x35,0x20,0x8b,0x75,0x21,0x11,		// 46B0 - 46BF
		0xd3,0x89,0x66,0x07,0xe6,0xb0,0x10,0xe9,0xe0,0x27,0xbc,0xf4,0xd4,0x45,0xb4,0x56,		// 46C0 - 46CF
		0x11,0xae,0x5b,0xf8,0xa4,0xca,0xcc,0x9b,0x1e,0x75,0xbe,0x26,0x97,0xf8,0xab,0x3e,		// 46D0 - 46DF
		0xf2,0x38,0x31,0x18,0x63,0x2e,0xb8,0x8b,0x2f,0x97,0x55,0x6a,0xb3,0xed,0xee,0x10,		// 46E0 - 46EF
		0xa8,0x95,0x9f,0x3c,0xa5,0x5a,0x5d,0x20,0xe5,0x1a,0xd9,0xb4,0x4b,0xbf,0xa7,0x50,		// 46F0 - 46FF
		0xa3,0x71,0xa0,0x7a,0x2b,0x0b,0x85,0xfd,0x52,0xcb,0xe5,0x3b,0xbf,0x4d,0x40,0xc3,		// 4700 - 470F
		0x95,0xba,0x6c,0x26,0xf6,0x3d,0x38,0x07,0xc6,0xb6,0x50,0x72,0xb1,0xb3,0x60,0x6f,		// 4710 - 471F
		0x6f,0x9c,0x7c,0xd6,0x46,0x2d,0xc0,0x64,0xd1,0x29,0x33,0x0f,0x01,0x4d,0xf1,0x97,		// 4720 - 472F
		0x61,0x83,0x8a,0x5e,0x9e,0x59,0xa5,0x79,0x46,0xb1,0xe9,0x07,0xd0,0xba,0x1d,0xc1,		// 4730 - 473F
		0xdd,0x1f,0x8d,0xd3,0xbd,0x7e,0xb0,0xeb,0x35,0x1b,0x09,0x8f,0x7f,0xd6,0x4b,0xb3,		// 4740 - 474F
		0x93,0x5a,0xc0,0x8b,0xa5,0x98,0xeb,0x9e,0xef,0x74,0x6d,0x1c,0xb0,0xbd,0x25,0x71,		// 4750 - 475F
		0x75,0x63,0x9b,0x1a,0x97,0xe4,0x9f,0xb7,0x05,0x08,0x2d,0x62,0x43,0xce,0x94,0x40,		// 4760 - 476F
		0xb3,0xa6,0xd7,0x55,0x14,0xe0,0x54,0x9d,0x48,0x65,0xa3,0x58,0x5a,0xa5,0xc1,0xa5,		// 4770 - 477F
		0xbf,0xd0,0x6e,0x52,0xdc,0x49,0xd3,0xf3,0xc9,0x58,0x68,0x31,0x55,0x1f,0x15,0x65,		// 4780 - 478F
		0x4a,0xcf,0x98,0x66,0xf2,0x1b,0x26,0x9e,0xd9,0xed,0x55,0x64,0xd5,0x58,0x39,0x86,		// 4790 - 479F
		0x44,0xcf,0xcd,0x24,0x95,0x94,0x95,0xc5,0x0a,0x72,0x82,0xa4,0xbb,0xaf,0x16,0x4b,		// 47A0 - 47AF
		0xdf,0x3d,0xc8,0x63,0x47,0x30,0xaa,0xcb,0x2b,0x75,0x49,0xe7,0x29,0xc0,0xd5,0x3b,		// 47B0 - 47BF
		0x8b,0xc6,0x82,0x38,0xc9,0xad,0x2d,0x55,0x4e,0xc0,0x43,0x62,0x7f,0x68,0xdf,0x19,		// 47C0 - 47CF
		0xfa,0x57,0x32,0xf7,0x1b,0x07,0x28,0x4a,0xc5,0x63,0x48,0x8a,0x5f,0xc4,0xdd,0xec,		// 47D0 - 47DF
		0x1c,0x1e,0x53,0x35,0x80,0x7c,0xe3,0xcc,0x20,0xa9,0x73,0x14,0xa9,0x30,0xb7,0xf8,		// 47E0 - 47EF
		0x23,0x87,0x9d,0xc8,0x77,0x88,0xe8,0x43,0x2f,0x20,0x1a,0xf5,0x7e,0x4b,0x98,0xc3,		// 47F0 - 47FF
		0x80,0x40,0x09,0xc4,0xc2,0xe8,0xff,0x52,0x05,0x95,0xd9,0x61,0x3f,0xf1,0xe8,0x10,		// 4800 - 480F
		0xe3,0x35,0xd0,0x7e,0x62,0x9b,0x31,0xdf,0xf2,0x15,0x87,0xcf,0x8e,0x3f,0x4f,0xe5,		// 4810 - 481F
		0x3e,0x92,0x6c,0x8c,0x98,0xdb,0xc8,0x0e,0x87,0xec,0x3e,0xf2,0x4b,0x92,0xb8,0x88,		// 4820 - 482F
		0xc1,0xc7,0x94,0xc2,0xe5,0x28,0x4d,0x45,0x95,0xa9,0x57,0xc0,0x98,0x87,0x4a,0x7d,		// 4830 - 483F
		0xde,0x7e,0x43,0x36,0x09,0x3d,0x87,0x29,0x2d,0x17,0x6a,0x6e,0xd4,0xfb,0x70,0x89,		// 4840 - 484F
		0x46,0xa6,0xb1,0x3c,0x07,0x17,0x82,0x9f,0xa0,0x43,0x51,0x72,0xa2,0x0b,0xd1,0xb1,		// 4850 - 485F
		0xe9,0x6b,0x58,0x69,0x1e,0xf4,0x85,0xcb,0x7f,0x7c,0x25,0x7e,0xe3,0x14,0x57,0x3a,		// 4860 - 486F
		0xf8,0x3a,0xef,0x93,0xd0,0x50,0x19,0x12,0x9c,0x4d,0x3f,0x8a,0xb7,0xb3,0x2c,0xa9,		// 4870 - 487F
		0xe6,0xc1,0x71,0xce,0xde,0xe9,0x07,0x1a,0x06,0x84,0x37,0xca,0x7f,0xc5,0xb7,0xc4,		// 4880 - 488F
		0x62,0xeb,0x16,0x6f,0x48,0xbb,0x59,0xc8,0x10,0x2e,0xe7,0xb3,0xdc,0x67,0xa2,0x8e,		// 4890 - 489F
		0x5d,0xe7,0x57,0x0c,0x51,0x04,0x58,0x41,0x49,0x97,0x67,0xf9,0xb0,0xf6,0xd6,0x4e,		// 48A0 - 48AF
		0x09,0x22,0xed,0x7a,0x78,0x41,0x8c,0xe9,0x84,0x4e,0x11,0x93,0x1b,0x0f,0x7c,0x88,		// 48B0 - 48BF
		0xd6,0x47,0xd2,0xcc,0x7f,0x2e,0xbf,0x66,0xd1,0x1e,0x7e,0xb4,0x7e,0x8f,0xfe,0x01,		// 48C0 - 48CF
		0x77,0x45,0x3d,0x59,0x67,0xc8,0xf8,0x9c,0x80,0x15,0x87,0xd2,0x7b,0x93,0x03,0xbe,		// 48D0 - 48DF
		0xda,0x48,0xa9,0xb6,0x71,0x4d,0x83,0xb2,0x24,0x7f,0x45,0xa2,0xf2,0x78,0x75,0x05,		// 48E0 - 48EF
		0x33,0xbe,0xce,0xb7,0x1d,0x39,0xe7,0x0a,0x8d,0xeb,0x10,0x19,0x05,0xdb,0x7c,0x59,		// 48F0 - 48FF
		0xf0,0x52,0xa6,0x71,0x2e,0x4a,0xed,0x4c,0xcc,0x24,0x81,0x6c,0x13,0x99,0x83,0x81,		// 4900 - 490F
		0xc5,0xf3,0x68,0x3a,0xa3,0x7d,0x9f,0x5b,0x32,0x38,0x73,0x10,0xbf,0xcf,0x32,0x80,		// 4910 - 491F
		0xa1,0xcd,0x8f,0xa6,0xbe,0x0e,0x45,0x5c,0x51,0x73,0xfd,0xb9,0xea,0xda,0x72,0x9d,		// 4920 - 492F
		0xb6,0x4e,0xd3,0x8a,0x00,0x7a,0x69,0xb6,0xf8,0x64,0x79,0x5e,0xb3,0x58,0x6c,0x5c,		// 4930 - 493F
		0x74,0x21,0x2d,0xfc,0x2a,0x80,0xd3,0x0c,0x39,0xd6,0x80,0x32,0x7d,0x24,0x88,0x83,		// 4940 - 494F
		0x8c,0x35,0xd6,0x50,0x3c,0x1a,0x8c,0x43,0x66,0xd7,0xea,0xab,0xe9,0x5c,0x71,0x15,		// 4950 - 495F
		0xf1,0xb7,0x48,0x1c,0x79,0x87,0xde,0x82,0x0e,0xb4,0xd1,0x7f,0xd6,0x5d,0x0f,0x58,		// 4960 - 496F
		0xd2,0x12,0x3b,0x34,0x60,0x44,0x52,0x2c,0x04,0xf9,0x8e,0xa1,0x67,0xc4,0x8a,0xd2,		// 4970 - 497F
		0xa0,0xf5,0xa8,0xad,0xb3,0x0d,0xb0,0xe6,0x57,0x75,0xb9,0x47,0xfd,0x6f,0x4d,0x47,		// 4980 - 498F
		0x0d,0x4c,0xc8,0xdd,0x73,0xe0,0x01,0x96,0x5a,0x33,0x2c,0xe6,0x37,0x79,0xff,0xbb,		// 4990 - 499F
		0x0a,0x44,0x14,0x58,0xe1,0xf9,0x8f,0x61,0x9d,0x80,0x00,0x32,0xf8,0x40,0x8b,0x75,		// 49A0 - 49AF
		0xc7,0x4b,0x46,0xf4,0x7d,0xd5,0xe2,0xab,0xf1,0xeb,0x8e,0x22,0x61,0x62,0x18,0xfa,		// 49B0 - 49BF
		0xb6,0x0d,0x55,0xc5,0x09,0x33,0xc4,0x1b,0x67,0x3f,0x6e,0xea,0xd1,0xba,0x10,0x0d,		// 49C0 - 49CF
		0x87,0x77,0x7c,0x20,0x87,0x0d,0x3d,0x93,0x50,0x8a,0x7a,0xfe,0xeb,0x66,0x1d,0xb4,		// 49D0 - 49DF
		0x2c,0xb6,0x33,0x9b,0x36,0xa2,0x96,0x3b,0x3d,0x19,0xca,0x14,0x90,0xc4,0x26,0x35,		// 49E0 - 49EF
		0xd6,0x38,0x34,0x0a,0x97,0x6f,0x5a,0x76,0xff,0x79,0xb9,0x21,0xdf,0x6f,0x55,0x14,		// 49F0 - 49FF
		0xf5,0xa9,0x76,0x83,0x6d,0x30,0x4f,0xe9,0xa7,0x76,0xde,0x5b,0x3b,0x45,0x13,0x15,		// 4A00 - 4A0F
		0x3b,0xf6,0x34,0x5a,0xb8,0xe3,0x80,0x7b,0x87,0x1f,0x13,0x35,0x44,0x64,0x09,0x3f,		// 4A10 - 4A1F
		0x98,0x4c,0xe6,0x24,0xb8,0xc4,0x36,0x4f,0x2e,0xbe,0x70,0x64,0xdc,0x27,0x20,0xd7,		// 4A20 - 4A2F
		0x3e,0x19,0x45,0xb7,0xef,0x51,0xf8,0xca,0x6f,0xe3,0x4f,0xdf,0x23,0x2c,0x81,0x60,		// 4A30 - 4A3F
		0x9d,0x09,0x4b,0x27,0x1e,0x46,0x92,0x92,0x59,0x5a,0x49,0xda,0x7a,0x51,0x95,0xa0,		// 4A40 - 4A4F
		0x67,0x09,0x2f,0xc9,0x46,0xa1,0x0b,0x8c,0x3f,0x2f,0x37,0xc9,0x83,0xb1,0x05,0x9d,		// 4A50 - 4A5F
		0x8d,0x47,0x6c,0x33,0xa8,0x9f,0xac,0xdd,0xb1,0xb0,0x31,0x63,0x1e,0xab,0xba,0x9b,		// 4A60 - 4A6F
		0x3f,0x2e,0xba,0x39,0xc4,0xbb,0xfe,0xe9,0x80,0x6a,0x91,0x9b,0x6c,0xda,0xdd,0x1e,		// 4A70 - 4A7F
		0xef,0x6d,0x12,0xf1,0x5c,0xb5,0xcc,0x56,0xbd,0x29,0xf0,0xa7,0xcf,0x1d,0xd6,0xed,		// 4A80 - 4A8F
		0x4d,0xf1,0xae,0xaf,0x71,0x88,0x1c,0x08,0xb9,0xfb,0x26,0xfc,0xe7,0x8f,0x50,0x0c,		// 4A90 - 4A9F
		0x4b,0xe5,0x05,0x08,0x44,0x71,0x39,0x25,0x05,0x2d,0x4d,0x50,0x95,0x8f,0x33,0xc1,		// 4AA0 - 4AAF
		0x19,0xb8,0xd2,0xd2,0x56,0xee,0xac,0x12,0x72,0x4c,0xbe,0x95,0xfa,0xb8,0xa7,0x8f,		// 4AB0 - 4ABF
		0x2a,0x16,0x0d,0x21,0x68,0xbb,0x3d,0x73,0x11,0x25,0x11,0x03,0x78,0xe9,0x17,0x3d,		// 4AC0 - 4ACF
		0x2c,0xec,0xef,0x4b,0x7a,0xd6,0xf5,0x2e,0x33,0xc4,0x21,0x0e,0xb0,0x3e,0x2b,0xce,		// 4AD0 - 4ADF
		0x12,0x68,0xf2,0xe4,0xce,0x7c,0x1e,0x68,0x6a,0x77,0x04,0x6a,0x81,0x13,0xcb,0x89,		// 4AE0 - 4AEF
		0x0d,0xf6,0xcd,0xc1,0xe6,0x29,0x40,0x85,0x85,0xcb,0x16,0x0e,0x0e,0x07,0x21,0xf2,		// 4AF0 - 4AFF
		0x8e,0x43,0x7b,0xf8,0x80,0x9a,0x25,0x2b,0x97,0x8d,0xee,0x2d,0xb7,0xf5,0x97,0xce,		// 4B00 - 4B0F
		0x44,0x3c,0x34,0xdd,0xa0,0xcd,0xd5,0x3f,0xef,0xc9,0x66,0x3d,0x1e,0xfc,0xd4,0x22,		// 4B10 - 4B1F
		0x23,0x0f,0x72,0x06,0x86,0xff,0x9a,0xe5,0x20,0xce,0x97,0xf4,0x23,0x78,0xc2,0x34,		// 4B20 - 4B2F
		0x5a,0x28,0xec,0x47,0xb2,0xac,0xfc,0x83,0xfa,0x26,0xd9,0x45,0xe7,0x05,0x8b,0x87,		// 4B30 - 4B3F
		0x5b,0x34,0x9d,0xb5,0xe6,0x91,0xc5,0xbd,0x8e,0xa1,0xc7,0x66,0xcb,0x82,0x96,0xe2,		// 4B40 - 4B4F
		0xd6,0x21,0xbc,0xa6,0x23,0xad,0xfd,0x79,0x2c,0x4b,0x37,0xcb,0x71,0x0b,0x8d,0x49,		// 4B50 - 4B5F
		0xbd,0x1a,0xc4,0xae,0xaa,0x3a,0xed,0xdc,0x67,0x70,0x45,0x2b,0xb9,0xfc,0x59,0x01,		// 4B60 - 4B6F
		0x40,0x8e,0x6e,0xa3,0xfc,0xb7,0x1f,0x4a,0x10,0x9e,0x48,0x7a,0xc5,0xf4,0x23,0x8f,		// 4B70 - 4B7F
		0xd1,0x2a,0xb1,0x99,0xda,0xe1,0x5c,0x69,0x36,0xa2,0xda,0xec,0xf5,0xcf,0x54,0xb8,		// 4B80 - 4B8F
		0x21,0xd9,0xc8,0xe5,0x44,0xb4,0xac,0x1e,0x2b,0x88,0xd4,0xf7,0xea,0xaa,0x95,0x81,		// 4B90 - 4B9F
		0x20,0xca,0x2b,0x1d,0x7c,0x6e,0x58,0x8d,0x80,0x9f,0x4e,0x51,0x85,0xe1,0xcf,0x30,		// 4BA0 - 4BAF
		0x00,0x69,0x93,0x15,0x03,0x8b,0xea,0x1c,0x07,0x72,0xa2,0xed,0xe8,0x13,0x2b,0x49,		// 4BB0 - 4BBF
		0x31,0x63,0xf9,0xe2,0x9a,0xc8,0x2a,0x70,0xcf,0xce,0x69,0x01,0x73,0x1c,0x12,0x90,		// 4BC0 - 4BCF
		0x65,0xa6,0x96,0xda,0x42,0x24,0x22,0x6d,0x2b,0xc2,0x7b,0x02,0xc8,0x19,0x2d,0x0c,		// 4BD0 - 4BDF
		0x8c,0x5e,0xe4,0x91,0x3b,0xd9,0x1a,0x39,0xaa,0x99,0xf2,0xa5,0xc7,0x67,0x64,0x01,		// 4BE0 - 4BEF
		0xd8,0xf8,0x9b,0xdd,0x08,0x67,0x9b,0x38,0x1f,0xe2,0x27,0xde,0x91,0xa3,0xe2,0xf5,		// 4BF0 - 4BFF
		0xba,0x21,0xb4,0xd2,0x68,0x88,0x6f,0x11,0x9a,0x67,0xb3,0xe4,0x87,0xa9,0x0f,0xab,		// 4C00 - 4C0F
		0xe2,0xc7,0x68,0xc5,0x5d,0x3c,0x9f,0xa6,0x6c,0x38,0x6e,0x2a,0x4b,0x98,0x93,0x29,		// 4C10 - 4C1F
		0x42,0x16,0x31,0x4c,0x28,0xbd,0x73,0x1f,0x26,0xa1,0x72,0x67,0xbd,0xcc,0x59,0xb5,		// 4C20 - 4C2F
		0x0a,0x7b,0xc7,0x3b,0x49,0x8b,0x74,0xdf,0x99,0x2e,0x18,0x8e,0xfe,0xe2,0x88,0xd3,		// 4C30 - 4C3F
		0xac,0xa4,0x22,0xa8,0x83,0x60,0x6c,0x8c,0xd6,0xad,0xf8,0xd5,0x70,0xb7,0x8b,0x48,		// 4C40 - 4C4F
		0xd9,0x7c,0x7d,0xe7,0xd5,0x3c,0x63,0x0a,0x2e,0x2a,0xec,0xb1,0xb3,0x68,0x09,0x19,		// 4C50 - 4C5F
		0x81,0x32,0x51,0x8d,0x81,0x5a,0xa3,0x7f,0x32,0xf4,0x0d,0xd7,0xa9,0x52,0xec,0x8b,		// 4C60 - 4C6F
		0xd6,0x33,0x55,0x70,0x08,0x37,0xb4,0x50,0xb3,0x96,0xb3,0x3c,0x72,0x12,0x5e,0x23,		// 4C70 - 4C7F
		0x48,0x2a,0x84,0xa4,0x2b,0x91,0x60,0x21,0xc3,0xde,0x78,0x15,0x6f,0x85,0xc6,0xa7,		// 4C80 - 4C8F
		0x89,0x06,0x16,0x7f,0xeb,0x64,0xaf,0xd8,0xb1,0xd9,0x35,0xd6,0x41,0xc8,0xce,0x1a,		// 4C90 - 4C9F
		0x89,0xf3,0x84,0x95,0x88,0xee,0xeb,0x99,0x10,0xd4,0x03,0x36,0xca,0x38,0x5f,0xc3,		// 4CA0 - 4CAF
		0x7a,0x5e,0x87,0xbb,0x84,0xab,0x9c,0xcb,0xb0,0x5b,0x3a,0x28,0x2a,0x72,0xa2,0x26,		// 4CB0 - 4CBF
		0xcd,0xf5,0x19,0x07,0xa0,0x59,0x8b,0x10,0xa1,0x3c,0x74,0xe3,0xc2,0x53,0x01,0x08,		// 4CC0 - 4CCF
		0x32,0xa4,0x72,0xcd,0xdd,0xf5,0xc2,0x50,0x36,0x84,0x8a,0xda,0x34,0xf8,0x23,0x6e,		// 4CD0 - 4CDF
		0x9a,0x98,0x0a,0xa2,0x7c,0xbb,0x89,0xae,0xff,0x7f,0x94,0xc3,0x60,0xbe,0xf2,0x9e,		// 4CE0 - 4CEF
		0x38,0x3e,0x9d,0x5c,0xfe,0x28,0x6a,0x90,0xcd,0xbc,0xec,0x93,0x67,0x42,0x96,0x1b,		// 4CF0 - 4CFF
		0x7b,0x44,0x21,0x0f,0x23,0xfa,0x2d,0x9a,0xb1,0x06,0x2b,0x7f,0xab,0x62,0x7a,0xac,		// 4D00 - 4D0F
		0x14,0x96,0xd0,0x11,0xed,0x2e,0xdc,0xb2,0xfc,0x6b,0x2a,0xfb,0xcc,0x39,0x46,0x54,		// 4D10 - 4D1F
		0xf5,0x61,0x24,0xf6,0x9d,0x00,0xbf,0xfd,0x3f,0x38,0x01,0xbe,0xac,0x25,0xe3,0x5a,		// 4D20 - 4D2F
		0x4f,0x12,0xd5,0x94,0xb4,0xed,0x60,0xdf,0x4c,0xf9,0x0a,0xbb,0x6a,0xc3,0x7a,0x42,		// 4D30 - 4D3F
		0x92,0x57,0xdc,0xfe,0xf3,0xb3,0x87,0xfe,0x32,0x7c,0xdd,0x29,0x69,0xf0,0x73,0xd2,		// 4D40 - 4D4F
		0x70,0x1c,0x73,0x8c,0x5b,0x4f,0x3e,0x3f,0x43,0xce,0x55,0x7b,0x4a,0xc9,0x79,0x0d,		// 4D50 - 4D5F
		0xd9,0x8e,0x11,0xd0,0x2c,0xfd,0xcd,0xc6,0x11,0x3c,0x89,0x67,0xec,0xac,0x74,0x39,		// 4D60 - 4D6F
		0xff,0x1b,0x71,0xa1,0xe8,0x3b,0xbd,0xf9,0x6b,0x52,0xd2,0xe2,0x72,0x34,0x8c,0xdc,		// 4D70 - 4D7F
		0x52,0x6f,0x8b,0x14,0x50,0xc5,0xd8,0x7c,0x64,0xdf,0xcb,0x21,0x3d,0x3f,0x2c,0xba,		// 4D80 - 4D8F
		0x84,0x77,0x98,0x7c,0x65,0x98,0x26,0x36,0x4c,0xee,0x4b,0x99,0xec,0xea,0xfb,0xd7,		// 4D90 - 4D9F
		0x86,0x60,0x11,0x71,0x68,0xf3,0xf1,0x49,0xb4,0xcd,0x6c,0xff,0x62,0x93,0xe4,0x7a,		// 4DA0 - 4DAF
		0x88,0x97,0xb0,0xc5,0xd9,0x50,0xc1,0x1d,0x6c,0x08,0x86,0x48,0xc0,0xd5,0x0e,0x28,		// 4DB0 - 4DBF
		0xfc,0xca,0x6d,0x8f,0x7b,0x6e,0x60,0x55,0x87,0x6d,0x34,0xa8,0x65,0x8e,0xe3,0xa4,		// 4DC0 - 4DCF
		0x93,0xe5,0x81,0x23,0x4d,0x4a,0xd6,0xd7,0x55,0x0a,0x4d,0x96,0xf4,0xdc,0x0d,0xf4,		// 4DD0 - 4DDF
		0x3c,0x16,0x65,0x17,0x91,0x20,0x6d,0xc7,0x68,0x29,0xea,0xc5,0x4d,0x1a,0x73,0x5e,		// 4DE0 - 4DEF
		0x2b,0xc8,0xd2,0x3f,0xc8,0x6e,0xad,0x8b,0x8f,0x5a,0x66,0x2b,0x92,0xe6,0x3f,0x66,		// 4DF0 - 4DFF
		0xcf,0xaa,0xc2,0xb1,0xb2,0xf0,0x60,0xc8,0xdc,0x68,0x58,0xfd,0x23,0x1e,0xda,0xd0,		// 4E00 - 4E0F
		0xda,0xa8,0x6c,0xc1,0x52,0xa4,0x8e,0x62,0xa0,0x62,0x99,0xb0,0xa1,0xdd,0xed,0xa3,		// 4E10 - 4E1F
		0x3c,0xf0,0x4b,0x04,0xe7,0xc6,0x80,0x7f,0x6d,0x93,0x44,0xf9,0xee,0x81,0x61,0x24,		// 4E20 - 4E2F
		0x27,0xee,0x18,0x50,0xf3,0xd4,0xc0,0x84,0x12,0x88,0xb0,0xcd,0x2a,0xa8,0x5f,0xd6,		// 4E30 - 4E3F
		0x0b,0x4e,0xca,0xb9,0x37,0x8a,0x16,0x15,0xa2,0x10,0x77,0x61,0xb6,0x2d,0x50,0x7f,		// 4E40 - 4E4F
		0x9a,0x00,0x9c,0x94,0xb4,0xe6,0x8c,0x18,0x6d,0x36,0x71,0x29,0x34,0x2f,0xdd,0x25,		// 4E50 - 4E5F
		0xc5,0x2e,0x05,0x77,0xab,0x24,0x6a,0xb1,0x03,0x48,0xb9,0xdc,0x84,0x09,0xef,0x0b,		// 4E60 - 4E6F
		0xbc,0x47,0xc0,0x37,0x9c,0xc2,0x3a,0x46,0x37,0xd3,0xa6,0x6d,0xc7,0x5a,0xaf,0xb8,		// 4E70 - 4E7F
		0xf1,0xf7,0xc6,0xe7,0x4a,0x7d,0xc4,0x7c,0x19,0xa3,0xd1,0x12,0x5f,0xfd,0x85,0xf0,		// 4E80 - 4E8F
		0x14,0x2b,0x4e,0xde,0xb4,0x51,0x12,0x38,0xfa,0xc7,0x15,0x40,0xeb,0x11,0x1c,0xb8,		// 4E90 - 4E9F
		0x17,0x11,0xd3,0xb1,0x1c,0x7b,0x6c,0x9e,0x6b,0x8a,0x89,0xac,0x4f,0xf1,0x5c,0x56,		// 4EA0 - 4EAF
		0x2b,0x15,0x0c,0x33,0x03,0x79,0x5b,0x13,0x3d,0x79,0x87,0x4b,0xa9,0x3c,0x6d,0x4d,		// 4EB0 - 4EBF
		0xc0,0xe4,0xf4,0x7c,0x29,0x07,0xa9,0x3e,0x82,0x63,0xa7,0x52,0x5c,0xcd,0xba,0x64,		// 4EC0 - 4ECF
		0x87,0x6b,0xc4,0xde,0x91,0x23,0x5f,0x02,0x89,0x53,0xc3,0x36,0x08,0xc3,0xeb,0x9e,		// 4ED0 - 4EDF
		0x73,0xd8,0xf3,0xf0,0x7a,0x0a,0xc5,0x84,0xe4,0x97,0xf4,0xab,0x8f,0x79,0xe8,0x42,		// 4EE0 - 4EEF
		0xb2,0x96,0x3c,0x87,0x66,0x38,0x64,0x2b,0x65,0xbc,0x93,0xa8,0x11,0x8e,0xdb,0xd4,		// 4EF0 - 4EFF
		0xb8,0x55,0x97,0xb6,0x16,0x6a,0x06,0x99,0x1b,0x8f,0x38,0x60,0xef,0xde,0x2e,0x19,		// 4F00 - 4F0F
		0x34,0xff,0x3d,0xd5,0x8b,0x9e,0xb3,0xb6,0x59,0x1c,0xbd,0x49,0xcb,0x85,0x88,0x16,		// 4F10 - 4F1F
		0x17,0xc3,0xa7,0x76,0x05,0x11,0xb5,0xa5,0xaf,0xb2,0x3b,0x18,0x84,0xe2,0xd3,0x11,		// 4F20 - 4F2F
		0x93,0x0d,0x8e,0x70,0x07,0x3f,0x94,0xcc,0xed,0xdc,0x0a,0xc2,0x3e,0x91,0x39,0x8d,		// 4F30 - 4F3F
		0x19,0x8a,0xec,0xd7,0x50,0xe5,0x19,0xcf,0x26,0x67,0xc4,0x7c,0x57,0x6e,0x21,0x51,		// 4F40 - 4F4F
		0x59,0x27,0xf9,0x01,0xe2,0x01,0x4e,0x95,0xaa,0x62,0x42,0xbb,0x72,0x98,0x35,0x61,		// 4F50 - 4F5F
		0x45,0x12,0x2e,0x82,0xfe,0xd0,0x7c,0x40,0x0a,0x18,0x9d,0x34,0x6f,0x6b,0x5e,0x02,		// 4F60 - 4F6F
		0x0d,0xb7,0x44,0x30,0x24,0xce,0x2b,0x38,0x17,0x17,0x2d,0xdb,0x70,0x83,0xc5,0xb9,		// 4F70 - 4F7F
		0x23,0xc3,0x34,0x1f,0x17,0xb9,0x24,0x20,0xe2,0x2c,0x8c,0xe7,0xd5,0xbf,0xd3,0x4b,		// 4F80 - 4F8F
		0x38,0x24,0x38,0xa4,0xd6,0x8d,0x71,0xdd,0xbd,0x63,0x92,0xcb,0x3f,0x3b,0x31,0xbd,		// 4F90 - 4F9F
		0x3c,0x06,0xc8,0x55,0xa4,0x87,0x5a,0x96,0x37,0x0b,0x5a,0x3d,0x8f,0x54,0xc8,0x55,		// 4FA0 - 4FAF
		0x61,0xd6,0x9d,0x06,0x00,0x26,0x69,0xae,0x22,0xaf,0x3b,0x33,0xe7,0xa7,0xc1,0x97,		// 4FB0 - 4FBF
		0x17,0x41,0xb0,0xcc,0xab,0x24,0x66,0xca,0x90,0x1d,0xcf,0xe0,0xa7,0x10,0x85,0x47,		// 4FC0 - 4FCF
		0x10,0x35,0x3b,0xfd,0xa8,0x80,0x5b,0xd0,0xd0,0x61,0xee,0xb9,0x71,0xae,0xbd,0x6c,		// 4FD0 - 4FDF
		0x3d,0xde,0xb5,0x2d,0x37,0x77,0x90,0xe5,0x75,0xc9,0xb2,0x75,0x24,0xdd,0x51,0x4a,		// 4FE0 - 4FEF
		0xce,0xa9,0xd9,0x32,0xd8,0x85,0x8f,0x6e,0x4f,0xe3,0x74,0x08,0xe4,0x3a,0x6c,0x67,		// 4FF0 - 4FFF
		0x34,0x43,0x9f,0x20,0x4d,0x68,0x20,0x0f,0x6e,0x7a,0xcd,0xa7,0x0f,0xa2,0x76,0x86,		// 5000 - 500F
		0x21,0x9a,0x41,0x4c,0x97,0x1c,0x4c,0xae,0x25,0x9b,0x95,0xc6,0x48,0x32,0x17,0xad,		// 5010 - 501F
		0x86,0xda,0x36,0x4c,0xf7,0xdf,0x5d,0x6f,0x04,0x95,0xe6,0x1b,0x6f,0x47,0x3a,0x22,		// 5020 - 502F
		0x94,0x70,0x39,0xf4,0xee,0x2d,0xdc,0xb8,0xdc,0xf3,0x18,0x9c,0xa5,0x7d,0x06,0x69,		// 5030 - 503F
		0xba,0x09,0x42,0x5a,0x3c,0xc4,0x91,0x2e,0xbe,0x83,0xc6,0x7c,0x4c,0xb3,0xe6,0x47,		// 5040 - 504F
		0xac,0x93,0x8a,0xd2,0xe3,0xa1,0x85,0xb5,0xfc,0x51,0xc7,0x31,0x04,0x05,0x81,0xc1,		// 5050 - 505F
		0x59,0x3a,0x8a,0xf1,0x25,0xff,0x02,0x73,0x25,0xac,0x35,0x70,0xaf,0xd0,0xc1,0x1c,		// 5060 - 506F
		0xf3,0x6b,0xfc,0x8d,0x81,0x5e,0x90,0xcd,0x0b,0x1f,0x68,0x2e,0x6c,0xb1,0xd0,0xdd,		// 5070 - 507F
		0xea,0xd4,0xd7,0xba,0xb8,0x79,0xf8,0x67,0xbf,0x78,0xfa,0x9f,0x9f,0x85,0x15,0xca,		// 5080 - 508F
		0xf0,0x61,0x56,0xce,0xcd,0x4d,0x45,0x27,0x93,0xc4,0xc4,0x3a,0xe6,0x69,0x3a,0xe6,		// 5090 - 509F
		0xf5,0x3f,0xf1,0x5d,0xff,0x18,0xbd,0x32,0x17,0x50,0xdf,0xb3,0x24,0xba,0x28,0x78,		// 50A0 - 50AF
		0x2b,0xdb,0x62,0x3c,0xd1,0x56,0xeb,0xec,0x1b,0xa8,0xa3,0xfe,0x79,0x15,0x08,0x04,		// 50B0 - 50BF
		0x03,0xe2,0xa0,0x81,0x02,0xc5,0x98,0xfb,0xb2,0x9a,0xaa,0x51,0x46,0x57,0x44,0x4f,		// 50C0 - 50CF
		0x2d,0x42,0xe6,0x80,0x94,0x62,0xcb,0x43,0x2c,0x33,0xcd,0x21,0x2d,0x9e,0x83,0x5e,		// 50D0 - 50DF
		0x9b,0x27,0xac,0xce,0xc8,0x69,0xd0,0xea,0x1a,0xbf,0x24,0x23,0x0e,0x45,0xaf,0x77,		// 50E0 - 50EF
		0x7d,0xff,0xab,0x41,0x1e,0x57,0x2e,0x55,0x4d,0xcd,0x09,0x4c,0x0a,0xea,0xf0,0x1d,		// 50F0 - 50FF
		0x45,0x75,0xdc,0xee,0x59,0xea,0xae,0x29,0xd6,0x28,0x15,0xd1,0x83,0x6a,0xb1,0x17,		// 5100 - 510F
		0xa3,0x78,0x79,0x28,0x78,0x1f,0x5a,0x4a,0x06,0xde,0x20,0x27,0x19,0xe2,0x9a,0x68,		// 5110 - 511F
		0x89,0x35,0xf9,0x86,0xbd,0x32,0x7a,0xdd,0x6e,0x3c,0x45,0x03,0xad,0xaf,0x94,0x57,		// 5120 - 512F
		0x28,0x17,0x17,0xdd,0xa9,0xa0,0x98,0x49,0xdf,0xce,0xdb,0x59,0x61,0x6e,0xc8,0x68,		// 5130 - 513F
		0xf0,0xcd,0xcb,0x41,0xfc,0x27,0x7c,0x31,0x6a,0x62,0x7b,0x60,0x95,0xfc,0x9e,0x60,		// 5140 - 514F
		0x93,0x43,0x4f,0x07,0xb9,0xc4,0x2f,0x7a,0x61,0x05,0x00,0x8b,0xea,0x77,0xc1,0x45,		// 5150 - 515F
		0x01,0xa6,0x1a,0xc4,0x1f,0xb3,0xfb,0x4b,0x53,0x04,0x81,0x90,0x42,0x3a,0x19,0x5a,		// 5160 - 516F
		0x6c,0x63,0xe7,0x4e,0xb1,0x71,0x69,0x06,0x13,0xec,0x57,0x64,0xbd,0xe3,0xce,0x26,		// 5170 - 517F
		0x45,0x28,0xae,0xba,0x2e,0xbd,0x41,0x53,0xb1,0x89,0x1d,0x3c,0xbc,0x4f,0x4b,0x6d,		// 5180 - 518F
		0x3c,0xe1,0xa8,0x5c,0x98,0x91,0x8c,0x15,0x7d,0xe9,0xaa,0x8d,0xe1,0x9c,0x37,0x33,		// 5190 - 519F
		0x42,0xbb,0x4f,0xc9,0x2f,0x2c,0x94,0x72,0x0a,0x59,0x18,0x0c,0x0c,0x25,0x7d,0xbf,		// 51A0 - 51AF
		0x89,0x24,0x5a,0xd6,0x76,0x0b,0xe1,0xce,0x28,0x65,0xbf,0xad,0x5e,0x88,0x44,0x96,		// 51B0 - 51BF
		0x82,0xc8,0xc4,0x99,0x2c,0xea,0x3d,0xcf,0xe8,0xdc,0x39,0xa7,0x39,0xa3,0xf6,0x7b,		// 51C0 - 51CF
		0xde,0x94,0xc5,0x67,0x53,0xc7,0xb0,0x5a,0x9b,0xc9,0x5f,0x6d,0x3d,0x91,0x3d,0x74,		// 51D0 - 51DF
		0x8d,0xb5,0xd6,0xd3,0x2c,0xde,0x83,0x94,0xd2,0x7a,0x4a,0xb6,0x4b,0xb0,0x00,0xc7,		// 51E0 - 51EF
		0xc0,0x99,0xb0,0xb5,0x38,0xad,0x41,0xe1,0x5e,0x7b,0x52,0x75,0x85,0x9e,0x69,0xf8,		// 51F0 - 51FF
		0xe9,0xec,0x4d,0x1f,0x38,0xf0,0xb0,0xe6,0x51,0x9b,0x11,0xe0,0x4b,0x36,0xe1,0xcb,		// 5200 - 520F
		0xb9,0x9b,0xe5,0x68,0x2c,0xa5,0xdb,0x8a,0xfa,0xe5,0x60,0x6c,0x3e,0x96,0x11,0x47,		// 5210 - 521F
		0x20,0xd3,0xf1,0x24,0x57,0x08,0x0b,0xef,0xec,0xa7,0x58,0xce,0x40,0x1c,0xe2,0xb1,		// 5220 - 522F
		0x50,0x02,0x2a,0x29,0x38,0x97,0xc7,0x7d,0xf6,0x6d,0x51,0xfb,0x71,0x63,0x7d,0x8c,		// 5230 - 523F
		0xba,0xd4,0x89,0x8b,0x91,0x0e,0xdb,0xd7,0x2b,0x06,0xe5,0x27,0x32,0x4a,0x4b,0x9e,		// 5240 - 524F
		0x0e,0x36,0x48,0xa0,0x63,0x6b,0x4e,0xe3,0xda,0x7d,0xec,0xc9,0x25,0xec,0xf5,0xed,		// 5250 - 525F
		0x3d,0x56,0xdf,0xfb,0xee,0xea,0x69,0xc6,0x96,0x20,0x80,0x94,0x2a,0xa7,0x64,0xbc,		// 5260 - 526F
		0x79,0x9f,0x07,0x74,0xb5,0x09,0xb6,0xe4,0x2f,0x7c,0xfa,0x7f,0x62,0x19,0xc1,0x92,		// 5270 - 527F
		0x33,0xc1,0xb9,0x1d,0x77,0x85,0xfd,0xe3,0xb6,0x5d,0xf3,0xbd,0x2e,0x1d,0x74,0x33,		// 5280 - 528F
		0x1b,0xa6,0x2e,0x4d,0x36,0x59,0x47,0xa7,0x7c,0xd2,0x43,0xc4,0x30,0xd2,0x28,0xa4,		// 5290 - 529F
		0x23,0x7c,0xe0,0x99,0x33,0xc5,0xde,0x56,0x12,0x26,0x05,0x49,0x49,0x93,0xc5,0x2b,		// 52A0 - 52AF
		0x7c,0xb1,0x87,0xd5,0xef,0x44,0x4b,0x55,0x49,0xe6,0x8f,0x41,0x98,0xff,0x73,0x4b,		// 52B0 - 52BF
		0x96,0xf1,0x1c,0x16,0x2b,0x93,0x56,0x48,0x32,0xe1,0x7d,0xe1,0x80,0xf2,0x9d,0xcb,		// 52C0 - 52CF
		0x22,0x2a,0xd8,0xb1,0xe7,0xb0,0x08,0x15,0x1f,0x22,0xa6,0x9d,0xa1,0x88,0xeb,0xae,		// 52D0 - 52DF
		0x13,0x87,0x34,0x3c,0x65,0xd8,0xab,0xe1,0x9f,0xf8,0x24,0x2c,0xdd,0x20,0x45,0x3b,		// 52E0 - 52EF
		0x97,0x77,0xea,0x8c,0x26,0x87,0xc7,0x10,0x84,0xed,0x50,0x81,0x54,0x55,0xd5,0xf6,		// 52F0 - 52FF
		0x22,0xa6,0xf2,0xb5,0xeb,0x7a,0x26,0x48,0xe0,0xd1,0xc2,0xd3,0x67,0x06,0x05,0xa4,		// 5300 - 530F
		0x63,0x02,0x85,0x0c,0xb5,0xaf,0xd0,0x6d,0x03,0xaf,0x54,0x95,0xb7,0x4f,0x7c,0x4a,		// 5310 - 531F
		0x4b,0xb6,0x1c,0x26,0xc5,0x63,0x0f,0xa6,0x7d,0xd6,0x1f,0x7d,0x26,0x8c,0x24,0x2e,		// 5320 - 532F
		0x0c,0x31,0x70,0xd9,0x9b,0x12,0x6b,0x55,0x21,0xd1,0x7b,0x80,0xd5,0x5c,0x27,0xd3,		// 5330 - 533F
		0x17,0x1f,0x7b,0x3a,0xf9,0x79,0xae,0x22,0xff,0x6d,0x02,0xd3,0x23,0x9b,0xec,0x00,		// 5340 - 534F
		0x1c,0x6e,0x75,0x9c,0xe0,0x96,0xe0,0xf0,0x68,0xb9,0x8d,0xeb,0xb3,0x65,0x1d,0xb9,		// 5350 - 535F
		0x0d,0x4a,0xd7,0x97,0x91,0xa6,0x4a,0xe5,0xed,0x00,0x34,0x7c,0x65,0x19,0xa3,0x43,		// 5360 - 536F
		0x1b,0x20,0x5a,0xfd,0x8d,0x25,0x76,0x65,0x5f,0xd0,0x52,0x7d,0x5b,0x53,0xa7,0x23,		// 5370 - 537F
		0xb6,0x9d,0xf8,0xe5,0x94,0xd0,0x2d,0x16,0xcf,0xf6,0x7e,0x21,0xf4,0xf0,0x92,0x1e,		// 5380 - 538F
		0x8f,0xae,0xe8,0xa3,0xa9,0xa6,0x77,0xdd,0x8e,0x7e,0x91,0xdf,0xd4,0x0c,0x0d,0x39,		// 5390 - 539F
		0x98,0x81,0xa5,0xcd,0x0b,0xe1,0x9d,0xde,0x2e,0xb7,0xa6,0x6a,0xd9,0x06,0x01,0xba,		// 53A0 - 53AF
		0x02,0x82,0xe7,0x37,0x3c,0x00,0x29,0x7f,0x7e,0x2c,0x14,0xb8,0x26,0x7a,0x97,0x25,		// 53B0 - 53BF
		0x3d,0x5f,0xa8,0xf6,0xfd,0xc0,0xe3,0x65,0x90,0xab,0x74,0xfe,0x1b,0x45,0x38,0x3e,		// 53C0 - 53CF
		0xfb,0x03,0x1f,0x60,0x4f,0x1d,0xd5,0x74,0xb6,0x40,0xa1,0xb1,0x5a,0x84,0x8d,0x0c,		// 53D0 - 53DF
		0x2d,0x9d,0xc7,0x0a,0x72,0x55,0x47,0xd2,0x80,0x3a,0xb2,0x86,0xc2,0x93,0x7e,0xd3,		// 53E0 - 53EF
		0x03,0x99,0x58,0xc7,0xe8,0xe4,0xc2,0xe3,0xbe,0x24,0x01,0x72,0x76,0x11,0x36,0x19,		// 53F0 - 53FF
		0xee,0xa5,0xcb,0xae,0x73,0x88,0x10,0x4d,0x83,0xcc,0x26,0xa9,0xd7,0xda,0x1d,0xa1,		// 5400 - 540F
		0xa1,0xac,0x59,0x14,0x12,0x3d,0x3a,0xf5,0x1f,0x3e,0xfc,0xa2,0x85,0x0b,0xdb,0x71,		// 5410 - 541F
		0x0a,0xdd,0x7b,0x8c,0x06,0x41,0x88,0x00,0x23,0xc9,0x99,0x10,0x61,0x01,0x5b,0xcf,		// 5420 - 542F
		0x5d,0xa4,0xeb,0xee,0xd2,0x10,0x83,0xd2,0x60,0xf8,0x59,0xe9,0x8c,0x59,0xc4,0x3f,		// 5430 - 543F
		0x09,0xaf,0xa1,0x4c,0x36,0x68,0xf5,0x11,0xe7,0x99,0xd4,0x63,0x68,0xf0,0x81,0x86,		// 5440 - 544F
		0xbf,0xea,0xd6,0xfd,0x32,0x45,0xe6,0xa1,0x09,0xb9,0xe2,0xf1,0x95,0xe3,0x39,0xa9,		// 5450 - 545F
		0x71,0x82,0x03,0x96,0x08,0xe5,0xa0,0xa8,0x57,0xa4,0x9c,0x49,0xf5,0x8f,0xd6,0xed,		// 5460 - 546F
		0x50,0xe4,0xe2,0xea,0x39,0xc5,0xab,0x8b,0xa3,0xe8,0x5d,0x5f,0xa7,0x91,0x82,0xd7,		// 5470 - 547F
		0xcc,0xbd,0x6b,0x10,0x86,0xa0,0xd1,0xee,0xfc,0x52,0xbc,0x6a,0x0e,0xc6,0xa4,0x2d,		// 5480 - 548F
		0x97,0xfb,0xd6,0x5d,0xef,0x76,0x1a,0xb7,0xb5,0xef,0x93,0xde,0xcb,0x4b,0xe6,0xf2,		// 5490 - 549F
		0xa1,0xca,0x9f,0x65,0xb7,0x82,0xd0,0x0a,0x5d,0x0c,0xfa,0x6f,0xbe,0x7d,0x31,0x6d,		// 54A0 - 54AF
		0x1c,0x97,0x7c,0xfd,0x5d,0x41,0x7b,0x4d,0xc7,0x35,0x4c,0x14,0x08,0xf9,0xae,0x22,		// 54B0 - 54BF
		0x79,0x10,0x67,0x3b,0xa3,0x71,0xe4,0x25,0x03,0x38,0x20,0x00,0x0a,0x9c,0xc7,0xd6,		// 54C0 - 54CF
		0x68,0x21,0x9a,0x73,0x8a,0x0e,0x15,0x77,0x61,0x22,0x4f,0xa9,0x66,0x83,0x23,0x8e,		// 54D0 - 54DF
		0xdb,0xf7,0x8d,0x3b,0x53,0x56,0x56,0x67,0x74,0x40,0xf4,0xc4,0xfc,0x0b,0xac,0x90,		// 54E0 - 54EF
		0x02,0xff,0xf9,0x66,0x7f,0xc6,0x31,0x5b,0x0c,0x1e,0x66,0x46,0xed,0xd1,0x8a,0x5f,		// 54F0 - 54FF
		0x4f,0xe7,0xd7,0x0c,0xce,0x1a,0x6e,0xf7,0x3a,0x8a,0x3f,0x64,0x9b,0xb2,0x28,0xc2,		// 5500 - 550F
		0x72,0x9b,0x61,0x7f,0x42,0x4f,0x17,0x21,0x4f,0x91,0x57,0x93,0xa6,0xcb,0x2e,0xbc,		// 5510 - 551F
		0x5d,0x48,0x0f,0x56,0x1c,0xa3,0x74,0xfe,0xdd,0x80,0xc8,0x87,0xef,0x79,0x85,0x94,		// 5520 - 552F
		0x41,0x5c,0x9a,0x66,0xdd,0x93,0x0f,0xf2,0xb3,0xe3,0xeb,0x37,0x98,0x5a,0x56,0xce,		// 5530 - 553F
		0x8e,0x82,0xfb,0xc3,0x46,0xdb,0xb0,0xa3,0xe3,0x88,0x59,0xd6,0x01,0x49,0x09,0x2f,		// 5540 - 554F
		0xf6,0xa9,0x6b,0xc2,0x57,0x79,0x61,0xf6,0xbf,0x7c,0xea,0xdb,0xcb,0x64,0x49,0xbd,		// 5550 - 555F
		0x69,0xfd,0x64,0xf9,0x53,0xa9,0x6a,0x0f,0xd6,0x0c,0xb8,0xf9,0xd8,0x08,0xfe,0xbb,		// 5560 - 556F
		0x19,0xec,0x9d,0x3c,0xb9,0xe8,0x54,0x54,0xfb,0xc5,0x1c,0x26,0x48,0xd2,0x50,0xb0,		// 5570 - 557F
		0x77,0x22,0x11,0xa0,0x4b,0xf4,0xe9,0x69,0x3d,0x73,0xae,0x97,0x7c,0xa0,0xaa,0x5f,		// 5580 - 558F
		0x33,0x8c,0xf8,0x7b,0x0a,0xca,0x31,0x35,0xef,0x24,0x49,0xc1,0x16,0x8d,0xb3,0xcf,		// 5590 - 559F
		0x3e,0x57,0xcc,0x61,0x37,0xa6,0x76,0xda,0xa1,0x25,0x03,0x58,0xf6,0xf7,0x56,0x44,		// 55A0 - 55AF
		0xcb,0xf1,0x44,0x28,0x52,0x06,0x40,0xc0,0x24,0x02,0x38,0x53,0x3d,0x7c,0xba,0x43,		// 55B0 - 55BF
		0x48,0x05,0x5b,0xe4,0x1e,0xa6,0x59,0x8a,0x89,0x8a,0x7f,0xe6,0x4d,0xf7,0x49,0x92,		// 55C0 - 55CF
		0x69,0x83,0x49,0xea,0x9a,0x84,0xc9,0x1e,0x21,0xc8,0xb2,0x85,0xc6,0x86,0xad,0x34,		// 55D0 - 55DF
		0x1d,0x95,0x87,0xd0,0x08,0xdc,0xda,0xa0,0x7d,0x0a,0xea,0xe6,0x89,0x87,0xcd,0x70,		// 55E0 - 55EF
		0x95,0xaa,0xcf,0x6a,0xe9,0x2c,0x14,0x76,0x6e,0xdc,0x7f,0xff,0xb8,0x95,0xd3,0xc9,		// 55F0 - 55FF
		0x43,0x6d,0x18,0xcd,0xfd,0x30,0x41,0x45,0x05,0x0d,0x0b,0x03,0xb3,0x8e,0x28,0x06,		// 5600 - 560F
		0xd8,0xce,0x9d,0x4f,0x47,0xe6,0x69,0xf1,0x94,0xa8,0x67,0x68,0x1b,0x90,0x75,0x2b,		// 5610 - 561F
		0x44,0xf7,0xd6,0x85,0x06,0x8a,0xd5,0xa0,0xaa,0xfb,0xab,0xe3,0xd2,0xf6,0xa3,0x7d,		// 5620 - 562F
		0xb9,0x57,0x7c,0x42,0xbc,0x9a,0x0f,0xb7,0x1a,0x92,0x32,0x68,0xf8,0x5e,0xdb,0x82,		// 5630 - 563F
		0xa8,0x9a,0x89,0x9d,0x2a,0xd2,0xdf,0xda,0xf3,0x3c,0x92,0x2e,0xee,0xa6,0x86,0xfd,		// 5640 - 564F
		0xc1,0xad,0x34,0xeb,0x51,0x30,0x4f,0xef,0x88,0x04,0xa7,0xa9,0x56,0xe9,0x4d,0xf5,		// 5650 - 565F
		0xf5,0xbd,0xf8,0xc0,0x72,0xf0,0xa7,0x1a,0x69,0x38,0x88,0x8d,0x10,0x86,0x19,0xad,		// 5660 - 566F
		0x76,0x38,0x8d,0xf1,0x0d,0x90,0x71,0xc1,0x67,0x65,0x8f,0xd0,0x3d,0x18,0x13,0xac,		// 5670 - 567F
		0xb5,0xca,0xec,0x94,0xe4,0xcc,0x75,0x89,0x92,0x57,0x55,0xa7,0x3e,0x7e,0xa4,0xb6,		// 5680 - 568F
		0x62,0x60,0x4f,0xfd,0xf9,0xa2,0xbd,0x56,0x3d,0x1d,0xb2,0x88,0xb5,0xd3,0x74,0xd0,		// 5690 - 569F
		0x6f,0x28,0x2d,0xc1,0x8b,0x4f,0x91,0x4f,0xf9,0x02,0xc0,0x26,0x82,0x76,0x6e,0x40,		// 56A0 - 56AF
		0x0d,0x8e,0x41,0xb6,0x1b,0x4f,0x7a,0xd6,0x95,0x94,0xd8,0x77,0xc7,0x02,0xb9,0x89,		// 56B0 - 56BF
		0xac,0x3f,0x83,0xf0,0x6c,0x5f,0x42,0x93,0x23,0x9f,0x93,0xaf,0xe4,0x56,0xc0,0x72,		// 56C0 - 56CF
		0xfe,0x28,0x2c,0xc5,0x7d,0x7d,0xf2,0x69,0xf4,0x31,0xc9,0x45,0x7a,0x8e,0x2b,0xfe,		// 56D0 - 56DF
		0xf3,0x77,0xb6,0xc9,0x91,0xe5,0xd2,0x7d,0x9a,0x98,0x94,0xed,0x6b,0x06,0xe2,0x74,		// 56E0 - 56EF
		0xbd,0x98,0xd8,0xd1,0x27,0x15,0x6b,0x35,0xe4,0x5e,0x4c,0x9b,0xd7,0x5d,0x0f,0x58,		// 56F0 - 56FF
		0xcc,0x38,0x8d,0xf3,0x01,0xca,0x87,0x36,0xe5,0x53,0x8c,0x85,0x1f,0x6e,0x1c,0x6f,		// 5700 - 570F
		0xd2,0x44,0x0d,0x83,0x1f,0x00,0x2e,0x65,0xec,0x83,0x2b,0x21,0xe4,0x58,0xb0,0xbe,		// 5710 - 571F
		0xbf,0xea,0xd1,0x17,0xc4,0xf4,0xaa,0xe6,0x8c,0x3a,0x42,0x22,0x08,0x77,0xb6,0x8b,		// 5720 - 572F
		0xc6,0x96,0x93,0x83,0x6f,0x24,0x83,0x1f,0x95,0x06,0x2c,0x7e,0xab,0x67,0x55,0x59,		// 5730 - 573F
		0x55,0xf5,0x4a,0xdc,0xe3,0x4d,0x82,0xb4,0x17,0xb3,0x80,0x6a,0x2f,0x07,0xf7,0xef,		// 5740 - 574F
		0x1f,0xf4,0x31,0x78,0x1f,0x6b,0xb1,0x8b,0x65,0x50,0x18,0x5a,0x34,0x73,0x45,0x51,		// 5750 - 575F
		0x15,0xc1,0xc0,0xeb,0x65,0xbc,0x59,0xc9,0x0f,0x28,0x0c,0x05,0x9b,0x07,0x28,0xc4,		// 5760 - 576F
		0x68,0xc8,0xb1,0x0a,0x35,0xbc,0x02,0xd3,0xe6,0xc9,0xb6,0x5f,0x85,0x62,0xc9,0xcd,		// 5770 - 577F
		0x88,0xb6,0xfb,0xeb,0x52,0x28,0x75,0x4d,0xfc,0x00,0xaf,0x9c,0x54,0x60,0x91,0x31,		// 5780 - 578F
		0x26,0x79,0xd9,0xe2,0xbb,0xfe,0xbc,0x1c,0xa0,0xd9,0xd0,0x33,0xa8,0x1e,0x29,0xf5,		// 5790 - 579F
		0x34,0x3d,0xc2,0x85,0xb2,0x7b,0x1f,0x67,0x64,0xa3,0x31,0xd7,0x63,0xf8,0x7a,0x5f,		// 57A0 - 57AF
		0xe3,0x6f,0x72,0xa8,0xb8,0x1b,0x28,0x91,0x1a,0xe9,0x2c,0x7e,0xa5,0x8d,0xad,0xf2,		// 57B0 - 57BF
		0xa3,0xbc,0xdf,0x61,0x8e,0x9c,0x9f,0x3f,0xd1,0x79,0x5a,0x5d,0xcf,0xb9,0x2b,0x75,		// 57C0 - 57CF
		0x26,0x12,0x43,0x04,0x35,0xfa,0x8e,0x57,0xdc,0x5f,0x94,0xe9,0x82,0x99,0x9d,0xec,		// 57D0 - 57DF
		0x5d,0x9d,0x18,0x26,0xed,0x73,0x3d,0xfe,0xca,0xea,0xf2,0xd7,0xa0,0x8a,0xeb,0x9c,		// 57E0 - 57EF
		0x78,0xca,0x16,0x9c,0x39,0x83,0x36,0x99,0x6e,0xa5,0xcd,0x1b,0x49,0x29,0x40,0x0a,		// 57F0 - 57FF
		0xe8,0x46,0x36,0x7c,0xd8,0xe8,0x41,0xcc,0xd8,0x5e,0xc0,0xec,0xdf,0x52,0x04,0xfc,		// 5800 - 580F
		0x60,0xff,0xb1,0x1b,0xcc,0x9e,0x67,0x7d,0x59,0x21,0xa2,0xbd,0x02,0x24,0xdf,0x75,		// 5810 - 581F
		0xce,0x21,0x01,0x0d,0x56,0xe3,0xf2,0xd0,0x81,0x3d,0x8d,0x45,0x93,0xfb,0xbc,0xbc,		// 5820 - 582F
		0x66,0x19,0xdd,0x27,0xf6,0x33,0x6b,0x2b,0x24,0x3d,0xda,0x77,0xb3,0x74,0xc2,0x55,		// 5830 - 583F
		0x97,0x94,0x40,0x7e,0x6f,0x4c,0x9a,0x33,0x50,0xef,0x21,0x89,0xc4,0x6c,0x5c,0x05,		// 5840 - 584F
		0x12,0x80,0x62,0x68,0xc0,0x2a,0x88,0xcc,0x57,0x60,0x3c,0xf0,0x66,0x00,0x31,0xd1,		// 5850 - 585F
		0xc9,0x09,0xbd,0x7a,0x2b,0x0b,0x7f,0x1c,0xca,0xdc,0x44,0x61,0x7a,0x8d,0x2b,0xfe,		// 5860 - 586F
		0xed,0x9c,0x08,0x88,0x31,0x6b,0x07,0x88,0x7a,0xf1,0x92,0xd1,0x22,0xb0,0x74,0x11,		// 5870 - 587F
		0xee,0xe7,0x3e,0xa7,0x93,0x08,0xe9,0xb4,0x79,0x6c,0xbe,0x75,0xbe,0x46,0x73,0xd0,		// 5880 - 588F
		0x7e,0xd6,0x97,0x2c,0x52,0xdf,0x30,0x86,0x16,0x5a,0xa2,0xc1,0xf0,0x6c,0xd2,0x3e,		// 5890 - 589F
		0x8d,0x96,0x8c,0xad,0xae,0x2c,0x22,0x23,0xe4,0x08,0x56,0x6c,0x97,0x7f,0x7a,0xa2,		// 58A0 - 58AF
		0x4d,0x94,0xd6,0xfe,0x29,0x6c,0x4a,0xef,0xb2,0x02,0x35,0x69,0xd7,0x1c,0x95,0x80,		// 58B0 - 58BF
		0x2f,0x7e,0x6f,0x35,0x85,0x5d,0x71,0x90,0x93,0x16,0xd6,0xef,0x0e,0x20,0x8a,0x9d,		// 58C0 - 58CF
		0xe3,0x3f,0x8e,0xa6,0xc1,0xfb,0x9f,0xea,0xd7,0x51,0x12,0x71,0xdf,0xa8,0x03,0xfe,		// 58D0 - 58DF
		0x5b,0x07,0xae,0xe7,0x1e,0x84,0x1d,0x23,0x0f,0x00,0x04,0xa5,0x2a,0x11,0xe9,0xe8,		// 58E0 - 58EF
		0xc7,0x40,0x87,0xcc,0x1f,0x75,0x75,0xa0,0x0c,0xaf,0x03,0x80,0x10,0xf8,0x65,0xe1,		// 58F0 - 58FF
		0x99,0x99,0x13,0x6a,0x83,0x8a,0x6f,0x06,0xdf,0x2c,0xa8,0x37,0xf3,0x3a,0xdf,0xad,		// 5900 - 590F
		0x81,0xfd,0x89,0x17,0x4d,0xc0,0x15,0x39,0xd9,0x84,0xce,0x3e,0x73,0xf5,0x02,0x50,		// 5910 - 591F
		0x71,0x9c,0x64,0x67,0xbc,0x55,0xaf,0x5e,0x8b,0x04,0x8c,0x4c,0x71,0x84,0xb6,0x11,		// 5920 - 592F
		0x9a,0xe0,0x5c,0x2f,0x52,0xc6,0xc7,0xdc,0xc6,0x38,0x3c,0x55,0x0f,0x85,0x24,0x74,		// 5930 - 593F
		0x6c,0x78,0x6a,0x85,0xcf,0xcf,0x25,0x56,0x9c,0xee,0x77,0x8d,0xad,0xd5,0xb4,0x3e,		// 5940 - 594F
		0x99,0x50,0xc7,0xbd,0x36,0x6d,0xd2,0xb1,0x5c,0x33,0x15,0x6a,0xec,0x91,0x11,0x75,		// 5950 - 595F
		0x11,0x95,0xed,0x6d,0xc6,0xdf,0x18,0x13,0x99,0x54,0x30,0xa1,0xae,0x17,0x23,0x5c,		// 5960 - 596F
		0x06,0xb5,0x94,0x69,0x01,0x9f,0x80,0xe1,0x22,0xde,0x21,0x28,0x13,0x02,0x12,0x7a,		// 5970 - 597F
		0xe9,0x5b,0xb5,0xc6,0xa8,0x6c,0xd2,0xc0,0x0a,0x9d,0x80,0x32,0x7c,0x30,0x49,0x92,		// 5980 - 598F
		0x6a,0x76,0x89,0xda,0xbc,0x43,0x17,0x94,0xa1,0x9f,0x27,0x34,0x8b,0xbe,0x6f,0xab,		// 5990 - 599F
		0x7b,0x33,0x89,0x39,0x7e,0x60,0x99,0x83,0x77,0x31,0x2f,0xe5,0x20,0x0a,0x6f,0x09,		// 59A0 - 59AF
		0x4c,0xfd,0x6f,0xb9,0x6f,0x41,0xe0,0xf1,0x5f,0xdf,0xf1,0x39,0x5c,0xaf,0x70,0x31,		// 59B0 - 59BF
		0x4f,0x83,0x32,0x6e,0x4f,0xa2,0xb6,0x84,0x69,0x78,0x05,0x64,0xa1,0x8b,0xdc,0xe9,		// 59C0 - 59CF
		0x34,0xb1,0x0d,0xad,0x20,0x81,0x23,0x21,0xe6,0x07,0x45,0xdd,0x8f,0xbc,0x5d,0x34,		// 59D0 - 59DF
		0xed,0xb4,0x79,0x0c,0x23,0x1a,0x71,0xec,0x68,0xda,0xca,0x57,0x07,0x9d,0xda,0x59,		// 59E0 - 59EF
		0xaa,0xfa,0x2d,0x5f,0xd9,0xea,0x28,0x4c,0xbe,0x7d,0xec,0xc8,0x2b,0xcc,0x7d,0xdb,		// 59F0 - 59FF
		0xde,0x2f,0x24,0xbc,0x03,0xb0,0x11,0xe3,0xfa,0xbf,0x45,0x65,0x5b,0x27,0xaf,0x81,		// 5A00 - 5A0F
		0x37,0x40,0x95,0x76,0xa1,0x66,0x36,0x98,0x6d,0xab,0xae,0xa3,0x38,0xc9,0x19,0x4f,		// 5A10 - 5A1F
		0xa9,0x5b,0xfb,0x25,0xf5,0x4c,0xe0,0x90,0xa9,0x8f,0x3f,0x37,0xa4,0x10,0xa4,0x8a,		// 5A20 - 5A2F
		0x62,0xeb,0x0e,0x9b,0x81,0xdd,0x96,0x30,0x7d,0xf7,0x52,0x16,0xbf,0x9a,0x79,0xb8,		// 5A30 - 5A3F
		0xd6,0x9f,0xc8,0xf0,0x04,0xd6,0x24,0x1c,0xfc,0xb2,0x80,0x75,0xea,0x42,0x01,0x9c,		// 5A40 - 5A4F
		0xb4,0x63,0x60,0x76,0x7f,0x35,0x91,0x3a,0x76,0xcb,0xa2,0xc8,0xc6,0x27,0xe5,0x3d,		// 5A50 - 5A5F
		0xed,0x65,0x51,0xc4,0x35,0x36,0x26,0xaf,0x7b,0x90,0xd0,0xc6,0x35,0xa4,0x0e,0xde,		// 5A60 - 5A6F
		0xb4,0x11,0x53,0xae,0xa6,0x57,0x6d,0xdf,0xde,0x8e,0x64,0x62,0x58,0x58,0xa5,0x06,		// 5A70 - 5A7F
		0x77,0x14,0x5f,0x4a,0x92,0x54,0x2e,0x6f,0xaf,0x91,0xf7,0xd2,0x8e,0x1e,0x13,0x79,		// 5A80 - 5A8F
		0xea,0x5b,0xaf,0xec,0xfb,0x2b,0x72,0x46,0x3f,0xa8,0x61,0x8b,0x7a,0x15,0x00,0x3c,		// 5A90 - 5A9F
		0xfc,0x13,0xba,0x29,0x22,0x18,0x83,0x87,0x1f,0x1e,0xbc,0x42,0xfc,0x98,0x57,0x95,		// 5AA0 - 5AAF
		0xde,0xaa,0x3b,0xd7,0x88,0x99,0xea,0x98,0x20,0x81,0x61,0xec,0x36,0x46,0x40,0x07,		// 5AB0 - 5ABF
		0x02,0xcc,0x2a,0x0a,0xed,0x6b,0x6f,0x1d,0x54,0x9d,0xe8,0xbe,0x88,0xfa,0x23,0x58,		// 5AC0 - 5ACF
		0x19,0x67,0xc0,0x18,0x54,0x8a,0x1b,0xfc,0x0a,0x81,0x2c,0x2d,0x93,0xd3,0xab,0x8e,		// 5AD0 - 5ADF
		0x13,0xa6,0x77,0x95,0xfc,0x33,0x38,0x5a,0xd4,0x78,0x43,0xed,0x39,0x2c,0xbf,0xed,		// 5AE0 - 5AEF
		0x22,0xf8,0x06,0x56,0x67,0xe4,0x4e,0x9b,0x84,0x10,0x89,0xf5,0x9a,0xa4,0x8a,0xfa,		// 5AF0 - 5AFF
		0xb6,0x09,0x68,0x71,0x56,0x5a,0x27,0x65,0x29,0x15,0x95,0x78,0x17,0x17,0x73,0x7a,		// 5B00 - 5B0F
		0x81,0xc7,0xd5,0x3a,0xca,0x91,0xcc,0x9c,0x16,0x96,0x41,0xec,0x51,0xa1,0x24,0x72,		// 5B10 - 5B1F
		0x74,0x5d,0xc7,0x47,0x03,0xc6,0x84,0x67,0xda,0xde,0xa6,0x06,0x2a,0xa1,0x87,0x28,		// 5B20 - 5B2F
		0xbf,0x3a,0xf5,0x6c,0x84,0x77,0xda,0x28,0x48,0x7b,0x1c,0xbb,0xc2,0xb3,0xc3,0x1f,		// 5B30 - 5B3F
		0xd3,0x0b,0x5a,0xbe,0x0c,0x61,0x97,0x87,0x70,0x39,0x3e,0x40,0x7b,0xb3,0x42,0x1e,		// 5B40 - 5B4F
		0x63,0xbb,0x2d,0x93,0x9d,0x80,0xc3,0x67,0xa3,0x27,0xe2,0x0a,0xf5,0xc0,0xad,0x29,		// 5B50 - 5B5F
		0x5d,0x79,0xea,0x7f,0x78,0x11,0xa7,0xee,0x72,0x90,0x24,0xce,0x11,0x36,0xed,0x85,		// 5B60 - 5B6F
		0xf5,0xb1,0x47,0x57,0x1e,0x93,0xcd,0x80,0xae,0x02,0x5b,0x80,0xf0,0xb1,0x2b,0xb7,		// 5B70 - 5B7F
		0x9a,0x10,0x3e,0x31,0x4f,0xc0,0xfe,0xc3,0x68,0x4a,0x21,0x57,0xf4,0x10,0xd0,0x84,		// 5B80 - 5B8F
		0xfd,0x84,0x09,0x62,0x0e,0x97,0x42,0x9c,0xf1,0x75,0x4f,0xc6,0xbd,0x6f,0x85,0xf1,		// 5B90 - 5B9F
		0x11,0x38,0x20,0x7d,0x9a,0x55,0xe2,0x2f,0xdb,0xcf,0xfd,0x83,0x2d,0x2b,0x33,0x44,		// 5BA0 - 5BAF
		0x04,0x9b,0x3c,0x59,0x75,0x76,0x68,0xe2,0xf5,0xe6,0x85,0x84,0x64,0xe1,0x03,0x00,		// 5BB0 - 5BBF
		0x4a,0x5a,0x56,0x0b,0x60,0xb8,0x9c,0x5a,0x52,0x87,0x80,0xfc,0xc3,0x6d,0x5e,0xec,		// 5BC0 - 5BCF
		0x91,0x60,0xa8,0xe7,0x5b,0x17,0x88,0x7b,0x41,0xbe,0xc6,0x61,0xeb,0xee,0xed,0x0c,		// 5BD0 - 5BDF
		0xcd,0xdc,0xa9,0x82,0xa9,0xd1,0x74,0x6b,0x55,0xda,0x71,0x67,0xbe,0xc0,0x98,0xa5,		// 5BE0 - 5BEF
		0x2d,0x3a,0x14,0xb2,0xc9,0x62,0xe9,0x8e,0x5e,0x66,0xda,0x05,0x5c,0x80,0x8a,0x3c,		// 5BF0 - 5BFF
		0x23,0x28,0xe1,0x8b,0x7d,0x88,0xb1,0x8a,0x6c,0x30,0x9a,0x6f,0x27,0x0b,0x2b,0x97,		// 5C00 - 5C0F
		0x5f,0x91,0x49,0x62,0xc6,0x3f,0xd5,0x44,0xd2,0x44,0x89,0x19,0xbe,0x7e,0x23,0xb9,		// 5C10 - 5C1F
		0xd3,0xa4,0xc6,0xcd,0xe5,0xc5,0x9d,0xe1,0x20,0xf1,0xc1,0xba,0x05,0x36,0x5d,0xe9,		// 5C20 - 5C2F
		0xaf,0xce,0x10,0xa0,0x5b,0x96,0x92,0xc5,0x27,0xc2,0x9b,0x45,0x1a,0xcf,0x00,0xab,		// 5C30 - 5C3F
		0x65,0xba,0x1f,0xf1,0xe8,0x70,0x7e,0x95,0xf8,0x85,0xaf,0xf0,0x60,0x28,0x77,0xc4,		// 5C40 - 5C4F
		0xa5,0x57,0x2f,0x14,0x8f,0x4f,0x69,0x38,0xe4,0x47,0xd7,0x30,0x77,0x5d,0x69,0x39,		// 5C50 - 5C5F
		0x61,0xd1,0xb6,0x9e,0x8f,0x71,0x9d,0xd1,0x7d,0x54,0x2c,0xba,0x40,0xcb,0xc0,0x4f,		// 5C60 - 5C6F
		0xca,0x95,0x6e,0x65,0x6a,0x52,0xa2,0xc5,0x92,0x3a,0x06,0x83,0xdd,0x0f,0xa6,0x8b,		// 5C70 - 5C7F
		0x50,0x50,0x51,0x7d,0xe1,0xb0,0x42,0xbb,0x35,0xc7,0x00,0xc0,0xae,0x06,0x82,0xb3,		// 5C80 - 5C8F
		0xa5,0xf0,0x97,0x3b,0xf4,0x87,0x85,0x96,0xb8,0x05,0xf0,0xe5,0x55,0xcd,0xfe,0xca,		// 5C90 - 5C9F
		0xba,0xa1,0xb9,0x35,0xe6,0x15,0xb5,0x7b,0xaa,0x44,0xf2,0xa9,0xb1,0xc1,0x03,0x17,		// 5CA0 - 5CAF
		0xbf,0xd1,0x70,0x40,0x36,0xd7,0x5a,0xd0,0xde,0x0f,0x5d,0xff,0xe5,0x7f,0xbb,0x1e,		// 5CB0 - 5CBF
		0x25,0x2b,0xb6,0x6f,0xa6,0x89,0x3d,0x3a,0x64,0x34,0xcb,0x1d,0x52,0xe4,0x8d,0xa4,		// 5CC0 - 5CCF
		0x9e,0x9e,0xc3,0x1a,0x37,0x28,0x68,0x9e,0x8d,0xc0,0x15,0x79,0x98,0x0d,0x23,0xae,		// 5CD0 - 5CDF
		0x1b,0x56,0x10,0xd3,0x2a,0xf2,0x23,0x20,0xea,0x00,0x53,0xc6,0x98,0x58,0x66,0x81,		// 5CE0 - 5CEF
		0xcc,0xc1,0x56,0x71,0xff,0x64,0xf8,0x26,0x4b,0x80,0xdf,0xfa,0x73,0x60,0x7f,0xa3,		// 5CF0 - 5CFF
		0x23,0x8a,0x8e,0x08,0x79,0x3a,0xb0,0x54,0xc3,0x0e,0x52,0x49,0x8b,0x03,0xd6,0xd8,		// 5D00 - 5D0F
		0xd1,0xa0,0xf1,0xee,0x97,0x71,0x52,0x90,0xa3,0xb7,0x85,0x2a,0x80,0x5e,0x16,0x24,		// 5D10 - 5D1F
		0xc6,0x2f,0xf9,0xb7,0x9b,0x47,0x29,0xff,0x7a,0xc8,0x90,0x51,0x33,0xce,0x27,0xce,		// 5D20 - 5D2F
		0x33,0xa5,0x5e,0x38,0x06,0x39,0xbe,0x05,0x1a,0xcd,0xcd,0xb2,0xc6,0xf0,0x32,0x5a,		// 5D30 - 5D3F
		0x8a,0xad,0x19,0x87,0x99,0x03,0xd9,0x48,0x94,0x95,0xd4,0x84,0x99,0xa1,0x9f,0x8d,		// 5D40 - 5D4F
		0x7c,0x36,0x64,0xf8,0x54,0xa2,0x84,0xad,0x3a,0x2a,0x80,0x3a,0x4d,0xff,0x19,0x6d,		// 5D50 - 5D5F
		0xfa,0x6d,0xb6,0x21,0x7a,0x54,0x07,0x58,0x9b,0xdc,0xe8,0x8a,0xc4,0x65,0x88,0x3d,		// 5D60 - 5D6F
		0x33,0xbd,0xca,0xd6,0x8a,0x96,0xeb,0xaf,0x8a,0x37,0x66,0x69,0x1e,0x71,0x14,0x84,		// 5D70 - 5D7F
		0x9b,0xd5,0x98,0x2c,0x46,0x24,0xfa,0x56,0x17,0x07,0x92,0x0c,0xbc,0x00,0x28,0x05,		// 5D80 - 5D8F
		0xe1,0xa1,0x59,0x79,0xaf,0xfc,0x3c,0x33,0x92,0x5a,0x46,0xe8,0x40,0x30,0x6b,0xc7,		// 5D90 - 5D9F
		0xf7,0x4e,0x86,0x51,0x05,0x5a,0xfb,0x6b,0x8e,0x7d,0x9b,0xb2,0x8a,0x5c,0xc8,0x0e,		// 5DA0 - 5DAF
		0x0d,0x4a,0xd9,0x8a,0xcb,0xbb,0xc0,0x63,0xdb,0xfc,0xe9,0x5e,0xbb,0x22,0x66,0x5f,		// 5DB0 - 5DBF
		0x95,0x41,0x4a,0x38,0xc0,0xde,0x52,0xbf,0x8a,0xa6,0xcb,0x23,0x35,0x60,0xaf,0x80,		// 5DC0 - 5DCF
		0x3f,0x20,0x12,0xb0,0xe7,0xbd,0xbc,0x65,0xec,0x86,0x18,0x74,0x98,0x31,0x4d,0x74,		// 5DD0 - 5DDF
		0xfd,0x14,0xaa,0x88,0x7f,0x98,0x47,0x79,0x92,0xea,0xe9,0x08,0xc5,0xf3,0x27,0x82,		// 5DE0 - 5DEF
		0x00,0x8b,0xcb,0x94,0x09,0xe9,0x7b,0x61,0x4d,0x5e,0x99,0xd2,0xde,0x44,0x67,0x2d,		// 5DF0 - 5DFF
		0xb8,0x31,0x6f,0xea,0x48,0x70,0x22,0xc2,0x2f,0xb1,0xbf,0x08,0x43,0xff,0x76,0x3c,		// 5E00 - 5E0F
		0xd6,0xf3,0xce,0xde,0x3c,0x27,0x44,0x80,0x87,0xee,0x34,0x1f,0x95,0x42,0xfd,0xb3,		// 5E10 - 5E1F
		0x4d,0xfe,0x61,0x05,0x25,0x4e,0x2a,0xc1,0xe7,0x63,0x13,0xcc,0xb6,0x6b,0xe5,0xd7,		// 5E20 - 5E2F
		0x4c,0xc0,0xe1,0x35,0x85,0x5f,0x5e,0xe9,0x21,0x9d,0xb3,0x04,0xc5,0x15,0x57,0x2e,		// 5E30 - 5E3F
		0x44,0xe5,0x47,0x82,0x1d,0x1a,0xa8,0x9f,0x45,0x68,0xae,0xfb,0x26,0x1f,0xbc,0x7b,		// 5E40 - 5E4F
		0xe7,0x5a,0xcd,0x41,0xee,0x79,0x12,0xc6,0xa3,0xd2,0xdc,0x28,0x77,0xa4,0xbd,0xc5,		// 5E50 - 5E5F
		0x26,0x4c,0xea,0x08,0x38,0xbc,0xe4,0x83,0xce,0x28,0x58,0x3e,0x9b,0x02,0x43,0x4f,		// 5E60 - 5E6F
		0x31,0x29,0x59,0xab,0x7e,0x5e,0xa8,0x3c,0x96,0xf7,0x79,0x34,0xb3,0xd7,0x77,0xa0,		// 5E70 - 5E7F
		0x79,0x9d,0x13,0x40,0x7f,0x1c,0x26,0x96,0x0c,0x0c,0xd8,0x3d,0x1e,0xfe,0xc2,0x7c,		// 5E80 - 5E8F
		0xb1,0x96,0x4f,0x1b,0x3d,0xf4,0x68,0x75,0x81,0x73,0x50,0xcf,0x7f,0x96,0xcc,0xe8,		// 5E90 - 5E9F
		0xc8,0x3f,0x88,0xd1,0xf9,0x22,0xb6,0xff,0x86,0x7a,0xf8,0x9f,0xb6,0xfa,0x80,0x29,		// 5EA0 - 5EAF
		0xef,0x07,0x75,0x38,0x34,0x24,0x99,0x99,0xec,0xae,0x2a,0xa2,0xe5,0xc9,0x06,0xc5,		// 5EB0 - 5EBF
		0x98,0x9a,0x12,0x65,0xaf,0xb7,0xdb,0xe7,0xc4,0xdb,0x7e,0x0d,0x6c,0xdf,0xc6,0x7f,		// 5EC0 - 5ECF
		0x74,0xe5,0x95,0xab,0x6a,0xd7,0x85,0xcf,0x5f,0x10,0xce,0x54,0xec,0x58,0x6b,0x5e,		// 5ED0 - 5EDF
		0x73,0x16,0x78,0xa1,0xa7,0xc1,0xdf,0x76,0x4f,0x98,0x33,0x2e,0x47,0x93,0xdc,0xa6,		// 5EE0 - 5EEF
		0xc7,0x99,0x75,0x1b,0xe7,0xf3,0x72,0x40,0x63,0x01,0x06,0x8e,0x9c,0x2b,0x44,0xdc,		// 5EF0 - 5EFF
		0xe0,0x1b,0x84,0x2f,0xeb,0x29,0x08,0xd3,0xae,0x17,0xdf,0xab,0x4f,0xff,0x0a,0xc5,		// 5F00 - 5F0F
		0x70,0x89,0xde,0x31,0xb4,0x61,0xa9,0x14,0x7f,0xe9,0x98,0xf8,0xfe,0x2b,0xd8,0x66,		// 5F10 - 5F1F
		0x68,0x11,0xfc,0xb7,0x83,0xd8,0x9f,0x27,0x69,0xc2,0x4a,0x2b,0x8c,0x0b,0x98,0x05,		// 5F20 - 5F2F
		0xf8,0x1f,0x97,0x95,0xd8,0x0a,0x72,0x72,0x3c,0x30,0x4d,0x39,0x19,0x3e,0x71,0x25,		// 5F30 - 5F3F
		0x91,0x60,0xa9,0xe0,0x75,0xb5,0xeb,0x99,0x09,0x00,0x3b,0x57,0x07,0xa0,0xcd,0x8d,		// 5F40 - 5F4F
		0xe6,0xc2,0x6a,0xee,0x5b,0xd5,0x14,0x82,0x21,0x3e,0xed,0xfa,0xf6,0x4d,0x55,0x41,		// 5F50 - 5F5F
		0xe6,0x70,0x53,0x53,0xcb,0xa7,0x36,0x52,0x15,0x38,0x7c,0xd7,0xc7,0xa4,0xf2,0x86,		// 5F60 - 5F6F
		0xc2,0xd9,0x1d,0xe5,0x46,0xa9,0xd9,0x6e,0xb6,0x7b,0x40,0xe2,0x9b,0x41,0xcd,0xe1,		// 5F70 - 5F7F
		0xec,0xaa,0xc1,0xb8,0x8d,0x98,0xc6,0x7a,0x15,0xd4,0xd3,0x52,0xd4,0x01,0x4f,0x17,		// 5F80 - 5F8F
		0x15,0xce,0x79,0x21,0xa0,0x70,0x07,0x5b,0x83,0x50,0x0d,0x9a,0x12,0x00,0x21,0x2d,		// 5F90 - 5F9F
		0x2d,0x74,0xbd,0xb6,0xc1,0x6f,0xe5,0x38,0x91,0x3b,0x09,0x70,0x37,0x9d,0x2c,0x69,		// 5FA0 - 5FAF
		0x65,0x08,0x46,0x4b,0x71,0x11,0xe7,0x73,0x11,0x23,0x1e,0xc9,0x63,0x74,0x99,0x4e,		// 5FB0 - 5FBF
		0x30,0x37,0x0d,0xf5,0x71,0x14,0xd9,0xb4,0x12,0xd5,0xe6,0xda,0xf7,0x62,0xd1,0xa3,		// 5FC0 - 5FCF
		0x3d,0xef,0x4c,0x0a,0xc2,0x74,0xc1,0xde,0xe7,0x5d,0x39,0x18,0x94,0x83,0x7d,0x6c,		// 5FD0 - 5FDF
		0x7d,0x5c,0x7a,0x1e,0xa4,0x6e,0xea,0x17,0x1f,0x0a,0x31,0x38,0x1c,0x36,0x85,0xee,		// 5FE0 - 5FEF
		0x22,0xeb,0x52,0x07,0x9a,0x81,0xdd,0xc4,0x8d,0x67,0x27,0x2f,0xaf,0x17,0x14,0xae,		// 5FF0 - 5FFF
		0x9d,0x49,0xcc,0xd9,0x63,0x67,0x62,0x89,0x41,0x42,0xb4,0x31,0xaf,0x03,0x92,0x72,		// 6000 - 600F
		0x9e,0x64,0x22,0xe9,0x01,0x20,0x82,0x4c,0x8c,0xa7,0xb0,0xb5,0xbb,0x17,0xa7,0x3d,		// 6010 - 601F
		0x17,0x68,0xcb,0xcd,0xb5,0xe6,0x87,0x31,0xff,0xe5,0x35,0x6e,0xb6,0xb0,0x3e,0x56,		// 6020 - 602F
		0x38,0xc2,0x82,0x59,0xff,0x39,0xfa,0x9e,0x6b,0x87,0x9b,0x53,0xc1,0x6b,0x7e,0x41,		// 6030 - 603F
		0x73,0x20,0x3f,0xa3,0xa2,0xd4,0xa3,0x38,0xe1,0x5b,0x7d,0x97,0x3c,0x25,0xd2,0xc3,		// 6040 - 604F
		0x79,0x6d,0x3b,0xff,0x9d,0xb4,0x8b,0xe3,0xb2,0x6e,0xb2,0xb0,0xc8,0xfb,0xe1,0xe1,		// 6050 - 605F
		0x3a,0xd8,0xef,0x02,0x32,0x17,0xfc,0xc5,0x6f,0x0c,0x54,0x53,0x46,0x4a,0x95,0xe0,		// 6060 - 606F
		0xe7,0xce,0x15,0x82,0xe2,0x79,0x7e,0x43,0xea,0xc4,0xbb,0x75,0xd8,0xaf,0x18,0x45,		// 6070 - 607F
		0xf3,0xfa,0xa4,0x93,0x6e,0x98,0xda,0x01,0x32,0x61,0x81,0x4a,0xde,0x07,0xd1,0xd6,		// 6080 - 608F
		0x0c,0x4b,0xd7,0x8b,0xd7,0x70,0x1b,0xe5,0x9a,0xf0,0x7f,0x49,0xf9,0x6f,0x6a,0x96,		// 6090 - 609F
		0x26,0xed,0x26,0xfe,0x5d,0x3f,0x87,0x14,0xb1,0xc0,0xce,0x25,0x0b,0x44,0xcc,0xcc,		// 60A0 - 60AF
		0x70,0x4d,0x4b,0xc1,0x82,0x82,0xa9,0xf2,0x4a,0x5c,0xc6,0xd5,0x34,0x23,0x21,0xfc,		// 60B0 - 60BF
		0x5b,0x19,0x3d,0xea,0x07,0xf5,0x4a,0x25,0x74,0x92,0x01,0x8c,0xd6,0xe9,0xd0,0xeb,		// 60C0 - 60CF
		0x99,0x3d,0x37,0xcd,0xed,0x95,0x72,0x91,0x82,0x6f,0x58,0xc0,0x90,0xb3,0x83,0x9e,		// 60D0 - 60DF
		0x1b,0xe6,0xb1,0xff,0x75,0xa0,0x6a,0x5c,0x04,0x40,0xe3,0x26,0x45,0xde,0x23,0x5a,		// 60E0 - 60EF
		0x11,0x81,0x64,0x56,0x20,0x92,0xbc,0xeb,0xcb,0x91,0xfc,0xb3,0x16,0x07,0xd9,0xa5,		// 60F0 - 60FF
		0xed,0xbc,0x49,0xe6,0xae,0x29,0x30,0xe2,0xe8,0x30,0x3c,0x9c,0x63,0x0b,0x0d,0x42,		// 6100 - 610F
		0x60,0x83,0x9a,0x05,0x21,0x62,0xd0,0x28,0xac,0x2a,0x7c,0x56,0xcd,0x07,0x6a,0x38,		// 6110 - 611F
		0x5a,0x03,0xce,0x47,0xba,0x79,0xe4,0xdf,0xa8,0xcc,0xd4,0x95,0x35,0x58,0xd8,0xcb,		// 6120 - 612F
		0x0c,0xa9,0xa0,0x82,0xfa,0xeb,0xf6,0x6f,0xae,0xa2,0x9e,0x50,0xbd,0x9c,0x80,0x80,		// 6130 - 613F
		0xe9,0x23,0x09,0xc9,0xa2,0x77,0xce,0x7a,0xcd,0x7b,0x72,0xba,0xc5,0xae,0xca,0x1c,		// 6140 - 614F
		0x9f,0x5d,0x40,0x74,0xb3,0x17,0x75,0xe8,0x57,0x62,0x2b,0x4a,0xee,0xac,0x61,0xa5,		// 6150 - 615F
		0x22,0x84,0xbf,0x15,0x6d,0x0a,0x35,0xdc,0xde,0xa4,0xe0,0xb3,0x1a,0xf3,0x2d,0x5e,		// 6160 - 616F
		0xa1,0x06,0x40,0x83,0x52,0xcd,0x97,0xbc,0x32,0xd0,0xea,0xeb,0x69,0x20,0x56,0xce,		// 6170 - 617F
		0x8d,0x8e,0xbb,0xd3,0x23,0x1c,0x63,0x2d,0x63,0xb1,0xe4,0x27,0x3c,0x11,0x47,0xb8,		// 6180 - 618F
		0x98,0x0b,0x69,0x58,0xe1,0xf5,0xa2,0x13,0xc4,0x55,0xa5,0xdc,0x35,0xe1,0xa7,0x23,		// 6190 - 619F
		0xb3,0xaa,0xc4,0xaa,0xcd,0x94,0x9e,0x94,0xe5,0x09,0x47,0xbf,0x34,0xee,0x61,0x53,		// 61A0 - 61AF
		0x0e,0xd6,0x83,0x9b,0x67,0x76,0xdf,0x14,0x97,0x5a,0x22,0xc4,0x5a,0xd6,0x9c,0xcd,		// 61B0 - 61BF
		0x1b,0x3e,0xa1,0x42,0x72,0x59,0x2f,0x39,0xeb,0x14,0xd0,0x22,0x09,0x74,0xc2,0x57,		// 61C0 - 61CF
		0x8a,0xce,0x56,0xf4,0xed,0x3a,0x96,0xe8,0x32,0x45,0x2a,0x4c,0xe1,0xe6,0x7d,0xf4,		// 61D0 - 61DF
		0x4d,0xb4,0x1b,0x44,0x1a,0x55,0x5e,0x45,0xfd,0x3a,0x49,0xf8,0xc3,0x89,0xb4,0xeb,		// 61E0 - 61EF
		0x95,0x5b,0xa9,0x09,0x7a,0x28,0x0f,0xb6,0x1d,0x7f,0x85,0x1c,0xd1,0xfb,0x91,0xbf,		// 61F0 - 61FF
		0xd2,0x72,0xfa,0x58,0xcd,0x6f,0x72,0xe0,0xa3,0xe3,0x78,0xeb,0x6b,0x17,0x7d,0x37,		// 6200 - 620F
		0xb6,0xe5,0x46,0x85,0x16,0x28,0x91,0xa7,0xe1,0x71,0xfb,0xdb,0x32,0xfc,0x21,0x57,		// 6210 - 621F
		0x31,0xe2,0x06,0x25,0x94,0x8f,0xb5,0x31,0x66,0x77,0x27,0xa1,0x07,0x05,0x66,0x64,		// 6220 - 622F
		0x75,0xd4,0xf3,0x0e,0xc9,0x22,0x65,0xe3,0x05,0x82,0x54,0x31,0x0c,0xd0,0x75,0xe4,		// 6230 - 623F
		0xf2,0x6a,0x06,0x54,0x76,0x9d,0x6d,0x61,0xcd,0x5e,0x1c,0xc2,0xa2,0x3b,0xb7,0x9a,		// 6240 - 624F
		0x5a,0x91,0x79,0x4c,0x9c,0xfe,0xd4,0x91,0x11,0x19,0x57,0xc8,0x68,0x61,0xd5,0x8d,		// 6250 - 625F
		0x9e,0x74,0xc4,0x8c,0x7c,0x82,0xe3,0x97,0x61,0x00,0x20,0xf7,0x41,0xa1,0xb8,0x00,		// 6260 - 626F
		0xee,0x82,0xa0,0xe9,0x96,0xa4,0x24,0xda,0x8d,0xa0,0xce,0x45,0x4d,0x96,0x89,0x7a,		// 6270 - 627F
		0xbc,0x67,0x06,0x76,0xad,0x24,0x5f,0xfc,0xa8,0xc6,0xfa,0xe8,0xee,0x1f,0xb1,0xbf,		// 6280 - 628F
		0xb8,0x10,0x2f,0x8a,0xc0,0xfd,0x9d,0xe5,0x02,0x7e,0x7f,0x53,0xc4,0x57,0xd8,0xd4,		// 6290 - 629F
		0xd4,0xab,0x95,0xba,0x11,0x6c,0x28,0xb8,0x2c,0x16,0x74,0x3c,0xb0,0x9d,0xe9,0xfe,		// 62A0 - 62AF
		0x40,0xa3,0xf0,0xd9,0x20,0xef,0x89,0xdb,0xf8,0x1b,0x32,0x98,0xd4,0x8c,0x0c,0xc3,		// 62B0 - 62BF
		0x6e,0xa8,0x39,0xff,0xb0,0x42,0x88,0xf2,0x75,0x59,0x54,0x9b,0x90,0x03,0xa9,0xe6,		// 62C0 - 62CF
		0x0f,0xa4,0xa9,0x7e,0xc1,0x63,0x2e,0xe3,0xf5,0xdf,0xb1,0xbc,0x85,0x1d,0x6b,0x6e,		// 62D0 - 62DF
		0x13,0xc6,0xb9,0xed,0x93,0x8f,0xc5,0xd3,0x09,0xf8,0x63,0xaf,0x94,0x39,0x39,0x9f,		// 62E0 - 62EF
		0xac,0x79,0x23,0x21,0xa8,0x42,0xd6,0x26,0x83,0x32,0xc3,0x68,0xdf,0xf3,0x3e,0xfe,		// 62F0 - 62FF
		0x4a,0x6d,0xdf,0x2d,0xc1,0x39,0x28,0x82,0x72,0x59,0x69,0x1d,0xc6,0x27,0xe1,0x50,		// 6300 - 630F
		0x9f,0x8c,0x26,0x69,0xdf,0x72,0xc7,0xcb,0x29,0x7c,0x2f,0x44,0xeb,0xf4,0xcc,0x9a,		// 6310 - 631F
		0x9c,0x05,0x71,0x67,0x42,0x2a,0xf9,0x27,0x38,0xe6,0x2e,0x90,0x2e,0xb6,0xe9,0x22,		// 6320 - 632F
		0x71,0x44,0x7a,0xfe,0x6d,0xdd,0x49,0xfb,0x70,0x25,0xbe,0xf7,0xb0,0x09,0x5f,0x6b,		// 6330 - 633F
		0x90,0xf6,0x38,0x42,0x1f,0x48,0x80,0xec,0xe1,0x06,0x79,0xae,0xd3,0xcc,0x98,0x3c,		// 6340 - 634F
		0xa9,0x08,0xe6,0x89,0x5a,0x69,0xa6,0xde,0xde,0x95,0x38,0x2a,0x36,0x1b,0x3d,0x99,		// 6350 - 635F
		0xae,0xa8,0xfc,0x67,0x5f,0x7d,0x05,0xf7,0xf7,0x20,0x13,0x1f,0xbd,0x52,0x37,0xc6,		// 6360 - 636F
		0xcf,0x42,0x33,0xb2,0xae,0x00,0x24,0x9b,0xfd,0x34,0x65,0x84,0x86,0x10,0xaf,0x4b,		// 6370 - 637F
		0x7e,0x83,0x85,0x7e,0x0a,0xb0,0xcf,0x70,0x02,0x9e,0xc5,0x8c,0xf4,0x31,0x0e,0xea,		// 6380 - 638F
		0x6c,0x59,0x29,0x20,0x72,0x89,0x0d,0x5b,0x55,0x6b,0x0c,0xae,0xa7,0xd2,0xfd,0xa9,		// 6390 - 639F
		0x89,0xf0,0x9a,0x2e,0x29,0xc9,0x27,0x80,0x88,0xe7,0x55,0x9d,0x81,0x4f,0x65,0xce,		// 63A0 - 63AF
		0x07,0xb5,0x90,0x7c,0xae,0xec,0xa7,0x45,0x6c,0xa0,0xf7,0x4f,0xa1,0x47,0x6f,0xdc,		// 63B0 - 63BF
		0x56,0x55,0x05,0x1f,0xc2,0xaf,0x55,0x4f,0x13,0x63,0x8b,0xf9,0x6b,0x96,0x84,0x9a,		// 63C0 - 63CF
		0x28,0xbe,0x30,0x6d,0x68,0x11,0x3b,0x82,0xcc,0x3c,0xec,0x10,0x7d,0x59,0x4d,0x0c,		// 63D0 - 63DF
		0x6d,0x1b,0x8c,0xfa,0xe0,0x4c,0xa1,0x04,0x2a,0x7a,0x31,0x49,0xba,0xed,0xb2,0x77,		// 63E0 - 63EF
		0x57,0xdc,0xd1,0x9c,0xaa,0xe0,0x10,0x39,0xfd,0xa8,0xb4,0x99,0x42,0xef,0xde,0x60,		// 63F0 - 63FF
		0x57,0xab,0xf8,0x67,0x88,0x87,0x52,0xc7,0x56,0x94,0x0d,0x34,0x76,0x3b,0x39,0x8d,		// 6400 - 640F
		0x1d,0x77,0x3a,0xb0,0x7b,0x41,0x70,0x93,0x85,0x4b,0x17,0x91,0xf8,0xf0,0x6b,0x01,		// 6410 - 641F
		0x9b,0x6b,0x10,0x0d,0xc4,0x48,0xb2,0xc2,0x1d,0x19,0xe9,0x63,0xa8,0x6a,0x5f,0x03,		// 6420 - 642F
		0x01,0xf7,0x34,0x52,0xe4,0x1c,0xa1,0xb8,0xee,0x8c,0xdc,0xa0,0xa8,0x46,0x3c,0x17,		// 6430 - 643F
		0xc1,0xc5,0x9e,0x95,0x9b,0x77,0x07,0x1a,0x0a,0x71,0x8b,0x7d,0x58,0x61,0x6d,0x01,		// 6440 - 644F
		0x8c,0xc4,0x87,0x2a,0xeb,0x59,0xec,0xcf,0xc0,0xd5,0xcd,0x6f,0x59,0xd8,0x99,0xc9,		// 6450 - 645F
		0x52,0x20,0x68,0xa6,0x16,0xfd,0x9a,0xfa,0xa2,0x04,0xbb,0x2b,0x8c,0x08,0xaa,0xb1,		// 6460 - 646F
		0x44,0x46,0xfb,0xdf,0x9b,0xe0,0x99,0x00,0x81,0x8d,0xb0,0xa6,0x13,0x8e,0xca,0x3f,		// 6470 - 647F
		0xd5,0xe4,0x38,0xe9,0x3b,0xc0,0xb3,0x88,0x6f,0x3b,0x43,0x15,0x4e,0x47,0x60,0x39,		// 6480 - 648F
		0xb3,0xe5,0x57,0x1a,0xf9,0x99,0xf0,0x75,0xbb,0x1b,0x4e,0xed,0xde,0x50,0x16,0xa2,		// 6490 - 649F
		0xd2,0x78,0xd4,0x06,0x14,0xa9,0x9a,0xec,0xf8,0x7c,0xea,0xe2,0xa5,0x06,0xd5,0xc1,		// 64A0 - 64AF
		0x61,0x0a,0x65,0x82,0x0f,0x6c,0x39,0x53,0xf5,0xe9,0x6f,0xea,0xc3,0x06,0xc7,0x1a,		// 64B0 - 64BF
		0xd1,0x46,0x04,0xa4,0xa9,0xa0,0x96,0x4f,0xc5,0x30,0x77,0x3b,0x9a,0x2d,0x53,0x72,		// 64C0 - 64CF
		0xd5,0x1b,0xeb,0xc0,0xe4,0x42,0xbb,0xc5,0xb8,0x5e,0xda,0x48,0xc9,0x98,0x23,0xce,		// 64D0 - 64DF
		0x5b,0xb5,0x92,0x6b,0x00,0x8e,0xf0,0xd9,0x5f,0xc0,0xb3,0xc7,0x33,0xa4,0x20,0x73,		// 64E0 - 64EF
		0x97,0x82,0xb2,0x7b,0x80,0x01,0xbf,0xf1,0x8b,0xe2,0x59,0xad,0xf9,0xee,0x73,0xe7,		// 64F0 - 64FF
		0xf7,0x2d,0x44,0x05,0x23,0x59,0xf1,0xb1,0x4d,0x92,0x66,0x2f,0x7a,0x53,0x84,0xed,		// 6500 - 650F
		0x2f,0xa5,0x82,0x5c,0xec,0x93,0x8d,0xff,0xf6,0xdd,0xb2,0xc2,0x59,0xf1,0xfe,0x8c,		// 6510 - 651F
		0x2e,0x16,0xe4,0x17,0x1a,0xeb,0xde,0x00,0x17,0x10,0x57,0x1a,0x77,0x23,0xc9,0x08,		// 6520 - 652F
		0x26,0xee,0x23,0x0b,0x2f,0xde,0x6d,0x18,0x81,0xb7,0xae,0x2e,0xf4,0x87,0x0e,0xe6,		// 6530 - 653F
		0x87,0xd9,0x38,0x4c,0xeb,0x2a,0x02,0xed,0x46,0xa1,0x50,0x31,0x31,0xfa,0x35,0xeb,		// 6540 - 654F
		0x02,0xc4,0x5c,0x2f,0x51,0xcc,0xa7,0x64,0xb5,0xd9,0x15,0x99,0xcf,0x99,0xe9,0x1d,		// 6550 - 655F
		0x8a,0xdc,0x09,0x49,0xa0,0x00,0xa4,0xa1,0x61,0xac,0x17,0x1c,0xb0,0xc2,0x12,0xbf,		// 6560 - 656F
		0x4e,0x8e,0xf6,0x70,0x5b,0x44,0x82,0x0a,0x19,0xa9,0xaf,0xad,0xf4,0x10,0xd8,0x58,		// 6570 - 657F
		0xbf,0x88,0x1e,0xb9,0x41,0x54,0x0b,0x43,0xf0,0x9b,0x76,0x82,0xfc,0x61,0xa6,0xab,		// 6580 - 658F
		0x8f,0xb6,0xba,0x78,0x54,0x2d,0x47,0x32,0x36,0x90,0x44,0x0f,0x6a,0xd2,0x23,0xbf,		// 6590 - 659F
		0xaf,0x45,0x41,0x42,0xd4,0x0d,0x80,0xfc,0x7b,0xd5,0x32,0x0b,0x1e,0xc1,0x3a,0xd8,		// 65A0 - 65AF
		0x4f,0xa3,0x6d,0xec,0x44,0x71,0x3f,0x06,0x92,0xf7,0x9b,0x6a,0x39,0xc9,0x12,0x7b,		// 65B0 - 65BF
		0xe1,0x7c,0x38,0x8c,0x63,0x15,0x4b,0xf4,0x8b,0xc2,0x16,0x60,0x1d,0xc8,0x15,0x6e,		// 65C0 - 65CF
		0x15,0xbd,0xda,0x77,0x33,0xf7,0xaf,0xab,0xb7,0x44,0x7d,0x64,0x6a,0xdb,0xed,0xb4,		// 65D0 - 65DF
		0xdd,0x93,0xcc,0x40,0xf5,0x53,0xb4,0x52,0xa7,0xca,0xe9,0x29,0x01,0x60,0x81,0x94,		// 65E0 - 65EF
		0x6a,0x6c,0xc8,0xbf,0x2a,0xa7,0xe2,0x4c,0x2d,0xe1,0xb2,0xa5,0x03,0xf2,0xfb,0x91,		// 65F0 - 65FF
		0x2c,0xf4,0xc5,0x06,0x93,0xaf,0x03,0x3f,0x58,0x55,0x72,0x0d,0xd2,0x70,0xc4,0x72,		// 6600 - 660F
		0xd5,0x18,0xfe,0x6c,0x30,0x69,0x1f,0x0f,0x7a,0x34,0x02,0xd6,0x0f,0xf5,0x85,0x3b,		// 6610 - 661F
		0x55,0x05,0xeb,0x85,0x44,0x11,0x7f,0xe2,0x25,0xcb,0x7a,0xb5,0x99,0xdf,0x27,0x31,		// 6620 - 662F
		0xde,0x29,0x45,0x27,0x4e,0x25,0xad,0x1c,0x28,0xa7,0x35,0x9f,0x93,0xcc,0xd3,0xda,		// 6630 - 663F
		0xe0,0x30,0x06,0x66,0x10,0x61,0x71,0x64,0x96,0x94,0xc9,0xc9,0x5e,0x97,0xf2,0xf9,		// 6640 - 664F
		0x0d,0x07,0x65,0x98,0x8b,0xc3,0xd5,0x9c,0xbf,0xa0,0x12,0xa7,0x99,0x5f,0x2d,0x95,		// 6650 - 665F
		0x56,0xdc,0xdd,0x50,0xff,0x87,0x21,0xec,0x33,0x18,0x27,0xf0,0x27,0x7f,0x6d,0xf1,		// 6660 - 666F
		0xeb,0x1a,0x26,0x66,0xef,0x2b,0xdf,0xb7,0xc5,0x89,0x62,0x97,0x28,0x96,0xdb,0x94,		// 6670 - 667F
		0x3e,0x70,0x39,0xec,0x1a,0x6c,0xd7,0xa3,0x85,0xc0,0x5c,0xd2,0xfe,0x7f,0xe0,0x42,		// 6680 - 668F
		0xff,0xcb,0x50,0x39,0x82,0x46,0x13,0x94,0xc4,0xc9,0xed,0x16,0x49,0x59,0x24,0x00,		// 6690 - 669F
		0x20,0x56,0xe2,0xe2,0x68,0xf6,0xdb,0xb0,0x13,0xf2,0x2f,0x18,0xea,0x7f,0x92,0x13,		// 66A0 - 66AF
		0xd1,0x80,0xaa,0xbb,0x4d,0xfa,0xb8,0x5c,0x43,0xc8,0x7b,0xcd,0x03,0x90,0x52,0x01,		// 66B0 - 66BF
		0x84,0xf5,0xa0,0xd9,0xf1,0x0e,0x74,0x3c,0x65,0x17,0x6a,0x6a,0xf4,0x67,0xcc,0x8d,		// 66C0 - 66CF
		0xea,0xa2,0xfd,0x92,0x57,0x30,0x18,0x36,0xcb,0xee,0xd4,0x64,0x5e,0x23,0xab,0xbe,		// 66D0 - 66DF
		0xf3,0xb5,0x3b,0x7a,0xbe,0x9d,0xec,0x6f,0x04,0x98,0xd3,0x6f,0x22,0x1f,0xd6,0xd8,		// 66E0 - 66EF
		0xd1,0x9a,0x11,0x66,0xa8,0xd1,0x79,0x4b,0xe3,0xa3,0xbf,0x82,0x62,0xfa,0x78,0x60,		// 66F0 - 66FF
		0xf5,0xfe,0x7a,0x6c,0xd6,0x89,0x89,0x70,0x77,0xdb,0x33,0xd0,0x7e,0x90,0xf8,0x1b,		// 6700 - 670F
		0x0e,0xcf,0xae,0xe0,0x49,0xc3,0x24,0xc3,0x13,0x4f,0x06,0xcf,0x18,0xfd,0x00,0x0e,		// 6710 - 671F
		0x10,0x38,0x26,0x57,0x42,0xbc,0x94,0x68,0x46,0x4a,0x51,0x35,0x10,0xa0,0x7a,0x7f,		// 6720 - 672F
		0x2a,0xa8,0x9c,0xa7,0x41,0xf0,0x61,0xc5,0xe3,0x5a,0x6f,0xf5,0x87,0x15,0x8d,0xf1,		// 6730 - 673F
		0xce,0xcb,0x07,0xe5,0x08,0x1c,0x54,0x7e,0xfa,0x4c,0xf7,0x44,0xdf,0x38,0xa3,0x2b,		// 6740 - 674F
		0xac,0x8f,0xa2,0x64,0x98,0x3e,0x78,0x79,0xdc,0x2c,0xc3,0x99,0xb7,0x28,0x65,0x31,		// 6750 - 675F
		0xb6,0x20,0xe5,0xbc,0x32,0x93,0x13,0xdb,0x1a,0x48,0xeb,0xa8,0xf3,0x41,0xbc,0x47,		// 6760 - 676F
		0x1c,0xeb,0x8a,0xbf,0x57,0x97,0xb0,0x08,0x85,0x2d,0xc9,0x66,0xb1,0x1f,0xd1,0xf5,		// 6770 - 677F
		0x50,0x9d,0x88,0x84,0xc7,0x08,0x17,0xa6,0x2e,0xa8,0xf6,0x07,0x54,0xa1,0x0d,0xfd,		// 6780 - 678F
		0x03,0x23,0x1a,0x5f,0x85,0xe2,0x52,0x9a,0x66,0xc6,0x4b,0x01,0x7c,0xe3,0x19,0x65,		// 6790 - 679F
		0x25,0xab,0xb8,0xe6,0xd0,0x62,0xaa,0x08,0xbf,0xd3,0xe0,0x0a,0x0b,0x42,0xde,0x73,		// 67A0 - 67AF
		0xe8,0xa1,0x1b,0xed,0x2a,0x07,0xa6,0x56,0x08,0x5d,0x0f,0x15,0x20,0x5b,0x85,0xaa,		// 67B0 - 67BF
		0xbc,0xb3,0x3c,0x89,0x54,0x8b,0x12,0x29,0x54,0x31,0x71,0x58,0x1e,0x0a,0x77,0xd1,		// 67C0 - 67CF
		0x53,0xcc,0x54,0x10,0x4f,0xed,0xf4,0x65,0xf2,0x5c,0xdf,0x48,0xa6,0x6e,0x5d,0xec,		// 67D0 - 67DF
		0x9d,0x1b,0xdd,0x17,0x5b,0x6a,0x97,0x30,0x75,0x2a,0x71,0x9a,0x98,0xe3,0x1f,0x40,		// 67E0 - 67EF
		0xcc,0x0c,0x8f,0x71,0xfa,0x7e,0x84,0xef,0xac,0x29,0x81,0x42,0x15,0x06,0xe8,0x52,		// 67F0 - 67FF
		0x51,0x4c,0x63,0x35,0xee,0xe7,0x83,0x46,0xaa,0x26,0xa7,0x77,0x7e,0xb4,0x20,0xe8,		// 6800 - 680F
		0xdc,0xc9,0x92,0xb8,0x36,0xa1,0x9d,0x1b,0xbf,0x2e,0xbd,0xac,0x75,0x0a,0x6f,0x05,		// 6810 - 681F
		0x5f,0xaf,0x96,0x8d,0x13,0xea,0x1c,0x92,0x7c,0x8d,0xdc,0x98,0xda,0x65,0xc0,0xf0,		// 6820 - 682F
		0x0a,0x6b,0x26,0x8c,0x08,0x3e,0x89,0x11,0xb2,0xd1,0x5d,0x2e,0xcf,0x61,0x3a,0x2d,		// 6830 - 683F
		0x4f,0xab,0x3d,0xc7,0xd4,0x5b,0xac,0x3d,0x72,0xc7,0xd8,0xa4,0xb3,0xdd,0x48,0x80,		// 6840 - 684F
		0xdf,0x5a,0x13,0x95,0x7a,0x3e,0x8e,0xfa,0x0d,0x7c,0x27,0x6f,0x2a,0xf5,0x91,0xf0,		// 6850 - 685F
		0xaa,0xa7,0x22,0x8b,0x39,0x22,0x79,0x6e,0x15,0x3c,0x63,0x44,0x12,0x06,0x00,0xc2,		// 6860 - 686F
		0xe2,0xff,0x21,0x7c,0x93,0x87,0xf5,0xfe,0x59,0x96,0xe5,0x18,0x8e,0xad,0xbc,0x79,		// 6870 - 687F
		0xf7,0x0d,0x0b,0x7f,0x49,0x28,0xcc,0x4e,0xeb,0x55,0x45,0x20,0xfe,0xc7,0x2f,0xdc,		// 6880 - 688F
		0x9b,0xc0,0x18,0xe9,0x5b,0x02,0x06,0x44,0x1d,0x87,0x5d,0xd0,0x03,0x71,0x02,0xee,		// 6890 - 689F
		0xbe,0x44,0xc1,0x4e,0x0c,0x53,0xec,0x05,0x7e,0x78,0x45,0xdf,0x7f,0x08,0x1e,0xf6,		// 68A0 - 68AF
		0x92,0x06,0xbf,0x83,0xdb,0x97,0x08,0xf5,0xe1,0xb6,0x58,0x40,0x92,0x29,0xad,0x78,		// 68B0 - 68BF
		0x88,0xb4,0x0c,0x9e,0x8a,0x8c,0x23,0xba,0x56,0x0e,0x2d,0x29,0x9d,0xb1,0x16,0x39,		// 68C0 - 68CF
		0x50,0x3a,0xdf,0xf3,0x1a,0x2f,0x45,0x38,0x2e,0x8d,0x9d,0x10,0x42,0xbd,0x03,0x3e,		// 68D0 - 68DF
		0xdb,0xc5,0xb3,0x18,0xcc,0xbc,0xb7,0x95,0xf9,0x80,0xc3,0xa8,0x61,0xab,0x5d,0xcc,		// 68E0 - 68EF
		0x5c,0xc2,0x40,0xe0,0x20,0xb0,0x03,0x36,0x8a,0x73,0xf6,0xe7,0x1c,0x16,0x4d,0x69,		// 68F0 - 68FF
		0x42,0xdf,0x80,0x63,0xd9,0xc9,0xf1,0xbf,0xf1,0x34,0xd0,0x01,0xd2,0xdc,0x3b,0xd8,		// 6900 - 690F
		0x3e,0x08,0xaa,0xf3,0xf6,0x04,0x8b,0x16,0x80,0xd0,0x29,0x6d,0x26,0x1a,0xd2,0x20,		// 6910 - 691F
		0x42,0x6a,0x39,0x27,0xb9,0x9d,0x19,0x60,0xc6,0x94,0x1b,0xdf,0xf9,0x2d,0xfa,0x85,		// 6920 - 692F
		0x7f,0x72,0xe5,0xd4,0xa3,0x11,0x25,0x01,0x95,0x0d,0xff,0x4b,0x6a,0xb2,0xdc,0x8c,		// 6930 - 693F
		0x65,0xce,0xa7,0x0e,0x75,0x1e,0x77,0x9f,0xfe,0x07,0x6e,0xe8,0xdc,0x86,0xe1,0xfa,		// 6940 - 694F
		0xa6,0x6a,0xb8,0x2a,0x2f,0xc1,0x18,0x1f,0x53,0x90,0x40,0x29,0xf0,0xc7,0xb1,0xd4,		// 6950 - 695F
		0x32,0x73,0x92,0xbe,0x14,0x36,0x52,0xa5,0x23,0xf4,0x8f,0xc4,0x85,0xd0,0x37,0x60,		// 6960 - 696F
		0x3b,0x57,0xed,0x9e,0xa3,0xfa,0xae,0x97,0x41,0xc2,0xb4,0xae,0xbe,0x3f,0x9a,0x22,		// 6970 - 697F
		0x31,0xc2,0xc2,0xdf,0x9e,0xcc,0xf4,0x9a,0xbc,0xc5,0x47,0x1c,0xfc,0xf1,0x45,0xde,		// 6980 - 698F
		0xc6,0xa1,0x4a,0xd7,0x06,0xa6,0x2d,0x92,0xe7,0x0b,0x22,0x83,0xde,0x04,0xdf,0x9b,		// 6990 - 699F
		0xeb,0x21,0xfe,0x1a,0x1c,0xc7,0xa3,0xa5,0x52,0xe1,0x5e,0x98,0x47,0xd3,0x53,0x9d,		// 69A0 - 69AF
		0xd0,0xaf,0x98,0x7e,0x60,0xac,0xde,0x37,0xce,0xd4,0x54,0x50,0x58,0xfc,0xc8,0x69,		// 69B0 - 69BF
		0xe7,0xf9,0x0f,0x17,0x95,0x11,0xa8,0xee,0x6c,0xb0,0x9c,0xdf,0x70,0x5c,0xa8,0xc5,		// 69C0 - 69CF
		0xe0,0xeb,0x9e,0x3a,0xba,0xf4,0x09,0xaf,0x7d,0x83,0x10,0xbc,0x32,0x11,0x9d,0xb4,		// 69D0 - 69DF
		0xad,0xb3,0xbe,0x7d,0x11,0x91,0x4b,0x9e,0x92,0x9a,0xc9,0x9a,0x7f,0x76,0x8e,0x7d,		// 69E0 - 69EF
		0x7f,0xbc,0x26,0xb4,0x1b,0x66,0xf6,0x21,0x7c,0x82,0x1f,0x6f,0x76,0x2a,0xa5,0xa3,		// 69F0 - 69FF
		0xc6,0xb5,0xd1,0xf4,0x98,0x2f,0xd3,0xdd,0x4d,0x07,0xac,0x70,0x7a,0x08,0x4b,0xed,		// 6A00 - 6A0F
		0x34,0x8a,0xf6,0x93,0x8b,0xea,0xec,0xb6,0x54,0x37,0x49,0x12,0x2c,0x2e,0x29,0x5f,		// 6A10 - 6A1F
		0xb9,0x69,0x10,0x26,0x33,0xd3,0x8a,0xd2,0x23,0x5f,0x0e,0x0a,0x6b,0xfa,0x28,0x3e,		// 6A20 - 6A2F
		0x87,0xbe,0xd8,0x80,0x12,0x68,0x35,0x96,0x8c,0x0c,0x55,0x4d,0x5a,0x07,0x71,0x10,		// 6A30 - 6A3F
		0x0e,0x36,0x45,0xb8,0xe9,0x65,0xb6,0xa6,0x9e,0x0a,0xb7,0x0f,0x59,0x34,0x6d,0x98,		// 6A40 - 6A4F
		0x00,0xbe,0x91,0x23,0xb9,0xc8,0x17,0xe8,0xac,0x67,0x0d,0xc7,0x0a,0x9c,0xc5,0xdc,		// 6A50 - 6A5F
		0x4e,0x83,0x36,0x55,0xc3,0xcd,0xa0,0x80,0x46,0x70,0x6f,0x28,0x4d,0x9d,0x62,0x22,		// 6A60 - 6A6F
		0x28,0xf3,0xec,0x23,0x87,0xf2,0xdb,0xd5,0x3d,0xb2,0x37,0x29,0x43,0xd5,0x6d,0xee,		// 6A70 - 6A7F
		0x00,0xba,0xac,0xa3,0xc7,0xf3,0x90,0x89,0xa2,0xfa,0xfe,0xfd,0x4e,0x1f,0x4f,0x05,		// 6A80 - 6A8F
		0x86,0xc5,0xb0,0x29,0x85,0xce,0xc8,0x84,0xc6,0x54,0x9c,0x1a,0x0e,0x9a,0xb0,0x6c,		// 6A90 - 6A9F
		0xac,0x42,0x6f,0x4a,0xff,0xc0,0xcd,0xe9,0x3a,0x0e,0x2b,0x35,0x64,0xa1,0x7b,0x68,		// 6AA0 - 6AAF
		0xa3,0x9d,0xa4,0xdc,0xb9,0x45,0x28,0x1d,0xcf,0xb5,0x04,0x43,0x72,0xd3,0xd8,0x7f,		// 6AB0 - 6ABF
		0xdb,0x83,0x47,0xf3,0x73,0x1a,0xa1,0xc7,0x96,0x16,0xbf,0x79,0x97,0x0c,0x2f,0x74,		// 6AC0 - 6ACF
		0x05,0xe1,0x92,0xe5,0x2d,0x3d,0x41,0xca,0xe0,0x3d,0x37,0x4b,0x77,0x68,0x2b,0x4e,		// 6AD0 - 6ADF
		0x13,0xe5,0xfc,0x46,0x2a,0xeb,0x52,0x4b,0x3f,0x78,0x83,0x70,0xf0,0x46,0xb3,0x51,		// 6AE0 - 6AEF
		0x36,0xfb,0x40,0xeb,0xe9,0x9f,0x5d,0xb1,0x82,0x54,0xfc,0xdc,0x25,0x41,0xf2,0x02,		// 6AF0 - 6AFF
		0xdf,0xd0,0x55,0xea,0x2c,0x19,0x29,0x9f,0xbc,0x9e,0x3c,0xc3,0x76,0x38,0x4f,0x26,		// 6B00 - 6B0F
		0xbe,0x51,0x76,0x97,0xf3,0x54,0xc2,0xfa,0x3c,0x62,0x1c,0x9b,0x85,0x47,0x74,0xc2,		// 6B10 - 6B1F
		0xc4,0xac,0x1c,0x88,0x81,0x8d,0x6e,0xe8,0x95,0xee,0xb5,0x19,0x32,0xca,0x4b,0x1b,		// 6B20 - 6B2F
		0x23,0x4d,0xfe,0x91,0x55,0x43,0xb8,0xce,0x97,0xcf,0x60,0x32,0x9e,0x60,0xfb,0xb7,		// 6B30 - 6B3F
		0x4c,0xe1,0x17,0xc7,0x32,0x30,0x69,0x51,0x53,0xd2,0xb5,0x1b,0x2a,0xe5,0xee,0x5a,		// 6B40 - 6B4F
		0xef,0x55,0x9f,0x80,0x17,0x53,0x89,0x55,0x1a,0x03,0x8d,0x49,0x78,0x75,0xcd,0x08,		// 6B50 - 6B5F
		0xfe,0xd7,0x0f,0x50,0x45,0xe9,0x62,0xff,0x7d,0xb1,0x03,0x71,0x68,0x6f,0x81,0x08,		// 6B60 - 6B6F
		0xa9,0xd3,0x20,0x0c,0x3f,0x6e,0x7b,0xb6,0x4d,0x67,0x6e,0x87,0x1c,0x6f,0x33,0xde,		// 6B70 - 6B7F
		0x62,0xf6,0xcb,0xca,0xc5,0x9f,0xa0,0x1d,0x9b,0xf2,0x68,0xc2,0xf4,0x52,0x4c,0x50,		// 6B80 - 6B8F
		0xda,0x2e,0x4a,0xde,0xd7,0x7b,0xd8,0x1a,0xb8,0x61,0xca,0x95,0x91,0x34,0x75,0x61,		// 6B90 - 6B9F
		0x01,0xa7,0x15,0xde,0xb7,0x3c,0x6c,0xd1,0x35,0xff,0xac,0xb6,0xd4,0x74,0x97,0x58,		// 6BA0 - 6BAF
		0x09,0xce,0xe5,0x9e,0xe6,0x61,0xe6,0xa8,0xe4,0x5a,0x68,0x1a,0xdf,0xae,0xdb,0xb8,		// 6BB0 - 6BBF
		0x62,0x50,0xb3,0x34,0x25,0xa7,0x0e,0x43,0xd4,0x3f,0x97,0xf6,0x12,0xbf,0xaa,0x48,		// 6BC0 - 6BCF
		0xbe,0x1b,0xb9,0xf4,0x75,0x0a,0xee,0x89,0x58,0xbb,0x11,0xbf,0x0f,0xc3,0xad,0x0c,		// 6BD0 - 6BDF
		0x0e,0x5b,0x6e,0x73,0x16,0xc8,0xce,0x9d,0xff,0x1a,0xf0,0x2a,0xb6,0x19,0xcc,0x49,		// 6BE0 - 6BEF
		0x82,0x7d,0x8d,0x86,0x8b,0x5d,0x37,0xe4,0x9c,0xea,0x8d,0x2c,0x28,0x5d,0x32,0x84,		// 6BF0 - 6BFF
		0x8b,0x2e,0x0e,0x43,0x93,0x87,0xf3,0x04,0x3f,0xf8,0x81,0xfa,0xc6,0x6c,0x47,0x83,		// 6C00 - 6C0F
		0xdb,0x5c,0x2a,0xff,0x30,0x42,0x0b,0xe2,0x39,0x51,0xa4,0x08,0x32,0x63,0xb3,0x49,		// 6C10 - 6C1F
		0x63,0x33,0x5b,0x4e,0xa3,0xcc,0xc7,0xa2,0x1b,0x41,0x10,0x0c,0x4c,0x9f,0x61,0x1d,		// 6C20 - 6C2F
		0x54,0x20,0x59,0x05,0x6c,0xa1,0xb0,0xab,0xb6,0x56,0x1e,0xfc,0x36,0xbd,0x78,0x82,		// 6C30 - 6C3F
		0x1d,0xd0,0x1d,0x39,0x4e,0x7f,0x90,0x9f,0x1b,0x5d,0x66,0x0b,0x4f,0x9a,0x63,0x3f,		// 6C40 - 6C4F
		0x72,0x31,0xe0,0x40,0x48,0x62,0x6f,0x66,0x9b,0x63,0xc2,0xaf,0x3a,0x53,0xc9,0x58,		// 6C50 - 6C5F
		0x42,0x6f,0x1b,0xaf,0x9c,0x88,0x97,0x23,0xc7,0xb5,0x4b,0x9d,0xd8,0x45,0x95,0x13,		// 6C60 - 6C6F
		0xbf,0xf7,0x87,0x5a,0xcb,0x6e,0x90,0x3b,0x71,0xdf,0x59,0xca,0x49,0x0d,0xee,0xf3,		// 6C70 - 6C7F
		0x59,0x77,0x1e,0x56,0x96,0xcf,0x24,0x55,0xa8,0xaf,0x87,0x6a,0xee,0x88,0x3e,0xbe,		// 6C80 - 6C8F
		0xc2,0xdb,0x18,0xf8,0xfe,0xab,0x5b,0x53,0xbe,0x32,0xab,0xf4,0x68,0xd3,0x2e,0x7a,		// 6C90 - 6C9F
		0xea,0x50,0xee,0xd6,0x43,0x3d,0x7f,0x5d,0x45,0xb4,0xe1,0x1b,0x99,0x4b,0xa7,0x6b,		// 6CA0 - 6CAF
		0x03,0x43,0x59,0xc5,0xe7,0x02,0x18,0xd6,0x0d,0xc3,0x80,0xd6,0xa1,0x8d,0xd3,0x16,		// 6CB0 - 6CBF
		0x7e,0x61,0x53,0xd8,0xac,0xb8,0xef,0x64,0x26,0x2d,0x22,0x58,0xe1,0x76,0x19,0x40,		// 6CC0 - 6CCF
		0x0b,0x98,0x14,0x66,0x90,0x5b,0x0e,0xec,0xe3,0xfc,0xa0,0x17,0xfb,0x23,0x23,0xee,		// 6CD0 - 6CDF
		0x9c,0x14,0x15,0x04,0xd7,0x29,0xbd,0x92,0xd4,0x80,0x12,0xc8,0xcf,0xf1,0xda,0x65,		// 6CE0 - 6CEF
		0x61,0x43,0x0f,0x86,0x01,0x9f,0x86,0xbb,0xca,0x44,0xd3,0x60,0x7f,0x7d,0x67,0x2b,		// 6CF0 - 6CFF
		0xcc,0xd0,0xfb,0x01,0xce,0x79,0x32,0x0e,0xd6,0x17,0x79,0x14,0x6a,0xa4,0x32,0x03,		// 6D00 - 6D0F
		0x8d,0xaa,0x13,0xcb,0x41,0xb4,0xc8,0x6e,0x49,0x03,0xe0,0x59,0x33,0x83,0xe6,0xf4,		// 6D10 - 6D1F
		0x96,0xfe,0xce,0x78,0x99,0x8e,0x94,0x01,0xb4,0x58,0x1f,0xe4,0xbb,0x77,0x6b,0x42,		// 6D20 - 6D2F
		0x18,0x37,0xe7,0xdd,0x57,0x84,0x1c,0x2b,0xe9,0xa2,0x90,0xa9,0x21,0x1e,0xea,0x72,		// 6D30 - 6D3F
		0x83,0x04,0x56,0x10,0x3e,0x52,0x2b,0x92,0xf7,0xad,0xcc,0xde,0xc8,0x53,0xcc,0x49,		// 6D40 - 6D4F
		0x89,0x51,0x55,0x65,0x4e,0xf6,0xca,0x1a,0x30,0x87,0xab,0xf9,0x51,0x34,0xb9,0xcc,		// 6D50 - 6D5F
		0x1a,0x4b,0x5b,0x72,0xc7,0xac,0x41,0xea,0x26,0x7d,0x47,0xad,0x9b,0x1e,0x9c,0x41,		// 6D60 - 6D6F
		0x68,0x5f,0x23,0x0b,0x2b,0xf1,0x19,0x65,0xa8,0x1b,0xf9,0xf0,0xc9,0xae,0x9c,0x2b,		// 6D70 - 6D7F
		0xe3,0x3b,0xa5,0x45,0x3b,0x83,0x1c,0x30,0xc9,0x2f,0x59,0xf7,0x3c,0xc2,0x24,0x51,		// 6D80 - 6D8F
		0x3e,0xcb,0x1a,0x76,0xf8,0x5f,0x53,0x31,0xd9,0xc6,0x41,0x37,0x93,0x75,0xdb,0xb7,		// 6D90 - 6D9F
		0x67,0x3c,0xfb,0x32,0xa3,0xc1,0x05,0x8d,0x69,0x2d,0xca,0x65,0xb1,0x25,0xac,0xa2,		// 6DA0 - 6DAF
		0x91,0xfc,0x02,0x4f,0xbd,0x27,0xbe,0xa9,0x4a,0xf1,0x4d,0x75,0xb7,0x70,0xbe,0x97,		// 6DB0 - 6DBF
		0x2d,0xb7,0x27,0xe1,0x06,0x4d,0x44,0x29,0x8d,0xde,0x62,0x9e,0x04,0x31,0x7b,0x5c,		// 6DC0 - 6DCF
		0xec,0x5a,0xa3,0x3d,0x80,0x31,0xa2,0xf2,0x83,0x02,0xe3,0x53,0x3b,0x86,0x8d,0xf4,		// 6DD0 - 6DDF
		0xbe,0x12,0xef,0xf9,0x6c,0x0f,0x21,0x2b,0xbd,0xaa,0xe8,0x4b,0x3d,0xcc,0xdb,0xa6,		// 6DE0 - 6DEF
		0xd4,0x4d,0xc4,0xe9,0x4b,0x65,0x49,0x37,0x0c,0x63,0xcc,0x79,0x29,0xa1,0x8f,0xf5,		// 6DF0 - 6DFF
		0xa0,0xb7,0x1c,0x23,0xde,0xef,0xe4,0xbb,0x81,0xf9,0x26,0x13,0x62,0xe0,0x12,0xa8,		// 6E00 - 6E0F
		0xd3,0x3d,0x2f,0xfa,0x25,0xab,0xfa,0x9e,0x6e,0x7a,0xd0,0x8e,0x88,0xa8,0x0d,0xc3,		// 6E10 - 6E1F
		0x5d,0x0c,0x76,0x06,0x62,0xd5,0xd4,0x03,0x62,0x33,0xe2,0x9f,0x7d,0x54,0x69,0x8b,		// 6E20 - 6E2F
		0x70,0x92,0xaa,0x19,0x17,0xeb,0xfc,0x4f,0x30,0xb1,0xb6,0x3b,0x61,0x82,0x4f,0x85,		// 6E30 - 6E3F
		0x7d,0x7b,0xc4,0x4b,0x03,0xa9,0x3a,0x28,0xe7,0xc0,0xe5,0x96,0x95,0x10,0x28,0x77,		// 6E40 - 6E4F
		0x34,0xb4,0xfe,0xee,0x27,0x0d,0x98,0x73,0xda,0x6f,0x48,0x27,0xbb,0x19,0x9d,0x64,		// 6E50 - 6E5F
		0x86,0x6b,0xd0,0x99,0xc6,0x53,0x5e,0x55,0x99,0x09,0xf7,0xa1,0xb3,0xfc,0x97,0x93,		// 6E60 - 6E6F
		0xa5,0x0c,0xf3,0x20,0x5f,0xf9,0x16,0x32,0xf4,0x1b,0x4c,0xfa,0x9e,0x54,0x3f,0x88,		// 6E70 - 6E7F
		0x02,0x44,0x60,0x99,0xb5,0xbb,0x88,0xb0,0xfe,0x74,0xdf,0x68,0xde,0x00,0xfe,0x08,		// 6E80 - 6E8F
		0x4d,0x00,0x50,0x58,0xc7,0x97,0xbe,0xb3,0x07,0x1f,0x8b,0x5e,0x13,0x1b,0x7c,0x18,		// 6E90 - 6E9F
		0x78,0x6d,0x3d,0xf2,0xd7,0xca,0x00,0x61,0xa0,0x6a,0x67,0x92,0x1e,0x04,0xa4,0xfd,		// 6EA0 - 6EAF
		0xb4,0xf9,0xdf,0x3d,0x66,0xd0,0xd7,0x1f,0x9a,0xe2,0xcd,0xf9,0x20,0x56,0x9e,0x3d,		// 6EB0 - 6EBF
		0x71,0x50,0x2f,0x4d,0x34,0x66,0x0d,0x91,0x07,0x54,0x55,0xc8,0x7b,0xf0,0xd2,0x9b,		// 6EC0 - 6ECF
		0x60,0x60,0x66,0x78,0x44,0x8a,0xab,0x9d,0x36,0xcc,0xd9,0x73,0xd0,0xed,0xeb,0x1e,		// 6ED0 - 6EDF
		0x74,0x54,0xfd,0x52,0xd5,0x78,0xf9,0x68,0xb9,0x98,0x72,0xb1,0xfe,0xac,0xd0,0x0a,		// 6EE0 - 6EEF
		0xdb,0x9b,0xae,0xb0,0x69,0xae,0x80,0x56,0x62,0x45,0x79,0x75,0x28,0xc9,0xac,0xe4,		// 6EF0 - 6EFF
		0x09,0xe1,0x71,0xa8,0xc1,0xe9,0x0a,0x0d,0x40,0xa0,0x86,0xf6,0xae,0x20,0xe6,0x71,		// 6F00 - 6F0F
		0xad,0x14,0x7f,0x8e,0xde,0x25,0x9f,0x72,0xa6,0xb5,0x73,0xa7,0x32,0xd0,0x28,0xb6,		// 6F10 - 6F1F
		0xb8,0x5f,0x51,0xf8,0x00,0x9f,0x89,0xa9,0x24,0xd2,0x59,0x3e,0x94,0x35,0x5c,0xf8,		// 6F20 - 6F2F
		0x5c,0x31,0xa0,0xba,0xaa,0xd5,0x50,0x18,0x8a,0x84,0x90,0xb0,0xf5,0xeb,0xa9,0xbd,		// 6F30 - 6F3F
		0x0a,0x36,0x66,0xe9,0x9b,0x84,0xbe,0x63,0xeb,0x98,0xb2,0x32,0xb6,0xd1,0x79,0xc9,		// 6F40 - 6F4F
		0x72,0x5c,0xdb,0xdb,0xd5,0xa8,0xdb,0x70,0x97,0x1a,0x98,0x39,0x79,0x03,0x75,0x20,		// 6F50 - 6F5F
		0x86,0xcf,0x78,0x24,0x99,0x7f,0xf0,0x64,0x1f,0x59,0x5b,0x79,0x1e,0xdd,0x86,0x09,		// 6F60 - 6F6F
		0x77,0xfc,0xf6,0x99,0x68,0x85,0x87,0xa3,0x54,0xe0,0x53,0xe9,0xc7,0xfe,0xd5,0x08,		// 6F70 - 6F7F
		0xb5,0x90,0x4f,0x50,0x02,0x77,0x68,0xd3,0x47,0x7c,0x1a,0xbc,0xd4,0x42,0xcb,0xe3,		// 6F80 - 6F8F
		0xf1,0x78,0xba,0x9e,0x6a,0x53,0x9d,0xd9,0x4a,0x3c,0x89,0x69,0xe6,0xc6,0x11,0x9d,		// 6F90 - 6F9F
		0x1d,0xe2,0xb2,0x16,0xdf,0x56,0x6f,0xd9,0xec,0x6b,0xb8,0xa3,0xde,0xe6,0x90,0x7d,		// 6FA0 - 6FAF
		0x6a,0x3a,0xef,0x8f,0xe3,0xfc,0x65,0x39,0xff,0x97,0x01,0x60,0xde,0x41,0x71,0x06,		// 6FB0 - 6FBF
		0x48,0x2e,0x6a,0x1e,0x37,0x03,0x4b,0x9e,0x95,0x8d,0xfd,0xd5,0x46,0xb3,0x1d,0xff,		// 6FC0 - 6FCF
		0x69,0xa9,0x5d,0x17,0xdb,0x67,0x27,0xec,0xfd,0x5a,0x84,0x77,0xb8,0x59,0x3d,0x6c,		// 6FD0 - 6FDF
		0xbe,0xda,0x40,0x0f,0x12,0x66,0x44,0x49,0xca,0x4a,0xb0,0xfb,0x14,0x90,0xb9,0x92,		// 6FE0 - 6FEF
		0x77,0x2d,0xcb,0xdc,0x5b,0x7c,0x2b,0x1a,0xcc,0xeb,0xda,0x56,0x7b,0xf5,0xbc,0xf6,		// 6FF0 - 6FFF
		0x05,0x50,0xf9,0x92,0x78,0x67,0xa4,0x03,0x14,0x0a,0x9b,0xbc,0x4e,0x64,0xae,0x5e,		// 7000 - 700F
		0x1b,0x2e,0x03,0x86,0x6a,0x23,0xb8,0xe9,0xf2,0xb4,0xcb,0xa4,0x2f,0xfc,0x37,0xcd,		// 7010 - 701F
		0xa7,0xf6,0x60,0x4e,0x72,0xee,0xb1,0xf3,0xf9,0x35,0x84,0xc1,0xfe,0x19,0x42,0x8a,		// 7020 - 702F
		0xdd,0x14,0xcb,0xbe,0x11,0x44,0x18,0x84,0xf9,0x1b,0x1f,0x09,0xdc,0x58,0xf6,0x18,		// 7030 - 703F
		0x2c,0x36,0x3c,0xec,0x07,0xe3,0xb5,0x42,0x03,0x33,0x34,0xb2,0x2b,0x96,0xbe,0x3e,		// 7040 - 704F
		0x45,0x48,0xec,0x2c,0x57,0xc7,0x91,0x11,0x69,0x8a,0x9d,0x2f,0x8b,0xf0,0x41,0x00,		// 7050 - 705F
		0x1a,0x77,0x54,0x13,0x40,0x2e,0xf6,0x17,0xba,0x6d,0x73,0x36,0xde,0xc3,0x6a,0xa4,		// 7060 - 706F
		0xdc,0x30,0x2e,0x77,0x44,0x94,0x6c,0xb9,0xc8,0x68,0x0e,0xbb,0x44,0xac,0x60,0xad,		// 7070 - 707F
		0xfb,0x20,0x71,0x6c,0x23,0xb7,0xbd,0x9b,0xa5,0x49,0x08,0xf5,0x1e,0x88,0x8d,0xe1,		// 7080 - 708F
		0x29,0x35,0x58,0x47,0xe0,0x94,0xf1,0xa3,0xa0,0x1d,0x3a,0x58,0x0d,0x74,0x9a,0x46,		// 7090 - 709F
		0x56,0x9b,0x5b,0x9e,0xbb,0x67,0x51,0xf5,0x4c,0x30,0xbd,0x98,0xf3,0xcd,0x70,0x20,		// 70A0 - 70AF
		0xb4,0xbf,0x34,0x46,0x34,0xad,0x67,0xf8,0x78,0x11,0xe9,0xac,0xf0,0x30,0x39,0xf4,		// 70B0 - 70BF
		0xb4,0x4f,0xda,0x52,0x0d,0x24,0xfc,0x4e,0x37,0x8b,0x58,0xc7,0x65,0x7a,0x5c,0x87,		// 70C0 - 70CF
		0x06,0x37,0x88,0x1a,0x47,0xc8,0x18,0xdf,0xd9,0xac,0xe3,0x5f,0xf4,0xc8,0x83,0xde,		// 70D0 - 70DF
		0x9c,0xa4,0xb6,0x30,0x23,0xd7,0x04,0xce,0xef,0xc0,0xa2,0x29,0x7d,0x77,0x97,0x3e,		// 70E0 - 70EF
		0xa6,0x03,0x1d,0x6b,0x21,0xce,0x4a,0x81,0x4a,0x56,0xef,0x1a,0x21,0x24,0xc1,0x2d,		// 70F0 - 70FF
		0x96,0x02,0xb6,0xdf,0x04,0x69,0xb2,0x9c,0xfb,0x39,0x63,0x67,0x42,0xac,0x69,0x6e,		// 7100 - 710F
		0x1c,0x8d,0xbb,0xe2,0xcb,0xa5,0x46,0x05,0x53,0x77,0xd7,0x85,0x80,0x2d,0x3a,0x08,		// 7110 - 711F
		0x2a,0xd1,0xa4,0x08,0xb8,0xc0,0x4e,0xe1,0xe3,0x5c,0x63,0x28,0xbd,0x02,0x1c,0x3f,		// 7120 - 712F
		0xf1,0x3c,0x29,0x26,0x4c,0x37,0x54,0x94,0x7c,0x77,0x61,0x47,0x18,0xc9,0x38,0x98,		// 7130 - 713F
		0xe1,0x79,0x46,0x52,0x48,0xc6,0x20,0xc4,0x30,0x93,0x69,0x15,0xf4,0x5f,0xf7,0xd8,		// 7140 - 714F
		0xac,0x77,0x31,0xe0,0xac,0x6a,0xbb,0x56,0x4e,0xbe,0x56,0x08,0xf2,0xe1,0x01,0x04,		// 7150 - 715F
		0x42,0x62,0x64,0x66,0xbb,0x61,0x6f,0x6e,0x69,0x45,0x3f,0xd6,0xf1,0xad,0x41,0x62,		// 7160 - 716F
		0xd5,0xa8,0x99,0xb8,0xf4,0x28,0xc5,0x72,0x50,0xb4,0x7d,0x72,0x14,0x5e,0xde,0x75,		// 7170 - 717F
		0xd6,0xf5,0xc8,0xeb,0x19,0x7b,0x85,0x07,0x16,0xd9,0xab,0x12,0xbc,0xd2,0x43,0x04,		// 7180 - 718F
		0xf5,0x36,0x2a,0x55,0x2b,0x58,0xb8,0x11,0x0b,0xc1,0xa0,0x2b,0x88,0x26,0x17,0x13,		// 7190 - 719F
		0x23,0x98,0x39,0x8a,0x6a,0xfb,0xa8,0xb6,0xbf,0xb9,0x76,0x71,0x5b,0xb8,0x45,0xe7,		// 71A0 - 71AF
		0x93,0x89,0xac,0x60,0x59,0xe2,0xdd,0x5a,0x05,0x4e,0x85,0xdb,0x56,0x23,0xf4,0x05,		// 71B0 - 71BF
		0xb3,0xb4,0x7e,0xeb,0xb7,0xc9,0x21,0xa3,0xed,0x4c,0x68,0x9d,0xd8,0x45,0x8e,0x32,		// 71C0 - 71CF
		0x37,0x09,0xe7,0x80,0x86,0xad,0x7c,0x76,0xc8,0xc1,0xf5,0x2b,0x84,0x3b,0xbd,0x74,		// 71D0 - 71DF
		0x0e,0xb2,0x60,0xb5,0x07,0xcd,0x38,0xf7,0x27,0xfa,0x48,0x3b,0x3a,0x63,0x68,0x0e,		// 71E0 - 71EF
		0x69,0x1e,0xa3,0x5e,0xbb,0xa3,0xdd,0x8c,0xdc,0x84,0xb8,0xc2,0x1c,0x58,0xb9,0x87,		// 71F0 - 71FF
		0xba,0xf8,0xa7,0x91,0x63,0xef,0x34,0xda,0xf6,0x2b,0xe0,0xf6,0x8a,0xf9,0x19,0xa3,		// 7200 - 720F
		0xb2,0x30,0xa7,0xa2,0x00,0xab,0x47,0xc5,0xc7,0xfd,0x96,0x4a,0x25,0x61,0x31,0x67,		// 7210 - 721F
		0x41,0xf0,0x1b,0x26,0xd2,0x17,0x5f,0x73,0xe1,0x47,0xf6,0x73,0xcf,0xee,0xea,0x18,		// 7220 - 722F
		0x99,0xa7,0xbc,0xf3,0x5b,0xad,0x04,0x49,0x13,0x96,0x57,0x68,0xa8,0x3e,0x6d,0x3b,		// 7230 - 723F
		0x2b,0x01,0x83,0x1d,0x5c,0x2d,0xff,0xeb,0x70,0xb6,0x53,0x5d,0x11,0x2c,0x23,0x96,		// 7240 - 724F
		0xa7,0xeb,0xaa,0xf9,0xd6,0x92,0x5a,0x3f,0x47,0xb6,0xc2,0xc6,0xac,0xd7,0xb5,0x2c,		// 7250 - 725F
		0xfe,0x92,0xa9,0x1d,0x09,0x19,0x5d,0x69,0x2b,0xe1,0xbf,0x5a,0x59,0x9a,0x0c,0x44,		// 7260 - 726F
		0x62,0x64,0x39,0x5d,0x78,0x40,0x92,0xcf,0xec,0xc4,0xa1,0x0c,0x39,0x14,0x51,0x62,		// 7270 - 727F
		0x44,0x0d,0x53,0xcf,0xe2,0xc3,0xc1,0x16,0x9b,0x2e,0x01,0x12,0xae,0x20,0xed,0x4b,		// 7280 - 728F
		0x54,0x7a,0x30,0xc7,0x49,0xa0,0xf3,0x23,0x89,0x2a,0xba,0xe2,0x57,0xdd,0x88,0x04,		// 7290 - 729F
		0x84,0xd9,0x4a,0xda,0xee,0x13,0x72,0x1a,0x47,0x06,0xe3,0x2f,0x18,0xa6,0x0d,0xd2,		// 72A0 - 72AF
		0x05,0x96,0x59,0xde,0x52,0x9a,0xc7,0x60,0xa6,0x4f,0xd5,0xee,0x0f,0x1a,0xa4,0x3b,		// 72B0 - 72BF
		0x47,0x5e,0x56,0xe8,0x36,0xf2,0xba,0x9c,0xb7,0xd2,0x2b,0x56,0x9f,0x14,0xb5,0x02,		// 72C0 - 72CF
		0xfc,0x1e,0x7a,0x4b,0x9a,0x17,0x54,0xb1,0xcc,0x9b,0xbc,0xdb,0x68,0xb3,0xeb,0x2e,		// 72D0 - 72DF
		0x14,0x04,0x3e,0x9e,0xc0,0x46,0xdf,0xc4,0x74,0xf8,0xa2,0x31,0x4c,0x52,0x2d,0x03,		// 72E0 - 72EF
		0xc1,0x7c,0x5c,0xb6,0x29,0xfd,0xe4,0x3c,0x81,0x76,0x36,0x4f,0x6b,0x90,0xa6,0x06,		// 72F0 - 72FF
		0x73,0x33,0xcc,0xa6,0x96,0xf9,0x2a,0xbb,0x05,0xe2,0x10,0x68,0x26,0x49,0xbd,0xfc,		// 7300 - 730F
		0xdc,0x16,0xc7,0xc5,0x08,0x36,0xbd,0x29,0x50,0x48,0x0a,0xf2,0x1f,0x99,0x1c,0xea,		// 7310 - 731F
		0xec,0x53,0xc6,0xa8,0xc0,0xf1,0xe3,0xa9,0xf2,0xf6,0x3d,0xa3,0x35,0xdf,0xad,0x15,		// 7320 - 732F
		0xd6,0x56,0x83,0x23,0x3e,0xa8,0x27,0xa1,0xbe,0x79,0x01,0x6e,0x8c,0xb7,0x97,0x03,		// 7330 - 733F
		0x08,0xcc,0xf5,0x4b,0x44,0x18,0x52,0xb6,0xc4,0x9e,0xf0,0x89,0x82,0xfd,0x44,0x78,		// 7340 - 734F
		0x35,0xa3,0x57,0x76,0xd3,0x3d,0x6c,0xcc,0x55,0x71,0xe3,0x68,0xba,0xd0,0x5d,0x78,		// 7350 - 735F
		0x4e,0x06,0x21,0x38,0x2c,0x54,0xbf,0x08,0x02,0x41,0xf3,0xc2,0x14,0x8c,0xcb,0x4a,		// 7360 - 736F
		0x84,0x64,0x0c,0x67,0xd0,0xdb,0xd3,0xd1,0x9c,0x99,0x78,0x8b,0xb2,0xcd,0xb7,0x72,		// 7370 - 737F
		0x47,0x6a,0x12,0x17,0x80,0x8f,0x71,0xca,0x34,0x46,0x0c,0xf7,0xf4,0x72,0x8a,0xb6,		// 7380 - 738F
		0x48,0x03,0x6a,0x9d,0x3c,0x6c,0xa3,0xd8,0x1b,0x57,0x87,0x7c,0x7b,0x97,0xed,0x19,		// 7390 - 739F
		0x79,0x5e,0x8f,0x8f,0x46,0xb0,0xb1,0x22,0xe3,0x17,0x04,0xd0,0x28,0x99,0xc9,0xe1,		// 73A0 - 73AF
		0x0b,0xe7,0x39,0xc1,0x1f,0xd7,0x25,0x0b,0x5b,0x14,0xda,0xe6,0x1d,0x14,0x47,0x94,		// 73B0 - 73BF
		0x6e,0x4b,0x62,0x48,0x88,0x9f,0xc7,0x38,0x96,0x1b,0xa2,0xf4,0xba,0xe7,0xd0,0xf6,		// 73C0 - 73CF
		0x54,0x78,0x41,0x7a,0x82,0x04,0xa1,0x90,0xe3,0x39,0x37,0x6f,0xa1,0x2e,0x0d,0x0c,		// 73D0 - 73DF
		0xae,0x9a,0x51,0xeb,0x4d,0x44,0xfb,0x35,0xd5,0xba,0xb0,0x0c,0xb1,0x46,0xe6,0x1b,		// 73E0 - 73EF
		0xac,0x1e,0x4a,0x71,0x6c,0xdb,0x5e,0x8f,0x3b,0x2c,0x67,0xbf,0x0e,0xcc,0x86,0xa8,		// 73F0 - 73FF
		0xbf,0xb1,0x25,0x20,0x9e,0x87,0x94,0x41,0x28,0x5c,0xf4,0xbf,0x16,0x9d,0x55,0x78,		// 7400 - 740F
		0x9a,0x41,0x1b,0x4d,0xe5,0x44,0xa6,0x31,0xec,0x57,0x32,0x7f,0x6c,0xd6,0xfb,0x91,		// 7410 - 741F
		0x2b,0xfa,0xa5,0x8e,0x82,0x50,0xdc,0x83,0x18,0x69,0x38,0xb6,0xf0,0xd3,0x63,0x37,		// 7420 - 742F
		0xa6,0x49,0x7d,0xb7,0xf5,0x27,0xbf,0x9d,0x7d,0x21,0x5f,0x57,0xc3,0x33,0xb4,0xee,		// 7430 - 743F
		0x7a,0xdb,0x9b,0xde,0x01,0x87,0x19,0x24,0x2c,0x49,0x42,0x98,0x47,0xd2,0x59,0x7d,		// 7440 - 744F
		0x58,0x9e,0x38,0x57,0xa5,0x6c,0xf2,0xfc,0x76,0xf1,0xb8,0xee,0x1c,0xcd,0xf9,0xe8,		// 7450 - 745F
		0x32,0xbe,0xcd,0xb7,0x23,0x14,0x94,0x4b,0xed,0x65,0xda,0x0e,0x24,0x81,0x7f,0x75,		// 7460 - 746F
		0x39,0xa8,0x14,0xd4,0xfc,0xfb,0x87,0x76,0x60,0x31,0x03,0xed,0x7e,0x8b,0x12,0xa7,		// 7470 - 747F
		0xdd,0x0a,0x05,0xc2,0xf1,0xdf,0x95,0x21,0xe1,0x23,0xca,0xc0,0x8e,0xc8,0x1c,0x44,		// 7480 - 748F
		0xd0,0xd0,0xd9,0xd7,0x02,0xbc,0xc6,0x32,0xc2,0x48,0x09,0xfb,0xf2,0x55,0x46,0x52,		// 7490 - 749F
		0x02,0x27,0x09,0xa7,0x72,0xd0,0x64,0xce,0x92,0xec,0xd9,0x55,0x8d,0x8f,0x79,0x15,		// 74A0 - 74AF
		0xa5,0x7c,0x4e,0x07,0xc0,0x98,0xf7,0x59,0x24,0x9e,0x92,0xc1,0x7f,0x13,0xdf,0x12,		// 74B0 - 74BF
		0x2a,0x7d,0xa1,0x0d,0xae,0xd0,0x48,0x79,0x88,0x29,0xce,0x76,0x29,0xbe,0xdf,0x0e,		// 74C0 - 74CF
		0x41,0x15,0x3c,0x0d,0x3d,0x75,0x61,0x12,0x0e,0x9b,0x66,0xe7,0x2d,0xad,0x23,0x0e,		// 74D0 - 74DF
		0xdc,0x74,0x97,0x9c,0xae,0xc5,0x8b,0x4b,0x49,0x40,0x72,0xca,0x6b,0x3e,0x94,0x57,		// 74E0 - 74EF
		0x2b,0x04,0x6b,0x90,0x82,0x3d,0x4d,0x86,0x09,0xa7,0x4c,0x14,0x04,0x0c,0x5b,0x6f,		// 74F0 - 74FF
		0xa0,0x74,0xb2,0xfd,0x79,0x99,0x73,0x6b,0x5f,0x9b,0x8d,0xfa,0x5a,0xf5,0xe0,0x19,		// 7500 - 750F
		0xeb,0xb0,0xa3,0x39,0x95,0xd6,0x03,0xdd,0x9c,0x2a,0x0d,0xf0,0x0d,0x16,0xce,0x5c,		// 7510 - 751F
		0xfe,0xe5,0xb9,0xd8,0x17,0x32,0x49,0x01,0x52,0xa0,0xe7,0xad,0xfe,0xcc,0x0d,0x7c,		// 7520 - 752F
		0x0a,0x80,0xac,0xb0,0x80,0x2a,0xcb,0x3e,0x50,0x8c,0x71,0x24,0x4f,0xb4,0xc6,0xfe,		// 7530 - 753F
		0x7f,0x2f,0x75,0xd4,0x91,0x7a,0x54,0x37,0xa8,0xb9,0x47,0x8c,0x60,0xab,0x62,0xa7,		// 7540 - 754F
		0x0f,0xde,0x4d,0x9c,0x4b,0x1f,0xed,0xd1,0xac,0x35,0x40,0x58,0xd2,0xcf,0x89,0x7c,		// 7550 - 755F
		0xaa,0xba,0xae,0x9a,0xee,0x57,0xde,0x33,0xeb,0x4d,0x76,0x3e,0x87,0x7b,0x26,0xc3,		// 7560 - 756F
		0x82,0x31,0x50,0xa5,0xfc,0x9f,0xb0,0xc0,0x38,0x8d,0x42,0x33,0x9f,0x4d,0x60,0xff,		// 7570 - 757F
		0x08,0xee,0x2b,0xd2,0x36,0xb3,0x2d,0x1d,0xa2,0xc3,0x3d,0x6c,0x7b,0x22,0xa2,0xf7,		// 7580 - 758F
		0xec,0xe0,0x7b,0x74,0x9d,0x91,0x5e,0x30,0x7c,0xfd,0x3f,0x5e,0xbd,0x18,0x93,0xaf,		// 7590 - 759F
		0x1f,0x34,0xb6,0x23,0x72,0x75,0x8a,0x1e,0x56,0x85,0x62,0xbe,0x45,0x8a,0x1e,0x6c,		// 75A0 - 75AF
		0xd4,0x55,0x97,0xb1,0x35,0xdc,0x3d,0x4b,0x01,0xeb,0xfe,0x81,0x34,0x16,0x6a,0xb3,		// 75B0 - 75BF
		0x7a,0xf2,0x15,0x35,0xa9,0x85,0x3d,0x5e,0x8e,0xfa,0xad,0xdb,0xec,0x99,0xe1,0x49,		// 75C0 - 75CF
		0xc2,0xf7,0x6b,0x04,0xcd,0x6a,0x96,0x39,0x4e,0xc0,0x48,0x43,0x0d,0x31,0x2d,0x34,		// 75D0 - 75DF
		0x9e,0x91,0x11,0xb1,0xe3,0xcb,0x8e,0x04,0xd2,0x8a,0xe8,0x6c,0x78,0x39,0x35,0xb7,		// 75E0 - 75EF
		0x3e,0x2e,0xc1,0x13,0x6c,0x22,0xb0,0x22,0xeb,0xe5,0xe5,0x4c,0x4f,0x4f,0x23,0x59,		// 75F0 - 75FF
		0x15,0x7a,0x72,0x3f,0x28,0x2e,0xc5,0x38,0xaa,0x9d,0xd9,0x18,0xf2,0x51,0x60,0xde,		// 7600 - 760F
		0xd1,0x62,0x5f,0x89,0x1a,0xec,0xd5,0x2d,0x61,0xc0,0x9d,0x45,0x02,0x5a,0x95,0x4b,		// 7610 - 761F
		0x66,0x14,0x00,0x86,0x81,0x99,0x29,0x24,0x9f,0x9b,0x4a,0x88,0x61,0xc9,0xab,0xe5,		// 7620 - 762F
		0x02,0xfb,0x0e,0x0c,0xdf,0xb0,0x4b,0x82,0x37,0xbb,0x38,0xd6,0x2f,0x39,0xcb,0x31,		// 7630 - 763F
		0x19,0xc6,0x83,0x2f,0xf5,0xf1,0x03,0xed,0x38,0xed,0x01,0x64,0xcd,0x89,0x5e,0xf5,		// 7640 - 764F
		0x5a,0x61,0x96,0x44,0xc4,0x56,0x5b,0x4a,0xf5,0x3d,0x7d,0xa6,0xdd,0xd4,0x0d,0x34,		// 7650 - 765F
		0xb6,0xfa,0xc2,0xe1,0x8d,0x1f,0x9b,0xbe,0xfe,0xf9,0xc6,0x53,0x3f,0x78,0xc1,0x35,		// 7660 - 766F
		0x60,0xfd,0xbf,0xdb,0xd0,0xc7,0x4d,0xad,0x24,0xad,0x35,0x5e,0x14,0x13,0xa3,0x7c,		// 7670 - 767F
		0xc6,0x17,0x86,0x45,0x50,0x0b,0x39,0xbd,0x78,0x28,0x63,0xfd,0xbd,0x80,0x1c,0xce,		// 7680 - 768F
		0x9c,0x35,0x51,0x76,0x0c,0xe9,0x69,0xd2,0x4b,0x75,0x28,0xa5,0xdc,0xde,0xd4,0x30,		// 7690 - 769F
		0xd1,0x85,0x97,0x03,0x46,0x9d,0x25,0x12,0x2e,0xe2,0x9e,0x0b,0x52,0x88,0xb6,0xe7,		// 76A0 - 76AF
		0x96,0x72,0x13,0xc0,0x7e,0xa5,0xf7,0xe2,0xf2,0xfc,0x1e,0x24,0x3e,0x1d,0xea,0x79,		// 76B0 - 76BF
		0x5d,0xab,0xbd,0xc2,0x77,0xbe,0xa6,0xe6,0xa8,0x90,0x41,0x25,0x03,0x79,0xd8,0xa9,		// 76C0 - 76CF
		0xd7,0x1d,0xce,0x5e,0x30,0xe4,0x3e,0x04,0xa1,0xaa,0xdf,0x83,0x41,0xb8,0x2b,0x7e,		// 76D0 - 76DF
		0xf4,0xf3,0xc0,0x2a,0xec,0x54,0x06,0x61,0x6f,0x98,0x12,0xf2,0xda,0x39,0xca,0x3c,		// 76E0 - 76EF
		0xe6,0x9c,0x4a,0xfb,0x2a,0x8c,0x87,0x61,0xe1,0xe7,0x32,0x69,0xee,0x97,0xe0,0x68,		// 76F0 - 76FF
		0x1d,0xc4,0x67,0xe4,0xac,0x48,0x8b,0xaa,0x0a,0x64,0xda,0x1b,0xde,0xb1,0xd4,0xc7,		// 7700 - 770F
		0x4b,0x59,0x4f,0x3d,0x72,0x86,0x1a,0x20,0x39,0x1b,0xe1,0x7e,0x4b,0xa3,0x50,0x5e,		// 7710 - 771F
		0x61,0x86,0x7b,0x98,0xbf,0x83,0x7e,0xea,0x01,0x5a,0x60,0x47,0x17,0xc9,0x3e,0x72,		// 7720 - 772F
		0x8f,0xba,0xa5,0xcc,0x12,0xbb,0x3f,0x6b,0x32,0xae,0xb2,0x6b,0x63,0xc2,0xc5,0x89,		// 7730 - 773F
		0x46,0xa2,0xc5,0xed,0x2e,0xec,0x27,0x48,0xdd,0xe4,0x6e,0x1f,0x8e,0x6a,0x4f,0x67,		// 7740 - 774F
		0x39,0x29,0x13,0x51,0x12,0x12,0x3e,0x67,0x52,0x09,0x6e,0xd8,0x3b,0xdd,0x85,0x10,		// 7750 - 775F
		0x56,0x7e,0x0a,0x8c,0x00,0x6a,0xcd,0xed,0x24,0x69,0xca,0x4b,0x4a,0x7a,0x50,0xcb,		// 7760 - 776F
		0xd1,0x0d,0x63,0x74,0x78,0x72,0x5e,0x3e,0x24,0x92,0xdd,0x6c,0xdd,0xdd,0xd9,0x1c,		// 7770 - 777F
		0x19,0x83,0x15,0x1d,0x3d,0xe7,0xb9,0x00,0x61,0x51,0x3d,0x72,0x53,0xe2,0x89,0xc9,		// 7780 - 778F
		0xdf,0xce,0x5b,0xdc,0x4e,0xc5,0xe8,0x18,0x2d,0xb2,0xc6,0xd0,0x50,0xa8,0x09,0xd5,		// 7790 - 779F
		0x16,0x19,0xad,0x47,0xed,0x4a,0x34,0xaa,0x19,0x03,0x8f,0x3c,0xb2,0x8b,0x42,0x86,		// 77A0 - 77AF
		0xec,0xd4,0xc4,0x32,0x9c,0xf2,0x24,0x1c,0xf7,0xd1,0xf2,0xac,0x9c,0x28,0x5d,0x62,		// 77B0 - 77BF
		0xd5,0xa9,0x99,0xb2,0x19,0x7b,0x84,0x13,0xd6,0xe9,0x88,0x53,0x6e,0x5c,0xc3,0x2d,		// 77C0 - 77CF
		0x7f,0x86,0x65,0x1d,0x68,0xe1,0x5a,0x73,0x09,0x58,0x2a,0xa7,0xca,0x43,0x1d,0xec,		// 77D0 - 77DF
		0xde,0x99,0xa2,0x07,0xc9,0x61,0xf1,0x62,0x1f,0x6a,0xf0,0x5c,0x8f,0x3c,0x53,0xe4,		// 77E0 - 77EF
		0x21,0x4e,0x08,0x46,0xbc,0x7a,0xd2,0x44,0xeb,0xad,0x34,0x69,0xe0,0xe3,0x90,0x9a,		// 77F0 - 77FF
		0xba,0x53,0x90,0xee,0x03,0xe6,0xc5,0xc0,0x7d,0xee,0x8e,0x02,0x1e,0x15,0x3c,0xd3,		// 7800 - 780F
		0x59,0x93,0x73,0x54,0x9f,0xa5,0xd3,0xb8,0x26,0x3a,0xd8,0x9b,0xe9,0xef,0xff,0x95,		// 7810 - 781F
		0xf0,0x3d,0x2b,0x0e,0xd1,0xf1,0x46,0x54,0x77,0xdd,0x2b,0xea,0x22,0xce,0xc4,0x24,		// 7820 - 782F
		0xaf,0xbe,0x6f,0xf0,0x1a,0x4a,0xa7,0xf7,0x41,0x66,0xe0,0xe5,0xea,0x4f,0xb2,0x04,		// 7830 - 783F
		0x08,0xc1,0x3a,0x10,0x3a,0x6b,0xbe,0x47,0x95,0xa0,0x8f,0xbf,0xa3,0x4f,0x34,0xfc,		// 7840 - 784F
		0xab,0x35,0xc4,0xc2,0x33,0x51,0x94,0x28,0xc4,0x98,0x12,0xee,0xed,0xeb,0xf1,0x10,		// 7850 - 785F
		0x8a,0x46,0x87,0x9b,0x47,0x3a,0x73,0xc0,0x5f,0x9d,0x82,0x27,0xaa,0x80,0xd4,0x86,		// 7860 - 786F
		0xd6,0x61,0x3a,0x71,0xf4,0xa2,0xe3,0x74,0x37,0x3a,0x38,0x5f,0xf9,0xab,0x04,0xe1,		// 7870 - 787F
		0xff,0x34,0xd8,0x58,0xfe,0x47,0xae,0xe8,0x5e,0x3d,0xcc,0xca,0x3d,0x49,0xeb,0xe7,		// 7880 - 788F
		0xb7,0xaa,0x99,0xa6,0x65,0x25,0xdc,0x02,0x23,0xb3,0x18,0xdf,0x17,0x77,0x32,0x9e,		// 7890 - 789F
		0xef,0xf2,0xf6,0xef,0x69,0x7a,0xb6,0xe6,0x19,0xe8,0x34,0x52,0x67,0x92,0xc3,0x4a,		// 78A0 - 78AF
		0xd7,0x79,0xa8,0x08,0x8d,0xc3,0xc6,0xfb,0x10,0x6b,0x7b,0x17,0x4e,0x37,0xc5,0x70,		// 78B0 - 78BF
		0xe0,0xea,0xa9,0x07,0x90,0xbb,0xd5,0xe3,0x18,0x07,0x84,0x64,0x2d,0x43,0xa2,0xd5,		// 78C0 - 78CF
		0xbc,0x34,0x30,0x40,0x74,0x62,0xeb,0x86,0x84,0xca,0x28,0xae,0xa6,0xd3,0x03,0x7e,		// 78D0 - 78DF
		0x5c,0x83,0xb8,0x48,0x79,0xf3,0x51,0x07,0xe4,0x00,0x82,0xab,0x99,0x44,0xd1,0xb0,		// 78E0 - 78EF
		0xf0,0x45,0xf9,0xf5,0x22,0xeb,0x91,0xcc,0x09,0x38,0xe9,0x4d,0x27,0x33,0x35,0xf1,		// 78F0 - 78FF
		0xea,0x25,0xed,0x5c,0x2e,0x08,0x73,0x79,0x04,0x3d,0xf7,0xcc,0xb2,0x7d,0x98,0x04,		// 7900 - 790F
		0xfb,0x12,0xcb,0xd0,0xa0,0x47,0x01,0xf4,0x26,0x1d,0x84,0x9c,0xda,0x3f,0xa2,0xf0,		// 7910 - 791F
		0x13,0x38,0x0e,0xe8,0xb7,0xe4,0x83,0x62,0x00,0x24,0xaa,0x72,0x80,0xd6,0x3e,0xf9,		// 7920 - 792F
		0x63,0x05,0x6e,0x79,0xf5,0x5c,0x83,0x27,0x64,0xe1,0xc2,0x42,0xc6,0xe0,0x94,0xa4,		// 7930 - 793F
		0x5d,0x24,0xe4,0x97,0x1a,0x6d,0xc9,0xe9,0x61,0x1f,0x65,0x43,0x0c,0x38,0x0d,0xb6,		// 7940 - 794F
		0xb2,0x84,0xa9,0x97,0x29,0x14,0x5e,0x8d,0x49,0xec,0x6b,0xe8,0xf3,0xfc,0x51,0x34,		// 7950 - 795F
		0x52,0x52,0x37,0x0e,0x61,0x8d,0x8c,0x37,0xae,0x95,0xee,0xe7,0x5d,0x89,0x4b,0x64,		// 7960 - 796F
		0x6f,0xf9,0x46,0xd2,0x45,0x56,0xdc,0x4d,0x5f,0xa6,0x47,0x35,0x6a,0x7c,0x22,0xc9,		// 7970 - 797F
		0x7a,0x28,0xcf,0xf8,0x94,0x2b,0x16,0x73,0x6f,0xee,0x0e,0x07,0x7b,0xb3,0x41,0x2a,		// 7980 - 798F
		0x23,0xcb,0x0b,0xd4,0x4f,0x09,0x43,0x90,0x2e,0x78,0x1d,0xd2,0x32,0x49,0x4f,0x8b,		// 7990 - 799F
		0x5c,0x0f,0x73,0xfb,0xb9,0x2f,0xad,0xc6,0x2d,0x91,0x8d,0x4b,0x6f,0x9c,0x37,0x31,		// 79A0 - 79AF
		0x55,0x62,0xc1,0x42,0x52,0x17,0xdc,0x7d,0x3d,0xc8,0xb7,0x66,0x53,0x49,0x20,0xa1,		// 79B0 - 79BF
		0x80,0x70,0xed,0xbf,0xda,0x80,0x9a,0x58,0x6e,0xe8,0x33,0x5a,0x40,0x2e,0x74,0xa0,		// 79C0 - 79CF
		0x8d,0x26,0x30,0xc7,0x53,0x67,0xef,0x3d,0x14,0xff,0xdb,0x9a,0xd6,0x66,0xdd,0x34,		// 79D0 - 79DF
		0x6e,0xb1,0x03,0xed,0xfe,0x08,0x25,0x50,0xbd,0x5a,0xc8,0xdd,0xf6,0x4f,0x42,0xa0,		// 79E0 - 79EF
		0x54,0x7f,0x1f,0x09,0x5c,0xe1,0xc4,0xf7,0x3b,0x86,0x52,0x16,0xc2,0x87,0xcd,0x6b,		// 79F0 - 79FF
		0xaf,0x3c,0x7e,0x2d,0x2e,0xae,0x95,0xd7,0x9f,0x4f,0x13,0x7b,0x9a,0xe9,0xe7,0x59,		// 7A00 - 7A0F
		0x30,0xd5,0x57,0xb0,0x74,0x6d,0xa2,0xd4,0x3b,0xc3,0xe4,0x81,0x1f,0x94,0x39,0x6f,		// 7A10 - 7A1F
		0xca,0x77,0x25,0x26,0x71,0x5a,0x34,0x14,0x9e,0x2f,0xdd,0xdd,0x33,0xe3,0xac,0xf2,		// 7A20 - 7A2F
		0xac,0x90,0xa1,0x65,0xa4,0xf3,0xd3,0xfc,0x9a,0x20,0x58,0x84,0xf6,0x74,0x69,0x67,		// 7A30 - 7A3F
		0x47,0xcc,0xc2,0x81,0xcf,0xf4,0x48,0x30,0x41,0x63,0xee,0xaa,0xc9,0x25,0xd9,0x94,		// 7A40 - 7A4F
		0x4d,0x18,0xc3,0xd0,0xf3,0x5b,0x9d,0x96,0xe3,0x04,0x78,0xc6,0x4e,0x11,0xa5,0x7c,		// 7A50 - 7A5F
		0xaf,0xa2,0x1b,0xe5,0x50,0x65,0x1a,0x52,0x10,0x51,0x0e,0x8b,0x65,0x97,0xb6,0x66,		// 7A60 - 7A6F
		0x9d,0xd5,0x85,0x98,0x69,0x8d,0x49,0xca,0x9b,0xd7,0x0a,0xf0,0x2f,0x52,0x35,0xd6,		// 7A70 - 7A7F
		0x88,0x60,0xfa,0xfb,0xfd,0x93,0xf2,0xa3,0x94,0x62,0x05,0x28,0x0d,0x21,0x8b,0x91,		// 7A80 - 7A8F
		0x23,0x30,0xb1,0x65,0x0e,0x72,0x1e,0xc2,0x4c,0x00,0xd7,0xa9,0xa1,0x1f,0x60,0x9c,		// 7A90 - 7A9F
		0x5d,0x70,0x25,0x6b,0xdd,0x67,0x18,0x4b,0x54,0xfe,0x9a,0x28,0xcc,0xab,0x9f,0x3c,		// 7AA0 - 7AAF
		0x67,0x8f,0x0d,0xe1,0xeb,0xf0,0x66,0xa3,0x7d,0xe9,0xa7,0x9a,0xad,0x60,0x70,0xf7,		// 7AB0 - 7ABF
		0xb3,0x39,0x64,0xdc,0xf8,0xc9,0xd3,0x71,0xd9,0x8e,0x97,0x34,0xa7,0x1d,0x3b,0x90,		// 7AC0 - 7ACF
		0xf2,0x5b,0x63,0xb2,0x07,0xf0,0x67,0x98,0xb7,0xf9,0x42,0x6a,0x5a,0xfd,0xab,0x0e,		// 7AD0 - 7ADF
		0x14,0x23,0x81,0xf7,0x57,0xa2,0x6c,0x3d,0xa9,0x78,0xc2,0xf3,0xa8,0x5f,0xa7,0xb5,		// 7AE0 - 7AEF
		0x4b,0xfd,0x79,0x80,0x6a,0x5b,0x6b,0xc6,0x81,0x98,0x6f,0xc2,0xb1,0xdf,0x5a,0x0a,		// 7AF0 - 7AFF
		0x07,0x96,0x42,0x63,0x01,0xd8,0x2b,0xd8,0x4e,0x26,0xe3,0x0e,0xd6,0x59,0x2b,0xd2,		// 7B00 - 7B0F
		0xfa,0xdb,0x17,0xf4,0x1d,0x17,0xb8,0x58,0x63,0x2e,0xf8,0x4a,0xb8,0xec,0xc4,0x12,		// 7B10 - 7B1F
		0x15,0xfa,0x71,0xc8,0xfe,0x55,0x58,0x6a,0x50,0xfe,0xc4,0x2c,0x39,0xf4,0x0f,0x0f,		// 7B20 - 7B2F
		0x88,0x5f,0x07,0xb5,0x27,0x0e,0x96,0x74,0xe5,0x23,0xa3,0xa9,0x79,0x0d,0x33,0x4f,		// 7B30 - 7B3F
		0xc4,0xb7,0xd4,0xd0,0x57,0xff,0x3b,0x1a,0x35,0x6a,0x2c,0xf6,0xda,0x16,0x9a,0x95,		// 7B40 - 7B4F
		0x7c,0xf0,0x10,0x6c,0x90,0x26,0x4f,0x43,0x90,0xe0,0x39,0x88,0xfc,0x2b,0xed,0xe8,		// 7B50 - 7B5F
		0x9f,0x35,0x34,0x21,0x13,0xc0,0x1c,0x11,0x87,0xd1,0xe2,0x13,0xc0,0xa8,0x15,0x8c,		// 7B60 - 7B6F
		0x5e,0xf5,0xf9,0xc1,0x61,0x49,0x2a,0xec,0xeb,0xcb,0x81,0x8e,0x47,0x2c,0x3b,0x06,		// 7B70 - 7B7F
		0x2b,0xdd,0x58,0x63,0x3a,0x7f,0x42,0x77,0xcd,0x9b,0xaf,0x2c,0xf3,0x93,0xc8,0x1c,		// 7B80 - 7B8F
		0xb7,0xd8,0x8b,0x5b,0xa1,0x5e,0x6e,0x97,0x7f,0x4d,0x45,0x64,0x64,0xfa,0x65,0xd1,		// 7B90 - 7B9F
		0xf2,0x15,0x0a,0x3f,0xd5,0x24,0xf6,0x73,0x90,0x2f,0x5b,0xe9,0x7c,0xbd,0xfb,0x6b,		// 7BA0 - 7BAF
		0x0d,0x00,0x8e,0xe3,0x58,0x4d,0x64,0x6e,0xd2,0xcf,0x4b,0xb1,0x5b,0x7b,0xb3,0x70,		// 7BB0 - 7BBF
		0x7b,0x46,0x10,0x5c,0xeb,0x96,0x80,0x2d,0x57,0xf7,0xae,0xf1,0x62,0x10,0xf6,0xa4,		// 7BC0 - 7BCF
		0xeb,0xd5,0xca,0x00,0x8e,0xfe,0x54,0x96,0x6e,0xb7,0x5c,0x1e,0x32,0x99,0x6d,0x0c,		// 7BD0 - 7BDF
		0x4e,0xd9,0x33,0x64,0x84,0xbf,0x28,0xce,0xaa,0x5a,0x70,0xed,0xad,0x73,0x00,0xed,		// 7BE0 - 7BEF
		0xd6,0xbf,0x06,0x5b,0x4c,0x58,0x85,0x3a,0xdb,0x6e,0x40,0x53,0xf3,0x3a,0xda,0xcc,		// 7BF0 - 7BFF
		0xf4,0x34,0x3b,0xfc,0xa8,0x86,0x36,0x7e,0x11,0xc0,0x68,0x84,0x66,0xcd,0x63,0x6e,		// 7C00 - 7C0F
		0x58,0x26,0x0c,0x9c,0x99,0x45,0x41,0x80,0x9f,0x5d,0xbf,0xf7,0xa6,0x48,0x43,0xd9,		// 7C10 - 7C1F
		0xf4,0xc1,0xf0,0xce,0x60,0xd3,0xf1,0x64,0x15,0x91,0x5f,0x5f,0x94,0x08,0x65,0x51,		// 7C20 - 7C2F
		0xf8,0x72,0xa2,0x6a,0x7e,0xad,0xce,0x90,0x44,0xeb,0xa1,0xb2,0x51,0xaa,0xf0,0x5a,		// 7C30 - 7C3F
		0xd6,0xe7,0x1a,0x82,0xb3,0x8e,0xa2,0xa9,0x3d,0x36,0x1d,0x26,0x3f,0x0b,0x4f,0xbb,		// 7C40 - 7C4F
		0x3f,0x0b,0x91,0x6d,0x02,0x76,0x75,0x93,0x52,0x7f,0xad,0x2e,0xfe,0x48,0x29,0x78,		// 7C50 - 7C5F
		0x23,0x0d,0x80,0xc0,0xaa,0xa0,0x91,0x74,0x12,0x15,0x6a,0x80,0x6f,0xbe,0x69,0xd6,		// 7C60 - 7C6F
		0xb3,0x5a,0xa0,0x4e,0x2d,0x89,0x7e,0xb1,0x4f,0x83,0xac,0x10,0xb4,0x0a,0x36,0x5b,		// 7C70 - 7C7F
		0x62,0x9d,0xeb,0x2f,0x4c,0xef,0x06,0xee,0x1b,0x97,0x0e,0x15,0x2d,0x09,0xfa,0xca,		// 7C80 - 7C8F
		0xde,0xc5,0x99,0xb5,0x07,0xce,0x31,0x11,0xc5,0x5e,0x67,0x03,0x7c,0xd8,0x5e,0x2a,		// 7C90 - 7C9F
		0x1b,0xfe,0x23,0x77,0xa1,0x64,0x49,0x3f,0xe0,0x24,0xd0,0x8e,0x80,0xd4,0x4c,0xbf,		// 7CA0 - 7CAF
		0x48,0xb5,0x42,0x49,0x99,0x2d,0xd6,0xdc,0x3b,0x78,0xa3,0xad,0x5d,0x9a,0xeb,0x0e,		// 7CB0 - 7CBF
		0xd6,0x98,0xf0,0x41,0xb1,0xe7,0xa1,0x8e,0xe9,0x25,0x79,0x93,0x71,0x07,0xa5,0xdc,		// 7CC0 - 7CCF
		0x77,0x93,0x65,0xb3,0xea,0x8f,0xb4,0x39,0x3a,0x39,0x2b,0xb6,0x5f,0x38,0x23,0x2e,		// 7CD0 - 7CDF
		0x1c,0xd3,0x1a,0x35,0x85,0x61,0x58,0x03,0xbf,0x00,0xd1,0xcb,0x07,0x8a,0x4e,0x49,		// 7CE0 - 7CEF
		0xf5,0xc5,0xc8,0x9b,0x02,0xda,0x14,0x51,0x49,0x09,0xc6,0xc7,0x8a,0x9a,0x4f,0xb3,		// 7CF0 - 7CFF
		0x74,0x17,0x68,0xfa,0x24,0xb8,0xb4,0xc8,0xe9,0x1f,0xa0,0xdf,0x4a,0x45,0x8f,0x2f,		// 7D00 - 7D0F
		0x4a,0xb5,0x34,0xa7,0xea,0xf8,0x3e,0x4c,0xf0,0x50,0x3b,0x88,0xe7,0xa9,0xb6,0xc4,		// 7D10 - 7D1F
		0x67,0xcc,0xa3,0x39,0x96,0xd6,0xfe,0x02,0xef,0xe8,0xae,0x76,0x42,0x21,0xaf,0xb6,		// 7D20 - 7D2F
		0xfc,0xc9,0x70,0x82,0xa9,0xcf,0x7a,0x51,0xb7,0x76,0x53,0xa0,0x7d,0x4b,0xa2,0x8a,		// 7D30 - 7D3F
		0x7c,0x5a,0x93,0x99,0xe4,0xa1,0x7d,0xdc,0x5a,0xc5,0xc3,0x39,0xf8,0x04,0xf8,0x05,		// 7D40 - 7D4F
		0x95,0x6b,0x46,0xd2,0x47,0x49,0x10,0x88,0x27,0xe3,0xd6,0xb8,0x54,0x69,0x59,0x2c,		// 7D50 - 7D5F
		0x3b,0x29,0x00,0xc3,0x15,0x03,0x7b,0x7c,0xb0,0x1d,0xa6,0xd0,0x73,0xd8,0xb0,0x45,		// 7D60 - 7D6F
		0x9d,0x02,0x7c,0x40,0xcd,0x4d,0x47,0x1a,0xc7,0xff,0x8c,0x77,0x75,0xec,0x24,0xd3,		// 7D70 - 7D7F
		0x2c,0xa1,0xb2,0x5e,0x31,0xe3,0x3e,0x0a,0x7c,0x58,0x20,0xe2,0xbb,0x83,0x20,0x9d,		// 7D80 - 7D8F
		0x9a,0xf6,0xdb,0x73,0x42,0xc2,0x69,0x2f,0x1f,0x33,0x3c,0x86,0xe7,0xba,0x4b,0xa7,		// 7D90 - 7D9F
		0xd8,0x2b,0x70,0x13,0x41,0x28,0x0f,0xaf,0x43,0xdd,0xf9,0x17,0xd9,0xef,0x90,0x36,		// 7DA0 - 7DAF
		0x16,0xae,0x2b,0x14,0xae,0x92,0xbc,0xee,0xb8,0xe5,0xb0,0x8c,0xb2,0xbd,0x16,0xcf,		// 7DB0 - 7DBF
		0xc6,0x2d,0x04,0x8a,0x4b,0xbc,0x36,0x92,0x8f,0x16,0xf9,0x19,0xd4,0x02,0x47,0x37,		// 7DC0 - 7DCF
		0x98,0x94,0x34,0xca,0x1a,0xa4,0x89,0x80,0x19,0x7f,0xae,0x32,0xdf,0xdb,0xcd,0x74,		// 7DD0 - 7DDF
		0x7e,0x11,0x34,0x6a,0x5a,0x86,0xfb,0xdd,0xe7,0x6a,0xe7,0x8d,0xb4,0xa6,0x8f,0xc9,		// 7DE0 - 7DEF
		0xa9,0x0f,0xbd,0x3e,0x8d,0xe0,0x17,0x0d,0xca,0x67,0xff,0x20,0x75,0xfe,0xb7,0xbd,		// 7DF0 - 7DFF
		0x89,0x3d,0xc9,0x5b,0x73,0x6e,0xa6,0xb5,0xd4,0x41,0x8d,0x1e,0x82,0xc2,0xae,0x14,		// 7E00 - 7E0F
		0xd0,0x87,0x90,0x17,0x0f,0x2e,0xb0,0xbc,0x54,0x07,0x6b,0xfd,0x7c,0x0d,0x1d,0xd3,		// 7E10 - 7E1F
		0x6e,0x1b,0x8b,0x07,0xa0,0x5c,0x7e,0x44,0xdd,0x04,0xb1,0x72,0x45,0x3d,0xed,0x3f,		// 7E20 - 7E2F
		0x95,0x64,0x73,0xfe,0xa8,0x76,0x9a,0xb5,0x3e,0xc5,0xb9,0x71,0xfd,0xf0,0x47,0xdd,		// 7E30 - 7E3F
		0xb5,0x11,0x41,0x13,0xe8,0x38,0xcc,0xb2,0x8a,0x19,0x1c,0x31,0x05,0x01,0x94,0x73,		// 7E40 - 7E4F
		0x80,0x0f,0x2f,0x9b,0x61,0xa0,0x1e,0x21,0x10,0x0b,0xb3,0x26,0xfe,0x8f,0x7d,0x04,		// 7E50 - 7E5F
		0xe7,0x89,0xb5,0x2a,0x54,0xea,0xd8,0x27,0x63,0xe9,0x96,0x04,0xca,0xf5,0xeb,0xd7,		// 7E60 - 7E6F
		0x1a,0xee,0x8c,0x95,0x41,0x94,0x84,0x28,0x53,0x40,0x1f,0xc1,0x8a,0xd2,0x07,0x70,		// 7E70 - 7E7F
		0x8b,0xea,0xad,0xf2,0xea,0x5b,0xea,0xca,0xf1,0xdc,0xe7,0x93,0x9d,0x01,0x3a,0x94,		// 7E80 - 7E8F
		0xea,0x6a,0x51,0x95,0x50,0x3b,0x14,0xf1,0x8e,0xcb,0xc6,0xed,0xa6,0xa1,0x2c,0x48,		// 7E90 - 7E9F
		0x29,0x9c,0xf2,0x13,0xb4,0x71,0x4a,0xc3,0xbb,0x5b,0xd6,0x85,0x85,0x0d,0xc8,0xd1,		// 7EA0 - 7EAF
		0x78,0xec,0x48,0x42,0x97,0x7b,0x16,0xa5,0x49,0x16,0x70,0x50,0x5c,0xe4,0x36,0xb5,		// 7EB0 - 7EBF
		0x49,0x07,0x4c,0x36,0xba,0x15,0x40,0x3b,0x49,0xcc,0x2c,0x82,0x8b,0x01,0xde,0xb7,		// 7EC0 - 7ECF
		0x4d,0xda,0x37,0x45,0x1d,0x3d,0xd1,0x6b,0x0d,0x88,0xe4,0x92,0xb3,0x83,0x6b,0xde,		// 7ED0 - 7EDF
		0x74,0x93,0x82,0x03,0x03,0x30,0x13,0x5a,0x24,0x98,0xb1,0x34,0xb6,0xc5,0xc4,0x6e,		// 7EE0 - 7EEF
		0xf0,0x9d,0xe7,0x45,0xeb,0x6a,0x8e,0x6c,0x60,0x89,0xec,0x5c,0xb4,0x66,0x14,0xec,		// 7EF0 - 7EFF
		0x31,0xa8,0x5e,0x21,0x97,0xa8,0x0c,0x47,0xd3,0x28,0x2d,0x40,0x0e,0x42,0xc2,0x1d,		// 7F00 - 7F0F
		0xe9,0x9e,0x20,0xeb,0x07,0xe8,0x95,0xcf,0xcd,0x81,0x4e,0x56,0x65,0x75,0x78,0x06,		// 7F10 - 7F1F
		0x09,0xae,0xa6,0x39,0x7e,0x67,0x73,0x2b,0xde,0xe3,0x68,0x51,0x9b,0x5e,0x20,0xec,		// 7F20 - 7F2F
		0xc1,0x44,0xa9,0xdf,0x7b,0xa1,0x2e,0xbd,0xd9,0xd8,0xd3,0x27,0xd0,0x99,0xe1,0x55,		// 7F30 - 7F3F
		0x83,0x0d,0x23,0xf2,0xc0,0x53,0x90,0x2d,0xce,0x30,0x29,0x0d,0x66,0x02,0x25,0x04,		// 7F40 - 7F4F
		0xff,0xf6,0x4c,0xc8,0x4f,0x7b,0xa1,0x5e,0x0e,0xf7,0x43,0x77,0xfd,0xb8,0x95,0x00,		// 7F50 - 7F5F
		0x27,0x2d,0x9d,0xf5,0x66,0x56,0xaa,0x76,0x2a,0x79,0x3a,0x1c,0x76,0x17,0x1a,0x8d,		// 7F60 - 7F6F
		0x2b,0x1e,0xcf,0x4e,0x89,0x60,0x35,0xd9,0xf3,0x44,0x66,0xf0,0xf2,0xbb,0xdd,0x30,		// 7F70 - 7F7F
		0x7d,0x76,0xdc,0xe9,0x78,0x57,0x0a,0x2d,0x7a,0x25,0x61,0x27,0xd3,0x83,0x47,0xae,		// 7F80 - 7F8F
		0xce,0x23,0xfb,0x1a,0x33,0x37,0x33,0x57,0x10,0x28,0x04,0x38,0xb9,0x8b,0x01,0x0d,		// 7F90 - 7F9F
		0x0e,0x51,0xa7,0x77,0xfc,0x3d,0xf9,0x7b,0x47,0x9c,0x67,0xd6,0x86,0x30,0xf4,0x90,		// 7FA0 - 7FAF
		0x6f,0x6d,0x98,0xd4,0x54,0xe8,0xe3,0xff,0xee,0x0c,0xe4,0xf7,0x5a,0x0e,0x49,0xbe,		// 7FB0 - 7FBF
		0x61,0x24,0xc7,0x47,0xfc,0xf2,0xbd,0x88,0x17,0x45,0x14,0xd0,0x96,0x04,0x69,0x5b,		// 7FC0 - 7FCF
		0x96,0x64,0x6e,0x24,0xf5,0x5a,0x8d,0xfa,0x14,0x56,0xcf,0xd6,0xdb,0x2e,0xfd,0x6c,		// 7FD0 - 7FDF
		0xfe,0x58,0x05,0x00,0x7f,0x5d,0x9e,0x7b,0x75,0x8a,0x2f,0xbe,0x0b,0xe9,0xed,0x36,		// 7FE0 - 7FEF
		0xcb,0x70,0x44,0xb0,0x1d,0x77,0x79,0x6f,0x0a,0x70,0x8d,0x7c,0x46,0xd2,0x64,0x3e 		// 7FF0 - 7FFF
};

RAND::RAND(int _seed)
{
	setseed(_seed);
}

void RAND::setseed(int _seed)
{
	seed = _seed;
	while(seed >= RAND_TABLE_MAX) {
		seed -= RAND_TABLE_MAX;
	}
}

int RAND::get(int n)
{
	unsigned int r = (unsigned int)rand_table[seed] << 8;
	seed ++;
	if(seed >= RAND_TABLE_MAX) {
		seed -= RAND_TABLE_MAX;
	}

	r += (unsigned int)rand_table[seed];
	seed ++;
	if(seed >= RAND_TABLE_MAX) {
		seed -= RAND_TABLE_MAX;
	}

	r = r * (unsigned int)n / 65536;

	return (int)r;
}

void RAND::dummyget(int n)
{
	seed += n * 2;
	if(seed >= RAND_TABLE_MAX) {
		seed -= RAND_TABLE_MAX;
	}
}
