
//
//	HSPVAR core module
//	onion software/onitama 2004/10
//

#ifndef HSP_COM_UNSUPPORTED		//iCOM T|[gȂł̃rh̓t@CŜ𖳎j

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ocidl.h>

#include "../hsp3code.h"
#include "../hsp3struct.h"
#include "../hsp3ext.h"
#include "../hspvar_core.h"
#include "comobj.h"
#include "hspvar_comobj.h"
#include "comobj_event.h"
#include "../strbuf.h"
#include "../supio.h"

/*------------------------------------------------------------*/
/*
		HSPVAR core interface (COM Object)
*/
/*------------------------------------------------------------*/

static HspVarProc *myproc;

// Core
static PDAT *HspVarComobj_GetPtr( PVal *pval )
{
	return (PDAT *)(( (IUnknown **)(pval->pt))+pval->offset);
}

static void *HspVarComobj_Cnv( const void *buffer, int flag )
{
	//		NGXgꂽ^ -> ̌^ւ̕ϊsȂ
	//		(gݍ݌^ɂ̂ݑΉOK)
	//		(Qƌ̃f[^j󂵂Ȃ)
	//
	throw HSPERR_INVALID_TYPE;
	return (void *)buffer;
}


static void *HspVarComobj_CnvCustom( const void *buffer, int flag )
{
	//		(JX^^Cv̂)
	//		̌^ -> NGXgꂽ^ ւ̕ϊsȂ
	//		(gݍ݌^ɑΉ)
	//		(Qƌ̃f[^j󂵂Ȃ)
	//
	throw HSPERR_INVALID_TYPE;
	return (void *)buffer;
}

static int GetVarElememtCount( PVal *pval )
{
	//		ϐ̗vf擾
	//
	int count;
	count = pval->len[1];
	if ( pval->len[2] ) count *= pval->len[2];
	if ( pval->len[3] ) count *= pval->len[3];
	if ( pval->len[4] ) count *= pval->len[4];
	return count;
}


static void HspVarComobj_Free( PVal *pval )
{
	//		PVAL|C^̕ϐ
	//
	IUnknown** ppunk;
	if ( pval->master ) {
		FreeDispParams( (ComDispParams *)pval->master );
	}
	if ( pval->mode == HSPVAR_MODE_MALLOC ) {
		// (ꎞϐɊ܂܂IuWFNg Release Ȃ)
		if ( (pval->support & HSPVAR_SUPPORT_TEMPVAR) == 0 ) {
#ifdef HSP_COMOBJ_DEBUG
			COM_DBG_MSG( "HspVarComobj_Free()\n" );
#endif
			int count = GetVarElememtCount( pval );
			ppunk = (IUnknown **)pval->pt;
			for (int i=0; i<count; i++) {
				ReleaseComPtr( &ppunk[i] );
			}
		}
		sbFree( pval->pt );
	}
	pval->pt   = NULL;
	pval->flag = HSPVAR_MODE_NONE;
}


static void HspVarComobj_Alloc( PVal *pval, const PVal *pval2 )
{
	//		pvalϐKvƂTCYmۂB
	//		(pvalłɊmۂĂ郁͌ĂяosȂ)
	//		(pval2NULL̏ꍇ́AVKf[^)
	//		(pval2w肳Ăꍇ́Apval2̓epčĊm)
	//
	int count,size;
	IUnknown **ppunk;
#ifdef HSP_COMOBJ_DEBUG
	COM_DBG_MSG( "HspVarComobj_Alloc()\n" );
#endif
	if ( pval->len[1] < 1 ) pval->len[1] = 1;		// zŒ 1 ͊mۂ
	count = GetVarElememtCount( pval );
	size  = count * sizeof( IUnknown* );
	ppunk = (IUnknown **)sbAlloc( size );
	pval->mode = HSPVAR_MODE_MALLOC;
	for (int i=0; i<count; i++) { ppunk[i] = NULL; }
	if ( pval2 != NULL ) {
		memcpy( ppunk, pval->pt, pval->size );
		sbFree( pval->pt );
		if ( pval->master ) sbFree( pval->master );
	}
	pval->master = NULL;		// ComDispParams p
	pval->pt = (char *)ppunk;
	pval->size = size;

}

static void HspVarComobj_ObjectMethod( PVal *pval )
{
	//		\bh̎s
	//
	VARIANT vres;
	HRESULT hr;
	char *ps;
	DISPID dispid;
	IUnknown** ppunk;
	BOOL bVariantRet;

//	ppunk = (IUnknown**)HspVarCorePtrAPTR( pval, pval->offset );
	ppunk = (IUnknown **)pval->pt;
	if ( ! IsVaridComPtr(ppunk) ) throw HSPERR_COMDLL_ERROR;

	// \bh DISPID 擾
	ps = code_gets();
	dispid = get_dispid( *ppunk, ps, &bVariantRet );
#ifdef HSP_COMOBJ_DEBUG
	COM_DBG_MSG( "ObjectMethod() : pObj=0x%p : PropName=\"%s\" (DISPID=%d)\n", *ppunk, ps, dispid);
#endif
	// \bhp[^̎擾E\bhs
	VariantInit( &vres );
	hr = CallDispMethod( *ppunk, dispid, &vres );
	comget_variantres( &vres, hr, bVariantRet );				// Ԓl擾
	VariantClear( &vres );
}

static int code_get_element( PVal *pval )
{
	// ϐ̔zvf̎擾
	//
	PVal pvalTemp;
	int chk, idx;
	HspVarCoreReset(pval);
	while (1) {
		HspVarCoreCopyArrayInfo( &pvalTemp, pval );			// Ԃۑ
		chk = code_get();
		HspVarCoreCopyArrayInfo( pval, &pvalTemp );			// Ԃ𕜋A
		if ( chk == PARAM_ENDSPLIT ) {
			if ( pval->arraycnt == 0 ) throw HSPERR_BAD_ARRAY_EXPRESSION;	// a() \L̓G[
			break;
		}
		if ( chk != PARAM_OK && chk != PARAM_SPLIT ) throw HSPERR_ARRAY_OVERFLOW;
		if ( mpval->flag != HSPVAR_FLAG_INT ) break;
		idx = *(int *)(mpval->pt);
		HspVarCoreArray( pval, idx );
	}
	return chk;
}

static void HspVarComobj_ArrayObject( PVal *pval )
{
	//		zvf̎w (Azzp)
	//
	IUnknown** ppunk;
	int chk;
	DISPID dispid;
	ComDispParams *paramdata;

	// zvf̎擾
	chk = code_get_element( pval );
	if ( chk == PARAM_ENDSPLIT ) return;	// zvfw肳ꂽꍇ͂̂܂

	// vpeBݒ莞
	ppunk = (IUnknown **)HspVarComobj_GetPtr( pval );
	if ( ! IsVaridComPtr(ppunk) ) throw HSPERR_COMDLL_ERROR;
	// vpeB DISPID 擾
	if ( mpval->flag != HSPVAR_FLAG_STR ) throw HSPERR_TYPE_MISMATCH;
	dispid = get_dispid( *ppunk, (char *)(mpval->pt), NULL );
#ifdef HSP_COMOBJ_DEBUG
	COM_DBG_MSG( "ArrayObject() : pObj=0x%p : PropName=\"%s\" (DISPID=%d)\n", *ppunk, mpval->pt, dispid);
#endif
	// p[^擾ێĂ
	paramdata = PrepForPutDispProp( *ppunk, dispid );
	if ( pval->master ) FreeDispParams( (ComDispParams *)pval->master );
	pval->master = paramdata;
}

static void HspVarComobj_ObjectWrite( PVal *pval, void *data, int vtype )
{
	//		ό^̑
	//
	ComDispParams *paramdata;
	HRESULT hr;
#ifdef HSP_COMOBJ_DEBUG
	COM_DBG_MSG( "ObjectWrite()\n" );
#endif
	// vpeBݒ莞
	paramdata = (ComDispParams *)pval->master;
	if ( paramdata == NULL ) throw ( HSPERR_COMDLL_ERROR );
	hr = PutDispProp( paramdata, data, vtype );
	FreeDispParams( paramdata );
	pval->master = NULL;

	if ( FAILED(hr) ) throw ( HSPERR_COMDLL_ERROR );
}


static void get_coclassname( IUnknown *punk, VARIANT *vres )
{
	HRESULT hr;
	IProvideClassInfo *pPCI;
	ITypeInfo *pTI;
	BSTR bstr = NULL;
	hr = punk->QueryInterface( IID_IProvideClassInfo, (void **)&pPCI );
	if ( SUCCEEDED(hr) && pPCI != NULL ) {
		hr = pPCI->GetClassInfo( &pTI );
		if ( SUCCEEDED(hr) && pTI != NULL ) {
			hr = pTI->GetDocumentation( MEMBERID_NIL, &bstr, NULL, NULL, NULL );
			pTI->Release();
		}
		pPCI->Release();
	}
	if ( bstr == NULL ) {
		bstr = SysAllocString( L"" );
	}
	vres->bstrVal = bstr;
	vres->vt = VT_BSTR;
}
static void get_interfacename( IUnknown *punk, VARIANT *vres )
{
	HRESULT hr;
	IDispatch *pDisp;
	ITypeInfo *pTI;
	BSTR bstr = NULL;
	hr = punk->QueryInterface( IID_IDispatch, (void **)&pDisp );
	if ( SUCCEEDED(hr) && pDisp != NULL ) {
		hr = pDisp->GetTypeInfo( 0, LOCALE_USER_DEFAULT, &pTI );
		if ( SUCCEEDED(hr) && pTI != NULL ) {
			hr = pTI->GetDocumentation( MEMBERID_NIL, &bstr, NULL, NULL, NULL );
			pTI->Release();
		}
		pDisp->Release();
	}
	if ( bstr == NULL ) {
		bstr = SysAllocString( L"" );
	}
	vres->bstrVal = bstr;
	vres->vt = VT_BSTR;
}

static void *HspVarComobj_ArrayObjectRead( PVal *pval, int *mptype )
{
	//		zvf̎w (Azz/ǂݏo)
	//
	void *ptr;
	IUnknown **ppunk;
	int chk;
	DISPID dispid;
	VARIANT vres;
	BOOL noconvret;
	char *propname;
	HRESULT hr = S_OK;

	// zvf̎擾
	chk = code_get_element( pval );
	ppunk = (IUnknown **)HspVarComobj_GetPtr( pval );
	if ( chk == PARAM_ENDSPLIT ) return ppunk;		// zvfw肳ꂽꍇ͂̂܂

	// vpeB擾
	// vpeB DISPID 擾
	if ( ! IsVaridComPtr(ppunk) ) throw ( HSPERR_COMDLL_ERROR );
	if ( mpval->flag != HSPVAR_FLAG_STR ) throw ( HSPERR_TYPE_MISMATCH );
	propname = (char *)(mpval->pt);
	VariantInit( &vres );
	if ( propname[0] == '$' ) {
		noconvret = FALSE;
		if ( stricmp( propname, "$coclass" ) == 0 ) {
			get_coclassname( *ppunk, &vres );
		} else if ( stricmp( propname, "$interface" ) == 0 ) {
			get_interfacename( *ppunk, &vres );
		} else {
			throw HSPERR_INVALID_PARAMETER;
		}
	} else {
		dispid = get_dispid( *ppunk, propname, &noconvret );
#ifdef HSP_COMOBJ_DEBUG
		COM_DBG_MSG( "ArrayObjectRead() : pObj=0x%p : PropName=\"%s\" (DISPID=%d)\n", *ppunk, mpval->pt, dispid);
#endif
	// p[^擾EvpeB擾
		hr = GetDispProp( *ppunk, dispid, &vres );
	}
	ptr = comget_variant( &vres, mptype, noconvret );
	VariantClear( &vres );
	if ( FAILED(hr) ) throw ( HSPERR_COMDLL_ERROR );
	return ptr;
}


// Size
static int HspVarComobj_GetSize( const PDAT *pdatl )
{
	//		(Ԃ̃|C^n܂)
	return sizeof(IUnknown*);
}

// Using
static int HspVarComobj_GetUsing( const PDAT *pdat )
{
	//		(Ԃ̃|C^n܂)
	return IsVaridComPtr((IUnknown**)pdat);
}

// Set
static void HspVarComobj_Set( PVal *pval, PDAT *pdat, const void *in )
{
	IUnknown **ppunkSrc, **ppunkDst;

	ppunkDst = (IUnknown **)pdat;
	ppunkSrc = (IUnknown **)in;
	if ( pval->support & HSPVAR_SUPPORT_TEMPVAR ) {
		// 悪ꎞϐ̏ꍇ AddRef() Ȃ
		*ppunkDst = *ppunkSrc;
#ifdef HSP_COMOBJ_DEBUG
		COM_DBG_MSG( "ppunkDst is Temporary objedct.\n");
#endif
	} else {
		CopyComPtr( ppunkDst, *ppunkSrc );
	}
}


static void *GetBlockSize( PVal *pval, PDAT *pdat, int *size )
{
	*size = pval->size - ( ((char *)pdat) - pval->pt );
	return (pdat);
}

static void AllocBlock( PVal *pval, PDAT *pdat, int size )
{
}

// Eq
static void HspVarComobj_EqI( PDAT *pdat, const void *val )
{
	*(int *)pdat = IsSameComObject( (IUnknown **)pdat, (IUnknown **)val );
	myproc->aftertype = HSPVAR_FLAG_INT;
}

// Ne
static void HspVarComobj_NeI( PDAT *pdat, const void *val )
{
	*(int *)pdat = !IsSameComObject( (IUnknown **)pdat, (IUnknown **)val );
	myproc->aftertype = HSPVAR_FLAG_INT;
}


/*------------------------------------------------------------*/

void HspVarComobj_Init( HspVarProc *p )
{
	myproc = p;

	p->Set = HspVarComobj_Set;
	p->Cnv = HspVarComobj_Cnv;
	p->GetPtr = HspVarComobj_GetPtr;
	p->CnvCustom = HspVarComobj_CnvCustom;
	p->GetSize = HspVarComobj_GetSize;
	p->GetUsing = HspVarComobj_GetUsing;
	p->GetBlockSize = GetBlockSize;
	p->AllocBlock = AllocBlock;

	p->ArrayObject = HspVarComobj_ArrayObject;
	p->ArrayObjectRead = HspVarComobj_ArrayObjectRead;
	p->ObjectWrite = HspVarComobj_ObjectWrite;
	p->ObjectMethod = HspVarComobj_ObjectMethod;

	p->Alloc = HspVarComobj_Alloc;
	p->Free = HspVarComobj_Free;
	p->EqI = HspVarComobj_EqI;
	p->NeI = HspVarComobj_NeI;

/*
	p->AddI = HspVarComobj_Invalid;
	p->SubI = HspVarComobj_Invalid;
	p->MulI = HspVarComobj_Invalid;
	p->DivI = HspVarComobj_Invalid;
	p->ModI = HspVarComobj_Invalid;

	p->AndI = HspVarComobj_Invalid;
	p->OrI  = HspVarComobj_Invalid;
	p->XorI = HspVarComobj_Invalid;

	p->EqI = HspVarComobj_Invalid;
	p->NeI = HspVarComobj_Invalid;
	p->GtI = HspVarComobj_Invalid;
	p->LtI = HspVarComobj_Invalid;
	p->GtEqI = HspVarComobj_Invalid;
	p->LtEqI = HspVarComobj_Invalid;

	p->RrI = HspVarComobj_Invalid;
	p->LrI = HspVarComobj_Invalid;
*/
	p->vartype_name = "comobj";				// ^Cv
	p->version = 0x001;					// ^^Cv^Co[W(0x100 = 1.0)
	p->support = HSPVAR_SUPPORT_STORAGE | HSPVAR_SUPPORT_ARRAYOBJ | HSPVAR_SUPPORT_NOCONVERT | HSPVAR_SUPPORT_VARUSE;
										// T|[g󋵃tO(HSPVAR_SUPPORT_*)
	p->basesize = sizeof(void*);	// P̃f[^gpTCY(byte) / ϒ̎-1
}

/*------------------------------------------------------------*/





#endif	// !defined( HSP_COM_UNSUPPORTED )

