
//
//	HSP3 debug support
//	(G[уfobOx)
//	onion software/onitama 2004/6
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hsp3config.h"
#include "hsp3.h"
#include "hsp3debug.h"

/*------------------------------------------------------------*/
/*
		system data
*/
/*------------------------------------------------------------*/


/*------------------------------------------------------------*/
/*
		interface
*/
/*------------------------------------------------------------*/

#ifdef HSPDEBUG
#ifdef JPNMSG
static char *err[]={
	"",												// 0
	"VXeG[܂",					// 1
	"@ԈĂ܂",							// 2
	"p[^̒lُł",						// 3
	"vZŃG[܂",					// 4
	"p[^̏ȗ͂ł܂",					// 5
	"p[^̌^Ⴂ܂",						// 6
	"z̗vfł",							// 7
	"Lȃxw肳Ă܂",				// 8
	"Tu[`⃋[ṽlXg[܂",		// 9
	"Tu[`Oreturn͖ł",				// 10
	"repeatOłloop͖ł",					// 11
	"t@CȂȖOł",		// 12
	"摜t@C܂",						// 13
	"Ot@CĂяõG[ł",			// 14
	"vZŃJbR̋LqႢ܂",				// 15
	"p[^̐܂",					// 16
	"񎮂ň镶z܂",			// 17
	"łȂϐw肵Ă܂",			// 18
	"0ŏZ܂",								// 19
	"obt@I[o[t[܂",			// 20
	"T|[gȂ@\I܂",			// 21
	"vZ̃JbR[܂",					// 22
	"ϐw肳Ă܂",					// 23
	"ȊOw肳Ă܂",					// 24
	"z̗vfԈĂ܂",				// 25
	"̊mۂł܂ł",				// 26
	"^Cv̏Ɏs܂",					// 27
	"֐Ɉݒ肳Ă܂",				// 28
	"X^bN̈̃I[o[t[ł",				// 29
	"ȖOp[^[Ɏw肳Ă܂",	// 30
	"قȂ^zϐɑ܂",			// 31
	"֐̃p[^[Lqsł",				// 32
	"IuWFNg܂",					// 33
	"zE֐ƂĎgpłȂ^ł",			// 34
	"W[ϐw肳Ă܂",			// 35
	"W[ϐ̎w肪ł",				// 36
	"ϐ^̕ϊɎs܂",					// 37
	"ODLĽĂяoɎs܂",				// 38
	"OIuWFNǧĂяoɎs܂",		// 39
	"֐̖߂lݒ肳Ă܂B",			// 40
	"֐𖽗߂ƂċLqĂ܂B\n(HSP2֐ꂽOgpĂ\܂)",			// 41
	"*"
};
#else
static char *err[]={
	"",									// 0
	"Unknown system error",				// 1
	"Syntax error",						// 2
	"Illegal function call",			// 3
	"Wrong expression",					// 4
	"Default parameter not allowed",	// 5
	"Type mismatch",					// 6
	"Array overflow",					// 7
	"Not a label object",				// 8
	"Too many nesting",					// 9
	"Return without gosub",				// 10
	"Loop without repeat",				// 11
	"File I/O error",					// 12
	"Picture file missing",				// 13
	"External execute error",			// 14
	"Priority error",					// 15
	"Too many parameters",				// 16
	"Temporary buffer overflow",		// 17
	"Wrong valiable name",				// 18
	"Divided by zero",					// 19
	"Buffer Overflow",					// 20
	"Unsupported function",				// 21
	"Expression too complex",			// 22
	"Variable required",				// 23
	"Integer value required",			// 24
	"Bad array expression",				// 25
	"Out of memory",					// 26
	"Type initalization failed",		// 27
	"No Function parameters",			// 28
	"Stack overflow",					// 29
	"Invalid parameter name",			// 30
	"Invalid type of array",			// 31
	"Invalid function parameter",		// 32
	"Too many window objects",			// 33
	"Invalid Array/Function",			// 34
	"Structure required",				// 35
	"Illegal structure call",			// 36
	"Invalid type of variable",			// 37
	"DLL call failed",					// 38
	"External COM call failed",			// 39
	"No function result",				// 40
	"Invalid syntax for function",		// 41
	"*"
};
#endif

char *hspd_geterror( HSPERROR error )
{
	if ((error<0)||(error>=HSPERR_MAX)) return err[0];
	return err[error];
}

#else

static char errmsg[256];

char *hspd_geterror( HSPERROR error )
{
#ifdef JPNMSG
	sprintf( errmsg, "G[܂(%d)", (int)error );
#else
	sprintf( errmsg, "Internal Error(%d)", (int)error );
#endif
	return errmsg;
}

#endif



