/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;

public final class AdSize {
    public static final int FULL_WIDTH = -1;
    public static final int AUTO_HEIGHT = -2;
    public static final AdSize BANNER = new AdSize(320, 50, "320x50_mb");
    public static final AdSize FULL_BANNER = new AdSize(468, 60, "468x60_as");
    public static final AdSize LARGE_BANNER = new AdSize(320, 100, "320x100_as");
    public static final AdSize LEADERBOARD = new AdSize(728, 90, "728x90_as");
    public static final AdSize MEDIUM_RECTANGLE = new AdSize(300, 250, "300x250_as");
    public static final AdSize WIDE_SKYSCRAPER = new AdSize(160, 600, "160x600_as");
    public static final AdSize SMART_BANNER = new AdSize(-1, -2, "smart_banner");
    public static final AdSize FLUID = new AdSize(-3, -4, "fluid");
    public static final AdSize SEARCH = new AdSize(-3, 0, "search_v2");
    private final int zzrG;
    private final int zzrH;
    private final String zzrI;

    public AdSize(int n, int n2) {
        String string = n == -1 ? "FULL" : String.valueOf(n);
        String string2 = n2 == -2 ? "AUTO" : String.valueOf(n2);
        String string3 = String.valueOf("_as");
        this(n, n2, new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("x").append(string2).append(string3).toString());
    }

    AdSize(int n, int n2, String string) {
        if (n < 0 && n != -1 && n != -3) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Invalid width for AdSize: ").append(n).toString());
        }
        if (n2 < 0 && n2 != -2 && n2 != -4) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Invalid height for AdSize: ").append(n2).toString());
        }
        this.zzrG = n;
        this.zzrH = n2;
        this.zzrI = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdSize)) {
            return false;
        }
        AdSize adSize = (AdSize)object;
        return this.zzrG == adSize.zzrG && this.zzrH == adSize.zzrH && this.zzrI.equals(adSize.zzrI);
    }

    public int getHeight() {
        return this.zzrH;
    }

    public int getHeightInPixels(Context context) {
        switch (this.zzrH) {
            case -2: {
                return zzec.zzb(context.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: {
                return -1;
            }
        }
        return zzeh.zzeO().zzb(context, this.zzrH);
    }

    public int getWidth() {
        return this.zzrG;
    }

    public int getWidthInPixels(Context context) {
        switch (this.zzrG) {
            case -1: {
                return zzec.zza(context.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: {
                return -1;
            }
        }
        return zzeh.zzeO().zzb(context, this.zzrG);
    }

    public int hashCode() {
        return this.zzrI.hashCode();
    }

    public boolean isAutoHeight() {
        return this.zzrH == -2;
    }

    public boolean isFullWidth() {
        return this.zzrG == -1;
    }

    public boolean isFluid() {
        return this.zzrG == -3 && this.zzrH == -4;
    }

    public String toString() {
        return this.zzrI;
    }
}

