/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zznf;
import com.google.android.gms.internal.zzpe;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;

@zzmb
public class zzis {
    private final Map<zzit, zziu> zzIz = new HashMap<zzit, zziu>();
    private final LinkedList<zzit> zzIA = new LinkedList();
    @Nullable
    private zzip zzIB;

    void zza(zzip zzip2) {
        if (this.zzIB == null) {
            this.zzIB = zzip2.zzgi();
            this.restore();
        }
    }

    @Nullable
    zziu.zza zza(zzdy zzdy2, String string2) {
        Object object;
        if (this.zzaj(string2)) {
            return null;
        }
        Context context = this.zzIB.getApplicationContext();
        zznf zznf2 = new zznf.zza(context).zzjn();
        int n = zznf2.zzUm;
        zzdy zzdy3 = zzis.zzn(zzdy2);
        zzit zzit2 = new zzit(zzdy3, string2, n);
        zziu zziu2 = this.zzIz.get(zzit2);
        if (zziu2 == null) {
            zzis.zza("Interstitial pool created at %s.", zzit2);
            zziu2 = new zziu(zzdy3, string2, n);
            this.zzIz.put(zzit2, zziu2);
        }
        this.zzIA.remove(zzit2);
        this.zzIA.add(zzit2);
        zziu2.zzgo();
        while (this.zzIA.size() > zzfx.zzCE.get()) {
            object = this.zzIA.remove();
            zziu zziu3 = this.zzIz.get(object);
            zzis.zza("Evicting interstitial queue for %s.", (zzit)object);
            while (zziu3.size() > 0) {
                zziu.zza zza2 = zziu3.zzp(null);
                zza2.zzIG.zzck();
            }
            this.zzIz.remove(object);
        }
        while (zziu2.size() > 0) {
            long l;
            object = zziu2.zzp(zzdy3);
            if (((zziu.zza)object).zzIK && (l = zzv.zzcP().currentTimeMillis() - ((zziu.zza)object).zzIJ) > 1000L * (long)zzfx.zzCG.get().intValue()) {
                zzis.zza("Expired interstitial at %s.", zzit2);
                continue;
            }
            String string3 = ((zziu.zza)object).zzIH != null ? " (inline) " : " ";
            zzis.zza(new StringBuilder(34 + String.valueOf(string3).length()).append("Pooled interstitial").append(string3).append("returned at %s.").toString(), zzit2);
            return object;
        }
        return null;
    }

    void zzb(zzdy zzdy2, String string2) {
        if (this.zzIB == null) {
            return;
        }
        Context context = this.zzIB.getApplicationContext();
        zznf zznf2 = new zznf.zza(context).zzjn();
        int n = zznf2.zzUm;
        zzdy zzdy3 = zzis.zzn(zzdy2);
        zzit zzit2 = new zzit(zzdy3, string2, n);
        zziu zziu2 = this.zzIz.get(zzit2);
        if (zziu2 == null) {
            zzis.zza("Interstitial pool created at %s.", zzit2);
            zziu2 = new zziu(zzdy3, string2, n);
            this.zzIz.put(zzit2, zziu2);
        }
        zziu2.zza(this.zzIB, zzdy2);
        zziu2.zzgo();
        zzis.zza("Inline entry added to the queue at %s.", zzit2);
    }

    void zzgj() {
        if (this.zzIB == null) {
            return;
        }
        for (Map.Entry<zzit, zziu> entry : this.zzIz.entrySet()) {
            zzit zzit2 = entry.getKey();
            zziu zziu2 = entry.getValue();
            if (zzpe.zzai((int)2)) {
                int n = zziu2.size();
                int n2 = zziu2.zzgm();
                if (n2 < n) {
                    zzpe.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzit2));
                }
            }
            zziu2.zzgn();
            while (zziu2.size() < zzfx.zzCF.get()) {
                zzis.zza("Pooling and loading one new interstitial for %s.", zzit2);
                zziu2.zzb(this.zzIB);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzIB == null) {
            return;
        }
        Context context = this.zzIB.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzit, zziu> entry : this.zzIz.entrySet()) {
            zzit zzit2 = entry.getKey();
            zziu zziu2 = entry.getValue();
            if (!zziu2.zzgp()) continue;
            zziw zziw2 = new zziw(zziu2);
            String string2 = zziw2.zzgs();
            String string3 = zzit2.toString();
            editor.putString(string3, string2);
            zzis.zza("Saved interstitial queue for %s.", zzit2);
        }
        editor.putString("PoolKeys", this.zzgk());
        editor.apply();
    }

    void restore() {
        if (this.zzIB == null) {
            return;
        }
        Context context = this.zzIB.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        try {
            zzit zzit2;
            HashMap<String, zzit> hashMap = new HashMap<String, zzit>();
            String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
            while (stringArray.hasNext()) {
                String[] stringArray2 = stringArray.next();
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zziw object = zziw.zzak(string3);
                zzit2 = new zzit(object.zzug, object.zztq, object.zzIE);
                if (this.zzIz.containsKey(zzit2)) continue;
                zziu zziu2 = new zziu(object.zzug, object.zztq, object.zzIE);
                this.zzIz.put(zzit2, zziu2);
                hashMap.put(zzit2.toString(), zzit2);
                zzis.zza("Restored interstitial queue for %s.", zzit2);
            }
            for (String string2 : stringArray = this.zzai(sharedPreferences.getString("PoolKeys", ""))) {
                zzit2 = (zzit)hashMap.get(string2);
                if (!this.zzIz.containsKey(zzit2)) continue;
                this.zzIA.add(zzit2);
            }
        }
        catch (Throwable throwable) {
            zzv.zzcN().zza(throwable, "InterstitialAdPool.restore");
            zzpe.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)throwable);
            this.zzIz.clear();
            this.zzIA.clear();
        }
    }

    void flush() {
        while (this.zzIA.size() > 0) {
            zzit zzit2 = this.zzIA.remove();
            zziu zziu2 = this.zzIz.get(zzit2);
            zzis.zza("Flushing interstitial queue for %s.", zzit2);
            while (zziu2.size() > 0) {
                zziu.zza zza2 = zziu2.zzp(null);
                zza2.zzIG.zzck();
            }
            this.zzIz.remove(zzit2);
        }
    }

    private String zzgk() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzIA.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzit)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzai(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private boolean zzaj(String string2) {
        try {
            return Pattern.matches(zzfx.zzCH.get(), string2);
        }
        catch (RuntimeException runtimeException) {
            zzv.zzcN().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    @Nullable
    static Bundle zzk(zzdy zzdy2) {
        Bundle bundle = zzdy2.zzyP;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
    }

    static zzdy zzl(zzdy zzdy2) {
        zzdy zzdy3 = zzis.zzo(zzdy2);
        Bundle bundle = zzis.zzk(zzdy3);
        if (bundle == null) {
            bundle = new Bundle();
            zzdy3.zzyP.putBundle("com.google.ads.mediation.admob.AdMobAdapter", bundle);
        }
        bundle.putBoolean("_skipMediation", true);
        return zzdy3;
    }

    static boolean zzm(zzdy zzdy2) {
        Bundle bundle = zzdy2.zzyP;
        if (bundle == null) {
            return false;
        }
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        return bundle2 != null && bundle2.containsKey("_skipMediation");
    }

    private static zzdy zzn(zzdy zzdy2) {
        String[] stringArray;
        zzdy zzdy3 = zzis.zzo(zzdy2);
        String string2 = zzfx.zzCD.get();
        for (String string3 : stringArray = string2.split(",")) {
            zzis.zzc(zzdy3.zzyP, string3);
        }
        return zzdy3;
    }

    static zzdy zzo(zzdy zzdy2) {
        Parcel parcel = Parcel.obtain();
        zzdy2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzdy zzdy3 = (zzdy)zzdy.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzdy.zzj((zzdy)zzdy3);
        return zzdy3;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray = string2.split("/", 2);
        if (stringArray.length == 0) {
            return;
        }
        String string3 = stringArray[0];
        if (stringArray.length == 1) {
            bundle.remove(string3);
            return;
        }
        Bundle bundle2 = bundle.getBundle(string3);
        if (bundle2 == null) {
            return;
        }
        zzis.zzc(bundle2, stringArray[1]);
    }

    private static void zza(String string2, zzit zzit2) {
        if (zzpe.zzai((int)2)) {
            zzpe.v(String.format(string2, zzit2));
        }
    }
}

