/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzmb
@TargetApi(value=14)
public class zzy
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzx.zza {
    private static final float[] zzNO = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzx zzNP;
    private final float[] zzNL;
    private final float[] zzNQ;
    private final float[] zzNR;
    private final float[] zzNS;
    private final float[] zzNT;
    private final float[] zzNU;
    private final float[] zzNV;
    private float zzNW;
    private float zzNX;
    private float zzNY;
    private int zzrH;
    private int zzrG;
    private SurfaceTexture zzNZ;
    private SurfaceTexture zzOa;
    private int zzOb;
    private int zzOc;
    private int zzOd;
    private FloatBuffer zzOe = ByteBuffer.allocateDirect(zzNO.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzOf;
    private final Object zzOg;
    private EGL10 zzOh;
    private EGLDisplay zzOi;
    private EGLContext zzOj;
    private EGLSurface zzOk;
    private volatile boolean zzOl;
    private volatile boolean zzOm;

    public zzy(Context context) {
        super("SphericalVideoProcessor");
        this.zzOe.put(zzNO).position(0);
        this.zzNL = new float[9];
        this.zzNQ = new float[9];
        this.zzNR = new float[9];
        this.zzNS = new float[9];
        this.zzNT = new float[9];
        this.zzNU = new float[9];
        this.zzNV = new float[9];
        this.zzNW = Float.NaN;
        this.zzNP = new zzx(context);
        this.zzNP.zza(this);
        this.zzOf = new CountDownLatch(1);
        this.zzOg = new Object();
    }

    public void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzrG = n;
        this.zzrH = n2;
        this.zzOa = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzi(int n, int n2) {
        Object object = this.zzOg;
        synchronized (object) {
            this.zzrG = n;
            this.zzrH = n2;
            this.zzOl = true;
            this.zzOg.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzhP() {
        Object object = this.zzOg;
        synchronized (object) {
            this.zzOm = true;
            this.zzOa = null;
            this.zzOg.notifyAll();
        }
    }

    public SurfaceTexture zzhQ() {
        if (this.zzOa == null) {
            return null;
        }
        try {
            this.zzOf.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzNZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzOd;
        Object object = this.zzOg;
        synchronized (object) {
            this.zzOg.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzho() {
        Object object = this.zzOg;
        synchronized (object) {
            this.zzOg.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        if (this.zzOa == null) {
            zzpe.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzOf.countDown();
            return;
        }
        boolean bl2 = this.zzhV();
        int n = this.zzhT();
        boolean bl3 = bl = this.zzOb != 0;
        if (!bl2 || !bl) {
            String string2 = GLUtils.getEGLErrorString((int)this.zzOh.eglGetError());
            String string3 = String.valueOf(string2);
            String string4 = string3.length() != 0 ? "EGL initialization failed: ".concat(string3) : new String("EGL initialization failed: ");
            zzpe.e((String)string4);
            zzv.zzcN().zza(new Throwable(string4), "SphericalVideoProcessor.run.1");
            this.zzhZ();
            this.zzOf.countDown();
            return;
        }
        this.zzNZ = new SurfaceTexture(n);
        this.zzNZ.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzOf.countDown();
        this.zzNP.start();
        try {
            this.zzOl = true;
            while (!this.zzOm) {
                this.zzhR();
                if (this.zzOl) {
                    this.zzhS();
                    this.zzOl = false;
                }
                try {
                    Object object = this.zzOg;
                    synchronized (object) {
                        if (!this.zzOm && !this.zzOl && this.zzOd == 0) {
                            this.zzOg.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            zzpe.zzbe((String)"SphericalVideoProcessor halted unexpectedly.");
        }
        catch (Throwable throwable) {
            zzpe.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzv.zzcN().zza(throwable, "SphericalVideoProcessor.run.2");
        }
        finally {
            this.zzNP.stop();
            this.zzNZ.setOnFrameAvailableListener(null);
            this.zzNZ = null;
            this.zzhZ();
        }
    }

    void zzhR() {
        while (this.zzOd > 0) {
            this.zzNZ.updateTexImage();
            --this.zzOd;
        }
        if (this.zzNP.zzb(this.zzNL)) {
            if (Float.isNaN(this.zzNW)) {
                this.zzNW = -this.zzc(this.zzNL);
            }
            this.zzb(this.zzNU, this.zzNW + this.zzNX);
        } else {
            this.zza(this.zzNL, -1.5707964f);
            this.zzb(this.zzNU, this.zzNX);
        }
        this.zza(this.zzNQ, 1.5707964f);
        this.zza(this.zzNR, this.zzNU, this.zzNQ);
        this.zza(this.zzNS, this.zzNL, this.zzNR);
        this.zza(this.zzNT, this.zzNY);
        this.zza(this.zzNV, this.zzNT, this.zzNS);
        GLES20.glUniformMatrix3fv((int)this.zzOc, (int)1, (boolean)false, (float[])this.zzNV, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.zzaC("drawArrays");
        GLES20.glFinish();
        this.zzOh.eglSwapBuffers(this.zzOi, this.zzOk);
    }

    private float zzc(float[] fArray) {
        float[] fArray2 = this.zza(fArray, new float[]{0.0f, 1.0f, 0.0f});
        return (float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f;
    }

    public void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzrG > this.zzrH) {
            f4 = 1.7453293f * f / (float)this.zzrG;
            f3 = 1.7453293f * f2 / (float)this.zzrG;
        } else {
            f4 = 1.7453293f * f / (float)this.zzrH;
            f3 = 1.7453293f * f2 / (float)this.zzrH;
        }
        this.zzNX -= f4;
        this.zzNY -= f3;
        if (this.zzNY < -1.5707964f) {
            this.zzNY = -1.5707964f;
        }
        if (this.zzNY > 1.5707964f) {
            this.zzNY = 1.5707964f;
        }
    }

    private void zzhS() {
        GLES20.glViewport((int)0, (int)0, (int)this.zzrG, (int)this.zzrH);
        this.zzaC("viewport");
        int n = GLES20.glGetUniformLocation((int)this.zzOb, (String)"uFOVx");
        int n2 = GLES20.glGetUniformLocation((int)this.zzOb, (String)"uFOVy");
        if (this.zzrG > this.zzrH) {
            GLES20.glUniform1f((int)n, (float)0.87266463f);
            GLES20.glUniform1f((int)n2, (float)(0.87266463f * (float)this.zzrH / (float)this.zzrG));
        } else {
            GLES20.glUniform1f((int)n, (float)(0.87266463f * (float)this.zzrG / (float)this.zzrH));
            GLES20.glUniform1f((int)n2, (float)0.87266463f);
        }
    }

    private float[] zza(float[] fArray, float[] fArray2) {
        return new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2], fArray[3] * fArray2[0] + fArray[4] * fArray2[1] + fArray[5] * fArray2[2], fArray[6] * fArray2[0] + fArray[7] * fArray2[1] + fArray[8] * fArray2[2]};
    }

    private void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    int zzhT() {
        this.zzOb = this.zzhU();
        GLES20.glUseProgram((int)this.zzOb);
        this.zzaC("useProgram");
        int n = GLES20.glGetAttribLocation((int)this.zzOb, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.zzOe);
        this.zzaC("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n);
        this.zzaC("enableVertexAttribArray");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.zzaC("genTextures");
        int n2 = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n2);
        this.zzaC("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        this.zzaC("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        this.zzaC("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        this.zzaC("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.zzaC("texParameteri");
        this.zzOc = GLES20.glGetUniformLocation((int)this.zzOb, (String)"uVMat");
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)this.zzOc, (int)1, (boolean)false, (float[])fArray, (int)0);
        return n2;
    }

    private int zzhU() {
        int n = this.zzc(35633, this.zzhX());
        if (n == 0) {
            return 0;
        }
        int n2 = this.zzc(35632, this.zzhY());
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        this.zzaC("createProgram");
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            this.zzaC("attachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            this.zzaC("attachShader");
            GLES20.glLinkProgram((int)n3);
            this.zzaC("linkProgram");
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            this.zzaC("getProgramiv");
            if (nArray[0] != 1) {
                Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                this.zzaC("deleteProgram");
                n3 = 0;
            } else {
                GLES20.glValidateProgram((int)n3);
                this.zzaC("validateProgram");
            }
        }
        return n3;
    }

    private int zzc(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        this.zzaC("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            this.zzaC("shaderSource");
            GLES20.glCompileShader((int)n2);
            this.zzaC("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            this.zzaC("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                this.zzaC("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    boolean zzhV() {
        this.zzOh = (EGL10)EGLContext.getEGL();
        this.zzOi = this.zzOh.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.zzOi == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        int[] nArray = new int[2];
        if (!this.zzOh.eglInitialize(this.zzOi, nArray)) {
            return false;
        }
        EGLConfig eGLConfig = this.zzhW();
        if (eGLConfig == null) {
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        this.zzOj = this.zzOh.eglCreateContext(this.zzOi, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray2);
        if (this.zzOj == null || this.zzOj == EGL10.EGL_NO_CONTEXT) {
            return false;
        }
        this.zzOk = this.zzOh.eglCreateWindowSurface(this.zzOi, eGLConfig, (Object)this.zzOa, null);
        if (this.zzOk == null || this.zzOk == EGL10.EGL_NO_SURFACE) {
            return false;
        }
        return this.zzOh.eglMakeCurrent(this.zzOi, this.zzOk, this.zzOk, this.zzOj);
    }

    @Nullable
    private EGLConfig zzhW() {
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
        if (!this.zzOh.eglChooseConfig(this.zzOi, nArray2, eGLConfigArray, 1, nArray)) {
            return null;
        }
        if (nArray[0] > 0) {
            return eGLConfigArray[0];
        }
        return null;
    }

    private String zzhX() {
        zzft<String> zzft2 = zzfx.zzCI;
        if (!zzft2.get().equals(zzft2.zzfm())) {
            return zzft2.get();
        }
        return "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
    }

    private String zzhY() {
        zzft<String> zzft2 = zzfx.zzCJ;
        if (!zzft2.get().equals(zzft2.zzfm())) {
            return zzft2.get();
        }
        return "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
    }

    boolean zzhZ() {
        boolean bl = false;
        if (this.zzOk != null && this.zzOk != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzOh.eglMakeCurrent(this.zzOi, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            bl |= this.zzOh.eglDestroySurface(this.zzOi, this.zzOk);
            this.zzOk = null;
        }
        if (this.zzOj != null) {
            bl |= this.zzOh.eglDestroyContext(this.zzOi, this.zzOj);
            this.zzOj = null;
        }
        if (this.zzOi != null) {
            bl |= this.zzOh.eglTerminate(this.zzOi);
            this.zzOi = null;
        }
        return bl;
    }

    private void zzaC(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

