/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.app.Activity;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzb;
import com.google.android.gms.tasks.zzc;
import com.google.android.gms.tasks.zzd;
import com.google.android.gms.tasks.zze;
import com.google.android.gms.tasks.zzf;
import com.google.android.gms.tasks.zzg;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

final class zzh<TResult>
extends Task<TResult> {
    private final Object zzrN = new Object();
    private final zzg<TResult> zzbLH = new zzg();
    private boolean zzbLI;
    private TResult zzbLJ;
    private Exception zzbLK;

    zzh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzbLI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuccessful() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzbLI && this.zzbLK == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult getResult() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzSe();
            if (this.zzbLK != null) {
                throw new RuntimeExecutionException(this.zzbLK);
            }
            return this.zzbLJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzSe();
            if (clazz.isInstance(this.zzbLK)) {
                throw (Throwable)clazz.cast(this.zzbLK);
            }
            if (this.zzbLK != null) {
                throw new RuntimeExecutionException(this.zzbLK);
            }
            return this.zzbLJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Exception getException() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzbLK;
        }
    }

    @Override
    @NonNull
    public Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        return this.addOnSuccessListener(TaskExecutors.MAIN_THREAD, onSuccessListener);
    }

    @Override
    @NonNull
    public Task<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        this.zzbLH.zza(new zze<TResult>(executor, onSuccessListener));
        this.zzSg();
        return this;
    }

    @Override
    @NonNull
    public Task<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zze<? super TResult> zze2 = new zze<TResult>(TaskExecutors.MAIN_THREAD, onSuccessListener);
        this.zzbLH.zza(zze2);
        zza.zzw(activity).zzb(zze2);
        this.zzSg();
        return this;
    }

    @Override
    @NonNull
    public Task<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        return this.addOnFailureListener(TaskExecutors.MAIN_THREAD, onFailureListener);
    }

    @Override
    @NonNull
    public Task<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        this.zzbLH.zza(new zzd(executor, onFailureListener));
        this.zzSg();
        return this;
    }

    @Override
    @NonNull
    public Task<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzd zzd2 = new zzd(TaskExecutors.MAIN_THREAD, onFailureListener);
        this.zzbLH.zza(zzd2);
        zza.zzw(activity).zzb(zzd2);
        this.zzSg();
        return this;
    }

    @Override
    @NonNull
    public Task<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        return this.addOnCompleteListener(TaskExecutors.MAIN_THREAD, onCompleteListener);
    }

    @Override
    @NonNull
    public Task<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        this.zzbLH.zza(new zzc<TResult>(executor, onCompleteListener));
        this.zzSg();
        return this;
    }

    @Override
    @NonNull
    public Task<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzc<TResult> zzc2 = new zzc<TResult>(TaskExecutors.MAIN_THREAD, onCompleteListener);
        this.zzbLH.zza(zzc2);
        zza.zzw(activity).zzb(zzc2);
        this.zzSg();
        return this;
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWith(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        zzh<TResult> zzh2 = new zzh<TResult>();
        this.zzbLH.zza(new com.google.android.gms.tasks.zza<TResult, TContinuationResult>(executor, continuation, zzh2));
        this.zzSg();
        return zzh2;
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTask(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        zzh<TResult> zzh2 = new zzh<TResult>();
        this.zzbLH.zza(new zzb<TResult, TContinuationResult>(executor, continuation, zzh2));
        this.zzSg();
        return zzh2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(TResult TResult) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzSf();
            this.zzbLI = true;
            this.zzbLJ = TResult;
        }
        this.zzbLH.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trySetResult(TResult TResult) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzbLI) {
                return false;
            }
            this.zzbLI = true;
            this.zzbLJ = TResult;
        }
        this.zzbLH.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(@NonNull Exception exception) {
        zzac.zzb((Object)exception, (Object)"Exception must not be null");
        Object object = this.zzrN;
        synchronized (object) {
            this.zzSf();
            this.zzbLI = true;
            this.zzbLK = exception;
        }
        this.zzbLH.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trySetException(@NonNull Exception exception) {
        zzac.zzb((Object)exception, (Object)"Exception must not be null");
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzbLI) {
                return false;
            }
            this.zzbLI = true;
            this.zzbLK = exception;
        }
        this.zzbLH.zza(this);
        return true;
    }

    private void zzSe() {
        zzac.zza((boolean)this.zzbLI, (Object)"Task is not yet complete");
    }

    private void zzSf() {
        zzac.zza((!this.zzbLI ? 1 : 0) != 0, (Object)"Task is already complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzSg() {
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.zzbLI) {
                return;
            }
        }
        this.zzbLH.zza(this);
    }

    private static class zza
    extends zzaaw {
        private final List<WeakReference<zzf<?>>> mListeners = new ArrayList();

        public static zza zzw(Activity activity) {
            zzaax zzaax2 = zza.zzs((Activity)activity);
            zza zza2 = (zza)zzaax2.zza("TaskOnStopCallback", zza.class);
            if (zza2 == null) {
                zza2 = new zza(zzaax2);
            }
            return zza2;
        }

        private zza(zzaax zzaax2) {
            super(zzaax2);
            this.zzaBs.zza("TaskOnStopCallback", (zzaaw)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> void zzb(zzf<T> zzf2) {
            List<WeakReference<zzf<?>>> list = this.mListeners;
            synchronized (list) {
                this.mListeners.add(new WeakReference<zzf<T>>(zzf2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onStop() {
            List<WeakReference<zzf<?>>> list = this.mListeners;
            synchronized (list) {
                for (WeakReference<zzf<?>> weakReference : this.mListeners) {
                    zzf zzf2 = (zzf)weakReference.get();
                    if (zzf2 == null) continue;
                    zzf2.cancel();
                }
                this.mListeners.clear();
            }
        }
    }
}

