/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;

@zzmb
class zzx
implements SensorEventListener {
    private final SensorManager zzNG;
    private final Object zzNH;
    private final Display zzNI;
    private final float[] zzNJ;
    private final float[] zzNK;
    private float[] zzNL;
    private Handler zzNM;
    private zza zzNN;

    zzx(Context context) {
        this.zzNG = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzNI = windowManager.getDefaultDisplay();
        this.zzNJ = new float[9];
        this.zzNK = new float[9];
        this.zzNH = new Object();
    }

    int getRotation() {
        return this.zzNI.getRotation();
    }

    void start() {
        if (this.zzNM != null) {
            return;
        }
        Sensor sensor = this.zzNG.getDefaultSensor(11);
        if (sensor == null) {
            zzpe.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzNM = new Handler(handlerThread.getLooper());
        boolean bl = this.zzNG.registerListener((SensorEventListener)this, sensor, 0, this.zzNM);
        if (!bl) {
            zzpe.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    void stop() {
        if (this.zzNM == null) {
            return;
        }
        this.zzNG.unregisterListener((SensorEventListener)this);
        this.zzNM.post(new Runnable(this){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.zzNM = null;
    }

    void zza(zza zza2) {
        this.zzNN = zza2;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.zza(sensorEvent.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            return;
        }
        Object object = this.zzNH;
        synchronized (object) {
            if (this.zzNL == null) {
                this.zzNL = new float[9];
            }
        }
        SensorManager.getRotationMatrixFromVector((float[])this.zzNJ, (float[])fArray);
        int n = this.getRotation();
        switch (n) {
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.zzNJ, (int)2, (int)129, (float[])this.zzNK);
                break;
            }
            case 2: {
                SensorManager.remapCoordinateSystem((float[])this.zzNJ, (int)129, (int)130, (float[])this.zzNK);
                break;
            }
            case 3: {
                SensorManager.remapCoordinateSystem((float[])this.zzNJ, (int)130, (int)1, (float[])this.zzNK);
                break;
            }
            default: {
                System.arraycopy(this.zzNJ, 0, this.zzNK, 0, 9);
            }
        }
        this.zzh(1, 3);
        this.zzh(2, 6);
        this.zzh(5, 7);
        Object object2 = this.zzNH;
        synchronized (object2) {
            System.arraycopy(this.zzNK, 0, this.zzNL, 0, 9);
        }
        if (this.zzNN != null) {
            this.zzNN.zzho();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzb(float[] fArray) {
        Object object = this.zzNH;
        synchronized (object) {
            if (this.zzNL == null) {
                return false;
            }
            System.arraycopy(this.zzNL, 0, fArray, 0, this.zzNL.length);
            return true;
        }
    }

    private void zzh(int n, int n2) {
        float f = this.zzNK[n];
        this.zzNK[n] = this.zzNK[n2];
        this.zzNK[n2] = f;
    }

    static interface zza {
        public void zzho();
    }
}

