/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.DownloadManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzrb;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;

@zzmb
@TargetApi(value=8)
public class zzpj {
    public boolean isAttachedToWindow(View view) {
        return view.getWindowToken() != null || view.getWindowVisibility() != 8;
    }

    public boolean zza(Context context, WebSettings webSettings) {
        return false;
    }

    public boolean zzt(View view) {
        return false;
    }

    public boolean zzu(View view) {
        return false;
    }

    public boolean zza(Window window) {
        return false;
    }

    public boolean zzl(zzqp zzqp2) {
        if (zzqp2 == null) {
            return false;
        }
        zzqp2.onPause();
        return true;
    }

    public boolean zzm(zzqp zzqp2) {
        if (zzqp2 == null) {
            return false;
        }
        zzqp2.onResume();
        return true;
    }

    public int zzkp() {
        return 0;
    }

    public int zzkq() {
        return 1;
    }

    public int zzkr() {
        return 5;
    }

    public String getDefaultUserAgent(Context context) {
        return "";
    }

    public boolean zza(DownloadManager.Request request) {
        return false;
    }

    public zzqq zzb(zzqp zzqp2, boolean bl) {
        return new zzqq(zzqp2, bl);
    }

    public WebChromeClient zzn(zzqp zzqp2) {
        return null;
    }

    public Set<String> zzh(Uri uri) {
        int n;
        if (uri.isOpaque()) {
            return Collections.emptySet();
        }
        String string2 = uri.getEncodedQuery();
        if (string2 == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n2 = 0;
        do {
            int n3;
            n = (n3 = string2.indexOf(38, n2)) == -1 ? string2.length() : n3;
            int n4 = string2.indexOf(61, n2);
            if (n4 > n || n4 == -1) {
                n4 = n;
            }
            String string3 = string2.substring(n2, n4);
            linkedHashSet.add(Uri.decode((String)string3));
        } while ((n2 = n + 1) < string2.length());
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public void zzb(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            this.zza(window.getDecorView().getViewTreeObserver(), onGlobalLayoutListener);
        }
    }

    public void zza(ViewTreeObserver viewTreeObserver, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        viewTreeObserver.removeGlobalOnLayoutListener(onGlobalLayoutListener);
    }

    public ViewGroup.LayoutParams zzks() {
        return new ViewGroup.LayoutParams(-2, -2);
    }

    public void zza(View view, Drawable drawable2) {
        view.setBackgroundDrawable(drawable2);
    }

    public String zza(SslError sslError) {
        return "";
    }

    public Drawable zza(Context context, Bitmap bitmap, boolean bl, float f) {
        return new BitmapDrawable(context.getResources(), bitmap);
    }

    public CookieManager zzL(Context context) {
        try {
            CookieSyncManager.createInstance((Context)context);
            return CookieManager.getInstance();
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Failed to obtain CookieManager.", (Throwable)exception);
            zzv.zzcN().zza(exception, "ApiLevelUtil.getCookieManager");
            return null;
        }
    }

    private zzpj() {
    }

    public static zzpj zzah(int n) {
        if (n >= 21) {
            return new zzh();
        }
        if (n >= 19) {
            return new zzg();
        }
        if (n >= 18) {
            return new zze();
        }
        if (n >= 17) {
            return new zzd();
        }
        if (n >= 16) {
            return new zzf();
        }
        if (n >= 14) {
            return new zzc();
        }
        if (n >= 11) {
            return new zzb();
        }
        if (n >= 9) {
            return new zza();
        }
        return new zzpj();
    }

    @TargetApi(value=21)
    public static class zzh
    extends zzg {
        @Override
        public CookieManager zzL(Context context) {
            return CookieManager.getInstance();
        }

        @Override
        public zzqq zzb(zzqp zzqp2, boolean bl) {
            return new zzrb(zzqp2, bl);
        }
    }

    @TargetApi(value=19)
    public static class zzg
    extends zze {
        @Override
        public boolean isAttachedToWindow(View view) {
            return view.isAttachedToWindow();
        }

        @Override
        public ViewGroup.LayoutParams zzks() {
            return new ViewGroup.LayoutParams(-1, -1);
        }
    }

    @TargetApi(value=18)
    public static class zze
    extends zzd {
        @Override
        public boolean isAttachedToWindow(View view) {
            return super.isAttachedToWindow(view) || view.getWindowId() != null;
        }

        @Override
        public int zzkr() {
            return 14;
        }
    }

    @TargetApi(value=17)
    public static class zzd
    extends zzf {
        @Override
        public boolean zza(Context context, WebSettings webSettings) {
            super.zza(context, webSettings);
            webSettings.setMediaPlaybackRequiresUserGesture(false);
            return true;
        }

        @Override
        public String getDefaultUserAgent(Context context) {
            return WebSettings.getDefaultUserAgent((Context)context);
        }

        @Override
        public Drawable zza(Context context, Bitmap bitmap, boolean bl, float f) {
            if (!bl || f <= 0.0f || f > 25.0f) {
                return new BitmapDrawable(context.getResources(), bitmap);
            }
            try {
                Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)false);
                Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2);
                RenderScript renderScript = RenderScript.create((Context)context);
                ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
                Allocation allocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap2);
                Allocation allocation2 = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap3);
                scriptIntrinsicBlur.setRadius(f);
                scriptIntrinsicBlur.setInput(allocation);
                scriptIntrinsicBlur.forEach(allocation2);
                allocation2.copyTo(bitmap3);
                return new BitmapDrawable(context.getResources(), bitmap3);
            }
            catch (RuntimeException runtimeException) {
                return new BitmapDrawable(context.getResources(), bitmap);
            }
        }
    }

    @TargetApi(value=16)
    public static class zzf
    extends zzc {
        @Override
        public void zzb(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
            Window window = activity.getWindow();
            if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
                this.zza(window.getDecorView().getViewTreeObserver(), onGlobalLayoutListener);
            }
        }

        @Override
        public void zza(View view, Drawable drawable2) {
            view.setBackground(drawable2);
        }

        @Override
        public void zza(ViewTreeObserver viewTreeObserver, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
            viewTreeObserver.removeOnGlobalLayoutListener(onGlobalLayoutListener);
        }

        @Override
        public boolean zza(Context context, WebSettings webSettings) {
            super.zza(context, webSettings);
            webSettings.setAllowFileAccessFromFileURLs(false);
            webSettings.setAllowUniversalAccessFromFileURLs(false);
            return true;
        }
    }

    @TargetApi(value=14)
    public static class zzc
    extends zzb {
        @Override
        public WebChromeClient zzn(zzqp zzqp2) {
            return new zzqy(zzqp2);
        }

        @Override
        public String zza(SslError sslError) {
            return sslError.getUrl();
        }
    }

    @TargetApi(value=11)
    public static class zzb
    extends zza {
        @Override
        public boolean zza(final Context context, final WebSettings webSettings) {
            super.zza(context, webSettings);
            return zzpv.zzb(new Callable<Boolean>(this){

                public Boolean zzkt() {
                    File file = context.getCacheDir();
                    if (file != null) {
                        webSettings.setAppCachePath(context.getCacheDir().getAbsolutePath());
                        webSettings.setAppCacheMaxSize(0L);
                        webSettings.setAppCacheEnabled(true);
                    }
                    webSettings.setDatabasePath(context.getDatabasePath("com.google.android.gms.ads.db").getAbsolutePath());
                    webSettings.setDatabaseEnabled(true);
                    webSettings.setDomStorageEnabled(true);
                    webSettings.setDisplayZoomControls(false);
                    webSettings.setBuiltInZoomControls(true);
                    webSettings.setSupportZoom(true);
                    webSettings.setAllowContentAccess(false);
                    return true;
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzkt();
                }
            });
        }

        @Override
        public boolean zzu(View view) {
            view.setLayerType(1, null);
            return true;
        }

        @Override
        public boolean zzt(View view) {
            view.setLayerType(0, null);
            return true;
        }

        @Override
        public boolean zza(Window window) {
            window.setFlags(0x1000000, 0x1000000);
            return true;
        }

        @Override
        public zzqq zzb(zzqp zzqp2, boolean bl) {
            return new zzqx(zzqp2, bl);
        }

        @Override
        public WebChromeClient zzn(zzqp zzqp2) {
            return new zzqw(zzqp2);
        }

        @Override
        public Set<String> zzh(Uri uri) {
            return uri.getQueryParameterNames();
        }

        @Override
        public boolean zza(DownloadManager.Request request) {
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(1);
            return true;
        }
    }

    @TargetApi(value=9)
    public static class zza
    extends zzpj {
        @Override
        public int zzkp() {
            return 6;
        }

        @Override
        public int zzkq() {
            return 7;
        }

        @Override
        public boolean zza(DownloadManager.Request request) {
            request.setShowRunningNotification(true);
            return true;
        }
    }
}

