/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zzjt;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzqa;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzjm
implements zzjn.zza {
    private final String zzKo;
    private final zzjs zzsD;
    private final long zzKp;
    private final zzjj zzKq;
    private final zzji zzKr;
    private zzdy zzug;
    private final zzec zzum;
    private final Context mContext;
    private final Object zzrN = new Object();
    private final zzqa zztr;
    private final boolean zzvW;
    private final zzgw zztn;
    private final List<String> zzto;
    private final boolean zzKs;
    private zzjt zzKt;
    private int zzKu = -2;
    private zzjv zzKv;

    public zzjm(Context context, String string2, zzjs zzjs2, zzjj zzjj2, zzji zzji2, zzdy zzdy2, zzec zzec2, zzqa zzqa2, boolean bl, boolean bl2, zzgw zzgw2, List<String> list) {
        this.mContext = context;
        this.zzsD = zzjs2;
        this.zzKr = zzji2;
        this.zzKo = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zzgC() : string2;
        this.zzKq = zzjj2;
        this.zzKp = zzjj2.zzJX != -1L ? zzjj2.zzJX : 10000L;
        this.zzug = zzdy2;
        this.zzum = zzec2;
        this.zztr = zzqa2;
        this.zzvW = bl;
        this.zzKs = bl2;
        this.zztn = zzgw2;
        this.zzto = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzrN;
        synchronized (object) {
            try {
                if (this.zzKt != null) {
                    this.zzKt.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzKu = -1;
            this.zzrN.notify();
        }
    }

    private String zzgC() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzKr.zzJK)) {
                return this.zzsD.zzas(this.zzKr.zzJK) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzpe.zzbe((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzD(int n) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzKu = n;
            this.zzrN.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzjv zzjv2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzKu = n;
            this.zzKv = zzjv2;
            this.zzrN.notify();
        }
    }

    protected zzjt zza(MediationAdapter mediationAdapter) {
        return new zzjz(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzjn zza(long l, long l2) {
        Object object = this.zzrN;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzjl zzjl2 = new zzjl();
            zzpi.zzWR.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzjm.this.zzrN;
                    synchronized (object) {
                        if (zzjm.this.zzKu != -2) {
                            return;
                        }
                        zzjm.this.zzKt = zzjm.this.zzgE();
                        if (zzjm.this.zzKt == null) {
                            zzjm.this.zzD(4);
                            return;
                        }
                        if (zzjm.this.zzgF() && !zzjm.this.zzE(1)) {
                            String string2 = zzjm.this.zzKo;
                            zzpe.zzbe((String)new StringBuilder(56 + String.valueOf(string2).length()).append("Ignoring adapter ").append(string2).append(" as delayed impression is not supported").toString());
                            zzjm.this.zzD(2);
                            return;
                        }
                        zzjl2.zza(zzjm.this);
                        zzjm.this.zza(zzjl2);
                    }
                }
            });
            long l4 = this.zza(l3, this.zzKp, l, l2);
            return new zzjn(this.zzKr, this.zzKt, this.zzKo, zzjl2, this.zzKu, this.zzgD(), l4);
        }
    }

    private zzjv zzgD() {
        if (this.zzKu != 0 || !this.zzgF()) {
            return null;
        }
        try {
            if (this.zzE(4) && this.zzKv != null && this.zzKv.zzgH() != 0) {
                return this.zzKv;
            }
        }
        catch (RemoteException remoteException) {
            zzpe.zzbe((String)"Could not get cpm value from MediationResponseMetadata");
        }
        return zzjm.zzF(this.zzgG());
    }

    private zzjt zzgE() {
        String string2 = String.valueOf(this.zzKo);
        zzpe.zzbd((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzvW) {
            if (zzfx.zzDb.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzKo)) {
                return this.zza((MediationAdapter)new AdMobAdapter());
            }
            if (zzfx.zzDc.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzKo)) {
                return this.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzKo)) {
                return new zzjz((MediationAdapter)new zzkh());
            }
        }
        try {
            return this.zzsD.zzar(this.zzKo);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzKo);
            zzpe.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private void zza(zzjl zzjl2) {
        String string2 = this.zzao(this.zzKr.zzJO);
        try {
            if (this.zztr.zzYc < 4100000) {
                if (this.zzum.zzzl) {
                    this.zzKt.zza(zze.zzA((Object)this.mContext), this.zzug, string2, (zzju)zzjl2);
                } else {
                    this.zzKt.zza(zze.zzA((Object)this.mContext), this.zzum, this.zzug, string2, (zzju)zzjl2);
                }
            } else if (this.zzvW) {
                this.zzKt.zza(zze.zzA((Object)this.mContext), this.zzug, string2, this.zzKr.zzJG, (zzju)zzjl2, this.zztn, this.zzto);
            } else if (this.zzum.zzzl) {
                this.zzKt.zza(zze.zzA((Object)this.mContext), this.zzug, string2, this.zzKr.zzJG, (zzju)zzjl2);
            } else if (this.zzKs) {
                if (this.zzKr.zzJR != null) {
                    this.zzKt.zza(zze.zzA((Object)this.mContext), this.zzug, string2, this.zzKr.zzJG, (zzju)zzjl2, new zzgw(zzjm.zzap(this.zzKr.zzJV)), this.zzKr.zzJU);
                } else {
                    this.zzKt.zza(zze.zzA((Object)this.mContext), this.zzum, this.zzug, string2, this.zzKr.zzJG, (zzju)zzjl2);
                }
            } else {
                this.zzKt.zza(zze.zzA((Object)this.mContext), this.zzum, this.zzug, string2, this.zzKr.zzJG, (zzju)zzjl2);
            }
        }
        catch (RemoteException remoteException) {
            zzpe.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzD(5);
        }
    }

    private long zza(long l, long l2, long l3, long l4) {
        while (this.zzKu == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return zzv.zzcP().elapsedRealtime() - l;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzpe.zzbd((String)"Timed out waiting for adapter.");
            this.zzKu = 3;
            return;
        }
        try {
            this.zzrN.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzKu = -1;
        }
    }

    private boolean zzE(int n) {
        Bundle bundle;
        try {
            bundle = this.zzvW ? this.zzKt.zzgM() : (this.zzum.zzzl ? this.zzKt.getInterstitialAdapterInfo() : this.zzKt.zzgL());
        }
        catch (RemoteException remoteException) {
            zzpe.zzbe((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzgF() {
        return this.zzKq.zzKh != -1;
    }

    private String zzao(String string2) {
        if (string2 == null || !this.zzgF() || this.zzE(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzpe.zzbe((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    private int zzgG() {
        JSONObject jSONObject;
        if (this.zzKr.zzJO == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzKr.zzJO);
        }
        catch (JSONException jSONException) {
            zzpe.zzbe((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzKo)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzE(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzjv zzF(final int n) {
        return new zzjv.zza(){

            public int zzgH() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzap(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzjm.zzaq(string3));
        }
        catch (JSONException jSONException) {
            zzpe.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    private static int zzaq(String string2) {
        if ("landscape".equals(string2)) {
            return 2;
        }
        if ("portrait".equals(string2)) {
            return 1;
        }
        return 0;
    }
}

