/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzaab;
import com.google.android.gms.internal.zzaal;
import com.google.android.gms.internal.zzaap;
import com.google.android.gms.internal.zzaau;
import com.google.android.gms.internal.zzabi;
import com.google.android.gms.internal.zzact;
import com.google.android.gms.internal.zzaxn;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzzs;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.internal.zzzy;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzaac
implements zzaau {
    private final Map<Api.zzc<?>, com.google.android.gms.common.api.zzc<?>> zzazt = new HashMap();
    private final Map<Api<?>, Integer> zzazu;
    private final zzaap zzaxK;
    private final zzaal zzazv;
    private final Lock zzazn;
    private final Looper zzrx;
    private final zzc zzazw;
    private final Condition zzazx;
    private final zzg zzazs;
    private boolean zzazy;
    private Map<zzzs<?>, ConnectionResult> zzazz;
    private ConnectionResult zzazA;

    public zzaac(Context context, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zzaxn, zzaxo> zza2, ArrayList<zzzy> arrayList, zzaal zzaal2) {
        this.zzazn = lock;
        this.zzrx = looper;
        this.zzazx = lock.newCondition();
        this.zzazw = zzc2;
        this.zzazv = zzaal2;
        this.zzazu = map2;
        this.zzazs = zzg2;
        HashMap hashMap = new HashMap();
        for (Api<?> iterator : map2.keySet()) {
            hashMap.put(iterator.zzuH(), iterator);
        }
        HashMap hashMap2 = new HashMap();
        for (zzzy zzzy2 : arrayList) {
            hashMap2.put(zzzy2.zzawb, zzzy2);
        }
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze2 = entry.getValue();
            zzzy zzzy3 = (zzzy)hashMap2.get(api);
            this.zzazt.put(entry.getKey(), new zzaab(context, api, looper, zze2, zzzy3, zzg2, zza2));
        }
        this.zzaxK = zzaap.zzvS();
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzzv.zza<R, A>> T zza(@NonNull T t) {
        this.zzazv.zzaAx.zzb(t);
        return this.zzazt.get(t.zzuH()).doRead(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzzv.zza<? extends Result, A>> T zzb(@NonNull T t) {
        this.zzazv.zzaAx.zzb(t);
        return this.zzazt.get(t.zzuH()).doWrite(t);
    }

    @Override
    public void connect() {
        this.zzazn.lock();
        try {
            if (this.zzazy) {
                return;
            }
            this.zzazy = true;
            this.zzazz = null;
            this.zzazA = null;
            zza zza2 = new zza();
            zzact zzact2 = new zzact(this.zzrx);
            this.zzaxK.zza(this.zzazt.values()).addOnSuccessListener((Executor)zzact2, (OnSuccessListener)zza2).addOnFailureListener((Executor)zzact2, (OnFailureListener)zza2);
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzazx.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzawX;
        }
        if (this.zzazA != null) {
            return this.zzazA;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzazx.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzawX;
        }
        if (this.zzazA != null) {
            return this.zzazA;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        this.zzazn.lock();
        try {
            this.zzazy = false;
            this.zzazz = null;
            this.zzazA = null;
            this.zzazx.signalAll();
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.zzazn.lock();
        try {
            if (((zzaab)this.zzazt.get(api.zzuH())).zzvr().isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzawX;
                return connectionResult;
            }
            if (this.zzazz != null) {
                ConnectionResult connectionResult = this.zzazz.get(this.zzazt.get(api.zzuH()).getApiKey());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.zzazn.lock();
        try {
            boolean bl = this.zzazz != null && this.zzazA == null;
            return bl;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.zzazn.lock();
        try {
            boolean bl = this.zzazz == null && this.zzazy;
            return bl;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public boolean zza(zzabi zzabi2) {
        return false;
    }

    @Override
    public void zzuN() {
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public void zzvj() {
    }

    private class zza
    implements OnFailureListener,
    OnSuccessListener<Void> {
        private zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zza(Void void_) {
            zzaac.this.zzazn.lock();
            try {
                zzaac.this.zzazz = (Map)new ArrayMap(zzaac.this.zzazt.size());
                for (Api.zzc zzc2 : zzaac.this.zzazt.keySet()) {
                    zzaac.this.zzazz.put(((com.google.android.gms.common.api.zzc)zzaac.this.zzazt.get(zzc2)).getApiKey(), ConnectionResult.zzawX);
                }
                this.zzvt();
                zzaac.this.zzazv.zzo(null);
                zzaac.this.zzazx.signalAll();
            }
            finally {
                zzaac.this.zzazn.unlock();
            }
        }

        public void onFailure(@NonNull Exception exception) {
            zzb zzb2 = (zzb)exception;
            zzaac.this.zzazn.lock();
            try {
                zzaac.this.zzazz = zzb2.zzuK();
                zzaac.this.zzazA = this.zzvs();
                if (zzaac.this.zzazA == null) {
                    this.zzvt();
                    zzaac.this.zzazv.zzo(null);
                } else {
                    zzaac.this.zzazy = false;
                    zzaac.this.zzazv.zzc(zzaac.this.zzazA);
                }
                zzaac.this.zzazx.signalAll();
            }
            finally {
                zzaac.this.zzazn.unlock();
            }
        }

        @Nullable
        private ConnectionResult zzvs() {
            ConnectionResult connectionResult = null;
            int n = 0;
            for (Api api : zzaac.this.zzazu.keySet()) {
                int n2;
                ConnectionResult connectionResult2 = (ConnectionResult)zzaac.this.zzazz.get(((com.google.android.gms.common.api.zzc)zzaac.this.zzazt.get(api.zzuH())).getApiKey());
                if (connectionResult2.isSuccess() || (n2 = ((Integer)zzaac.this.zzazu.get(api)).intValue()) == 2 || n2 == 1 && !connectionResult2.hasResolution() && !zzaac.this.zzazw.isUserResolvableError(connectionResult2.getErrorCode())) continue;
                int n3 = api.zzuF().getPriority();
                if (connectionResult != null && n <= n3) continue;
                connectionResult = connectionResult2;
                n = n3;
            }
            return connectionResult;
        }

        private void zzvt() {
            if (zzaac.this.zzazs == null) {
                ((zzaac)zzaac.this).zzazv.zzaAs = Collections.emptySet();
                return;
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(zzaac.this.zzazs.zzxe());
            Map<Api<?>, zzg.zza> map = zzaac.this.zzazs.zzxg();
            for (Api<?> api : map.keySet()) {
                ConnectionResult connectionResult = (ConnectionResult)zzaac.this.zzazz.get(((com.google.android.gms.common.api.zzc)zzaac.this.zzazt.get(api.zzuH())).getApiKey());
                if (connectionResult == null || !connectionResult.isSuccess()) continue;
                hashSet.addAll(map.get(api).zzajm);
            }
            ((zzaac)zzaac.this).zzazv.zzaAs = hashSet;
        }

        public /* synthetic */ void onSuccess(Object object) {
            this.zza((Void)object);
        }
    }
}

