/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zza();
    public static zze zzaiV = zzh.zzyv();
    final int versionCode;
    private String zzGu;
    private String zzaix;
    private String zzaiW;
    private String zzaiX;
    private Uri zzaiY;
    private String zzaiZ;
    private long zzaja;
    private String zzajb;
    List<Scope> zzahM;
    private String zzaik;
    private String zzail;
    private static Comparator<Scope> zzajc = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzuS().compareTo(scope2.zzuS());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInAccount zzcu(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        return GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzcv(jSONObject.optString("serverAuthCode", null));
    }

    public static GoogleSignInAccount zza(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Uri uri, @Nullable Long l, @NonNull String string8, @NonNull Set<Scope> set) {
        if (l == null) {
            l = zzaiV.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(3, string2, string3, string4, string5, uri, null, l, zzac.zzdv((String)string8), new ArrayList<Scope>((Collection)zzac.zzw(set)), string6, string7);
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.versionCode = n;
        this.zzGu = string2;
        this.zzaix = string3;
        this.zzaiW = string4;
        this.zzaiX = string5;
        this.zzaiY = uri;
        this.zzaiZ = string6;
        this.zzaja = l;
        this.zzajb = string7;
        this.zzahM = list;
        this.zzaik = string8;
        this.zzail = string9;
    }

    @Nullable
    public String getId() {
        return this.zzGu;
    }

    @Nullable
    public String getIdToken() {
        return this.zzaix;
    }

    @Nullable
    public String getEmail() {
        return this.zzaiW;
    }

    @Nullable
    public Account getAccount() {
        return this.zzaiW == null ? null : new Account(this.zzaiW, "com.google");
    }

    @Nullable
    public String getDisplayName() {
        return this.zzaiX;
    }

    @Nullable
    public String getGivenName() {
        return this.zzaik;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzail;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzaiY;
    }

    public GoogleSignInAccount zzcv(String string2) {
        this.zzaiZ = string2;
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzaiZ;
    }

    public long zzqE() {
        return this.zzaja;
    }

    public boolean zza() {
        return zzaiV.currentTimeMillis() / 1000L >= this.zzaja - 300L;
    }

    @NonNull
    public String zzqF() {
        return this.zzajb;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzahM);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        return this.zzqG().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zzqG().equals(this.zzqG());
    }

    public String zzqG() {
        return this.zzqI().toString();
    }

    public String zzqH() {
        JSONObject jSONObject = this.zzqI();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private JSONObject zzqI() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzaja);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzqF());
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzahM, zzajc);
            for (Scope scope : this.zzahM) {
                jSONArray.put((Object)scope.zzuS());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

