/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.internal.zzaar;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzaax;

public abstract class zzzw
extends zzaaw
implements DialogInterface.OnCancelListener {
    protected boolean mStarted;
    protected boolean zzayG;
    private ConnectionResult zzayH;
    private int zzayI = -1;
    private final Handler zzayJ = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzaxX;

    protected zzzw(zzaax zzaax2) {
        this(zzaax2, GoogleApiAvailability.getInstance());
    }

    zzzw(zzaax zzaax2, GoogleApiAvailability googleApiAvailability) {
        super(zzaax2);
        this.zzaxX = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), this.zzayI);
        this.zzva();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.zzayG = bundle.getBoolean("resolving_error", false);
            if (this.zzayG) {
                this.zzayI = bundle.getInt("failed_client_id", -1);
                this.zzayH = new ConnectionResult(bundle.getInt("failed_status"), (PendingIntent)bundle.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("resolving_error", this.zzayG);
        if (this.zzayG) {
            bundle.putInt("failed_client_id", this.zzayI);
            bundle.putInt("failed_status", this.zzayH.getErrorCode());
            bundle.putParcelable("failed_resolution", (Parcelable)this.zzayH.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        switch (n) {
            case 2: {
                int n3 = this.zzaxX.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (this.zzayH.getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                this.zzayH = new ConnectionResult(n4, null);
            }
        }
        if (bl) {
            this.zzva();
        } else {
            this.zza(this.zzayH, this.zzayI);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzuW();

    protected void zzva() {
        this.zzayI = -1;
        this.zzayG = false;
        this.zzayH = null;
        this.zzuW();
    }

    public void zzb(ConnectionResult connectionResult, int n) {
        if (!this.zzayG) {
            this.zzayG = true;
            this.zzayI = n;
            this.zzayH = connectionResult;
            this.zzayJ.post((Runnable)new zza());
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        @MainThread
        public void run() {
            if (!zzzw.this.mStarted) {
                return;
            }
            if (zzzw.this.zzayH.hasResolution()) {
                zzzw.this.zzaBs.startActivityForResult(GoogleApiActivity.zzb((Context)zzzw.this.getActivity(), zzzw.this.zzayH.getResolution(), zzzw.this.zzayI, false), 1);
            } else if (zzzw.this.zzaxX.isUserResolvableError(zzzw.this.zzayH.getErrorCode())) {
                zzzw.this.zzaxX.zza(zzzw.this.getActivity(), zzzw.this.zzaBs, zzzw.this.zzayH.getErrorCode(), 2, zzzw.this);
            } else if (zzzw.this.zzayH.getErrorCode() == 18) {
                final Dialog dialog = zzzw.this.zzaxX.zza(zzzw.this.getActivity(), zzzw.this);
                zzzw.this.zzaxX.zza(zzzw.this.getActivity().getApplicationContext(), new zzaar.zza(){

                    @Override
                    public void zzvb() {
                        zzzw.this.zzva();
                        if (dialog.isShowing()) {
                            dialog.dismiss();
                        }
                    }
                });
            } else {
                zzzw.this.zza(zzzw.this.zzayH, zzzw.this.zzayI);
            }
        }
    }
}

