/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zzf;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zza
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzajd = new Scope("profile");
    public static final Scope zzaje = new Scope("email");
    public static final Scope zzajf = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzb();
    final int versionCode;
    private final ArrayList<Scope> zzajg;
    private Account zzagg;
    private boolean zzajh;
    private final boolean zzaji;
    private final boolean zzajj;
    private String zzajk;
    private String zzajl;
    private static Comparator<Scope> zzajc = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzuS().compareTo(scope2.zzuS());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzcw(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null));
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this.versionCode = n;
        this.zzajg = arrayList;
        this.zzagg = account;
        this.zzajh = bl;
        this.zzaji = bl2;
        this.zzajj = bl3;
        this.zzajk = string2;
        this.zzajl = string3;
    }

    private GoogleSignInOptions(Set<Scope> set, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this(2, new ArrayList<Scope>(set), account, bl, bl2, bl3, string2, string3);
    }

    public ArrayList<Scope> zzqJ() {
        return new ArrayList<Scope>(this.zzajg);
    }

    public Scope[] getScopeArray() {
        return this.zzajg.toArray(new Scope[this.zzajg.size()]);
    }

    public Account getAccount() {
        return this.zzagg;
    }

    public boolean zzqK() {
        return this.zzajh;
    }

    public boolean zzqL() {
        return this.zzaji;
    }

    public boolean zzqM() {
        return this.zzajj;
    }

    public String zzqN() {
        return this.zzajk;
    }

    public String zzqO() {
        return this.zzajl;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzajg.size() != googleSignInOptions.zzqJ().size() || !this.zzajg.containsAll(googleSignInOptions.zzqJ())) {
                return false;
            }
            return (this.zzagg == null ? googleSignInOptions.getAccount() == null : this.zzagg.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zzajk) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzqN()) : this.zzajk.equals(googleSignInOptions.zzqN())) && this.zzajj == googleSignInOptions.zzqM() && this.zzajh == googleSignInOptions.zzqK() && this.zzaji == googleSignInOptions.zzqL();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.zzajg) {
            arrayList.add(scope.zzuS());
        }
        Collections.sort(arrayList);
        return new zzf().zzq(arrayList).zzq(this.zzagg).zzq(this.zzajk).zzad(this.zzajj).zzad(this.zzajh).zzad(this.zzaji).zzqV();
    }

    public String zzqG() {
        return this.zzqI().toString();
    }

    private JSONObject zzqI() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzajg, zzajc);
            for (Scope scope : this.zzajg) {
                jSONArray.put((Object)scope.zzuS());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzagg != null) {
                jSONObject.put("accountName", (Object)this.zzagg.name);
            }
            jSONObject.put("idTokenRequested", this.zzajh);
            jSONObject.put("forceCodeForRefreshToken", this.zzajj);
            jSONObject.put("serverAuthRequested", this.zzaji);
            if (!TextUtils.isEmpty((CharSequence)this.zzajk)) {
                jSONObject.put("serverClientId", (Object)this.zzajk);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzajl)) {
                jSONObject.put("hostedDomain", (Object)this.zzajl);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> zzajm = new HashSet<Scope>();
        private boolean zzaji;
        private boolean zzajj;
        private boolean zzajh;
        private String zzajk;
        private Account zzagg;
        private String zzajl;

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzac.zzw((Object)googleSignInOptions);
            this.zzajm = new HashSet<Scope>(googleSignInOptions.zzajg);
            this.zzaji = googleSignInOptions.zzaji;
            this.zzajj = googleSignInOptions.zzajj;
            this.zzajh = googleSignInOptions.zzajh;
            this.zzajk = googleSignInOptions.zzajk;
            this.zzagg = googleSignInOptions.zzagg;
            this.zzajl = googleSignInOptions.zzajl;
        }

        public Builder requestId() {
            this.zzajm.add(zzajf);
            return this;
        }

        public Builder requestEmail() {
            this.zzajm.add(zzaje);
            return this;
        }

        public Builder requestProfile() {
            this.zzajm.add(zzajd);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzajm.add(scope);
            this.zzajm.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public Builder requestIdToken(String string2) {
            this.zzajh = true;
            this.zzajk = this.zzcx(string2);
            return this;
        }

        public Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzaji = true;
            this.zzajk = this.zzcx(string2);
            this.zzajj = bl;
            return this;
        }

        public Builder setAccountName(String string2) {
            this.zzagg = new Account(zzac.zzdv((String)string2), "com.google");
            return this;
        }

        public Builder setHostedDomain(String string2) {
            this.zzajl = zzac.zzdv((String)string2);
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.zzajh && (this.zzagg == null || !this.zzajm.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(this.zzajm, this.zzagg, this.zzajh, this.zzaji, this.zzajj, this.zzajk, this.zzajl);
        }

        private String zzcx(String string2) {
            zzac.zzdv((String)string2);
            zzac.zzb((this.zzajk == null || this.zzajk.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

