/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamite;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.zzc;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamite.zza;
import com.google.android.gms.dynamite.zzb;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Field;
import java.util.HashMap;

public final class DynamiteModule {
    private static com.google.android.gms.dynamite.zza zzaQr;
    private static final HashMap<String, byte[]> zzaQs;
    private static String zzaQt;
    private static final zzb.zza zzaQu;
    private static final zzb.zza zzaQv;
    public static final zzb zzaQw;
    public static final zzb zzaQx;
    public static final zzb zzaQy;
    public static final zzb zzaQz;
    public static final zzb zzaQA;
    private final Context zzaQB;

    public static DynamiteModule zza(Context context, zzb zzb2, String string2) throws zza {
        if ("com.google.android.gms".equals(context.getApplicationContext().getPackageName())) {
            return DynamiteModule.zza(context, zzb2, string2, zzaQu);
        }
        try {
            return DynamiteModule.zza(context, zzb2, string2, zzaQv);
        }
        catch (zza zza2) {
            String string3 = String.valueOf(zza2.toString());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load module via fast route".concat(string3) : new String("Failed to load module via fast route")));
            return DynamiteModule.zza(context, zzb2, string2, zzaQu);
        }
    }

    public static DynamiteModule zza(Context context, zzb zzb2, String string2, zzb.zza zza2) throws zza {
        zzb.zzb zzb3 = zzb2.zza(context, string2, zza2);
        int n = zzb3.zzaQD;
        final int n2 = zzb3.zzaQE;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
        if (zzb3.zzaQF == 0 || zzb3.zzaQF == -1 && zzb3.zzaQD == 0 || zzb3.zzaQF == 1 && zzb3.zzaQE == 0) {
            n = zzb3.zzaQD;
            n2 = zzb3.zzaQE;
            throw new zza(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString());
        }
        if (zzb3.zzaQF == -1) {
            return DynamiteModule.zzC(context, string2);
        }
        if (zzb3.zzaQF == 1) {
            try {
                return zza2.zza(context, string2, zzb3.zzaQE);
            }
            catch (zza zza3) {
                String string3 = String.valueOf(zza3.getMessage());
                Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                if (zzb3.zzaQD != 0) {
                    n2 = zzb3.zzaQD;
                    zzb.zza zza4 = new zzb.zza(){

                        @Override
                        public int zzb(Context context, String string2, boolean bl) {
                            return 0;
                        }

                        @Override
                        public int zzA(Context context, String string2) {
                            return n2;
                        }

                        @Override
                        public DynamiteModule zza(Context context, String string2, int n) throws zza {
                            throw new zza("local only VersionPolicy should not load from remote");
                        }
                    };
                    zzb3 = zzb2.zza(context, string2, zza4);
                    if (zzb3.zzaQF == -1) {
                        return DynamiteModule.zzC(context, string2);
                    }
                }
                throw new zza("Remote load failed. No local fallback found.", zza3);
            }
        }
        n = zzb3.zzaQF;
        throw new zza(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString());
    }

    public static int zzA(Context context, String string2) {
        try {
            Object object = String.valueOf("com.google.android.gms.dynamite.descriptors.");
            Object object2 = String.valueOf("ModuleDescriptor");
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string2).length() + String.valueOf(object2).length()).append((String)object).append(string2).append(".").append((String)object2).toString());
            object = clazz.getDeclaredField("MODULE_ID");
            object2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!((Field)object).get(null).equals(string2)) {
                String string3 = String.valueOf(((Field)object).get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return ((Field)object2).getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    public static int zzb(Context context, String string2, boolean bl) {
        com.google.android.gms.dynamite.zza zza2 = DynamiteModule.zzaU(context);
        if (zza2 == null) {
            return 0;
        }
        try {
            return zza2.zza(zze.zzA(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int zzc(Context context, String string2, boolean bl) throws zza {
        try (Cursor cursor = null;){
            String string3 = bl ? "api_force_staging" : "api";
            String string4 = String.valueOf("content://com.google.android.gms.chimera/");
            Uri uri = Uri.parse((String)new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string4).append(string3).append("/").append(string2).toString());
            if (context == null) throw new zza("Failed to get dynamite module ContentResolver.");
            string4 = context.getContentResolver();
            if (string4 == null) {
                throw new zza("Failed to get dynamite module ContentResolver.");
            }
            cursor = string4.query(uri, null, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new zza("Failed to connect to dynamite module ContentResolver.");
            }
            int n = cursor.getInt(0);
            if (n > 0) {
                Class<DynamiteModule> clazz = DynamiteModule.class;
                // MONITORENTER : com.google.android.gms.dynamite.DynamiteModule.class
                byte[] byArray = Base64.decode((String)cursor.getString(3), (int)0);
                zzaQs.put(new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(":").append(n).toString(), byArray);
                zzaQt = cursor.getString(2);
                // MONITOREXIT : clazz
            }
            int n2 = n;
            return n2;
        }
    }

    public static int zzB(Context context, String string2) {
        return DynamiteModule.zzb(context, string2, false);
    }

    private static DynamiteModule zzC(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new DynamiteModule(context.getApplicationContext());
    }

    private static DynamiteModule zza(Context context, String string2, int n) throws zza {
        zzd zzd2;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        com.google.android.gms.dynamite.zza zza2 = DynamiteModule.zzaU(context);
        if (zza2 == null) {
            throw new zza("Failed to create IDynamiteLoader.");
        }
        try {
            zzd2 = zza2.zza(zze.zzA(context), string2, n);
        }
        catch (RemoteException remoteException) {
            throw new zza("Failed to load remote module.", remoteException);
        }
        if (zze.zzE(zzd2) == null) {
            throw new zza("Failed to load remote module.");
        }
        return new DynamiteModule((Context)zze.zzE(zzd2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static com.google.android.gms.dynamite.zza zzaU(Context context) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            if (zzaQr != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zzaQr;
            }
            if (zzc.zzuz().isGooglePlayServicesAvailable(context) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            try {
                Context context2 = context.createPackageContext("com.google.android.gms", 3);
                ClassLoader classLoader = context2.getClassLoader();
                Class<?> clazz2 = classLoader.loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl");
                IBinder iBinder = (IBinder)clazz2.newInstance();
                com.google.android.gms.dynamite.zza zza2 = zza.zza.zzce(iBinder);
                if (zza2 != null) {
                    zzaQr = zza2;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return zza2;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    public Context zzBd() {
        return this.zzaQB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zzb(Context context, String string2, int n) throws zza {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Context context2 = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            byte[] byArray = zzaQs.get(new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(":").append(n).toString());
            String string3 = zzaQt;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (byArray == null) {
                throw new zza("Module implementation could not be found.");
            }
            context2 = context.getApplicationContext();
            Context context3 = DynamiteModule.zza(context2, string2, byArray, string3);
            if (context3 == null) {
                throw new zza("Failed to get module context");
            }
            return new DynamiteModule(context3);
        }
    }

    private static Context zza(Context context, String string2, byte[] byArray, String string3) {
        if (string3 == null || string3.isEmpty()) {
            Log.e((String)"DynamiteModule", (String)"No valid DynamiteLoader APK path");
            return null;
        }
        try {
            ClassLoader classLoader = DynamiteModule.zzD(context, string3);
            com.google.android.gms.dynamite.zzb zzb2 = zzb.zza.zzcf((IBinder)classLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]));
            zzd zzd2 = zzb2.zza(zze.zzA(context), string2, byArray);
            return (Context)zze.zzE(zzd2);
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.toString());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load DynamiteLoader: ".concat(string4) : new String("Failed to load DynamiteLoader: ")));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader zzD(Context context, String string2) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        Class<DynamiteLoaderClassLoader> clazz = DynamiteLoaderClassLoader.class;
        synchronized (DynamiteLoaderClassLoader.class) {
            if (DynamiteLoaderClassLoader.sClassLoader != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return DynamiteLoaderClassLoader.sClassLoader;
            }
            ClassLoader classLoader = context.getApplicationContext().getClassLoader();
            Class<?> clazz2 = classLoader.loadClass(DynamiteLoaderClassLoader.class.getName());
            Field field = clazz2.getDeclaredField("sClassLoader");
            Class<?> clazz3 = clazz2;
            synchronized (clazz3) {
                DynamiteLoaderClassLoader.sClassLoader = (ClassLoader)field.get(null);
                if (DynamiteLoaderClassLoader.sClassLoader != null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4, 7] lbl15 : MonitorExitStatement: MONITOREXIT : var6_6
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return DynamiteLoaderClassLoader.sClassLoader;
                }
                DynamiteLoaderClassLoader.sClassLoader = new PathClassLoader(string2, ClassLoader.getSystemClassLoader()){

                    protected Class<?> loadClass(String string2, boolean bl) throws ClassNotFoundException {
                        if (!string2.startsWith("java.") && !string2.startsWith("android.")) {
                            try {
                                return this.findClass(string2);
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                        return super.loadClass(string2, bl);
                    }
                };
                field.set(null, DynamiteLoaderClassLoader.sClassLoader);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var6_6
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return DynamiteLoaderClassLoader.sClassLoader;
            }
        }
    }

    public IBinder zzdX(String string2) throws zza {
        try {
            Class<?> clazz = this.zzaQB.getClassLoader().loadClass(string2);
            return (IBinder)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new zza(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException);
        }
    }

    private DynamiteModule(Context context) {
        this.zzaQB = zzac.zzw(context);
    }

    static {
        zzaQs = new HashMap();
        zzaQu = new zzb.zza(){

            @Override
            public int zzb(Context context, String string2, boolean bl) throws zza {
                return DynamiteModule.zzb(context, string2, bl);
            }

            @Override
            public int zzA(Context context, String string2) {
                return DynamiteModule.zzA(context, string2);
            }

            @Override
            public DynamiteModule zza(Context context, String string2, int n) throws zza {
                return DynamiteModule.zza(context, string2, n);
            }
        };
        zzaQv = new zzb.zza(){

            @Override
            public int zzb(Context context, String string2, boolean bl) throws zza {
                return DynamiteModule.zzc(context, string2, bl);
            }

            @Override
            public int zzA(Context context, String string2) {
                return DynamiteModule.zzA(context, string2);
            }

            @Override
            public DynamiteModule zza(Context context, String string2, int n) throws zza {
                return DynamiteModule.zzb(context, string2, n);
            }
        };
        zzaQw = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaQE = zza2.zzb(context, string2, true);
                if (zzb2.zzaQE != 0) {
                    zzb2.zzaQF = 1;
                } else {
                    zzb2.zzaQD = zza2.zzA(context, string2);
                    if (zzb2.zzaQD != 0) {
                        zzb2.zzaQF = -1;
                    }
                }
                return zzb2;
            }
        };
        zzaQx = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaQD = zza2.zzA(context, string2);
                if (zzb2.zzaQD != 0) {
                    zzb2.zzaQF = -1;
                } else {
                    zzb2.zzaQE = zza2.zzb(context, string2, true);
                    if (zzb2.zzaQE != 0) {
                        zzb2.zzaQF = 1;
                    }
                }
                return zzb2;
            }
        };
        zzaQy = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaQD = zza2.zzA(context, string2);
                zzb2.zzaQE = zza2.zzb(context, string2, true);
                zzb2.zzaQF = zzb2.zzaQD == 0 && zzb2.zzaQE == 0 ? 0 : (zzb2.zzaQD >= zzb2.zzaQE ? -1 : 1);
                return zzb2;
            }
        };
        zzaQz = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaQD = zza2.zzA(context, string2);
                zzb2.zzaQE = zza2.zzb(context, string2, true);
                zzb2.zzaQF = zzb2.zzaQD == 0 && zzb2.zzaQE == 0 ? 0 : (zzb2.zzaQE >= zzb2.zzaQD ? 1 : -1);
                return zzb2;
            }
        };
        zzaQA = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaQD = zza2.zzA(context, string2);
                zzb2.zzaQE = zzb2.zzaQD != 0 ? zza2.zzb(context, string2, false) : zza2.zzb(context, string2, true);
                zzb2.zzaQF = zzb2.zzaQD == 0 && zzb2.zzaQE == 0 ? 0 : (zzb2.zzaQE >= zzb2.zzaQD ? 1 : -1);
                return zzb2;
            }
        };
    }

    @DynamiteApi
    public static class DynamiteLoaderClassLoader {
        public static ClassLoader sClassLoader;
    }

    public static class zza
    extends Exception {
        private zza(String string2) {
            super(string2);
        }

        private zza(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }

    public static interface com.google.android.gms.dynamite.DynamiteModule$zzb {
        public zzb zza(Context var1, String var2, zza var3) throws com.google.android.gms.dynamite.DynamiteModule$zza;

        public static class zzb {
            public int zzaQD = 0;
            public int zzaQE = 0;
            public int zzaQF = 0;
        }

        public static interface zza {
            public int zzb(Context var1, String var2, boolean var3) throws com.google.android.gms.dynamite.DynamiteModule$zza;

            public int zzA(Context var1, String var2);

            public DynamiteModule zza(Context var1, String var2, int var3) throws com.google.android.gms.dynamite.DynamiteModule$zza;
        }
    }
}

