/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzmb;
import java.util.Locale;

@zzmb
public final class zznf {
    public final int zzUa;
    public final boolean zzUb;
    public final boolean zzUc;
    public final String zzUd;
    public final String zzUe;
    public final boolean zzUf;
    public final boolean zzUg;
    public final boolean zzUh;
    public final boolean zzUi;
    public final String zzUj;
    public final String zzUk;
    public final int zzUl;
    public final int zzUm;
    public final int zzUn;
    public final int zzUo;
    public final int zzUp;
    public final int zzUq;
    public final float zzxa;
    public final int zzRn;
    public final int zzRo;
    public final double zzUr;
    public final boolean zzUs;
    public final boolean zzUt;
    public final int zzUu;
    public final String zzUv;
    public final boolean zzUw;

    zznf(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6, boolean bl9) {
        this.zzUa = n;
        this.zzUb = bl;
        this.zzUc = bl2;
        this.zzUd = string2;
        this.zzUe = string3;
        this.zzUf = bl3;
        this.zzUg = bl4;
        this.zzUh = bl5;
        this.zzUi = bl6;
        this.zzUj = string4;
        this.zzUk = string5;
        this.zzUl = n2;
        this.zzUm = n3;
        this.zzUn = n4;
        this.zzUo = n5;
        this.zzUp = n6;
        this.zzUq = n7;
        this.zzxa = f;
        this.zzRn = n8;
        this.zzRo = n9;
        this.zzUr = d;
        this.zzUs = bl7;
        this.zzUt = bl8;
        this.zzUu = n10;
        this.zzUv = string6;
        this.zzUw = bl9;
    }

    public static final class zza {
        private int zzUa;
        private boolean zzUh;
        private boolean zzUi;
        private int zzUl;
        private int zzUp;
        private int zzUq;
        private String zzUd;
        private int zzUm;
        private int zzUn;
        private int zzUo;
        private boolean zzUt;
        private int zzUu;
        private double zzUr;
        private boolean zzUs;
        private String zzUv;
        private boolean zzUb;
        private boolean zzUc;
        private String zzUe;
        private boolean zzUf;
        private boolean zzUg;
        private String zzUj;
        private String zzUk;
        private float zzxa;
        private int zzRn;
        private int zzRo;
        private boolean zzUw;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzs(context);
            this.zza(context, packageManager);
            this.zzt(context);
            Locale locale = Locale.getDefault();
            this.zzUb = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzUc = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzUe = locale.getCountry();
            this.zzUf = zzeh.zzeO().zzkI();
            this.zzUg = zzi.zzaK((Context)context);
            this.zzUj = locale.getLanguage();
            this.zzUk = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzxa = displayMetrics.density;
            this.zzRn = displayMetrics.widthPixels;
            this.zzRo = displayMetrics.heightPixels;
        }

        public zza(Context context, zznf zznf2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzs(context);
            this.zza(context, packageManager);
            this.zzt(context);
            this.zzu(context);
            this.zzUb = zznf2.zzUb;
            this.zzUc = zznf2.zzUc;
            this.zzUe = zznf2.zzUe;
            this.zzUf = zznf2.zzUf;
            this.zzUg = zznf2.zzUg;
            this.zzUj = zznf2.zzUj;
            this.zzUk = zznf2.zzUk;
            this.zzxa = zznf2.zzxa;
            this.zzRn = zznf2.zzRn;
            this.zzRo = zznf2.zzRo;
        }

        private void zzs(Context context) {
            AudioManager audioManager = zzv.zzcJ().zzG(context);
            if (audioManager != null) {
                try {
                    this.zzUa = audioManager.getMode();
                    this.zzUh = audioManager.isMusicActive();
                    this.zzUi = audioManager.isSpeakerphoneOn();
                    this.zzUl = audioManager.getStreamVolume(3);
                    this.zzUp = audioManager.getRingerMode();
                    this.zzUq = audioManager.getStreamVolume(2);
                    return;
                }
                catch (Throwable throwable) {
                    zzv.zzcN().zza(throwable, "DeviceInfo.gatherAudioInfo");
                }
            }
            this.zzUa = -2;
            this.zzUh = false;
            this.zzUi = false;
            this.zzUl = 0;
            this.zzUp = 0;
            this.zzUq = 0;
        }

        @TargetApi(value=16)
        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzUd = telephonyManager.getNetworkOperator();
            this.zzUn = telephonyManager.getNetworkType();
            this.zzUo = telephonyManager.getPhoneType();
            this.zzUm = -2;
            this.zzUt = false;
            this.zzUu = -1;
            if (zzv.zzcJ().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzUm = networkInfo.getType();
                    this.zzUu = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzUm = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzUt = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzt(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzUr = (float)n2 / (float)n3;
                this.zzUs = n == 2 || n == 5;
            } else {
                this.zzUr = -1.0;
                this.zzUs = false;
            }
        }

        private void zzu(Context context) {
            this.zzUv = Build.FINGERPRINT;
            this.zzUw = zzgl.zzn(context);
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                String string2;
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                if (packageInfo != null) {
                    int n = packageInfo.versionCode;
                    String string3 = String.valueOf(activityInfo.packageName);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append(n).append(".").append(string3).toString();
                } else {
                    string2 = null;
                }
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zznf zzjn() {
            return new zznf(this.zzUa, this.zzUb, this.zzUc, this.zzUd, this.zzUe, this.zzUf, this.zzUg, this.zzUh, this.zzUi, this.zzUj, this.zzUk, this.zzUl, this.zzUm, this.zzUn, this.zzUo, this.zzUp, this.zzUq, this.zzxa, this.zzRn, this.zzRo, this.zzUr, this.zzUs, this.zzUt, this.zzUu, this.zzUv, this.zzUw);
        }
    }
}

