/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzmb;

@zzmb
public class zzec
extends zza {
    public static final Parcelable.Creator<zzec> CREATOR = new zzed();
    public final int versionCode;
    public final String zzzk;
    public final int height;
    public final int heightPixels;
    public final boolean zzzl;
    public final int width;
    public final int widthPixels;
    public final zzec[] zzzm;
    public final boolean zzzn;
    public final boolean zzzo;
    public boolean zzzp;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)zzec.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zzec zzj(Context context) {
        return new zzec(5, "320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static zzec zzez() {
        return new zzec(5, "reward_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzec() {
        this(5, "interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzec(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public zzec(Context context, AdSize[] adSizeArray) {
        int n;
        AdSize adSize = adSizeArray[0];
        this.versionCode = 5;
        this.zzzl = false;
        this.zzzo = adSize.isFluid();
        if (this.zzzo) {
            this.width = AdSize.BANNER.getWidth();
            this.height = AdSize.BANNER.getHeight();
        } else {
            this.width = adSize.getWidth();
            this.height = adSize.getHeight();
        }
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzeh.zzeO().zzQ(context) && zzeh.zzeO().zzR(context) ? zzec.zza(displayMetrics) - zzeh.zzeO().zzS(context) : zzec.zza(displayMetrics);
            double d = (float)this.widthPixels / displayMetrics.density;
            n = (int)d;
            if (d - (double)((int)d) >= 0.01) {
                ++n;
            }
        } else {
            n = this.width;
            this.widthPixels = zzeh.zzeO().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? zzec.zzc(displayMetrics) : this.height;
        this.heightPixels = zzeh.zzeO().zza(displayMetrics, n2);
        if (bl || bl2) {
            int n3 = n;
            this.zzzk = new StringBuilder(26).append(n3).append("x").append(n2).append("_as").toString();
        } else {
            this.zzzk = this.zzzo ? "320x50_mb" : adSize.toString();
        }
        if (adSizeArray.length > 1) {
            this.zzzm = new zzec[adSizeArray.length];
            for (int i = 0; i < adSizeArray.length; ++i) {
                this.zzzm[i] = new zzec(context, adSizeArray[i]);
            }
        } else {
            this.zzzm = null;
        }
        this.zzzn = false;
        this.zzzp = false;
    }

    public zzec(zzec zzec2, zzec[] zzecArray) {
        this(5, zzec2.zzzk, zzec2.height, zzec2.heightPixels, zzec2.zzzl, zzec2.width, zzec2.widthPixels, zzecArray, zzec2.zzzn, zzec2.zzzo, zzec2.zzzp);
    }

    zzec(int n, String string, int n2, int n3, boolean bl, int n4, int n5, zzec[] zzecArray, boolean bl2, boolean bl3, boolean bl4) {
        this.versionCode = n;
        this.zzzk = string;
        this.height = n2;
        this.heightPixels = n3;
        this.zzzl = bl;
        this.width = n4;
        this.widthPixels = n5;
        this.zzzm = zzecArray;
        this.zzzn = bl2;
        this.zzzo = bl3;
        this.zzzp = bl4;
    }

    public AdSize zzeA() {
        return com.google.android.gms.ads.zza.zza(this.width, this.height, this.zzzk);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzed.zza(this, parcel, n);
    }

    public void zzl(boolean bl) {
        this.zzzp = bl;
    }
}

