/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Debug;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcp;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzek;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzht;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zznq;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzpa;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpe;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzmb
public abstract class zza
extends zzep.zza
implements zzq,
zzdt,
zzht,
zzln.zza,
zzmc.zza,
zzpa {
    protected zzgf zzsr;
    protected zzgd zzss;
    protected zzgd zzst;
    protected boolean zzsu = false;
    protected final zzs zzsv;
    protected final zzw zzsw;
    @Nullable
    protected transient zzdy zzsx;
    protected final zzcp zzsy;
    protected final zzd zzsz;

    public zzd zzbz() {
        return this.zzsz;
    }

    zza(zzw zzw2, @Nullable zzs zzs2, zzd zzd2) {
        this.zzsw = zzw2;
        this.zzsv = zzs2 != null ? zzs2 : new zzs(this);
        this.zzsz = zzd2;
        zzv.zzcJ().zzz(this.zzsw.zzqr);
        zzv.zzcN().zzc(this.zzsw.zzqr, this.zzsw.zzvf);
        zzv.zzcO().initialize(this.zzsw.zzqr);
        this.zzsy = zzv.zzcN().zzjZ();
        zzv.zzcM().initialize(this.zzsw.zzqr);
        this.zzbA();
    }

    private void zzbA() {
        if (zzfx.zzEf.get().booleanValue()) {
            Timer timer = new Timer();
            CountDownLatch countDownLatch = new CountDownLatch(zzfx.zzEh.get());
            TimerTask timerTask = this.zza(timer, countDownLatch);
            timer.schedule(timerTask, 0L, (long)zzfx.zzEg.get());
        }
    }

    private TimerTask zza(final Timer timer, final CountDownLatch countDownLatch) {
        return new TimerTask(){

            @Override
            public void run() {
                if ((long)zzfx.zzEh.get().intValue() != countDownLatch.getCount()) {
                    zzpe.zzbc((String)"Stopping method tracing");
                    Debug.stopMethodTracing();
                    if (countDownLatch.getCount() == 0L) {
                        timer.cancel();
                        return;
                    }
                }
                String string2 = String.valueOf(zza.this.zzsw.zzqr.getPackageName()).concat("_adsTrace_");
                try {
                    zzpe.zzbc((String)"Starting method tracing");
                    countDownLatch.countDown();
                    long l = zzv.zzcP().currentTimeMillis();
                    Debug.startMethodTracing((String)new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l).toString(), (int)zzfx.zzEi.get());
                }
                catch (Exception exception) {
                    zzpe.zzc((String)"Exception occurred while starting method tracing.", (Throwable)exception);
                    return;
                }
            }
        };
    }

    public void zzbB() {
        this.zzsr = new zzgf(zzfx.zzBK.get(), "load_ad", this.zzsw.zzvj.zzzk);
        this.zzss = new zzgd(-1L, null, null);
        this.zzst = new zzgd(-1L, null, null);
    }

    public void destroy() {
        zzac.zzdn((String)"destroy must be called on the main UI thread.");
        this.zzsv.cancel();
        this.zzsy.zzk(this.zzsw.zzvk);
        this.zzsw.destroy();
    }

    public com.google.android.gms.dynamic.zzd zzbC() {
        zzac.zzdn((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzA((Object)((Object)this.zzsw.zzvg));
    }

    @Nullable
    public zzec zzbD() {
        zzac.zzdn((String)"getAdSize must be called on the main UI thread.");
        return this.zzsw.zzvj == null ? null : new zzfl(this.zzsw.zzvj);
    }

    public boolean isReady() {
        zzac.zzdn((String)"isLoaded must be called on the main UI thread.");
        return this.zzsw.zzvh == null && this.zzsw.zzvi == null && this.zzsw.zzvk != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private zzdy zza(zzdy zzdy2) {
        if (zzi.zzaK((Context)this.zzsw.zzqr) && zzdy2.zzyN != null) {
            return new zzdz(zzdy2).zza(null).zzex();
        }
        return zzdy2;
    }

    public boolean zzb(zzdy zzdy2) {
        zzac.zzdn((String)"loadAd must be called on the main UI thread.");
        zzv.zzcO().zzeq();
        if (zzfx.zzCy.get().booleanValue()) {
            zzdy.zzj((zzdy)zzdy2);
        }
        zzdy2 = this.zza(zzdy2);
        if (this.zzsw.zzvh != null || this.zzsw.zzvi != null) {
            if (this.zzsx != null) {
                zzpe.zzbe((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzpe.zzbe((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzsx = zzdy2;
            return false;
        }
        zzpe.zzbd((String)"Starting ad request.");
        this.zzbB();
        this.zzss = this.zzsr.zzfw();
        if (!zzdy2.zzyI) {
            String string2 = String.valueOf(zzeh.zzeO().zzO(this.zzsw.zzqr));
            zzpe.zzbd((String)new StringBuilder(71 + String.valueOf(string2).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string2).append("\") to get test ads on this device.").toString());
        }
        this.zzsv.zzg(zzdy2);
        this.zzsu = this.zza(zzdy2, this.zzsr);
        return this.zzsu;
    }

    protected abstract boolean zza(zzdy var1, zzgf var2);

    @Override
    public void zza(zzov.zza zza2) {
        long l;
        if (zza2.zzVB.zzRO != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzVB.zzRX) && (l = this.zzw(zza2.zzVB.zzRX)) != -1L) {
            zzgd zzgd2 = this.zzsr.zzc(zza2.zzVB.zzRO + l);
            this.zzsr.zza(zzgd2, "stc");
        }
        this.zzsr.zzX(zza2.zzVB.zzRX);
        this.zzsr.zza(this.zzss, "arf");
        this.zzst = this.zzsr.zzfw();
        this.zzsr.zzg("gqi", zza2.zzVB.zzRY);
        this.zzsw.zzvh = null;
        this.zzsw.zzvl = zza2;
        this.zza(zza2, this.zzsr);
    }

    protected abstract void zza(zzov.zza var1, zzgf var2);

    boolean zza(zzov zzov2) {
        return false;
    }

    @Override
    public void zzb(zzov zzov2) {
        this.zzsr.zza(this.zzst, "awr");
        this.zzsw.zzvi = null;
        if (zzov2.errorCode != -2 && zzov2.errorCode != 3) {
            zzv.zzcN().zzb(this.zzsw.zzdi());
        }
        if (zzov2.errorCode == -1) {
            this.zzsu = false;
            return;
        }
        if (this.zza(zzov2)) {
            zzpe.zzbc((String)"Ad refresh scheduled.");
        }
        if (zzov2.errorCode != -2) {
            this.zzh(zzov2.errorCode);
            return;
        }
        if (this.zzsw.zzvD == null) {
            this.zzsw.zzvD = new zzpb(this.zzsw.zzvd);
        }
        this.zzsy.zzj(this.zzsw.zzvk);
        if (this.zza(this.zzsw.zzvk, zzov2)) {
            this.zzsw.zzvk = zzov2;
            this.zzsw.zzdr();
            this.zzsr.zzg("is_mraid", this.zzsw.zzvk.zzdz() ? "1" : "0");
            this.zzsr.zzg("is_mediation", this.zzsw.zzvk.zzRK ? "1" : "0");
            if (this.zzsw.zzvk.zzMZ != null && this.zzsw.zzvk.zzMZ.zzkV() != null) {
                this.zzsr.zzg("is_delay_pl", this.zzsw.zzvk.zzMZ.zzkV().zzlr() ? "1" : "0");
            }
            this.zzsr.zza(this.zzss, "ttc");
            if (zzv.zzcN().zzjN() != null) {
                zzv.zzcN().zzjN().zza(this.zzsr);
            }
            if (this.zzsw.zzdm()) {
                this.zzbK();
            }
        }
        if (zzov2.zzKb != null) {
            zzv.zzcJ().zza(this.zzsw.zzqr, zzov2.zzKb);
        }
    }

    protected abstract boolean zza(@Nullable zzov var1, zzov var2);

    public void onAdClicked() {
        if (this.zzsw.zzvk == null) {
            zzpe.zzbe((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzpe.zzbc((String)"Pinging click URLs.");
        if (this.zzsw.zzvm != null) {
            this.zzsw.zzvm.zzjA();
        }
        if (this.zzsw.zzvk.zzJY != null) {
            zzv.zzcJ().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, this.zzsw.zzvk.zzJY);
        }
        if (this.zzsw.zzvn != null) {
            try {
                this.zzsw.zzvn.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zzbE() {
        this.zzbI();
    }

    @Override
    public void onAppEvent(String string2, @Nullable String string3) {
        if (this.zzsw.zzvp != null) {
            try {
                this.zzsw.zzvp.onAppEvent(string2, string3);
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public void zzbF() {
        zzac.zzdn((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzsw.zzvk == null) {
            zzpe.zzbe((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzpe.zzbc((String)"Pinging manual tracking URLs.");
        if (this.zzsw.zzvk.zzRM != null && !this.zzsw.zzvk.zzVz) {
            zzv.zzcJ().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, this.zzsw.zzvk.zzRM);
            this.zzsw.zzvk.zzVz = true;
            this.zzd(this.zzsw.zzvk);
        }
    }

    public void pause() {
        zzac.zzdn((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzac.zzdn((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(zzdy zzdy2) {
        if (this.zzsw.zzvg == null) {
            return false;
        }
        ViewParent viewParent = this.zzsw.zzvg.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzv.zzcJ().zza(view, view.getContext());
    }

    public void zzd(zzdy zzdy2) {
        if (this.zzc(zzdy2)) {
            this.zzb(zzdy2);
        } else {
            zzpe.zzbd((String)"Ad is not visible. Not refreshing ad.");
            this.zzsv.zzh(zzdy2);
        }
    }

    public void zza(zzel zzel2) {
        zzac.zzdn((String)"setAdListener must be called on the main UI thread.");
        this.zzsw.zzvo = zzel2;
    }

    public void zza(zznt zznt2) {
        zzac.zzdn((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzsw.zzvA = zznt2;
    }

    public void setUserId(String string2) {
        zzpe.zzbe((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public void zza(zzek zzek2) {
        zzac.zzdn((String)"setAdListener must be called on the main UI thread.");
        this.zzsw.zzvn = zzek2;
    }

    public void zza(zzec zzec2) {
        zzac.zzdn((String)"setAdSize must be called on the main UI thread.");
        this.zzsw.zzvj = zzec2;
        if (this.zzsw.zzvk != null && this.zzsw.zzvk.zzMZ != null && this.zzsw.zzvF == 0) {
            this.zzsw.zzvk.zzMZ.zza(zzec2);
        }
        if (this.zzsw.zzvg == null) {
            return;
        }
        if (this.zzsw.zzvg.getChildCount() > 1) {
            this.zzsw.zzvg.removeView(this.zzsw.zzvg.getNextView());
        }
        this.zzsw.zzvg.setMinimumWidth(zzec2.widthPixels);
        this.zzsw.zzvg.setMinimumHeight(zzec2.heightPixels);
        this.zzsw.zzvg.requestLayout();
    }

    public void zza(zzer zzer2) {
        zzac.zzdn((String)"setAppEventListener must be called on the main UI thread.");
        this.zzsw.zzvp = zzer2;
    }

    public void zza(zzkz zzkz2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zzgj zzgj2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public void zza(zzld zzld2, String string2) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public void zza(zzet zzet2) {
        zzac.zzdn((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzsw.zzvq = zzet2;
    }

    public void stopLoading() {
        zzac.zzdn((String)"stopLoading must be called on the main UI thread.");
        this.zzsu = false;
        this.zzsw.zzi(true);
    }

    public boolean isLoading() {
        return this.zzsu;
    }

    public zzew zzbG() {
        return null;
    }

    public void zza(@Nullable zzfn zzfn2) {
        zzac.zzdn((String)"setVideoOptions must be called on the main UI thread.");
        this.zzsw.zzvy = zzfn2;
    }

    long zzw(String string2) {
        int n = string2.indexOf("ufe");
        int n2 = string2.indexOf(44, n);
        if (n2 == -1) {
            n2 = string2.length();
        }
        try {
            return Long.parseLong(string2.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzpe.zzbe((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzpe.zzbe((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        zzw.zza zza2 = this.zzsw.zzvg;
        if (zza2 != null) {
            zza2.addView(view, zzv.zzcL().zzks());
        }
    }

    protected void zzbH() {
        zzpe.zzbd((String)"Ad closing.");
        if (this.zzsw.zzvo != null) {
            try {
                this.zzsw.zzvo.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzsw.zzvA != null) {
            try {
                this.zzsw.zzvA.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbI() {
        zzpe.zzbd((String)"Ad leaving application.");
        if (this.zzsw.zzvo != null) {
            try {
                this.zzsw.zzvo.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzsw.zzvA != null) {
            try {
                this.zzsw.zzvA.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbJ() {
        zzpe.zzbd((String)"Ad opening.");
        if (this.zzsw.zzvo != null) {
            try {
                this.zzsw.zzvo.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzsw.zzvA != null) {
            try {
                this.zzsw.zzvA.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbK() {
        zzpe.zzbd((String)"Ad finished loading.");
        this.zzsu = false;
        if (this.zzsw.zzvo != null) {
            try {
                this.zzsw.zzvo.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzsw.zzvA != null) {
            try {
                this.zzsw.zzvA.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zzh(int n) {
        zzpe.zzbe((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzsu = false;
        if (this.zzsw.zzvo != null) {
            try {
                this.zzsw.zzvo.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzsw.zzvA != null) {
            try {
                this.zzsw.zzvA.onRewardedVideoAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbL() {
        if (this.zzsw.zzvA == null) {
            return;
        }
        try {
            this.zzsw.zzvA.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzpe.zzc((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
        }
    }

    protected void zza(@Nullable zzok zzok2) {
        if (this.zzsw.zzvA == null) {
            return;
        }
        try {
            String string2 = "";
            int n = 0;
            if (zzok2 != null) {
                string2 = zzok2.type;
                n = zzok2.zzVj;
            }
            this.zzsw.zzvA.zza((zznq)new zznn(string2, n));
        }
        catch (RemoteException remoteException) {
            zzpe.zzc((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
        }
    }

    protected void zzc(@Nullable zzov zzov2) {
        if (zzov2 == null) {
            zzpe.zzbe((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzpe.zzbc((String)"Pinging Impression URLs.");
        if (this.zzsw.zzvm != null) {
            this.zzsw.zzvm.zzjz();
        }
        if (zzov2.zzJZ != null && !zzov2.zzVy) {
            zzv.zzcJ().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, zzov2.zzJZ);
            zzov2.zzVy = true;
            this.zzd(zzov2);
        }
    }

    private void zzd(zzov zzov2) {
        if (!zzv.zzcR().zzkz() || zzov2.zzVA || TextUtils.isEmpty((CharSequence)zzov2.zzSg)) {
            return;
        }
        zzpe.zzbc((String)"Sending troubleshooting signals to the server.");
        zzv.zzcR().zza(this.zzsw.zzqr, this.zzsw.zzvf.zzaZ, zzov2.zzSg, this.zzsw.zzvd);
        zzov2.zzVA = true;
    }

    @Override
    public void zza(HashSet<zzow> hashSet) {
        this.zzsw.zza(hashSet);
    }
}

