/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.internal.zzez;
import com.google.android.gms.internal.zzpy;

public final class PublisherAdView
extends ViewGroup {
    private final zzez zzrJ;

    public PublisherAdView(Context context) {
        super(context);
        this.zzrJ = new zzez(this);
    }

    public PublisherAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzrJ = new zzez(this, attributeSet, true);
    }

    public PublisherAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzrJ = new zzez(this, attributeSet, true);
    }

    public void destroy() {
        this.zzrJ.destroy();
    }

    public AdListener getAdListener() {
        return this.zzrJ.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzrJ.getAdSize();
    }

    public AdSize[] getAdSizes() {
        return this.zzrJ.getAdSizes();
    }

    public String getAdUnitId() {
        return this.zzrJ.getAdUnitId();
    }

    public AppEventListener getAppEventListener() {
        return this.zzrJ.getAppEventListener();
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzrJ.getOnCustomRenderedAdLoadedListener();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zzrJ.zza(publisherAdRequest.zzbq());
    }

    public void pause() {
        this.zzrJ.pause();
    }

    public void setManualImpressionsEnabled(boolean bl) {
        this.zzrJ.setManualImpressionsEnabled(bl);
    }

    public void recordManualImpression() {
        this.zzrJ.recordManualImpression();
    }

    public void resume() {
        this.zzrJ.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.zzrJ.setAdListener(adListener);
    }

    public void setAdSizes(AdSize ... adSizeArray) {
        if (adSizeArray == null || adSizeArray.length < 1) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.zzrJ.zza(adSizeArray);
    }

    public void setAdUnitId(String string) {
        this.zzrJ.setAdUnitId(string);
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        this.zzrJ.setAppEventListener(appEventListener);
    }

    public void setCorrelator(Correlator correlator) {
        this.zzrJ.setCorrelator(correlator);
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzrJ.setOnCustomRenderedAdLoadedListener(onCustomRenderedAdLoadedListener);
    }

    public String getMediationAdapterClassName() {
        return this.zzrJ.getMediationAdapterClassName();
    }

    public boolean isLoading() {
        return this.zzrJ.isLoading();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzpy.zzb("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

