/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.ClientApi;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzbuz;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.internal.zzph;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqp;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzpi {
    public static final Handler zzWR = new zzpf(Looper.getMainLooper());
    private final Object zzrN = new Object();
    private boolean zzWS = true;
    private String zzHY;
    private boolean zzWT = false;
    private zzja zzSV;

    public Map<String, Integer> zza(View view, WindowManager windowManager) {
        DisplayMetrics displayMetrics = this.zza(windowManager);
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        int[] nArray = new int[2];
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        view.getLocationInWindow(nArray);
        hashMap.put("xInPixels", nArray[0]);
        hashMap.put("yInPixels", nArray[1]);
        hashMap.put("windowWidthInPixels", n);
        hashMap.put("windowHeightInPixels", n2);
        return hashMap;
    }

    public void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        this.zza(context, string2, bl, httpURLConnection, false);
    }

    public void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", this.zzh(context, string2));
        httpURLConnection.setUseCaches(bl2);
    }

    public boolean zzy(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzpe.zzbe((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzpe.zzbe((String)String.format(string2, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzpe.zzbe((String)String.format(string2, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzpe.zzbe((String)String.format(string2, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzpe.zzbe((String)String.format(string2, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzpe.zzbe((String)String.format(string2, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzpe.zzbe((String)String.format(string2, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzpe.zzbe((String)String.format(string2, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public boolean zza(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public boolean zzki() {
        return this.zzWS;
    }

    public void zza(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new zzps(context, string2, string3).zziw();
        }
    }

    public void zzc(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        this.zza(context, string2, arrayList);
    }

    public void zza(List<String> list, String string2) {
        for (String string3 : list) {
            new zzps(string3, string2).zziw();
        }
    }

    public void zza(final Context context, final List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzbuz.zzcf((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzpe.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zzgl.zzn(context)) {
            zzpe.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        final zzgl zzgl2 = new zzgl();
        zzgl.zza zza2 = new zzgl.zza(this){

            @Override
            public void zzfE() {
                for (String string2 : list) {
                    String string3 = String.valueOf(string2);
                    zzpe.zzbd((String)(string3.length() != 0 ? "Pinging url: ".concat(string3) : new String("Pinging url: ")));
                    Uri uri = Uri.parse((String)string2);
                    zzgl2.mayLaunchUrl(uri, null, null);
                }
                zzgl2.zzd((Activity)context);
            }

            @Override
            public void zzfF() {
            }
        };
        zzgl2.zza(zza2);
        zzgl2.zze((Activity)context);
    }

    public String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public boolean zzz(Context context) {
        if (this.zzWT) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zza(), intentFilter);
        this.zzWT = true;
        return true;
    }

    public void zza(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzh(context, string2));
    }

    String zzkj() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzh(final Context context, String string2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzHY != null) {
                return this.zzHY;
            }
            if (string2 == null) {
                return this.zzkj();
            }
            try {
                this.zzHY = zzv.zzcL().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzHY)) {
                if (!zzeh.zzeO().zzkJ()) {
                    this.zzHY = null;
                    zzWR.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = zzpi.this.zzrN;
                            synchronized (object) {
                                zzpi.this.zzHY = zzpi.this.zzA(context);
                                zzpi.this.zzrN.notifyAll();
                            }
                        }
                    });
                    while (this.zzHY == null) {
                        try {
                            this.zzrN.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzHY = this.zzkj();
                            String string3 = String.valueOf(this.zzHY);
                            zzpe.zzbe((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    try {
                        this.zzHY = this.zzA(context);
                    }
                    catch (Exception exception) {
                        this.zzHY = this.zzkj();
                    }
                }
            }
            String string4 = String.valueOf(this.zzHY);
            this.zzHY = new StringBuilder(11 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).append(")").toString();
            return this.zzHY;
        }
    }

    protected String zzA(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public boolean zza(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String zzaV(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public JSONObject zzP(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    private JSONObject zzi(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    JSONArray zza(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            this.zza(jSONArray, object);
        }
        return jSONArray;
    }

    private void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzi((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzP(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)this.zza((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzi((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzP(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string2, object);
        }
    }

    public Map<String, String> zzg(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = zzv.zzcL().zzh(uri);
        for (String string2 : set) {
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    public String zzkk() {
        return UUID.randomUUID().toString();
    }

    public String zzkl() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string2 = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string2 = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return string2;
    }

    public int zzaW(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzpe.zzbe((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public String zzkm() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        return string2.startsWith(string3) ? string2 : new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    protected int[] zzkn() {
        return new int[]{0, 0};
    }

    public int[] zzh(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return this.zzkn();
    }

    public int[] zzi(Activity activity) {
        int[] nArray = this.zzh(activity);
        return new int[]{zzeh.zzeO().zzc((Context)activity, nArray[0]), zzeh.zzeO().zzc((Context)activity, nArray[1])};
    }

    public int[] zzj(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getTop(), view.getBottom()};
        }
        return this.zzkn();
    }

    public int[] zzk(Activity activity) {
        int[] nArray = this.zzj(activity);
        return new int[]{zzeh.zzeO().zzc((Context)activity, nArray[0]), zzeh.zzeO().zzc((Context)activity, nArray[1])};
    }

    public boolean zzaX(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = windowManager.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        return displayMetrics;
    }

    public AlertDialog.Builder zzB(Context context) {
        return new AlertDialog.Builder(context);
    }

    public zzfp zzC(Context context) {
        return new zzfp(context);
    }

    public Bitmap zzp(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, bl);
    }

    public String zzD(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public String zza(Context context, View view, zzec zzec2) {
        if (!zzfx.zzCl.get().booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", zzec2.width);
            jSONObject2.put("height", zzec2.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)this.zzD(context));
            if (!zzec2.zzzl) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzpe.zzc((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public String zza(zzqp zzqp2, String string2) {
        return this.zza(zzqp2.getContext(), zzqp2.zzkX(), string2, zzqp2.getView());
    }

    public String zza(Context context, zzav zzav2, String string2, View view) {
        if (zzav2 == null) {
            return string2;
        }
        try {
            Uri uri = Uri.parse((String)string2);
            if (zzav2.zzd(uri)) {
                uri = zzav2.zza(uri, context, view);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public boolean zzE(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzh(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean zzh(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    public void zza(final Context context, final @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        if (bl) {
            bundle.putString("device", zzv.zzcJ().zzkm());
            bundle.putString("eids", TextUtils.join((CharSequence)",", zzfx.zzfn()));
        }
        zzeh.zzeO().zza(context, string2, string3, bundle, bl, new zzpx.zza(this){

            public void zzu(String string22) {
                zzv.zzcJ().zzc(context, string2, string22);
            }
        });
    }

    public void zzb(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        if (zzfx.zzCR.get().booleanValue()) {
            this.zza(context, string2, string3, bundle, bl);
        }
    }

    public void runOnUiThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            zzWR.post(runnable);
        }
    }

    public static void zzb(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
        } else {
            zzph.zza(runnable);
        }
    }

    private Bitmap zzq(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzpe.zzbe((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzpe.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private Bitmap zzr(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzpe.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public Bitmap zzF(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            if (zzfx.zzDK.get().booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    View view = window.getDecorView().getRootView();
                    bitmap = this.zzr(view);
                }
            } else {
                bitmap = this.zzq(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzpe.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public void zzb(Context context, Intent intent) {
        try {
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public float zzco() {
        zzp zzp2 = zzv.zzdd().zzcn();
        return zzp2 != null && zzp2.zzcp() ? zzp2.zzco() : 1.0f;
    }

    public boolean zzcq() {
        zzp zzp2 = zzv.zzdd().zzcn();
        return zzp2 != null ? zzp2.zzcq() : false;
    }

    public AudioManager zzG(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public float zzH(Context context) {
        AudioManager audioManager = this.zzG(context);
        if (audioManager == null) {
            return 0.0f;
        }
        int n = audioManager.getStreamMaxVolume(3);
        int n2 = audioManager.getStreamVolume(3);
        return n == 0 ? 0.0f : (float)n2 / (float)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzja zzd(Context context, zzqa zzqa2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzSV == null) {
                this.zzSV = new zzja(context.getApplicationContext() != null ? context.getApplicationContext() : context, zzqa2, zzfx.zzAR.get());
            }
            return this.zzSV;
        }
    }

    public int zzI(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return applicationInfo == null ? 0 : applicationInfo.targetSdkVersion;
    }

    public boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return this.zza(view, powerManager, keyguardManager);
    }

    public boolean zza(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = zzv.zzcJ().zzki() || !this.zza(keyguardManager);
        return view.getVisibility() == 0 && view.isShown() && this.zza(powerManager) && bl && (zzfx.zzCM.get() == false || view.getLocalVisibleRect(new Rect()) || view.getGlobalVisibleRect(new Rect()));
    }

    private boolean zza(PowerManager powerManager) {
        return powerManager == null || powerManager.isScreenOn();
    }

    private boolean zza(KeyguardManager keyguardManager) {
        if (keyguardManager == null) {
            return false;
        }
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    public int zzs(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public boolean zzJ(Context context) {
        try {
            context.getClassLoader().loadClass(ClientApi.class.getName());
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    public Bundle zzko() {
        Bundle bundle = new Bundle();
        try {
            Object object;
            if (zzfx.zzBw.get().booleanValue()) {
                object = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)object);
                bundle.putParcelable("debug_memory_info", (Parcelable)object);
            }
            if (zzfx.zzBx.get().booleanValue()) {
                object = Runtime.getRuntime();
                bundle.putLong("runtime_free_memory", ((Runtime)object).freeMemory());
                bundle.putLong("runtime_max_memory", ((Runtime)object).maxMemory());
                bundle.putLong("runtime_total_memory", ((Runtime)object).totalMemory());
            }
        }
        catch (Exception exception) {
            zzpe.zzc((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    public String zzb(String string2, Map<String, String> map) {
        for (String string3 : map.keySet()) {
            string2 = string2.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", string3), String.format("$1%s$2", Uri.encode((String)map.get(string3))));
        }
        return string2.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "[^@]+"), String.format("$1%s$2", "")).replaceAll("@@", "@");
    }

    @TargetApi(value=18)
    public void zza(Context context, Uri uri) {
        try {
            Bundle bundle = new Bundle();
            if (zzfx.zzEP.get().booleanValue() && zzs.zzyE()) {
                bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            }
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(new Intent("android.intent.action.VIEW", uri).putExtras(bundle));
            String string2 = String.valueOf(uri.toString());
            zzpe.zzbc((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzpe.zzb((String)"No browser is found.", (Throwable)activityNotFoundException);
        }
    }

    public void zzd(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Error writing to file in internal storage.", (Throwable)exception);
        }
    }

    public String zzi(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(zzo.zza((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzpe.zzb((String)"Error reading from internal storage.", (Throwable)iOException);
            return "";
        }
    }

    @TargetApi(value=24)
    public boolean zza(Activity activity, Configuration configuration) {
        zzpx zzpx2 = zzeh.zzeO();
        int n = zzpx2.zzb((Context)activity, configuration.screenHeightDp);
        int n2 = zzpx2.zzb((Context)activity, configuration.screenWidthDp);
        Context context = activity.getApplicationContext();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = this.zza(windowManager);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        int n5 = 0;
        int n6 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = activity.getResources().getDimensionPixelSize(n6);
        }
        DisplayMetrics displayMetrics2 = activity.getResources().getDisplayMetrics();
        int n7 = (int)Math.round((double)displayMetrics2.density + 0.5);
        int n8 = n7 * zzfx.zzEX.get();
        return this.zzb(n3, n + n5, n8) && this.zzb(n4, n2, n8);
    }

    boolean zzb(int n, int n2, int n3) {
        int n4 = Math.abs(n - n2);
        return n4 <= n3;
    }

    public Bundle zzK(Context context) {
        zzdb zzdb2 = zzv.zzcN().zzw(context);
        if (zzdb2 == null) {
            return null;
        }
        return this.zza(zzdb2);
    }

    public Bundle zza(zzdb zzdb2) {
        String string2;
        String string3;
        if (zzdb2 == null) {
            return null;
        }
        if (!zzfx.zzBU.get().booleanValue() && !zzfx.zzBW.get().booleanValue()) {
            return null;
        }
        if (zzv.zzcN().zzjJ() && zzv.zzcN().zzjK()) {
            return null;
        }
        if (zzdb2.zzei()) {
            zzdb2.wakeup();
        }
        zzcy zzcy2 = zzdb2.zzeg();
        String string4 = null;
        if (zzcy2 != null) {
            string3 = zzcy2.zzdV();
            string4 = zzcy2.zzdW();
            string2 = zzcy2.zzdX();
            if (string3 != null) {
                zzv.zzcN().zzaS(string3);
            }
            if (string2 != null) {
                zzv.zzcN().zzaT(string2);
            }
        } else {
            string3 = zzv.zzcN().zzjR();
            string2 = zzv.zzcN().zzjS();
        }
        Bundle bundle = new Bundle(1);
        if (string2 != null && zzfx.zzBW.get().booleanValue() && !zzv.zzcN().zzjK()) {
            bundle.putString("v_fp_vertical", string2);
        }
        if (string3 != null && zzfx.zzBU.get().booleanValue() && !zzv.zzcN().zzjJ()) {
            bundle.putString("fingerprint", string3);
            if (!string3.equals(string4)) {
                bundle.putString("v_fp", string4);
            }
        }
        if (!bundle.isEmpty()) {
            return bundle;
        }
        return null;
    }

    private final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzpi.this.zzWS = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzpi.this.zzWS = false;
            }
        }
    }
}

