/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzcw;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpt;
import java.lang.ref.WeakReference;
import java.util.HashSet;

@zzmb
@TargetApi(value=14)
public class zzcv
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzwH = zzfx.zzCO.get();
    private final Context zzvZ;
    private Application zzwI;
    private final WindowManager zzwf;
    private final PowerManager zzwg;
    private final KeyguardManager zzwh;
    @Nullable
    BroadcastReceiver zzwo;
    private WeakReference<ViewTreeObserver> zzwJ;
    WeakReference<View> zzwK;
    private zzcw zzwL;
    private zzpt zzvK = new zzpt(zzwH);
    private boolean zzwn = false;
    private int zzwM = -1;
    private HashSet<zzb> zzwN = new HashSet();
    private DisplayMetrics zzwO;

    public zzcv(Context context, View view) {
        this.zzvZ = context.getApplicationContext();
        this.zzwf = (WindowManager)context.getSystemService("window");
        this.zzwg = (PowerManager)this.zzvZ.getSystemService("power");
        this.zzwh = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzvZ instanceof Application) {
            this.zzwI = (Application)this.zzvZ;
            this.zzwL = new zzcw((Application)this.zzvZ, this);
        }
        this.zzwO = context.getResources().getDisplayMetrics();
        this.zze(view);
    }

    public void zze(View view) {
        View view2;
        View view3 = view2 = this.zzwK != null ? (View)this.zzwK.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzg(view2);
        }
        this.zzwK = new WeakReference<View>(view);
        if (view != null) {
            if (zzv.zzcL().isAttachedToWindow(view)) {
                this.zzf(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }

    public void zza(zzb zzb2) {
        this.zzwN.add(zzb2);
        this.zzl(3);
    }

    private void zzdT() {
        zzv.zzcJ();
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                zzcv.this.zzl(3);
            }
        });
    }

    public void onViewAttachedToWindow(View view) {
        this.zzwM = -1;
        this.zzf(view);
        this.zzl(3);
    }

    public void onViewDetachedFromWindow(View view) {
        this.zzwM = -1;
        this.zzl(3);
        this.zzg(view);
    }

    private void zza(Activity activity, int n) {
        if (this.zzwK == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzwK.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzwM = n;
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zzdT();
    }

    public void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zzdT();
    }

    public void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zzdT();
    }

    public void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzl(3);
        this.zzdT();
    }

    public void onActivityStopped(Activity activity) {
        this.zzl(3);
        this.zzdT();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzl(3);
        this.zzdT();
    }

    public void onActivityDestroyed(Activity activity) {
        this.zzl(3);
        this.zzdT();
    }

    public void onGlobalLayout() {
        this.zzl(2);
    }

    public void onScrollChanged() {
        this.zzl(1);
    }

    private void zzdB() {
        if (this.zzwo != null) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        this.zzwo = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                zzcv.this.zzl(3);
            }
        };
        this.zzvZ.registerReceiver(this.zzwo, intentFilter);
    }

    private void zzdC() {
        if (this.zzwo != null) {
            try {
                this.zzvZ.unregisterReceiver(this.zzwo);
            }
            catch (IllegalStateException illegalStateException) {
                zzpe.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzv.zzcN().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            this.zzwo = null;
        }
    }

    private void zzl(int n) {
        boolean bl;
        if (this.zzwN.size() == 0) {
            return;
        }
        if (this.zzwK == null) {
            return;
        }
        View view = (View)this.zzwK.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        rect5.right = this.zzwf.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzwf.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzpe.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzwM != -1 ? this.zzwM : n2;
        boolean bl6 = bl = !bl3 && zzv.zzcJ().zza(view, this.zzwg, this.zzwh) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzvK.tryAcquire() && bl == this.zzwn) {
            return;
        }
        if (!bl && !this.zzwn && n == 1) {
            return;
        }
        zza zza2 = new zza(zzv.zzcP().elapsedRealtime(), this.zzwg.isScreenOn(), view != null ? zzv.zzcL().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzwO.density, bl);
        for (zzb zzb2 : this.zzwN) {
            zzb2.zza(zza2);
        }
        this.zzwn = bl;
    }

    Rect zza(Rect rect) {
        return new Rect(this.zzm(rect.left), this.zzm(rect.top), this.zzm(rect.right), this.zzm(rect.bottom));
    }

    private int zzm(int n) {
        float f = this.zzwO.density;
        return (int)((float)n / f);
    }

    private void zzf(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzwJ = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzdB();
        if (this.zzwI != null) {
            try {
                this.zzwI.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzwL);
            }
            catch (Exception exception) {
                zzpe.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private void zzg(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzwJ != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzwJ.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzwJ = null;
            }
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        this.zzdC();
        if (this.zzwI != null) {
            try {
                this.zzwI.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzwL);
            }
            catch (Exception exception) {
                zzpe.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    public static interface zzb {
        public void zza(zza var1);
    }

    public static class zza {
        public final long timestamp;
        public final boolean zzwQ;
        public final boolean zzwR;
        public final int zzwS;
        public final Rect zzwT;
        public final Rect zzwU;
        public final Rect zzwV;
        public final boolean zzwW;
        public final Rect zzwX;
        public final boolean zzwY;
        public final Rect zzwZ;
        public final float zzxa;
        public final boolean zzxb;

        public zza(long l, boolean bl, boolean bl2, int n, Rect rect, Rect rect2, Rect rect3, boolean bl3, Rect rect4, boolean bl4, Rect rect5, float f, boolean bl5) {
            this.timestamp = l;
            this.zzwQ = bl;
            this.zzwR = bl2;
            this.zzwS = n;
            this.zzwT = rect;
            this.zzwU = rect2;
            this.zzwV = rect3;
            this.zzwW = bl3;
            this.zzwX = rect4;
            this.zzwY = bl4;
            this.zzwZ = rect5;
            this.zzxa = f;
            this.zzxb = bl5;
        }
    }
}

