/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.KeyEventCompatHoneycomb;
import android.view.KeyEvent;
import android.view.View;

public final class KeyEventCompat {
    static final KeyEventVersionImpl IMPL = Build.VERSION.SDK_INT >= 11 ? new HoneycombKeyEventVersionImpl() : new BaseKeyEventVersionImpl();

    public static int normalizeMetaState(int metaState) {
        return IMPL.normalizeMetaState(metaState);
    }

    public static boolean metaStateHasModifiers(int metaState, int modifiers) {
        return IMPL.metaStateHasModifiers(metaState, modifiers);
    }

    public static boolean metaStateHasNoModifiers(int metaState) {
        return IMPL.metaStateHasNoModifiers(metaState);
    }

    public static boolean hasModifiers(KeyEvent event, int modifiers) {
        return IMPL.metaStateHasModifiers(event.getMetaState(), modifiers);
    }

    public static boolean hasNoModifiers(KeyEvent event) {
        return IMPL.metaStateHasNoModifiers(event.getMetaState());
    }

    @Deprecated
    public static void startTracking(KeyEvent event) {
        event.startTracking();
    }

    @Deprecated
    public static boolean isTracking(KeyEvent event) {
        return event.isTracking();
    }

    @Deprecated
    public static Object getKeyDispatcherState(View view) {
        return view.getKeyDispatcherState();
    }

    @Deprecated
    public static boolean dispatch(KeyEvent event, KeyEvent.Callback receiver, Object state, Object target) {
        return event.dispatch(receiver, (KeyEvent.DispatcherState)state, target);
    }

    public static boolean isCtrlPressed(KeyEvent event) {
        return IMPL.isCtrlPressed(event);
    }

    private KeyEventCompat() {
    }

    static class HoneycombKeyEventVersionImpl
    extends BaseKeyEventVersionImpl {
        HoneycombKeyEventVersionImpl() {
        }

        @Override
        public int normalizeMetaState(int metaState) {
            return KeyEventCompatHoneycomb.normalizeMetaState(metaState);
        }

        @Override
        public boolean metaStateHasModifiers(int metaState, int modifiers) {
            return KeyEventCompatHoneycomb.metaStateHasModifiers(metaState, modifiers);
        }

        @Override
        public boolean metaStateHasNoModifiers(int metaState) {
            return KeyEventCompatHoneycomb.metaStateHasNoModifiers(metaState);
        }

        @Override
        public boolean isCtrlPressed(KeyEvent event) {
            return KeyEventCompatHoneycomb.isCtrlPressed(event);
        }
    }

    static class BaseKeyEventVersionImpl
    implements KeyEventVersionImpl {
        private static final int META_MODIFIER_MASK = 247;
        private static final int META_ALL_MASK = 247;

        BaseKeyEventVersionImpl() {
        }

        private static int metaStateFilterDirectionalModifiers(int metaState, int modifiers, int basic, int left, int right) {
            boolean wantLeftOrRight;
            boolean wantBasic = (modifiers & basic) != 0;
            int directional = left | right;
            boolean bl = wantLeftOrRight = (modifiers & directional) != 0;
            if (wantBasic) {
                if (wantLeftOrRight) {
                    throw new IllegalArgumentException("bad arguments");
                }
                return metaState & ~directional;
            }
            if (wantLeftOrRight) {
                return metaState & ~basic;
            }
            return metaState;
        }

        @Override
        public int normalizeMetaState(int metaState) {
            if ((metaState & 0xC0) != 0) {
                metaState |= 1;
            }
            if ((metaState & 0x30) != 0) {
                metaState |= 2;
            }
            return metaState & 0xF7;
        }

        @Override
        public boolean metaStateHasModifiers(int metaState, int modifiers) {
            metaState = this.normalizeMetaState(metaState) & 0xF7;
            metaState = BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(metaState, modifiers, 1, 64, 128);
            return (metaState = BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(metaState, modifiers, 2, 16, 32)) == modifiers;
        }

        @Override
        public boolean metaStateHasNoModifiers(int metaState) {
            return (this.normalizeMetaState(metaState) & 0xF7) == 0;
        }

        @Override
        public boolean isCtrlPressed(KeyEvent event) {
            return false;
        }
    }

    static interface KeyEventVersionImpl {
        public int normalizeMetaState(int var1);

        public boolean metaStateHasModifiers(int var1, int var2);

        public boolean metaStateHasNoModifiers(int var1);

        public boolean isCtrlPressed(KeyEvent var1);
    }
}

