/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzdu;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzeb;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzej;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpy;
import java.util.concurrent.atomic.AtomicBoolean;

@zzmb
public class zzez {
    private final zzjr zzzU = new zzjr();
    private final zzeb zzrB;
    private final AtomicBoolean zzzV;
    private final VideoController zzzW = new VideoController();
    final zzej zzzX = new zzej(){

        @Override
        public void onAdLoaded() {
            zzez.this.zzzW.zza(zzez.this.zzbt());
            super.onAdLoaded();
        }

        @Override
        public void onAdFailedToLoad(int n) {
            zzez.this.zzzW.zza(zzez.this.zzbt());
            super.onAdFailedToLoad(n);
        }
    };
    private zzdt zzyD;
    private AdListener zzyE;
    private AdSize[] zzzr;
    private AppEventListener zzzq;
    private Correlator zzzY;
    private zzep zzzZ;
    private InAppPurchaseListener zzAa;
    private OnCustomRenderedAdLoadedListener zzAb;
    private PlayStorePurchaseListener zzAc;
    private VideoOptions zzsb;
    private String zztq;
    private String zzAd;
    private ViewGroup zzAe;
    private int zzAf;
    private boolean zzsS;

    public zzez(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzeb.zzey(), 0);
    }

    public zzez(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzeb.zzey(), n);
    }

    public zzez(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzeb.zzey(), 0);
    }

    public zzez(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, bl, zzeb.zzey(), n);
    }

    zzez(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzeb zzeb2, zzep zzep2, int n) {
        this.zzAe = viewGroup;
        this.zzrB = zzeb2;
        this.zzzZ = zzep2;
        this.zzzV = new AtomicBoolean(false);
        this.zzAf = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzef zzef2 = new zzef(context, attributeSet);
                this.zzzr = zzef2.zzm(bl);
                this.zztq = zzef2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzeh.zzeO().zza(viewGroup, new zzec(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzeh.zzeO().zza(viewGroup, zzez.zza(context, this.zzzr[0], this.zzAf), "Ads by Google");
            }
        }
    }

    zzez(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzeb zzeb2, int n) {
        this(viewGroup, attributeSet, bl, zzeb2, null, n);
    }

    public void destroy() {
        try {
            if (this.zzzZ != null) {
                this.zzzZ.destroy();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzyE;
    }

    public AdSize getAdSize() {
        try {
            zzec zzec2;
            if (this.zzzZ != null && (zzec2 = this.zzzZ.zzbD()) != null) {
                return zzec2.zzeA();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to get the current AdSize.", remoteException);
        }
        return this.zzzr != null ? this.zzzr[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzzr;
    }

    public String getAdUnitId() {
        return this.zztq;
    }

    public AppEventListener getAppEventListener() {
        return this.zzzq;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzAa;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzAb;
    }

    public void zza(zzey zzey2) {
        try {
            if (this.zzzZ == null) {
                this.zzfd();
            }
            if (this.zzzZ.zzb(this.zzrB.zza(this.zzAe.getContext(), zzey2))) {
                this.zzzU.zzi(zzey2.zzeY());
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzzZ != null) {
                this.zzzZ.pause();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzzV.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzzZ != null) {
                this.zzzZ.zzbF();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzzZ != null) {
                this.zzzZ.resume();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        this.zzyE = adListener;
        this.zzzX.zza(adListener);
    }

    public void zza(zzdt zzdt2) {
        try {
            this.zzyD = zzdt2;
            if (this.zzzZ != null) {
                this.zzzZ.zza(zzdt2 != null ? new zzdu(zzdt2) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzzr != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzzr = adSizeArray;
        try {
            if (this.zzzZ != null) {
                this.zzzZ.zza(zzez.zza(this.zzAe.getContext(), this.zzzr, this.zzAf));
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzAe.requestLayout();
    }

    public void setAdUnitId(String string) {
        if (this.zztq != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zztq = string;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzzq = appEventListener;
            if (this.zzzZ != null) {
                this.zzzZ.zza(appEventListener != null ? new zzee(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzAc != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzAa = inAppPurchaseListener;
            if (this.zzzZ != null) {
                this.zzzZ.zza(inAppPurchaseListener != null ? new zzle(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzAb = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzzZ != null) {
                this.zzzZ.zza(onCustomRenderedAdLoadedListener != null ? new zzgk(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        if (this.zzAa != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzAc = playStorePurchaseListener;
            this.zzAd = string;
            if (this.zzzZ != null) {
                this.zzzZ.zza(playStorePurchaseListener != null ? new zzli(playStorePurchaseListener) : null, string);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setManualImpressionsEnabled(boolean bl) {
        this.zzsS = bl;
        try {
            if (this.zzzZ != null) {
                this.zzzZ.setManualImpressionsEnabled(this.zzsS);
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set manual impressions.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzzY = correlator;
        try {
            if (this.zzzZ != null) {
                this.zzzZ.zza(this.zzzY == null ? null : this.zzzY.zzbr());
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set correlator.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzzZ != null) {
                return this.zzzZ.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public boolean isLoading() {
        try {
            if (this.zzzZ != null) {
                return this.zzzZ.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public VideoController getVideoController() {
        return this.zzzW;
    }

    public zzew zzbt() {
        if (this.zzzZ == null) {
            return null;
        }
        try {
            return this.zzzZ.zzbG();
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public void setVideoOptions(VideoOptions videoOptions) {
        this.zzsb = videoOptions;
        try {
            if (this.zzzZ != null) {
                this.zzzZ.zza(videoOptions == null ? null : new zzfn(videoOptions));
            }
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to set video options.", remoteException);
        }
    }

    public VideoOptions getVideoOptions() {
        return this.zzsb;
    }

    private void zzfc() {
        try {
            zzd zzd2 = this.zzzZ.zzbC();
            if (zzd2 == null) {
                return;
            }
            this.zzAe.addView((View)zze.zzE((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to get an ad frame.", remoteException);
        }
    }

    void zzfd() throws RemoteException {
        if ((this.zzzr == null || this.zztq == null) && this.zzzZ == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        this.zzzZ = this.zzfe();
        this.zzzZ.zza(new zzdv(this.zzzX));
        if (this.zzyD != null) {
            this.zzzZ.zza(new zzdu(this.zzyD));
        }
        if (this.zzzq != null) {
            this.zzzZ.zza(new zzee(this.zzzq));
        }
        if (this.zzAa != null) {
            this.zzzZ.zza(new zzle(this.zzAa));
        }
        if (this.zzAc != null) {
            this.zzzZ.zza(new zzli(this.zzAc), this.zzAd);
        }
        if (this.zzAb != null) {
            this.zzzZ.zza(new zzgk(this.zzAb));
        }
        if (this.zzzY != null) {
            this.zzzZ.zza(this.zzzY.zzbr());
        }
        if (this.zzsb != null) {
            this.zzzZ.zza(new zzfn(this.zzsb));
        }
        this.zzzZ.setManualImpressionsEnabled(this.zzsS);
        this.zzfc();
    }

    protected zzep zzfe() throws RemoteException {
        Context context = this.zzAe.getContext();
        zzec zzec2 = zzez.zza(context, this.zzzr, this.zzAf);
        if (this.zzb(zzec2)) {
            return zzeh.zzeP().zza(context, zzec2, this.zztq);
        }
        return zzeh.zzeP().zza(context, zzec2, this.zztq, this.zzzU);
    }

    private static zzec zza(Context context, AdSize[] adSizeArray, int n) {
        zzec zzec2 = new zzec(context, adSizeArray);
        zzec2.zzl(zzez.zzy(n));
        return zzec2;
    }

    private static zzec zza(Context context, AdSize adSize, int n) {
        zzec zzec2 = new zzec(context, adSize);
        zzec2.zzl(zzez.zzy(n));
        return zzec2;
    }

    public boolean zzb(zzec zzec2) {
        return "search_v2".equals(zzec2.zzzk);
    }

    private static boolean zzy(int n) {
        return n == 1;
    }
}

