/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzaam;
import com.google.android.gms.internal.zzaan;
import com.google.android.gms.internal.zzaao;
import com.google.android.gms.internal.zzaxn;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzaxr;
import com.google.android.gms.internal.zzayb;
import com.google.android.gms.internal.zzzv;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzaaj
implements zzaam {
    private final zzaan zzazK;
    private final Lock zzazn;
    private final Context mContext;
    private final com.google.android.gms.common.zzc zzazw;
    private ConnectionResult zzazA;
    private int zzazN;
    private int zzazO = 0;
    private int zzazP;
    private final Bundle zzazQ = new Bundle();
    private final Set<Api.zzc> zzazR = new HashSet<Api.zzc>();
    private zzaxn zzazS;
    private int zzazT;
    private boolean zzazU;
    private boolean zzazV;
    private zzr zzazW;
    private boolean zzazX;
    private boolean zzazY;
    private final zzg zzazs;
    private final Map<Api<?>, Integer> zzazu;
    private final Api.zza<? extends zzaxn, zzaxo> zzaxY;
    private ArrayList<Future<?>> zzazZ = new ArrayList();

    public zzaaj(zzaan zzaan2, zzg zzg2, Map<Api<?>, Integer> map, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zzaxn, zzaxo> zza2, Lock lock, Context context) {
        this.zzazK = zzaan2;
        this.zzazs = zzg2;
        this.zzazu = map;
        this.zzazw = zzc2;
        this.zzaxY = zza2;
        this.zzazn = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.zzazK.zzaAG.clear();
        this.zzazU = false;
        this.zzazA = null;
        this.zzazO = 0;
        this.zzazT = 2;
        this.zzazV = false;
        this.zzazX = false;
        boolean bl = false;
        HashMap<Api.zze, zza> hashMap = new HashMap<Api.zze, zza>();
        for (Api<?> api : this.zzazu.keySet()) {
            Api.zze zze2 = this.zzazK.zzaAr.get(api.zzuH());
            int n = this.zzazu.get(api);
            bl |= api.zzuF().getPriority() == 1;
            if (zze2.zzqD()) {
                this.zzazU = true;
                if (n < this.zzazT) {
                    this.zzazT = n;
                }
                if (n != 0) {
                    this.zzazR.add(api.zzuH());
                }
            }
            hashMap.put(zze2, new zza(this, api, n));
        }
        if (bl) {
            this.zzazU = false;
        }
        if (this.zzazU) {
            this.zzazs.zzc(this.zzazK.zzazd.getSessionId());
            zze zze3 = new zze();
            this.zzazS = this.zzaxY.zza(this.mContext, this.zzazK.zzazd.getLooper(), this.zzazs, this.zzazs.zzxk(), zze3, zze3);
        }
        this.zzazP = this.zzazK.zzaAr.size();
        this.zzazZ.add(zzaao.zzvR().submit(new zzb(hashMap)));
    }

    private boolean zzvB() {
        --this.zzazP;
        if (this.zzazP > 0) {
            return false;
        }
        if (this.zzazP < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zzazK.zzazd.zzvN());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzazA != null) {
            this.zzazK.zzaAJ = this.zzazN;
            this.zzf(this.zzazA);
            return false;
        }
        return true;
    }

    private void zza(zzayb zzayb2) {
        if (!this.zzcv(0)) {
            return;
        }
        ConnectionResult connectionResult = zzayb2.zzxA();
        if (connectionResult.isSuccess()) {
            zzaf zzaf2 = zzayb2.zzOp();
            ConnectionResult connectionResult2 = zzaf2.zzxA();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzf(connectionResult2);
                return;
            }
            this.zzazV = true;
            this.zzazW = zzaf2.zzxz();
            this.zzazX = zzaf2.zzxB();
            this.zzazY = zzaf2.zzxC();
            this.zzvC();
        } else if (this.zze(connectionResult)) {
            this.zzvF();
            this.zzvC();
        } else {
            this.zzf(connectionResult);
        }
    }

    private void zzvC() {
        if (this.zzazP != 0) {
            return;
        }
        if (!this.zzazU || this.zzazV) {
            this.zzvD();
        }
    }

    private void zzvD() {
        ArrayList<Api.zze> arrayList = new ArrayList<Api.zze>();
        this.zzazO = 1;
        this.zzazP = this.zzazK.zzaAr.size();
        for (Api.zzc<?> zzc2 : this.zzazK.zzaAr.keySet()) {
            if (this.zzazK.zzaAG.containsKey(zzc2)) {
                if (!this.zzvB()) continue;
                this.zzvE();
                continue;
            }
            arrayList.add(this.zzazK.zzaAr.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzazZ.add(zzaao.zzvR().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        if (!this.zzcv(1)) {
            return;
        }
        if (bundle != null) {
            this.zzazQ.putAll(bundle);
        }
        if (this.zzvB()) {
            this.zzvE();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzcv(1)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzvB()) {
            this.zzvE();
        }
    }

    private void zzvE() {
        this.zzazK.zzvP();
        zzaao.zzvR().execute(new Runnable(){

            @Override
            public void run() {
                zzaaj.this.zzazw.zzan(zzaaj.this.mContext);
            }
        });
        if (this.zzazS != null) {
            if (this.zzazX) {
                this.zzazS.zza(this.zzazW, this.zzazY);
            }
            this.zzaq(false);
        }
        for (Api.zzc<?> zzc2 : this.zzazK.zzaAG.keySet()) {
            Api.zze zze2 = this.zzazK.zzaAr.get(zzc2);
            zze2.disconnect();
        }
        Bundle bundle = this.zzazQ.isEmpty() ? null : this.zzazQ;
        this.zzazK.zzaAK.zzo(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzzv.zza<R, A>> T zza(T t) {
        this.zzazK.zzazd.zzaAl.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzzv.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzvG();
        this.zzaq(true);
        this.zzazK.zzh(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzf(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzuF().getPriority(), n, connectionResult)) {
            this.zzazA = connectionResult;
            this.zzazN = n2;
        }
        this.zzazK.zzaAG.put(api.zzuH(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zzd(connectionResult)) {
            return false;
        }
        return this.zzazA == null || n < this.zzazN;
    }

    private boolean zzd(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zzazw.zzcr(connectionResult.getErrorCode()) != null;
    }

    private void zzvF() {
        this.zzazU = false;
        this.zzazK.zzazd.zzaAs = Collections.emptySet();
        for (Api.zzc zzc2 : this.zzazR) {
            if (this.zzazK.zzaAG.containsKey(zzc2)) continue;
            this.zzazK.zzaAG.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zze(ConnectionResult connectionResult) {
        return this.zzazT == 2 || this.zzazT == 1 && !connectionResult.hasResolution();
    }

    private void zzf(ConnectionResult connectionResult) {
        this.zzvG();
        this.zzaq(!connectionResult.hasResolution());
        this.zzazK.zzh(connectionResult);
        this.zzazK.zzaAK.zzc(connectionResult);
    }

    private void zzaq(boolean bl) {
        if (this.zzazS != null) {
            if (this.zzazS.isConnected() && bl) {
                this.zzazS.zzOe();
            }
            this.zzazS.disconnect();
            this.zzazW = null;
        }
    }

    private void zzvG() {
        for (Future<?> future : this.zzazZ) {
            future.cancel(true);
        }
        this.zzazZ.clear();
    }

    private Set<Scope> zzvH() {
        if (this.zzazs == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzazs.zzxe());
        Map<Api<?>, zzg.zza> map = this.zzazs.zzxg();
        for (Api<?> api : map.keySet()) {
            if (this.zzazK.zzaAG.containsKey(api.zzuH())) continue;
            hashSet.addAll(map.get(api).zzajm);
        }
        return hashSet;
    }

    private boolean zzcv(int n) {
        if (this.zzazO != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zzazK.zzazd.zzvN());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zzazP;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = String.valueOf(this.zzcw(this.zzazO));
            String string4 = String.valueOf(this.zzcw(n));
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzcw(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends zzaxr {
        private final WeakReference<zzaaj> zzaAb;

        zzd(zzaaj zzaaj2) {
            this.zzaAb = new WeakReference<zzaaj>(zzaaj2);
        }

        @Override
        @BinderThread
        public void zzb(final zzayb zzayb2) {
            final zzaaj zzaaj2 = (zzaaj)this.zzaAb.get();
            if (zzaaj2 == null) {
                return;
            }
            zzaaj2.zzazK.zza(new zzaan.zza(this, zzaaj2){

                @Override
                public void zzvA() {
                    zzaaj2.zza(zzayb2);
                }
            });
        }
    }

    private static class zza
    implements zzf.zzf {
        private final WeakReference<zzaaj> zzaAb;
        private final Api<?> zzawb;
        private final int zzazb;

        public zza(zzaaj zzaaj2, Api<?> api, int n) {
            this.zzaAb = new WeakReference<zzaaj>(zzaaj2);
            this.zzawb = api;
            this.zzazb = n;
        }

        public void zzg(@NonNull ConnectionResult connectionResult) {
            zzaaj zzaaj2 = (zzaaj)this.zzaAb.get();
            if (zzaaj2 == null) {
                return;
            }
            zzac.zza((Looper.myLooper() == ((zzaaj)zzaaj2).zzazK.zzazd.getLooper() ? 1 : 0) != 0, (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzaaj2.zzazn.lock();
            try {
                if (!zzaaj2.zzcv(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzaaj2.zzb(connectionResult, this.zzawb, this.zzazb);
                }
                if (zzaaj2.zzvB()) {
                    zzaaj2.zzvC();
                }
            }
            finally {
                zzaaj2.zzazn.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle bundle) {
            zzaaj.this.zzazS.zza(new zzd(zzaaj.this));
        }

        @Override
        public void onConnectionSuspended(int n) {
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzaaj.this.zzazn.lock();
            try {
                if (zzaaj.this.zze(connectionResult)) {
                    zzaaj.this.zzvF();
                    zzaaj.this.zzvC();
                } else {
                    zzaaj.this.zzf(connectionResult);
                }
            }
            finally {
                zzaaj.this.zzazn.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zze> zzaAg;

        public zzc(ArrayList<Api.zze> arrayList) {
            this.zzaAg = arrayList;
        }

        @Override
        @WorkerThread
        public void zzvA() {
            ((zzaaj)zzaaj.this).zzazK.zzazd.zzaAs = zzaaj.this.zzvH();
            for (Api.zze zze2 : this.zzaAg) {
                zze2.zza(zzaaj.this.zzazW, ((zzaaj)zzaaj.this).zzazK.zzazd.zzaAs);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zze, zza> zzaAc;

        public zzb(Map<Api.zze, zza> map) {
            this.zzaAc = map;
        }

        @Override
        @WorkerThread
        public void zzvA() {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (Api.zze object : this.zzaAc.keySet()) {
                if (object.zzuI()) {
                    bl2 = true;
                    if (this.zzaAc.get(object).zzazb != 0) continue;
                    bl = true;
                    break;
                }
                bl3 = false;
            }
            int n2 = n = bl2 ? zzaaj.this.zzazw.isGooglePlayServicesAvailable(zzaaj.this.mContext) : 0;
            if (n != 0 && (bl || bl3)) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzaaj.this.zzazK.zza(new zzaan.zza(zzaaj.this){

                    @Override
                    public void zzvA() {
                        zzaaj.this.zzf(connectionResult);
                    }
                });
                return;
            }
            if (zzaaj.this.zzazU) {
                zzaaj.this.zzazS.connect();
            }
            for (Api.zze zze2 : this.zzaAc.keySet()) {
                final zzf.zzf zzf2 = this.zzaAc.get(zze2);
                if (zze2.zzuI() && n != 0) {
                    zzaaj.this.zzazK.zza(new zzaan.zza(this, zzaaj.this){

                        @Override
                        public void zzvA() {
                            zzf2.zzg(new ConnectionResult(16, null));
                        }
                    });
                    continue;
                }
                zze2.zza(zzf2);
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        @Override
        @WorkerThread
        public void run() {
            zzaaj.this.zzazn.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzvA();
            }
            catch (RuntimeException runtimeException) {
                zzaaj.this.zzazK.zza(runtimeException);
            }
            finally {
                zzaaj.this.zzazn.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzvA();
    }
}

