/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzly;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqp;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzlu
implements Callable<zzov> {
    static long zzPS = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzpp zzQb;
    private final zzr zzQc;
    private final zzav zzGr;
    private final zzlt zzGp;
    private final Object zzrN = new Object();
    private final zzov.zza zzPo;
    private final zzgf zzsr;
    private boolean zzQd;
    private int zzPF;
    private List<String> zzQe;
    private JSONObject zzQf;

    public zzlu(Context context, zzr zzr2, zzpp zzpp2, zzav zzav2, zzov.zza zza2, zzgf zzgf2) {
        this.mContext = context;
        this.zzQc = zzr2;
        this.zzQb = zzpp2;
        this.zzPo = zza2;
        this.zzGr = zzav2;
        this.zzsr = zzgf2;
        this.zzGp = this.zza(context, zza2, zzr2, zzav2);
        this.zzGp.zziE();
        this.zzQd = false;
        this.zzPF = -2;
        this.zzQe = null;
    }

    public zzov zziP() {
        try {
            this.zzGp.zziF();
            String string2 = this.zziR();
            JSONObject jSONObject = this.zzaG(string2);
            zza zza2 = this.zzd(jSONObject);
            zzgu.zza zza3 = this.zza(zza2, jSONObject, string2);
            this.zza(zza3);
            zzov zzov2 = this.zzb(zza3);
            return zzov2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzpe.zzc((String)"Malformed native JSON response.", (Throwable)jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzpe.zzc((String)"Timeout when loading native ad.", (Throwable)timeoutException);
        }
        if (!this.zzQd) {
            this.zzS(0);
        }
        return this.zzb(null);
    }

    private JSONObject zzaG(final String string2) throws ExecutionException, InterruptedException, TimeoutException, JSONException {
        if (this.zziQ()) {
            return null;
        }
        final zzqc zzqc2 = new zzqc();
        final zzb zzb2 = new zzb(this);
        zzlt.zza zza2 = new zzlt.zza(){

            @Override
            public void zze(final zzjb zzjb2) {
                zzhx zzhx2;
                zzb2.zzQz = zzhx2 = new zzhx(){

                    @Override
                    public void zza(zzqp zzqp2, Map<String, String> map) {
                        try {
                            String string2 = map.get("success");
                            if (TextUtils.isEmpty((CharSequence)string2)) {
                                return;
                            }
                            JSONObject jSONObject = new JSONObject(string2);
                            if (!string2.equals(jSONObject.optString("ads_id", ""))) {
                                return;
                            }
                            zzjb2.zzb("/nativeAdPreProcess", zzb2.zzQz);
                            zzqc2.zzh(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                            return;
                        }
                        catch (JSONException jSONException) {
                            zzpe.zzb((String)"Malformed native JSON response.", (Throwable)jSONException);
                            zzlu.this.zzS(0);
                            zzac.zza((boolean)zzlu.this.zziQ(), (Object)"Unable to set the ad state error!");
                            zzqc2.zzh(null);
                            return;
                        }
                    }
                };
                zzjb2.zza("/nativeAdPreProcess", zzhx2);
                try {
                    JSONObject jSONObject = new JSONObject(((zzlu)zzlu.this).zzPo.zzVB.body);
                    jSONObject.put("ads_id", (Object)string2);
                    zzjb2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzpe.zzc((String)"Exception occurred while invoking javascript", (Throwable)jSONException);
                    zzqc2.zzh(null);
                }
            }

            @Override
            public void zziO() {
                zzqc2.zzh(null);
            }
        };
        this.zzGp.zza(zza2);
        return (JSONObject)zzqc2.get(zzPS, TimeUnit.MILLISECONDS);
    }

    protected zza zzd(JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException, TimeoutException {
        boolean bl;
        if (this.zziQ() || jSONObject == null) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzPo.zzSF.zzvx != null ? this.zzPo.zzSF.zzvx.zzGD : false;
        boolean bl3 = bl = this.zzPo.zzSF.zzvx != null ? this.zzPo.zzSF.zzvx.zzGF : false;
        if ("2".equals(string2)) {
            return new zzlw(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzlx(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzqc zzqc2 = new zzqc();
            zzpi.zzWR.post(new Runnable(){

                @Override
                public void run() {
                    zzqc2.zzh((zzhm)zzlu.this.zzQc.zzcs().get((Object)string3));
                }
            });
            if (zzqc2.get(zzPS, TimeUnit.MILLISECONDS) != null) {
                return new zzly(bl2);
            }
            String string4 = String.valueOf(jSONObject.getString("custom_template_id"));
            zzpe.e((String)(string4.length() != 0 ? "No handler for custom template: ".concat(string4) : new String("No handler for custom template: ")));
        } else {
            this.zzS(0);
        }
        return null;
    }

    private void zza(zzgu.zza zza2) {
        zzhx zzhx2;
        if (!(zza2 instanceof zzgr)) {
            return;
        }
        final zzgr zzgr2 = (zzgr)zza2;
        zzb zzb2 = new zzb(this);
        zzb2.zzQz = zzhx2 = new zzhx(){

            @Override
            public void zza(zzqp zzqp2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzlu.this.zzb((zzhh)zzgr2, string2);
            }
        };
        this.zzGp.zza(new zzlt.zza(this){

            @Override
            public void zze(zzjb zzjb2) {
                zzjb2.zza("/nativeAdCustomClick", zzhx2);
            }
        });
    }

    private void zzb(zzhh zzhh2, String string2) {
        try {
            zzhl zzhl2 = this.zzQc.zzz(zzhh2.getCustomTemplateId());
            if (zzhl2 != null) {
                zzhl2.zza(zzhh2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzpe.zzc((String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to call onCustomClick for asset ").append(string2).append(".").toString(), (Throwable)remoteException);
        }
    }

    private zzgu.zza zza(zza zza2, JSONObject jSONObject, String string2) throws ExecutionException, InterruptedException, JSONException {
        if (this.zziQ() || zza2 == null || jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzd(jSONObject2, "impression_tracking_urls");
        this.zzQe = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzQf = jSONObject2.optJSONObject("active_view");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzpe.e((String)"Failed to retrieve ad assets.");
            return null;
        }
        t.zzb((zzgu)new zzgv(this.mContext, this.zzQc, this.zzGp, this.zzGr, jSONObject, (zzgu.zza)t, this.zzPo.zzSF.zzvf, string2));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzov zzb(zzgu.zza zza2) {
        int n;
        Object object = this.zzrN;
        synchronized (object) {
            n = this.zzPF;
            if (zza2 == null && this.zzPF == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzov(this.zzPo.zzSF.zzRd, null, this.zzPo.zzVB.zzJY, n, this.zzPo.zzVB.zzJZ, this.zzQe, this.zzPo.zzVB.orientation, this.zzPo.zzVB.zzKe, this.zzPo.zzSF.zzRg, false, null, null, null, null, null, 0L, this.zzPo.zzvj, this.zzPo.zzVB.zzRJ, this.zzPo.zzVv, this.zzPo.zzVw, this.zzPo.zzVB.zzRP, this.zzQf, zza2, null, null, null, this.zzPo.zzVB.zzSc, this.zzPo.zzVB.zzSd, null, this.zzPo.zzVB.zzKb, this.zzPo.zzVB.zzSg);
    }

    public zzqf<zzgm> zze(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzqd<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        final int n6 = this.zzPo.zzSF.zzvx != null && this.zzPo.zzSF.zzvx.versionCode >= 2 ? this.zzPo.zzSF.zzvx.zzGG : 1;
        ArrayList arrayList = new ArrayList<zzqf<zzgo>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzqf zzqf2 = zzqe.zzo(arrayList);
        return zzqe.zza(zzqf2, new zzqe.zza<List<zzgo>, zzgm>(this){

            public zzgm zzj(List<zzgo> list) {
                try {
                    return list == null || list.isEmpty() ? null : new zzgm(string2, zzlu.zzh(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4, n6);
                }
                catch (RemoteException remoteException) {
                    zzpe.zzb((String)"Could not get attribution icon", (Throwable)remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object apply(Object object) {
                return this.zzj((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzgo> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzqf<zzgo> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzqf<zzgo>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzqf<zzgo>> arrayList = new ArrayList<zzqf<zzgo>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzqf<zzgo> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        final boolean bl3 = jSONObject.optBoolean("is_transparent", true);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzqd<Object>(null);
        }
        if (bl2) {
            return new zzqd<zzgo>(new zzgo(null, Uri.parse((String)string2), d));
        }
        return this.zzQb.zza(string2, new zzpp.zza<zzgo>(){

            public zzgo zziS() {
                zzlu.this.zza(2, bl);
                return null;
            }

            @TargetApi(value=19)
            public zzgo zzg(InputStream inputStream) {
                Bitmap bitmap = null;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inDensity = (int)(160.0 * d);
                if (!bl3) {
                    options.inPreferredConfig = Bitmap.Config.RGB_565;
                }
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                }
                catch (Exception exception) {
                    zzpe.zzb((String)"Error grabbing image.", (Throwable)exception);
                }
                if (bitmap == null) {
                    zzlu.this.zza(2, bl);
                    return null;
                }
                if (zzs.zzyF()) {
                    int n = bitmap.getWidth();
                    int n2 = bitmap.getHeight();
                    int n3 = bitmap.getAllocationByteCount();
                    zzpe.v(new StringBuilder(61).append("Decoded image w: ").append(n).append(" h:").append(n2).append(" bytes: ").append(n3).toString());
                }
                return new zzgo((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zziT() {
                return this.zziS();
            }

            @Override
            @TargetApi(value=19)
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    public zzqf<zzqp> zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject(string2);
        if (jSONObject2 == null) {
            return new zzqd<Object>(null);
        }
        String string3 = jSONObject2.optString("vast_xml");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            zzpe.zzbe((String)"Required field 'vast_xml' is missing");
            return new zzqd<Object>(null);
        }
        return this.zza(this.mContext, this.zzGr, this.zzPo, this.zzsr, this.zzQc).zzf(jSONObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zziQ() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzQd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzS(int n) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzQd = true;
            this.zzPF = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzS(n);
        }
    }

    private String[] zzd(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzh(List<zzgo> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzgo zzgo2 : list) {
            arrayList.add((Drawable)zze.zzE((zzd)zzgo2.zzfK()));
        }
        return arrayList;
    }

    zzlt zza(Context context, zzov.zza zza2, zzr zzr2, zzav zzav2) {
        return new zzlt(context, zza2, zzr2, zzav2);
    }

    zzlv zza(Context context, zzav zzav2, zzov.zza zza2, zzgf zzgf2, zzr zzr2) {
        return new zzlv(context, zzav2, zza2, zzgf2, zzr2);
    }

    String zziR() {
        return UUID.randomUUID().toString();
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zziP();
    }

    class zzb {
        public zzhx zzQz;

        zzb(zzlu zzlu2) {
        }
    }

    public static interface zza<T extends zzgu.zza> {
        public T zza(zzlu var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

