/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapTeleporter
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zza();
    final int mVersionCode;
    ParcelFileDescriptor zzSn;
    final int zzanR;
    private Bitmap zzaCg;
    private boolean zzaCh;
    private File zzaCi;

    BitmapTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor, int n2) {
        this.mVersionCode = n;
        this.zzSn = parcelFileDescriptor;
        this.zzanR = n2;
        this.zzaCg = null;
        this.zzaCh = false;
    }

    public BitmapTeleporter(Bitmap bitmap) {
        this.mVersionCode = 1;
        this.zzSn = null;
        this.zzanR = 0;
        this.zzaCg = bitmap;
        this.zzaCh = true;
    }

    public Bitmap zzwz() {
        if (!this.zzaCh) {
            Bitmap.Config config;
            int n;
            int n2;
            byte[] byArray;
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzSn));
            try {
                byArray = new byte[dataInputStream.readInt()];
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                config = Bitmap.Config.valueOf((String)dataInputStream.readUTF());
                dataInputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                this.zza(dataInputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            this.zzaCg = bitmap;
            this.zzaCh = true;
        }
        return this.zzaCg;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzSn == null) {
            Bitmap bitmap = this.zzaCg;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            FileOutputStream fileOutputStream = this.zzwA();
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            try {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.writeInt(bitmap.getWidth());
                dataOutputStream.writeInt(bitmap.getHeight());
                dataOutputStream.writeUTF(bitmap.getConfig().toString());
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not write into unlinked file", iOException);
            }
            finally {
                this.zza(dataOutputStream);
            }
        }
        zza.zza(this, parcel, n | 1);
        this.zzSn = null;
    }

    public void release() {
        if (!this.zzaCh) {
            try {
                this.zzSn.close();
            }
            catch (IOException iOException) {
                Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            }
        }
    }

    public void zzd(File file) {
        if (file == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zzaCi = file;
    }

    private FileOutputStream zzwA() {
        FileOutputStream fileOutputStream;
        File file;
        if (this.zzaCi == null) {
            throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
        }
        try {
            file = File.createTempFile("teleporter", ".tmp", this.zzaCi);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.zzSn = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        file.delete();
        return fileOutputStream;
    }

    private void zza(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
        }
    }
}

