/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzw;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class zzh {
    SharedPreferences zzbhD;
    Context zzqr;

    public zzh(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    public zzh(Context context, String string) {
        this.zzqr = context;
        this.zzbhD = context.getSharedPreferences(string, 4);
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("-no-backup");
        this.zzeK(string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    public synchronized long zzjz(String string) {
        String string2 = this.zzau(string, "cre");
        String string3 = this.zzbhD.getString(string2, null);
        if (string3 != null) {
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    public SharedPreferences zzaam() {
        return this.zzbhD;
    }

    private void zzeK(String string) {
        block4: {
            File file = zzw.getNoBackupFilesDir((Context)this.zzqr);
            File file2 = new File(file, string);
            if (file2.exists()) {
                return;
            }
            try {
                if (file2.createNewFile() && !this.isEmpty()) {
                    Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                    FirebaseInstanceId.zza(this.zzqr, this);
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                String string2 = String.valueOf(iOException.getMessage());
                Log.d((String)"InstanceID/Store", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.zzbhD.getAll().isEmpty();
    }

    private String zzp(String string, String string2, String string3) {
        String string4 = String.valueOf("|T|");
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string4).append(string2).append("|").append(string3).toString();
    }

    private String zzau(String string, String string2) {
        String string3 = String.valueOf("|S|");
        return new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string).append(string3).append(string2).toString();
    }

    private void zzeL(String string) {
        SharedPreferences.Editor editor = this.zzbhD.edit();
        Map map = this.zzbhD.getAll();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public synchronized void zzGA() {
        this.zzbhD.edit().clear().commit();
    }

    public synchronized zza zzq(String string, String string2, String string3) {
        return zza.zzjB(this.zzbhD.getString(this.zzp(string, string2, string3), null));
    }

    public synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zza.zzc(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zzbhD.edit();
        editor.putString(this.zzp(string, string2, string3), string6);
        editor.commit();
    }

    public synchronized void zzi(String string, String string2, String string3) {
        String string4 = this.zzp(string, string2, string3);
        SharedPreferences.Editor editor = this.zzbhD.edit();
        editor.remove(string4);
        editor.commit();
    }

    synchronized KeyPair zzjA(String string) {
        KeyPair keyPair = com.google.firebase.iid.zza.zzGs();
        long l = System.currentTimeMillis();
        SharedPreferences.Editor editor = this.zzbhD.edit();
        editor.putString(this.zzau(string, "|P|"), FirebaseInstanceId.zzv(keyPair.getPublic().getEncoded()));
        editor.putString(this.zzau(string, "|K|"), FirebaseInstanceId.zzv(keyPair.getPrivate().getEncoded()));
        editor.putString(this.zzau(string, "cre"), Long.toString(l));
        editor.commit();
        return keyPair;
    }

    synchronized void zzeN(String string) {
        this.zzeL(String.valueOf(string).concat("|"));
    }

    public synchronized void zzeO(String string) {
        this.zzeL(String.valueOf(string).concat("|T|"));
    }

    public synchronized KeyPair zzeM(String string) {
        String string2 = this.zzbhD.getString(this.zzau(string, "|P|"), null);
        String string3 = this.zzbhD.getString(this.zzau(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"InstanceID/Store", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            FirebaseInstanceId.zza(this.zzqr, this);
            return null;
        }
    }

    static class zza {
        private static final long zzcjj = TimeUnit.DAYS.toMillis(7L);
        final String zzbwP;
        final String zzbhg;
        final long timestamp;

        private zza(String string, String string2, long l) {
            this.zzbwP = string;
            this.zzbhg = string2;
            this.timestamp = l;
        }

        static zza zzjB(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            if (string.startsWith("{")) {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    return new zza(jSONObject.getString("token"), jSONObject.getString("appVersion"), jSONObject.getLong("timestamp"));
                }
                catch (JSONException jSONException) {
                    String string2 = String.valueOf((Object)jSONException);
                    Log.w((String)"InstanceID/Store", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to parse token: ").append(string2).toString());
                    return null;
                }
            }
            return new zza(string, null, 0L);
        }

        static String zzc(String string, String string2, long l) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("token", (Object)string);
                jSONObject.put("appVersion", (Object)string2);
                jSONObject.put("timestamp", l);
                return jSONObject.toString();
            }
            catch (JSONException jSONException) {
                String string3 = String.valueOf((Object)jSONException);
                Log.w((String)"InstanceID/Store", (String)new StringBuilder(24 + String.valueOf(string3).length()).append("Failed to encode token: ").append(string3).toString());
                return null;
            }
        }

        boolean zzjC(String string) {
            return System.currentTimeMillis() > this.timestamp + zzcjj || !string.equals(this.zzbhg);
        }
    }
}

