/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public final class ByteString
implements Serializable {
    private static final long serialVersionUID = 6225913660341986054L;
    private static final String fileVersionID = "$Id: ByteString.java,v 1.7 2006/03/26 14:35:37 Yuki Exp $";
    private static final Charset charset = Charset.forName("MS932");
    private static final CharsetDecoder decorder = charset.newDecoder();
    private byte[] bytes;
    private int offset;
    private int length;

    public ByteString(String text) {
        ByteBuffer encoded = charset.encode(text);
        this.offset = 0;
        this.length = encoded.remaining();
        this.bytes = new byte[this.length + 1];
        encoded.get(this.bytes, 0, this.length);
    }

    public ByteString(byte[] bytes, int offset, boolean uniqueBuffer) {
        this(bytes, offset, bytes.length - offset, uniqueBuffer);
    }

    public ByteString(byte[] bytes, int offset, int length, boolean uniqueBuffer) {
        this.length = Math.min(length, ByteString.calculateLength(bytes, offset));
        if (uniqueBuffer) {
            this.bytes = new byte[this.length + 256];
            this.offset = 0;
            System.arraycopy(bytes, offset, this.bytes, this.offset, this.length);
        } else {
            this.bytes = bytes;
            this.offset = offset;
        }
    }

    public ByteString(ByteString str, boolean uniqueBuffer) {
        this(str.bytes, str.offset, str.length, uniqueBuffer);
    }

    private static int calculateLength(byte[] bytes, int offset) {
        int i = offset;
        while (i < bytes.length) {
            if (bytes[i] == 0) {
                return i - offset;
            }
            ++i;
        }
        return bytes.length - offset;
    }

    public static ByteString concat(ByteString lhs, ByteString rhs) {
        byte[] newBytes = new byte[lhs.length + rhs.length + 1];
        System.arraycopy(lhs.bytes, lhs.offset, newBytes, 0, lhs.length);
        System.arraycopy(rhs.bytes, rhs.offset, newBytes, lhs.length, rhs.length);
        return new ByteString(newBytes, 0, lhs.length + rhs.length, false);
    }

    public void append(ByteString rhs) {
        this.replace(this.length, 0, rhs);
    }

    public String toString() {
        return this.decode(ByteBuffer.wrap(this.bytes, this.offset, this.length)).toString();
    }

    private CharBuffer decode(ByteBuffer in) {
        int n = (int)((float)in.remaining() * decorder.averageCharsPerByte() + 1.0f);
        CharBuffer out = CharBuffer.allocate(n);
        if (in.remaining() != 0) {
            CoderResult cr;
            decorder.reset();
            while (!(cr = in.hasRemaining() ? decorder.decode(in, out, true) : decorder.flush(out)).isUnderflow() && cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(n *= 2);
                ((Buffer)out).flip();
                o.put(out);
                out = o;
            }
        }
        ((Buffer)out).flip();
        return out;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteString) {
            ByteString rhs = (ByteString)obj;
            if (rhs.length != this.length) {
                return false;
            }
            return this.compareTo(rhs) == 0;
        }
        return super.equals(obj);
    }

    public int compareTo(ByteString rhs) {
        int ret = this.compareSub(0, rhs);
        if (ret != 0) {
            return ret;
        }
        if (rhs.length > this.length) {
            return 1;
        }
        return 0;
    }

    public int compareSub(int index, ByteString rhs) {
        byte[] lb = this.bytes;
        int lo = this.offset + index;
        byte[] rb = rhs.bytes;
        int ro = rhs.offset;
        int l = Math.min(this.length - index, rhs.length);
        int i = 0;
        while (i < l) {
            if (lb[lo + i] != rb[ro + i]) {
                return lb[lo + i] - rb[ro + i];
            }
            ++i;
        }
        if (l < rhs.length) {
            return -1;
        }
        return 0;
    }

    public int length() {
        return this.length;
    }

    public byte get(int index) {
        try {
            return this.bytes[this.offset + index];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void set(int index, byte b) {
        this.bytes[this.offset + index] = b;
        if (index < this.length) {
            if (b == 0) {
                this.length = index;
            }
        } else if (index == this.length) {
            this.length = ByteString.calculateLength(this.bytes, this.offset);
        }
    }

    public int indexOf(ByteString sub, int index) {
        int i = index;
        while (i + sub.length < this.length) {
            if (this.compareSub(i, sub) == 0) {
                return i - index;
            }
            ++i;
        }
        return -1;
    }

    public ByteString substring(int index, int count) {
        if (index < 0) {
            count += index;
            index = 0;
        }
        if (index >= this.length) {
            index = this.length;
        }
        if (index + count >= this.length) {
            count = this.length - index;
        }
        byte[] b = new byte[count + 1];
        System.arraycopy(this.bytes, this.offset + index, b, 0, count);
        return new ByteString(b, 0, count, false);
    }

    public void assign(String string) {
        this.assign(new ByteString(string));
    }

    public void assign(ByteString string) {
        this.replace(0, this.length, string);
    }

    public void replace(int index, int length, ByteString string) {
        int newLength = this.length + string.length - length;
        if (this.bytes.length < this.offset + newLength + 1) {
            byte[] newBytes = new byte[newLength + 1024];
            System.arraycopy(this.bytes, this.offset, newBytes, 0, index);
            System.arraycopy(string.bytes, string.offset, newBytes, index, string.length);
            System.arraycopy(this.bytes, this.offset + index + length, newBytes, index + string.length, this.length - (index + length));
            this.bytes = newBytes;
            this.offset = 0;
            this.length = newLength;
        } else {
            System.arraycopy(this.bytes, this.offset + index + length, this.bytes, this.offset + index + string.length, this.length - (index + length));
            System.arraycopy(string.bytes, string.offset, this.bytes, this.offset + index, string.length);
            this.bytes[this.offset + newLength] = 0;
            this.length = newLength;
        }
    }

    public int lineIndex(int line) {
        if (line < 0) {
            return this.length;
        }
        int readedLine = 0;
        int index = 0;
        while (index < this.length) {
            if (readedLine == line) break;
            if (this.get(index) == 10) {
                ++readedLine;
            }
            ++index;
        }
        return index;
    }

    public int nextLineIndex(int index) {
        int nextIndex = index;
        while (nextIndex < this.length) {
            if (this.get(nextIndex) == 10) {
                ++nextIndex;
                break;
            }
            ++nextIndex;
        }
        return nextIndex;
    }
}

