/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzjx;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzo {
    @Nullable
    public static View zzg(@Nullable zzov zzov2) {
        if (zzov2 == null) {
            zzpe.e((String)"AdState is null");
            return null;
        }
        if (zzo.zzh(zzov2) && zzov2.zzMZ != null) {
            return zzov2.zzMZ.getView();
        }
        try {
            zzd zzd2;
            zzd zzd3 = zzd2 = zzov2.zzKB != null ? zzov2.zzKB.getView() : null;
            if (zzd2 == null) {
                zzpe.zzbe((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)zze.zzE((zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzpe.zzc((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    public static void zza(@Nullable zzov zzov2, zzf.zza zza2) {
        if (zzov2 != null && zzo.zzh(zzov2)) {
            View view;
            zzqp zzqp2 = zzov2.zzMZ;
            View view2 = view = zzqp2 != null ? zzqp2.getView() : null;
            if (view == null) {
                zzpe.zzbe((String)"AdWebView is null");
                return;
            }
            try {
                zzjx zzjx2;
                List<String> list;
                List<String> list2 = list = zzov2.zzKA != null ? zzov2.zzKA.zzJU : null;
                if (list == null || list.isEmpty()) {
                    zzpe.zzbe((String)"No template ids present in mediation response");
                    return;
                }
                zzjw zzjw2 = zzov2.zzKB != null ? zzov2.zzKB.zzgJ() : null;
                zzjx zzjx3 = zzjx2 = zzov2.zzKB != null ? zzov2.zzKB.zzgK() : null;
                if (list.contains("2") && zzjw2 != null) {
                    zzjw2.zzl(zze.zzA((Object)view));
                    if (!zzjw2.getOverrideImpressionRecording()) {
                        zzjw2.recordImpression();
                    }
                    zzqp2.zzkV().zza("/nativeExpressViewClicked", zzo.zza(zzjw2, null, zza2));
                } else if (list.contains("1") && zzjx2 != null) {
                    zzjx2.zzl(zze.zzA((Object)view));
                    if (!zzjx2.getOverrideImpressionRecording()) {
                        zzjx2.recordImpression();
                    }
                    zzqp2.zzkV().zza("/nativeExpressViewClicked", zzo.zza(null, zzjx2, zza2));
                } else {
                    zzpe.zzbe((String)"No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzpe.zzc((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzqp zzqp2, zzjn zzjn2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzo.zzb(zzqp2, zzjn2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzpe.zzc((String)"Unable to invoke load assets", (Throwable)remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzqp zzqp2, zzjn zzjn2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzqp2.getView();
        if (view == null) {
            zzpe.zzbe((String)"AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzjn2.zzKA.zzJU;
        if (list == null || list.isEmpty()) {
            zzpe.zzbe((String)"No template ids present in mediation response");
            return false;
        }
        zzo.zza(zzqp2, countDownLatch);
        zzjw zzjw2 = zzjn2.zzKB.zzgJ();
        zzjx zzjx2 = zzjn2.zzKB.zzgK();
        if (list.contains("2") && zzjw2 != null) {
            object = zzo.zza(zzjw2);
            zzo.zza(zzqp2, object, zzjn2.zzKA.zzJT);
        } else if (list.contains("1") && zzjx2 != null) {
            object = zzo.zza(zzjx2);
            zzo.zza(zzqp2, (zzgq)object, zzjn2.zzKA.zzJT);
        } else {
            zzpe.zzbe((String)"No matching template id and mapper");
            return false;
        }
        object = zzjn2.zzKA.zzJR;
        String string2 = zzjn2.zzKA.zzJS;
        if (string2 != null) {
            zzqp2.loadDataWithBaseURL(string2, (String)object, "text/html", "UTF-8", null);
        } else {
            zzqp2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzh(@Nullable zzov zzov2) {
        return zzov2 != null && zzov2.zzRK && zzov2.zzKA != null && zzov2.zzKA.zzJR != null;
    }

    private static zzgp zza(zzjw zzjw2) throws RemoteException {
        return new zzgp(zzjw2.getHeadline(), zzjw2.getImages(), zzjw2.getBody(), zzjw2.zzfL(), zzjw2.getCallToAction(), zzjw2.getStarRating(), zzjw2.getStore(), zzjw2.getPrice(), null, zzjw2.getExtras(), null, null);
    }

    private static zzgq zza(zzjx zzjx2) throws RemoteException {
        return new zzgq(zzjx2.getHeadline(), zzjx2.getImages(), zzjx2.getBody(), zzjx2.zzfQ(), zzjx2.getCallToAction(), zzjx2.getAdvertiser(), null, zzjx2.getExtras());
    }

    private static void zza(final zzqp zzqp2, final zzgp zzgp2, final String string2) {
        zzqp2.zzkV().zza(new zzqq.zza(){

            @Override
            public void zza(zzqp zzqp22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzgp2.getHeadline());
                    jSONObject.put("body", (Object)zzgp2.getBody());
                    jSONObject.put("call_to_action", (Object)zzgp2.getCallToAction());
                    jSONObject.put("price", (Object)zzgp2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzgp2.getStarRating()));
                    jSONObject.put("store", (Object)zzgp2.getStore());
                    jSONObject.put("icon", (Object)zzo.zza(zzgp2.zzfL()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzgp2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzgz zzgz2 = zzo.zze(e);
                            jSONArray.put((Object)zzo.zza(zzgz2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzo.zza(zzgp2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzqp2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzpe.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(final zzqp zzqp2, final zzgq zzgq2, final String string2) {
        zzqp2.zzkV().zza(new zzqq.zza(){

            @Override
            public void zza(zzqp zzqp22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzgq2.getHeadline());
                    jSONObject.put("body", (Object)zzgq2.getBody());
                    jSONObject.put("call_to_action", (Object)zzgq2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zzgq2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzo.zza(zzgq2.zzfQ()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzgq2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzgz zzgz2 = zzo.zze(e);
                            jSONArray.put((Object)zzo.zza(zzgz2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzo.zza(zzgq2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzqp2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzpe.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(zzqp zzqp2, CountDownLatch countDownLatch) {
        zzqp2.zzkV().zza("/nativeExpressAssetsLoaded", zzo.zza(countDownLatch));
        zzqp2.zzkV().zza("/nativeExpressAssetsLoadingFailed", zzo.zzb(countDownLatch));
    }

    static zzhx zza(final CountDownLatch countDownLatch) {
        return new zzhx(){

            @Override
            public void zza(zzqp zzqp2, Map<String, String> map) {
                countDownLatch.countDown();
                zzqp2.getView().setVisibility(0);
            }
        };
    }

    static zzhx zzb(final CountDownLatch countDownLatch) {
        return new zzhx(){

            @Override
            public void zza(zzqp zzqp2, Map<String, String> map) {
                zzpe.zzbe((String)"Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzqp2.destroy();
            }
        };
    }

    static zzhx zza(final @Nullable zzjw zzjw2, final @Nullable zzjx zzjx2, final zzf.zza zza2) {
        return new zzhx(){

            @Override
            public void zza(zzqp zzqp2, Map<String, String> map) {
                View view = zzqp2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzjw2 != null) {
                        if (!zzjw2.getOverrideClickHandling()) {
                            zzjw2.zzk(zze.zzA((Object)view));
                            zza2.onClick();
                        } else {
                            zzo.zza(zzqp2);
                        }
                    } else if (zzjx2 != null) {
                        if (!zzjx2.getOverrideClickHandling()) {
                            zzjx2.zzk(zze.zzA((Object)view));
                            zza2.onClick();
                        } else {
                            zzo.zza(zzqp2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzpe.zzc((String)"Unable to call handleClick on mapper", (Throwable)remoteException);
                }
            }
        };
    }

    private static void zza(zzqp zzqp2) {
        View.OnClickListener onClickListener = zzqp2.zzlk();
        if (onClickListener != null) {
            onClickListener.onClick(zzqp2.getView());
        }
    }

    private static JSONObject zza(@Nullable Bundle bundle, String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string2)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string2);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string3 = (String)iterator.next();
            if (!bundle.containsKey(string3)) continue;
            String string4 = jSONObject2.getString(string3);
            if ("image".equals(string4)) {
                object = bundle.get(string3);
                if (object instanceof Bitmap) {
                    String string5 = zzo.zza((Bitmap)object);
                    jSONObject.put(string3, (Object)string5);
                    continue;
                }
                zzpe.zzbe((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string3);
            if (object instanceof Bitmap) {
                zzpe.zzbe((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string3, (Object)String.valueOf(bundle.get(string3)));
        }
        return jSONObject;
    }

    static String zza(@Nullable zzgz zzgz2) {
        if (zzgz2 == null) {
            zzpe.zzbe((String)"Image is null. Returning empty string");
            return "";
        }
        try {
            Uri uri = zzgz2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzpe.zzbe((String)"Unable to get image uri. Trying data uri next");
        }
        return zzo.zzb(zzgz2);
    }

    private static String zzb(zzgz zzgz2) {
        Drawable drawable2;
        zzd zzd2;
        try {
            zzd2 = zzgz2.zzfK();
            if (zzd2 == null) {
                zzpe.zzbe((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)zze.zzE((zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzpe.zzbe((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzpe.zzbe((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        zzd2 = (BitmapDrawable)drawable2;
        Bitmap bitmap = zzd2.getBitmap();
        return zzo.zza(bitmap);
    }

    private static String zza(@Nullable Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzpe.zzbe((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = Base64.encodeToString((byte[])byArray, (int)0);
        String string3 = String.valueOf("data:image/png;base64,");
        String string4 = String.valueOf(string2);
        return string4.length() != 0 ? string3.concat(string4) : new String(string3);
    }

    @Nullable
    private static zzgz zze(Object object) {
        if (object instanceof IBinder) {
            return zzgz.zza.zzB((IBinder)((IBinder)object));
        }
        return null;
    }
}

