/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaae;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzabd;
import com.google.android.gms.internal.zzabe;
import com.google.android.gms.internal.zzabf;
import com.google.android.gms.internal.zzabj;
import com.google.android.gms.internal.zzabk;
import com.google.android.gms.internal.zzabn;
import com.google.android.gms.internal.zzabr;
import com.google.android.gms.internal.zzzq;
import com.google.android.gms.internal.zzzs;
import com.google.android.gms.internal.zzzu;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.internal.zzzz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class zzaap
implements Handler.Callback {
    public static final Status zzaAO = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzaAP = new Status(4, "The user must be signed in to make this API call.");
    private long zzaAo = 5000L;
    private long zzaAn = 120000L;
    private long zzaAQ = 10000L;
    private static final Object zztU = new Object();
    private static zzaap zzaAR;
    private final Context mContext;
    private final GoogleApiAvailability zzaxX;
    private int zzaAS = -1;
    private final AtomicInteger zzaAT = new AtomicInteger(1);
    private final AtomicInteger zzaAU = new AtomicInteger(0);
    private final Map<zzzs<?>, zza<?>> zzazt = new ConcurrentHashMap(5, 0.75f, 1);
    private zzaae zzaAV = null;
    private final Set<zzzs<?>> zzaAW = new com.google.android.gms.common.util.zza();
    private final Set<zzzs<?>> zzaAX = new com.google.android.gms.common.util.zza();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaap zzax(Context context) {
        Object object = zztU;
        synchronized (object) {
            if (zzaAR == null) {
                Looper looper = zzaap.zzvT();
                zzaAR = new zzaap(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzaAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaap zzvS() {
        Object object = zztU;
        synchronized (object) {
            zzac.zzb((Object)zzaAR, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzaAR;
        }
    }

    private static Looper zzvT() {
        HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
        handlerThread.start();
        return handlerThread.getLooper();
    }

    private zzaap(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzaxX = googleApiAvailability;
    }

    public int zzvU() {
        return this.zzaAT.getAndIncrement();
    }

    public void zza(zzc<?> zzc2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, zzc2));
    }

    @WorkerThread
    private void zzb(zzc<?> zzc2) {
        zza<?> zza2;
        zzzs<?> zzzs2 = zzc2.getApiKey();
        if (!this.zzazt.containsKey(zzzs2)) {
            this.zzazt.put(zzzs2, new zza(zzc2));
        }
        if ((zza2 = this.zzazt.get(zzzs2)).zzqD()) {
            this.zzaAX.add(zzzs2);
        }
        zza2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(@NonNull zzaae zzaae2) {
        Object object = zztU;
        synchronized (object) {
            if (this.zzaAV != zzaae2) {
                this.zzaAV = zzaae2;
                this.zzaAW.clear();
                this.zzaAW.addAll((Collection<zzzs<?>>)zzaae2.zzvx());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(@NonNull zzaae zzaae2) {
        Object object = zztU;
        synchronized (object) {
            if (this.zzaAV == zzaae2) {
                this.zzaAV = null;
                this.zzaAW.clear();
            }
        }
    }

    public Task<Void> zza(Iterable<zzc<?>> iterable) {
        zzzu zzzu2 = new zzzu(iterable);
        for (zzc<? extends Api.ApiOptions> zzc2 : iterable) {
            zza<?> zza2 = this.zzazt.get(zzc2.getApiKey());
            if (zza2 != null && zza2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)zzzu2));
            return zzzu2.getTask();
        }
        zzzu2.zzuZ();
        return zzzu2.getTask();
    }

    @WorkerThread
    private void zza(zzzu zzzu2) {
        Set<zzzs<?>> set = zzzu2.zzuY();
        for (zzzs<?> zzzs2 : set) {
            zza<?> zza2 = this.zzazt.get(zzzs2);
            if (zza2 == null) {
                ConnectionResult connectionResult = new ConnectionResult(13);
                zzzu2.zza(zzzs2, connectionResult);
                return;
            }
            if (zza2.isConnected()) {
                zzzu2.zza(zzzs2, ConnectionResult.zzawX);
                continue;
            }
            if (zza2.zzwe() != null) {
                zzzu2.zza(zzzs2, zza2.zzwe());
                continue;
            }
            zza2.zzb(zzzu2);
        }
    }

    public void zzuW() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    @WorkerThread
    private void zzvV() {
        for (zza<?> zza2 : this.zzazt.values()) {
            zza2.zzwd();
            zza2.connect();
        }
    }

    @WorkerThread
    private void zzvW() {
        for (zzzs<?> zzzs2 : this.zzaAX) {
            this.zzazt.remove(zzzs2).signOut();
        }
        this.zzaAX.clear();
    }

    public <O extends Api.ApiOptions> void zza(zzc<O> zzc2, int n, zzzv.zza<? extends Result, Api.zzb> zza2) {
        zzzq.zzb<zzzv.zza<? extends Result, Api.zzb>> zzb2 = new zzzq.zzb<zzzv.zza<? extends Result, Api.zzb>>(n, zza2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)new zzabd(zzb2, this.zzaAU.get(), zzc2)));
    }

    public <O extends Api.ApiOptions, TResult> void zza(zzc<O> zzc2, int n, zzabn<Api.zzb, TResult> zzabn2, TaskCompletionSource<TResult> taskCompletionSource, zzabk zzabk2) {
        zzzq.zzd<TResult> zzd2 = new zzzq.zzd<TResult>(n, zzabn2, taskCompletionSource, zzabk2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)new zzabd(zzd2, this.zzaAU.get(), zzc2)));
    }

    @WorkerThread
    private void zza(zzabd zzabd2) {
        zza<?> zza2 = this.zzazt.get(zzabd2.zzaBF.getApiKey());
        if (zza2 == null) {
            this.zzb(zzabd2.zzaBF);
            zza2 = this.zzazt.get(zzabd2.zzaBF.getApiKey());
        }
        if (zza2.zzqD() && this.zzaAU.get() != zzabd2.zzaBE) {
            zzabd2.zzaBD.zzy(zzaAO);
            zza2.signOut();
            return;
        }
        zza2.zza(zzabd2.zzaBD);
    }

    public <O extends Api.ApiOptions> Task<Void> zza(@NonNull zzc<O> zzc2, @NonNull zzabe<Api.zzb, ?> zzabe2, @NonNull zzabr<Api.zzb, ?> zzabr2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzzq.zzc zzc3 = new zzzq.zzc(new zzabf(zzabe2, zzabr2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, (Object)new zzabd(zzc3, this.zzaAU.get(), zzc2)));
        return taskCompletionSource.getTask();
    }

    public <O extends Api.ApiOptions> Task<Void> zza(@NonNull zzc<O> zzc2, @NonNull zzaaz.zzb<?> zzb2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzzq.zze zze2 = new zzzq.zze(zzb2, (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(11, (Object)new zzabd(zze2, this.zzaAU.get(), zzc2)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.zza((zzzu)message.obj);
                break;
            }
            case 5: {
                this.zzb((zzc)message.obj);
                break;
            }
            case 2: {
                this.zzvV();
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                this.zza((zzabd)message.obj);
                break;
            }
            case 4: {
                this.zza(message.arg1, (ConnectionResult)message.obj);
                break;
            }
            case 7: {
                if (!this.zzazt.containsKey(message.obj)) break;
                this.zzazt.get(message.obj).resume();
                break;
            }
            case 8: {
                this.zzvW();
                break;
            }
            case 9: {
                if (!this.zzazt.containsKey(message.obj)) break;
                this.zzazt.get(message.obj).zzvJ();
                break;
            }
            case 10: {
                if (!this.zzazt.containsKey(message.obj)) break;
                this.zzazt.get(message.obj).zzwh();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    boolean zzc(ConnectionResult connectionResult, int n) {
        if (connectionResult.hasResolution() || this.zzaxX.isUserResolvableError(connectionResult.getErrorCode())) {
            this.zzaxX.zza(this.mContext, connectionResult, n);
            return true;
        }
        return false;
    }

    public void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, n, 0, (Object)connectionResult));
        }
    }

    @WorkerThread
    private void zza(int n, ConnectionResult connectionResult) {
        zza<?> zza2 = null;
        for (zza<?> zza3 : this.zzazt.values()) {
            if (zza3.getInstanceId() != n) continue;
            zza2 = zza3;
            break;
        }
        if (zza2 != null) {
            zza<?> zza3;
            String string2 = String.valueOf(this.zzaxX.getErrorString(connectionResult.getErrorCode()));
            zza3 = String.valueOf(connectionResult.getErrorMessage());
            zza2.zzC(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zza3).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zza3)).toString()));
        } else {
            Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
        }
    }

    private class zzb
    implements zzf.zzf,
    zzabj.zza {
        private final Api.zze zzazq;
        private final zzzs<?> zzaxH;
        private zzr zzazW = null;
        private Set<Scope> zzajm = null;
        private boolean zzaBj = false;

        public zzb(Api.zze zze2, zzzs<?> zzzs2) {
            this.zzazq = zze2;
            this.zzaxH = zzzs2;
        }

        public void zzg(final @NonNull ConnectionResult connectionResult) {
            zzaap.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (connectionResult.isSuccess()) {
                        zzb.this.zzaBj = true;
                        if (zzb.this.zzazq.zzqD()) {
                            zzb.this.zzwi();
                        } else {
                            zzb.this.zzazq.zza(null, Collections.emptySet());
                        }
                    } else {
                        ((zza)zzaap.this.zzazt.get(zzb.this.zzaxH)).onConnectionFailed(connectionResult);
                    }
                }
            });
        }

        @Override
        @WorkerThread
        public void zzi(ConnectionResult connectionResult) {
            ((zza)zzaap.this.zzazt.get(this.zzaxH)).zzi(connectionResult);
        }

        @Override
        @WorkerThread
        public void zzb(zzr zzr2, Set<Scope> set) {
            if (zzr2 == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zzi(new ConnectionResult(4));
            } else {
                this.zzazW = zzr2;
                this.zzajm = set;
                this.zzwi();
            }
        }

        @WorkerThread
        private void zzwi() {
            if (this.zzaBj && this.zzazW != null) {
                this.zzazq.zza(this.zzazW, this.zzajm);
            }
        }
    }

    public class zza<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zzzz {
        private final Queue<zzzq> zzaAY = new LinkedList<zzzq>();
        private final Api.zze zzazq;
        private final Api.zzb zzaAZ;
        private final zzzs<O> zzaxH;
        private final zzaad zzaBa;
        private final Set<zzzu> zzaBb = new HashSet<zzzu>();
        private final Map<zzaaz.zzb<?>, zzabf> zzaBc = new HashMap();
        private final int zzaBd;
        private final zzabj zzaBe;
        private boolean zzaAm;
        private ConnectionResult zzaBf = null;

        @WorkerThread
        public zza(zzc<O> zzc2) {
            this.zzazq = zzc2.buildApiClient(zzaap.this.mHandler.getLooper(), this);
            this.zzaAZ = this.zzazq instanceof zzal ? ((zzal)this.zzazq).zzxG() : this.zzazq;
            this.zzaxH = zzc2.getApiKey();
            this.zzaBa = new zzaad();
            this.zzaBd = zzc2.getInstanceId();
            this.zzaBe = this.zzazq.zzqD() ? zzc2.createSignInCoordinator(zzaap.this.mContext, zzaap.this.mHandler) : null;
        }

        @Override
        public void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == zzaap.this.mHandler.getLooper()) {
                this.zzvZ();
            } else {
                zzaap.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zza.this.zzvZ();
                    }
                });
            }
        }

        @WorkerThread
        private void zzvZ() {
            this.zzwd();
            this.zzj(ConnectionResult.zzawX);
            this.zzwf();
            Iterator<zzabf> iterator = this.zzaBc.values().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                try {
                    new TaskCompletionSource();
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(1);
                    this.zzazq.disconnect();
                    break;
                }
                catch (RemoteException remoteException) {
                }
            }
            this.zzwb();
            this.zzwg();
        }

        @Override
        public void onConnectionSuspended(int n) {
            if (Looper.myLooper() == zzaap.this.mHandler.getLooper()) {
                this.zzwa();
            } else {
                zzaap.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zza.this.zzwa();
                    }
                });
            }
        }

        @WorkerThread
        private void zzwa() {
            this.zzwd();
            this.zzaAm = true;
            this.zzaBa.zzvw();
            zzaap.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzaap.this.mHandler, (int)7, this.zzaxH), zzaap.this.zzaAo);
            zzaap.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzaap.this.mHandler, (int)9, this.zzaxH), zzaap.this.zzaAn);
            zzaap.this.zzaAS = -1;
        }

        @WorkerThread
        public void zzi(@NonNull ConnectionResult connectionResult) {
            zzac.zza((Handler)zzaap.this.mHandler);
            this.zzazq.disconnect();
            this.onConnectionFailed(connectionResult);
        }

        @Override
        public void zza(final ConnectionResult connectionResult, Api<?> api, int n) {
            if (Looper.myLooper() == zzaap.this.mHandler.getLooper()) {
                this.onConnectionFailed(connectionResult);
            } else {
                zzaap.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zza.this.onConnectionFailed(connectionResult);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzac.zza((Handler)zzaap.this.mHandler);
            if (this.zzaBe != null) {
                this.zzaBe.zzwr();
            }
            this.zzwd();
            zzaap.this.zzaAS = -1;
            this.zzj(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zzC(zzaAP);
                return;
            }
            if (this.zzaAY.isEmpty()) {
                this.zzaBf = connectionResult;
                return;
            }
            Object object = zztU;
            synchronized (object) {
                if (zzaap.this.zzaAV != null && zzaap.this.zzaAW.contains(this.zzaxH)) {
                    zzaap.this.zzaAV.zzb(connectionResult, this.zzaBd);
                    return;
                }
            }
            if (!zzaap.this.zzc(connectionResult, this.zzaBd)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zzaAm = true;
                }
                if (this.zzaAm) {
                    zzaap.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzaap.this.mHandler, (int)7, this.zzaxH), zzaap.this.zzaAo);
                } else {
                    object = String.valueOf(this.zzaxH.zzuV());
                    this.zzC(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
                }
            }
        }

        @WorkerThread
        private void zzwb() {
            while (this.zzazq.isConnected() && !this.zzaAY.isEmpty()) {
                zzzq zzzq2 = this.zzaAY.remove();
                this.zzb(zzzq2);
            }
        }

        @WorkerThread
        public void zza(zzzq zzzq2) {
            zzac.zza((Handler)zzaap.this.mHandler);
            if (this.zzazq.isConnected()) {
                this.zzb(zzzq2);
                this.zzwg();
            } else {
                this.zzaAY.add(zzzq2);
                if (this.zzaBf != null && this.zzaBf.hasResolution()) {
                    this.onConnectionFailed(this.zzaBf);
                } else {
                    this.connect();
                }
            }
        }

        @WorkerThread
        public void signOut() {
            zzac.zza((Handler)zzaap.this.mHandler);
            this.zzC(zzaAO);
            this.zzaBa.zzvv();
            for (zzaaz.zzb<?> zzb2 : this.zzaBc.keySet()) {
                this.zza(new zzzq.zze(zzb2, (TaskCompletionSource<Void>)new TaskCompletionSource()));
            }
            this.zzazq.disconnect();
        }

        public Api.zze zzvr() {
            return this.zzazq;
        }

        public Map<zzaaz.zzb<?>, zzabf> zzwc() {
            return this.zzaBc;
        }

        @WorkerThread
        public void zzwd() {
            zzac.zza((Handler)zzaap.this.mHandler);
            this.zzaBf = null;
        }

        @WorkerThread
        public ConnectionResult zzwe() {
            zzac.zza((Handler)zzaap.this.mHandler);
            return this.zzaBf;
        }

        @WorkerThread
        private void zzb(zzzq zzzq2) {
            zzzq2.zza(this.zzaBa, this.zzqD());
            try {
                zzzq2.zza(this);
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzazq.disconnect();
            }
        }

        @WorkerThread
        public void zzC(Status status) {
            zzac.zza((Handler)zzaap.this.mHandler);
            for (zzzq zzzq2 : this.zzaAY) {
                zzzq2.zzy(status);
            }
            this.zzaAY.clear();
        }

        @WorkerThread
        public void resume() {
            zzac.zza((Handler)zzaap.this.mHandler);
            if (this.zzaAm) {
                this.connect();
            }
        }

        @WorkerThread
        private void zzwf() {
            if (this.zzaAm) {
                zzaap.this.mHandler.removeMessages(9, this.zzaxH);
                zzaap.this.mHandler.removeMessages(7, this.zzaxH);
                this.zzaAm = false;
            }
        }

        @WorkerThread
        public void zzvJ() {
            zzac.zza((Handler)zzaap.this.mHandler);
            if (this.zzaAm) {
                this.zzwf();
                int n = zzaap.this.zzaxX.isGooglePlayServicesAvailable(zzaap.this.mContext);
                Status status = n == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zzC(status);
                this.zzazq.disconnect();
            }
        }

        private void zzwg() {
            zzaap.this.mHandler.removeMessages(10, this.zzaxH);
            zzaap.this.mHandler.sendMessageDelayed(zzaap.this.mHandler.obtainMessage(10, this.zzaxH), zzaap.this.zzaAQ);
        }

        @WorkerThread
        public void zzwh() {
            zzac.zza((Handler)zzaap.this.mHandler);
            if (this.zzazq.isConnected() && this.zzaBc.size() == 0) {
                if (this.zzaBa.zzvu()) {
                    this.zzwg();
                    return;
                }
                this.zzazq.disconnect();
            }
        }

        @WorkerThread
        public void connect() {
            zzac.zza((Handler)zzaap.this.mHandler);
            if (this.zzazq.isConnected() || this.zzazq.isConnecting()) {
                return;
            }
            if (this.zzazq.zzuI() && zzaap.this.zzaAS != 0) {
                zzaap.this.zzaAS = zzaap.this.zzaxX.isGooglePlayServicesAvailable(zzaap.this.mContext);
                if (zzaap.this.zzaAS != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(zzaap.this.zzaAS, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            zzb zzb2 = new zzb(this.zzazq, this.zzaxH);
            if (this.zzazq.zzqD()) {
                this.zzaBe.zza(zzb2);
            }
            this.zzazq.zza(zzb2);
        }

        @WorkerThread
        public void zzb(zzzu zzzu2) {
            zzac.zza((Handler)zzaap.this.mHandler);
            this.zzaBb.add(zzzu2);
        }

        @WorkerThread
        private void zzj(ConnectionResult connectionResult) {
            for (zzzu zzzu2 : this.zzaBb) {
                zzzu2.zza(this.zzaxH, connectionResult);
            }
            this.zzaBb.clear();
        }

        boolean isConnected() {
            return this.zzazq.isConnected();
        }

        public boolean zzqD() {
            return this.zzazq.zzqD();
        }

        public int getInstanceId() {
            return this.zzaBd;
        }
    }
}

