/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@zzmb
public class zzpl {
    private final Context mContext;
    private String zzWZ;
    private String zztq;
    private final float zzLP;
    private float zzXa;
    private float zzXb;
    private float zzXc;
    private int mState = 0;

    public zzpl(Context context) {
        this.mContext = context;
        this.zzLP = context.getResources().getDisplayMetrics().density;
    }

    public zzpl(Context context, String string2) {
        this(context);
        this.zzWZ = string2;
    }

    public void zzg(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzXa = f;
            this.zzXb = f2;
            this.zzXc = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzXb) {
                    this.zzXb = f2;
                } else if (f2 < this.zzXc) {
                    this.zzXc = f2;
                }
                if (this.zzXb - this.zzXc > 30.0f * this.zzLP) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzXa >= 50.0f * this.zzLP) {
                        this.zzXa = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzXa <= -50.0f * this.zzLP) {
                    this.zzXa = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzXa) {
                        this.zzXa = f;
                    }
                } else if (this.mState == 2 && f < this.zzXa) {
                    this.zzXa = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void showDialog() {
        if (zzfx.zzER.get().booleanValue() || zzfx.zzEQ.get().booleanValue()) {
            this.zzku();
        } else {
            this.zzkv();
        }
    }

    public void setAdUnitId(String string2) {
        this.zztq = string2;
    }

    public void zzaY(String string2) {
        this.zzWZ = string2;
    }

    private void zzku() {
        if (!(this.mContext instanceof Activity)) {
            zzpe.zzbd((String)"Can not create dialog without Activity Context");
            return;
        }
        Resources resources = zzv.zzcN().getResources();
        String string2 = resources != null ? resources.getString(R.string.debug_menu_title) : "Select a Debug Mode";
        String string3 = resources != null ? resources.getString(R.string.debug_menu_ad_information) : "Ad Information";
        String string4 = resources != null ? resources.getString(R.string.debug_menu_creative_preview) : "Creative Preview";
        String string5 = resources != null ? resources.getString(R.string.debug_menu_troubleshooting) : "Troubleshooting";
        ArrayList<String> arrayList = new ArrayList<String>();
        final int n = this.zza(arrayList, string3, true);
        final int n2 = this.zza(arrayList, string4, zzfx.zzEQ.get());
        final int n3 = this.zza(arrayList, string5, zzfx.zzER.get());
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)string2).setItems((CharSequence[])arrayList.toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n4) {
                if (n4 == n) {
                    zzpl.this.zzkv();
                } else if (n4 == n2 && zzfx.zzEQ.get().booleanValue()) {
                    zzpl.this.zzkw();
                } else if (n4 == n3 && zzfx.zzER.get().booleanValue()) {
                    zzpl.this.zzkx();
                }
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private int zza(List<String> list, String string2, boolean bl) {
        if (!bl) {
            return -1;
        }
        list.add(string2);
        return list.size() - 1;
    }

    private void zzkv() {
        if (!(this.mContext instanceof Activity)) {
            zzpe.zzbd((String)"Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzpl.zzaZ(this.zzWZ);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzv.zzcJ().zzb(zzpl.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(this){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private void zzkw() {
        zzpe.zzbc((String)"Debug mode [Creative Preview] selected.");
        zzph.zza(new Runnable(){

            @Override
            public void run() {
                zzv.zzcR().zzj(zzpl.this.mContext, zzpl.this.zztq);
            }
        });
    }

    private void zzkx() {
        zzpe.zzbc((String)"Debug mode [Troubleshooting] selected.");
        zzph.zza(new Runnable(){

            @Override
            public void run() {
                zzv.zzcR().zzk(zzpl.this.mContext, zzpl.this.zztq);
            }
        });
    }

    static String zzaZ(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzv.zzcJ().zzg(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

