/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzo
extends zzn
implements Handler.Callback {
    private final HashMap<zza, zzb> zzaEF = new HashMap();
    private final Context zzvZ;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zza zzaEG;
    private final long zzaEH;

    zzo(Context context) {
        this.zzvZ = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzaEG = com.google.android.gms.common.stats.zza.zzyc();
        this.zzaEH = 5000L;
    }

    @Override
    public boolean zza(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        return this.zza(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzac.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzaEF;
        synchronized (hashMap) {
            zzb zzb2 = this.zzaEF.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzdr(string2);
                this.zzaEF.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zza2);
                if (zzb2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzdr(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzac.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzaEF;
        synchronized (hashMap) {
            zzb zzb2 = this.zzaEF.get(zza2);
            if (zzb2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzb2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzxt()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zza2);
                this.mHandler.sendMessageDelayed(message, this.zzaEH);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                zza zza2 = (zza)message.obj;
                HashMap<zza, zzb> hashMap = this.zzaEF;
                synchronized (hashMap) {
                    zzb zzb2 = this.zzaEF.get(zza2);
                    if (zzb2 != null && zzb2.zzxt()) {
                        if (zzb2.isBound()) {
                            zzb2.zzds("GmsClientSupervisor");
                        }
                        this.zzaEF.remove(zza2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzaca;
        private final String zzaEI;
        private final ComponentName zzaEJ;

        public zza(String string2, String string3) {
            this.zzaca = zzac.zzdv(string2);
            this.zzaEI = zzac.zzdv(string3);
            this.zzaEJ = null;
        }

        public zza(ComponentName componentName) {
            this.zzaca = null;
            this.zzaEI = null;
            this.zzaEJ = zzac.zzw(componentName);
        }

        public String toString() {
            return this.zzaca == null ? this.zzaEJ.flattenToString() : this.zzaca;
        }

        public Intent zzxs() {
            Intent intent = this.zzaca != null ? new Intent(this.zzaca).setPackage(this.zzaEI) : new Intent().setComponent(this.zzaEJ);
            return intent;
        }

        public int hashCode() {
            return zzaa.hashCode(this.zzaca, this.zzaEJ);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return zzaa.equal(this.zzaca, zza2.zzaca) && zzaa.equal(this.zzaEJ, zza2.zzaEJ);
        }
    }

    private final class zzb {
        private final zza zzaEK;
        private final Set<ServiceConnection> zzaEL;
        private int mState;
        private boolean zzaEM;
        private IBinder zzaEa;
        private final com.google.android.gms.common.internal.zzo$zza zzaEN;
        private ComponentName zzaEJ;

        public zzb(com.google.android.gms.common.internal.zzo$zza zza2) {
            this.zzaEN = zza2;
            this.zzaEK = new zza();
            this.zzaEL = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        @TargetApi(value=14)
        public void zzdr(String string2) {
            this.mState = 3;
            this.zzaEM = zzo.this.zzaEG.zza(zzo.this.zzvZ, string2, this.zzaEN.zzxs(), this.zzaEK, 129);
            if (!this.zzaEM) {
                this.mState = 2;
                try {
                    zzo.this.zzaEG.zza(zzo.this.zzvZ, this.zzaEK);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        public void zzds(String string2) {
            zzo.this.zzaEG.zza(zzo.this.zzvZ, this.zzaEK);
            this.zzaEM = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzo.this.zzaEG.zza(zzo.this.zzvZ, serviceConnection, string2, this.zzaEN.zzxs());
            this.zzaEL.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzo.this.zzaEG.zzb(zzo.this.zzvZ, serviceConnection);
            this.zzaEL.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzaEM;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzaEL.contains(serviceConnection);
        }

        public boolean zzxt() {
            return this.zzaEL.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzaEa;
        }

        public ComponentName getComponentName() {
            return this.zzaEJ;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HashMap hashMap = zzo.this.zzaEF;
                synchronized (hashMap) {
                    zzb.this.zzaEa = iBinder;
                    zzb.this.zzaEJ = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.zzaEL) {
                        serviceConnection.onServiceConnected(componentName, iBinder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName componentName) {
                HashMap hashMap = zzo.this.zzaEF;
                synchronized (hashMap) {
                    zzb.this.zzaEa = null;
                    zzb.this.zzaEJ = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.zzaEL) {
                        serviceConnection.onServiceDisconnected(componentName);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

