/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzg;
import com.google.firebase.iid.zzh;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class FirebaseInstanceId {
    private static Map<String, FirebaseInstanceId> zzbha = new ArrayMap();
    private static zze zzciQ;
    private final FirebaseApp zzciR;
    private final zzd zzciS;
    private final String zzciT;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzbha.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            zzd zzd2 = zzd.zzb(firebaseApp.getApplicationContext(), null);
            if (zzciQ == null) {
                zzciQ = new zze(zzd2.zzaag());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, zzd2);
            zzbha.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzd zzd2) {
        this.zzciR = firebaseApp;
        this.zzciS = zzd2;
        this.zzciT = this.zzaac();
        if (this.zzciT == null) {
            throw new IllegalStateException("IID failing to initialize, FirebaseApp is missing project ID");
        }
        FirebaseInstanceIdService.zza(this.zzciR.getApplicationContext(), this);
    }

    String zzaac() {
        String string = this.zzciR.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = this.zzciR.getOptions().getApplicationId();
        if (string2.startsWith("1:")) {
            String[] stringArray = string2.split(":");
            if (stringArray.length < 2) {
                return null;
            }
            String string3 = stringArray[1];
            if (string3.isEmpty()) {
                return null;
            }
            return string3;
        }
        return string2;
    }

    public String getId() {
        return FirebaseInstanceId.zza(this.zzciS.zzGt());
    }

    public long getCreationTime() {
        return this.zzciS.getCreationTime();
    }

    public void deleteInstanceId() throws IOException {
        this.zzciS.zzb("*", "*", null);
        this.zzciS.zzGu();
    }

    @Nullable
    public String getToken() {
        zzh.zza zza2 = this.zzaad();
        if (zza2 == null || zza2.zzjC(zzd.zzbhg)) {
            FirebaseInstanceIdService.zzbV(this.zzciR.getApplicationContext());
        }
        return zza2 != null ? zza2.zzbwP : null;
    }

    @Nullable
    zzh.zza zzaad() {
        return this.zzciS.zzaag().zzq("", this.zzciT, "*");
    }

    String zzaae() throws IOException {
        return this.getToken(this.zzciT, "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        return this.zzciS.getToken(string, string2, null);
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        this.zzciS.zzb(string, string2, null);
    }

    public void zzju(String string) {
        zzciQ.zzju(string);
        FirebaseInstanceIdService.zzbV(this.zzciR.getApplicationContext());
    }

    zze zzaaf() {
        return zzciQ;
    }

    void zzjv(String string) throws IOException {
        zzh.zza zza2 = this.zzaad();
        if (zza2 == null || zza2.zzjC(zzd.zzbhg)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzciS.getToken(zza2.zzbwP, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    void zzjw(String string) throws IOException {
        zzh.zza zza2 = this.zzaad();
        if (zza2 == null || zza2.zzjC(zzd.zzbhg)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzciS.zzb(zza2.zzbwP, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    static String zzbT(Context context) {
        return FirebaseInstanceId.getInstance().zzciR.getOptions().getApplicationId();
    }

    static String zzv(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)(n & 0xFF);
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    static int zzbU(Context context) {
        return FirebaseInstanceId.zzK(context, context.getPackageName());
    }

    static int zzK(Context context, String string) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return 0;
        }
    }

    static String zzbg(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    static void zza(Context context, zzh zzh2) {
        zzh2.zzGA();
        Intent intent = new Intent();
        intent.putExtra("CMD", "RST");
        zzg.zzaaj().zzf(context, intent);
    }

    static void zzbh(Context context) {
        Intent intent = new Intent();
        intent.putExtra("CMD", "SYNC");
        zzg.zzaaj().zzf(context, intent);
    }
}

