/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzaa;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzqp;
import java.util.HashMap;

@zzmb
public class zzl
extends FrameLayout
implements zzi {
    private final zzqp zzGt;
    private final FrameLayout zzNl;
    private final zzgf zzNm;
    private final zzaa zzNn;
    private final long zzNo;
    @Nullable
    private zzj zzNp;
    private boolean zzNq;
    private boolean zzNr;
    private boolean zzNs;
    private boolean zzNt;
    private long zzNu;
    private long zzNv;
    private String zzHV;
    private Bitmap zzNw;
    private ImageView zzNx;
    private boolean zzNy;

    public static void zzi(zzqp zzqp2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzqp2.zza("onVideoEvent", hashMap);
    }

    public zzl(Context context, zzqp zzqp2, int n, boolean bl, zzgf zzgf2) {
        super(context);
        this.zzGt = zzqp2;
        this.zzNm = zzgf2;
        this.zzNl = new FrameLayout(context);
        this.addView((View)this.zzNl, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzt((Object)zzqp2.zzbz());
        this.zzNp = zzqp2.zzbz().zzsN.zza(context, zzqp2, n, bl, zzgf2);
        if (this.zzNp != null) {
            this.zzNl.addView((View)this.zzNp, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            if (zzfx.zzBr.get().booleanValue()) {
                this.zzhG();
            }
        }
        this.zzNx = new ImageView(context);
        this.zzNo = zzfx.zzBv.get();
        this.zzNt = zzfx.zzBt.get();
        if (this.zzNm != null) {
            this.zzNm.zzg("spinner_used", this.zzNt ? "1" : "0");
        }
        this.zzNn = new zzaa(this);
        this.zzNn.zzid();
        if (this.zzNp != null) {
            this.zzNp.zza(this);
        }
        if (this.zzNp == null) {
            this.zzk("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    private void zzg(int n, int n2) {
        if (!this.zzNt) {
            return;
        }
        n = Math.max(n / zzfx.zzBu.get(), 1);
        n2 = Math.max(n2 / zzfx.zzBu.get(), 1);
        if (this.zzNw != null && this.zzNw.getWidth() == n && this.zzNw.getHeight() == n2) {
            return;
        }
        this.zzNw = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.zzNy = false;
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzNl.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void zzaB(String string2) {
        this.zzHV = string2;
    }

    public void zza(float f, float f2) {
        if (this.zzNp != null) {
            this.zzNp.zza(f, f2);
        }
    }

    public void zzgq() {
        if (this.zzNp == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzHV)) {
            this.zzNp.setVideoPath(this.zzHV);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzNp == null) {
            return;
        }
        this.zzNp.pause();
    }

    public void play() {
        if (this.zzNp == null) {
            return;
        }
        this.zzNp.play();
    }

    public void seekTo(int n) {
        if (this.zzNp == null) {
            return;
        }
        this.zzNp.seekTo(n);
    }

    public void zzhE() {
        if (this.zzNp == null) {
            return;
        }
        this.zzNp.zzhE();
    }

    public void zzhF() {
        if (this.zzNp == null) {
            return;
        }
        this.zzNp.zzhF();
    }

    public void zzb(float f) {
        if (this.zzNp == null) {
            return;
        }
        this.zzNp.zzb(f);
    }

    @TargetApi(value=14)
    public void zzf(MotionEvent motionEvent) {
        if (this.zzNp == null) {
            return;
        }
        this.zzNp.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public void zzhG() {
        if (this.zzNp == null) {
            return;
        }
        Context context = this.zzNp.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzNp.zzhd());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzNl.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzNl.bringChildToFront((View)textView);
    }

    @Override
    public void zzhy() {
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zza("surfaceCreated", new String[0]);
            }
        });
    }

    @Override
    public void zzhz() {
        if (this.zzNp == null) {
            return;
        }
        if (this.zzNv == 0L) {
            float f = (float)this.zzNp.getDuration() / 1000.0f;
            int n = this.zzNp.getVideoWidth();
            int n2 = this.zzNp.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzhA() {
        this.zzhM();
        this.zzNq = true;
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzhN();
        this.zzNq = false;
    }

    @Override
    public void zzhB() {
        this.zza("ended", new String[0]);
        this.zzhN();
    }

    @Override
    public void zzk(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public void zzhC() {
        this.zzhJ();
        this.zzNv = this.zzNu;
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zza("surfaceDestroyed", new String[0]);
            }
        });
    }

    public void destroy() {
        this.zzNn.cancel();
        if (this.zzNp != null) {
            this.zzNp.stop();
        }
        this.zzhN();
    }

    void zzhH() {
        if (this.zzNp == null) {
            return;
        }
        long l = this.zzNp.getCurrentPosition();
        if (this.zzNu != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzNu = l;
        }
    }

    @Override
    public void zzhD() {
        if (this.zzNq) {
            this.zzhK();
        }
        this.zzhI();
    }

    @Override
    public void zzf(int n, int n2) {
        this.zzg(n, n2);
    }

    @TargetApi(value=14)
    private void zzhI() {
        if (this.zzNw == null) {
            return;
        }
        long l = zzv.zzcP().elapsedRealtime();
        if (this.zzNp.getBitmap(this.zzNw) != null) {
            this.zzNy = true;
        }
        long l2 = zzv.zzcP().elapsedRealtime() - l;
        if (zzpe.zzkh()) {
            zzpe.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
        }
        if (l2 > this.zzNo) {
            zzpe.zzbe((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
            this.zzNt = false;
            this.zzNw = null;
            if (this.zzNm != null) {
                this.zzNm.zzg("spinner_jank", Long.toString(l2));
            }
        }
    }

    private void zzhJ() {
        if (this.zzNy && this.zzNw != null && !this.zzhL()) {
            this.zzNx.setImageBitmap(this.zzNw);
            this.zzNx.invalidate();
            this.zzNl.addView((View)this.zzNx, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzNl.bringChildToFront((View)this.zzNx);
        }
    }

    private void zzhK() {
        if (this.zzhL()) {
            this.zzNl.removeView((View)this.zzNx);
        }
    }

    private boolean zzhL() {
        return this.zzNx.getParent() != null;
    }

    private void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        for (String string4 : stringArray) {
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzGt.zza("onVideoEvent", hashMap);
    }

    private void zzhM() {
        if (this.zzGt.zzkR() == null) {
            return;
        }
        if (this.zzNr) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzGt.zzkR().getWindow().getAttributes();
        boolean bl = this.zzNs = (layoutParams.flags & 0x80) != 0;
        if (!this.zzNs) {
            this.zzGt.zzkR().getWindow().addFlags(128);
            this.zzNr = true;
        }
    }

    private void zzhN() {
        if (this.zzGt.zzkR() == null) {
            return;
        }
        if (this.zzNr && !this.zzNs) {
            this.zzGt.zzkR().getWindow().clearFlags(128);
            this.zzNr = false;
        }
    }
}

