/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbut;
import com.google.android.gms.internal.zzbuw;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzbum {
    private final ByteBuffer zzcrW;

    private zzbum(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzbum(ByteBuffer byteBuffer) {
        this.zzcrW = byteBuffer;
        this.zzcrW.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzbum zzae(byte[] byArray) {
        return zzbum.zzc(byArray, 0, byArray.length);
    }

    public static zzbum zzc(byte[] byArray, int n, int n2) {
        return new zzbum(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzJ(n, 1);
        this.zzn(d);
    }

    public void zzc(int n, float f) throws IOException {
        this.zzJ(n, 5);
        this.zzk(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzJ(n, 0);
        this.zzaW(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzJ(n, 0);
        this.zzaX(l);
    }

    public void zzF(int n, int n2) throws IOException {
        this.zzJ(n, 0);
        this.zzqn(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzJ(n, 1);
        this.zzaY(l);
    }

    public void zzg(int n, boolean bl) throws IOException {
        this.zzJ(n, 0);
        this.zzbl(bl);
    }

    public void zzq(int n, String string2) throws IOException {
        this.zzJ(n, 2);
        this.zzkb(string2);
    }

    public void zza(int n, zzbut zzbut2) throws IOException {
        this.zzJ(n, 2);
        this.zzc(zzbut2);
    }

    public void zzb(int n, byte[] byArray) throws IOException {
        this.zzJ(n, 2);
        this.zzaf(byArray);
    }

    public void zzG(int n, int n2) throws IOException {
        this.zzJ(n, 0);
        this.zzqo(n2);
    }

    public void zzd(int n, long l) throws IOException {
        this.zzJ(n, 0);
        this.zzaZ(l);
    }

    public void zzn(double d) throws IOException {
        this.zzbf(Double.doubleToLongBits(d));
    }

    public void zzk(float f) throws IOException {
        this.zzqv(Float.floatToIntBits(f));
    }

    public void zzaW(long l) throws IOException {
        this.zzbd(l);
    }

    public void zzaX(long l) throws IOException {
        this.zzbd(l);
    }

    public void zzqn(int n) throws IOException {
        if (n >= 0) {
            this.zzqt(n);
        } else {
            this.zzbd(n);
        }
    }

    public void zzaY(long l) throws IOException {
        this.zzbf(l);
    }

    public void zzbl(boolean bl) throws IOException {
        this.zzqr(bl ? 1 : 0);
    }

    public void zzkb(String string2) throws IOException {
        try {
            int n = zzbum.zzqu(string2.length());
            int n2 = zzbum.zzqu(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzcrW.position();
                if (this.zzcrW.remaining() < n) {
                    throw new zza(n3 + n, this.zzcrW.limit());
                }
                this.zzcrW.position(n3 + n);
                zzbum.zza((CharSequence)string2, this.zzcrW);
                int n4 = this.zzcrW.position();
                this.zzcrW.position(n3);
                this.zzqt(n4 - n3 - n);
                this.zzcrW.position(n4);
            } else {
                this.zzqt(zzbum.zzb(string2));
                zzbum.zza((CharSequence)string2, this.zzcrW);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.zzcrW.position(), this.zzcrW.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzb(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzbum.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                int n5 = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n5).toString());
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzbum.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzbum.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n5 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n + n4;
        }
        int n6 = n + n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n6 < n5) {
                byArray[n6++] = (byte)c;
            } else if (c < '\u0800' && n6 <= n5 - 2) {
                byArray[n6++] = (byte)(0x3C0 | c >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n6 <= n5 - 3) {
                byArray[n6++] = (byte)(0x1E0 | c >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c);
            } else if (n6 <= n5 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n6++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n6;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n6;
    }

    public void zzb(zzbut zzbut2) throws IOException {
        zzbut2.zza(this);
    }

    public void zzc(zzbut zzbut2) throws IOException {
        this.zzqt(zzbut2.zzacY());
        zzbut2.zza(this);
    }

    public void zzaf(byte[] byArray) throws IOException {
        this.zzqt(byArray.length);
        this.zzah(byArray);
    }

    public void zzqo(int n) throws IOException {
        this.zzqt(zzbum.zzqw(n));
    }

    public void zzaZ(long l) throws IOException {
        this.zzbd(zzbum.zzbg(l));
    }

    public static int zzb(int n, double d) {
        return zzbum.zzqs(n) + 8;
    }

    public static int zzd(int n, float f) {
        return zzbum.zzqs(n) + 4;
    }

    public static int zze(int n, long l) {
        return zzbum.zzqs(n) + zzbum.zzba(l);
    }

    public static int zzf(int n, long l) {
        return zzbum.zzqs(n) + zzbum.zzbb(l);
    }

    public static int zzH(int n, int n2) {
        return zzbum.zzqs(n) + zzbum.zzqp(n2);
    }

    public static int zzg(int n, long l) {
        return zzbum.zzqs(n) + 8;
    }

    public static int zzh(int n, boolean bl) {
        return zzbum.zzqs(n) + 1;
    }

    public static int zzr(int n, String string2) {
        return zzbum.zzqs(n) + zzbum.zzkc(string2);
    }

    public static int zzb(int n, zzbut zzbut2) {
        return zzbum.zzqs(n) * 2 + zzbum.zzd(zzbut2);
    }

    public static int zzc(int n, zzbut zzbut2) {
        return zzbum.zzqs(n) + zzbum.zze(zzbut2);
    }

    public static int zzc(int n, byte[] byArray) {
        return zzbum.zzqs(n) + zzbum.zzag(byArray);
    }

    public static int zzI(int n, int n2) {
        return zzbum.zzqs(n) + zzbum.zzqq(n2);
    }

    public static int zzh(int n, long l) {
        return zzbum.zzqs(n) + zzbum.zzbc(l);
    }

    public static int zzba(long l) {
        return zzbum.zzbe(l);
    }

    public static int zzbb(long l) {
        return zzbum.zzbe(l);
    }

    public static int zzqp(int n) {
        if (n >= 0) {
            return zzbum.zzqu(n);
        }
        return 10;
    }

    public static int zzkc(String string2) {
        int n = zzbum.zzb(string2);
        return zzbum.zzqu(n) + n;
    }

    public static int zzd(zzbut zzbut2) {
        return zzbut2.zzacZ();
    }

    public static int zze(zzbut zzbut2) {
        int n = zzbut2.zzacZ();
        return zzbum.zzqu(n) + n;
    }

    public static int zzag(byte[] byArray) {
        return zzbum.zzqu(byArray.length) + byArray.length;
    }

    public static int zzqq(int n) {
        return zzbum.zzqu(zzbum.zzqw(n));
    }

    public static int zzbc(long l) {
        return zzbum.zzbe(zzbum.zzbg(l));
    }

    public int zzacL() {
        return this.zzcrW.remaining();
    }

    public void zzacM() {
        if (this.zzacL() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzc(byte by) throws IOException {
        if (!this.zzcrW.hasRemaining()) {
            throw new zza(this.zzcrW.position(), this.zzcrW.limit());
        }
        this.zzcrW.put(by);
    }

    public void zzqr(int n) throws IOException {
        this.zzc((byte)n);
    }

    public void zzah(byte[] byArray) throws IOException {
        this.zzd(byArray, 0, byArray.length);
    }

    public void zzd(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzcrW.remaining() < n2) {
            throw new zza(this.zzcrW.position(), this.zzcrW.limit());
        }
        this.zzcrW.put(byArray, n, n2);
    }

    public void zzJ(int n, int n2) throws IOException {
        this.zzqt(zzbuw.zzK(n, n2));
    }

    public static int zzqs(int n) {
        return zzbum.zzqu(zzbuw.zzK(n, 0));
    }

    public void zzqt(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzqr(n);
                return;
            }
            this.zzqr(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzqu(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzbd(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzqr((int)l);
                return;
            }
            this.zzqr((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzbe(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzqv(int n) throws IOException {
        if (this.zzcrW.remaining() < 4) {
            throw new zza(this.zzcrW.position(), this.zzcrW.limit());
        }
        this.zzcrW.putInt(n);
    }

    public void zzbf(long l) throws IOException {
        if (this.zzcrW.remaining() < 8) {
            throw new zza(this.zzcrW.position(), this.zzcrW.limit());
        }
        this.zzcrW.putLong(l);
    }

    public static int zzqw(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzbg(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super(new StringBuilder(108).append("CodedOutputStream was writing to a flat byte array and ran out of space (pos ").append(n).append(" limit ").append(n2).append(").").toString());
        }
    }
}

