/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzf<T extends IInterface> {
    private int zzaDB;
    private long zzaDC;
    private long zzaDD;
    private int zzaDE;
    private long zzaDF;
    private final Context mContext;
    private final Looper zzrx;
    private final zzn zzaDG;
    private final com.google.android.gms.common.zzc zzazw;
    final Handler mHandler;
    private final Object zzrN = new Object();
    private final Object zzaDH = new Object();
    private zzv zzaDI;
    protected zzf zzaDJ;
    private T zzaDK;
    private final ArrayList<zze<?>> zzaDL = new ArrayList();
    private zzh zzaDM;
    private int zzaDN = 1;
    private final zzb zzaDO;
    private final zzc zzaDP;
    private final int zzaDQ;
    private final String zzaDR;
    protected AtomicInteger zzaDS = new AtomicInteger(0);
    public static final String[] zzaDT = new String[]{"service_esmobile", "service_googleme"};

    protected zzf(Context context, Looper looper, int n, zzb zzb2, zzc zzc2, String string2) {
        this(context, looper, zzn.zzaC(context), com.google.android.gms.common.zzc.zzuz(), n, zzac.zzw(zzb2), zzac.zzw(zzc2), string2);
    }

    protected zzf(Context context, Looper looper, zzn zzn2, com.google.android.gms.common.zzc zzc2, int n, zzb zzb2, zzc zzc3, String string2) {
        this.mContext = zzac.zzb(context, (Object)"Context must not be null");
        this.zzrx = zzac.zzb(looper, (Object)"Looper must not be null");
        this.zzaDG = zzac.zzb(zzn2, (Object)"Supervisor must not be null");
        this.zzazw = zzac.zzb(zzc2, (Object)"API availability must not be null");
        this.mHandler = new zzd(looper);
        this.zzaDQ = n;
        this.zzaDO = zzb2;
        this.zzaDP = zzc3;
        this.zzaDR = string2;
    }

    @NonNull
    protected abstract String zzeu();

    protected String zzwP() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzev();

    @Nullable
    protected final String zzwQ() {
        return this.zzaDR == null ? this.mContext.getClass().getName() : this.zzaDR;
    }

    @Nullable
    protected abstract T zzh(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzaDD = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzaDB = n;
        this.zzaDC = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzaDE = connectionResult.getErrorCode();
        this.zzaDF = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(int n, T t) {
        zzac.zzas(n == 3 == (t != null));
        Object object = this.zzrN;
        synchronized (object) {
            this.zzaDN = n;
            this.zzaDK = t;
            switch (n) {
                case 2: {
                    this.zzwR();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzwS();
                }
            }
        }
    }

    private void zzwR() {
        String string2;
        if (this.zzaDM != null) {
            String string3 = String.valueOf(this.zzeu());
            string2 = String.valueOf(this.zzwP());
            Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
            this.zzaDG.zzb(this.zzeu(), this.zzwP(), this.zzaDM, this.zzwQ());
            this.zzaDS.incrementAndGet();
        }
        this.zzaDM = new zzh(this.zzaDS.get());
        boolean bl = this.zzaDG.zza(this.zzeu(), this.zzwP(), this.zzaDM, this.zzwQ());
        if (!bl) {
            string2 = String.valueOf(this.zzeu());
            String string4 = String.valueOf(this.zzwP());
            Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
            this.zza(16, null, this.zzaDS.get());
        }
    }

    private void zzwS() {
        if (this.zzaDM != null) {
            this.zzaDG.zzb(this.zzeu(), this.zzwP(), this.zzaDM, this.zzwQ());
            this.zzaDM = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzaDN != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public void zzwT() {
        int n = this.zzazw.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zzaDJ = new zzi();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaDS.get(), n));
            return;
        }
        this.zza(new zzi());
    }

    public void zza(@NonNull zzf zzf2) {
        this.zzaDJ = zzac.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzaDN == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzaDN == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzaDS.incrementAndGet();
        Object object = this.zzaDL;
        synchronized (object) {
            int n = this.zzaDL.size();
            for (int i = 0; i < n; ++i) {
                this.zzaDL.get(i).zzxb();
            }
            this.zzaDL.clear();
        }
        object = this.zzaDH;
        synchronized (object) {
            this.zzaDI = null;
        }
        this.zza(1, null);
    }

    public void zzcM(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzaDS.get(), n));
    }

    public void zza(zzf zzf2, ConnectionResult connectionResult) {
        this.zzaDJ = zzac.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaDS.get(), connectionResult.getErrorCode(), (Object)connectionResult.getResolution()));
    }

    private void zzm(ConnectionResult connectionResult) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaDS.get(), connectionResult.getErrorCode(), (Object)connectionResult.getResolution()));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzrx;
    }

    public Account getAccount() {
        return null;
    }

    public final Account zzwU() {
        return this.getAccount() != null ? this.getAccount() : new Account("<<default account>>", "com.google");
    }

    protected Bundle zzql() {
        return new Bundle();
    }

    @BinderThread
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzj(n, iBinder, bundle)));
    }

    protected void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzk(n, bundle)));
    }

    protected final void zzwV() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzud() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzwW() throws DeadObjectException {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzaDN == 4) {
                throw new DeadObjectException();
            }
            this.zzwV();
            zzac.zza(this.zzaDK != null, (Object)"Client is connected but service is null");
            return this.zzaDK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(zzr zzr2, Set<Scope> set) {
        Bundle bundle = this.zzql();
        com.google.android.gms.common.internal.zzj zzj2 = new com.google.android.gms.common.internal.zzj(this.zzaDQ).zzdq(this.mContext.getPackageName()).zzp(bundle);
        if (set != null) {
            zzj2.zzf(set);
        }
        if (this.zzqD()) {
            zzj2.zze(this.zzwU()).zzb(zzr2);
        } else if (this.zzwX()) {
            zzj2.zze(this.getAccount());
        }
        try {
            Object object = this.zzaDH;
            synchronized (object) {
                if (this.zzaDI != null) {
                    this.zzaDI.zza((zzu)new zzg(this, this.zzaDS.get()), zzj2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzcM(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)runtimeException);
            this.zzm(new ConnectionResult(8, null, "IGmsServiceBroker.getService failed."));
        }
    }

    public boolean zzqD() {
        return false;
    }

    public boolean zzwX() {
        return false;
    }

    public boolean zzuI() {
        return true;
    }

    public boolean zzqS() {
        return false;
    }

    public Intent zzqT() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzwY() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        T t;
        int n;
        Object object = this.zzrN;
        synchronized (object) {
            n = this.zzaDN;
            t = this.zzaDK;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("CONNECTED");
                break;
            }
            case 4: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.println("null");
        } else {
            printWriter.append(this.zzev()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzaDD > 0L) {
            l = this.zzaDD;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaDD)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaDC > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzaDB) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzaDB));
                }
            }
            l = this.zzaDC;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaDC)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaDF > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzaDE));
            l = this.zzaDF;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaDF)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder zzuJ() {
        Object object = this.zzaDH;
        synchronized (object) {
            if (this.zzaDI == null) {
                return null;
            }
            return this.zzaDI.asBinder();
        }
    }

    public static final class zzg
    extends zzu.zza {
        private zzf zzaDX;
        private final int zzaDY;

        public zzg(@NonNull zzf zzf2, int n) {
            this.zzaDX = zzf2;
            this.zzaDY = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzac.zzb(this.zzaDX, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzaDX.zza(n, iBinder, bundle, this.zzaDY);
            this.zzxc();
        }

        private void zzxc() {
            this.zzaDX = null;
        }
    }

    private abstract class zza
    extends zze<Boolean> {
        public final int statusCode;
        public final Bundle zzaDU;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzaDU = bundle;
        }

        protected abstract boolean zzwZ();

        protected abstract void zzn(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzf.this.zza(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzwZ()) break;
                    zzf.this.zza(1, null);
                    this.zzn(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzf.this.zza(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzf.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzaDU != null) {
                        pendingIntent = (PendingIntent)this.zzaDU.getParcelable("pendingIntent");
                    }
                    this.zzn(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected /* synthetic */ void zzu(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzj
    extends zza {
        public final IBinder zzaDZ;

        @BinderThread
        public zzj(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzaDZ = iBinder;
        }

        @Override
        protected void zzn(ConnectionResult connectionResult) {
            if (zzf.this.zzaDP != null) {
                zzf.this.zzaDP.onConnectionFailed(connectionResult);
            }
            zzf.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzwZ() {
            String string2;
            try {
                string2 = this.zzaDZ.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzf.this.zzev().equals(string2)) {
                String string3 = String.valueOf(zzf.this.zzev());
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = zzf.this.zzh(this.zzaDZ);
            if (t != null && zzf.this.zza(2, 3, t)) {
                Bundle bundle = zzf.this.zzud();
                if (zzf.this.zzaDO != null) {
                    zzf.this.zzaDO.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzk
    extends zza {
        @BinderThread
        public zzk(int n, @Nullable Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzn(ConnectionResult connectionResult) {
            zzf.this.zzaDJ.zzg(connectionResult);
            zzf.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzwZ() {
            zzf.this.zzaDJ.zzg(ConnectionResult.zzawX);
            return true;
        }
    }

    protected class zzi
    implements zzf {
        @Override
        public void zzg(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzf.this.zza(null, zzf.this.zzwY());
            } else if (zzf.this.zzaDP != null) {
                zzf.this.zzaDP.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zze<TListener> {
        private TListener mListener;
        private boolean zzaDW;

        public zze(TListener TListener) {
            this.mListener = TListener;
            this.zzaDW = false;
        }

        protected abstract void zzu(TListener var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzxa() {
            TListener TListener;
            zze zze2 = this;
            synchronized (zze2) {
                TListener = this.mListener;
                if (this.zzaDW) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                this.zzu(TListener);
            }
            zze2 = this;
            synchronized (zze2) {
                this.zzaDW = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzxb();
            ArrayList arrayList = zzf.this.zzaDL;
            synchronized (arrayList) {
                zzf.this.zzaDL.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzxb() {
            zze zze2 = this;
            synchronized (zze2) {
                this.mListener = null;
            }
        }
    }

    final class zzd
    extends Handler {
        public zzd(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (zzf.this.zzaDS.get() != message.arg1) {
                if (this.zzb(message)) {
                    this.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 5 || zzf.this.isConnecting())) {
                this.zza(message);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                zzf.this.zzaDJ.zzg(connectionResult);
                zzf.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 4) {
                zzf.this.zza(4, null);
                if (zzf.this.zzaDO != null) {
                    zzf.this.zzaDO.onConnectionSuspended(message.arg2);
                }
                zzf.this.onConnectionSuspended(message.arg2);
                zzf.this.zza(4, 1, null);
                return;
            }
            if (message.what == 2 && !zzf.this.isConnected()) {
                this.zza(message);
                return;
            }
            if (this.zzb(message)) {
                zze zze2 = (zze)message.obj;
                zze2.zzxa();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zze zze2 = (zze)message.obj;
            zze2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public static interface zzf {
        public void zzg(@NonNull ConnectionResult var1);
    }

    public static interface zzc {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface zzb {
        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public final class zzh
    implements ServiceConnection {
        private final int zzaDY;

        public zzh(int n) {
            this.zzaDY = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                zzf.this.zzm(new ConnectionResult(8, null, "ServiceBroker IBinder is null"));
                return;
            }
            Object object = zzf.this.zzaDH;
            synchronized (object) {
                zzf.this.zzaDI = zzv.zza.zzbu(iBinder);
            }
            zzf.this.zza(0, null, this.zzaDY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = zzf.this.zzaDH;
            synchronized (object) {
                zzf.this.zzaDI = null;
            }
            zzf.this.mHandler.sendMessage(zzf.this.mHandler.obtainMessage(4, this.zzaDY, 1));
        }
    }
}

