/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzes;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfi;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlf;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zznr;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zzpy;

@zzmb
public class zzeg {
    private zzes zzzs;
    private final Object zzrN = new Object();
    private final zzdx zzzt;
    private final zzdw zzzu;
    private final zzfd zzzv;
    private final zzhn zzzw;
    private final zznv zzzx;
    private final zzlf zzzy;
    private final zzkq zzzz;

    public zzeg(zzdx zzdx2, zzdw zzdw2, zzfd zzfd2, zzhn zzhn2, zznv zznv2, zzlf zzlf2, zzkq zzkq2) {
        this.zzzt = zzdx2;
        this.zzzu = zzdw2;
        this.zzzv = zzfd2;
        this.zzzw = zzhn2;
        this.zzzx = zznv2;
        this.zzzy = zzlf2;
        this.zzzz = zzkq2;
    }

    @Nullable
    private static zzes zzeB() {
        try {
            Object obj = zzeg.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzpy.zzbe("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzes.zza.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzpy.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private zzes zzeC() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzzs == null) {
                this.zzzs = zzeg.zzeB();
            }
            return this.zzzs;
        }
    }

    @VisibleForTesting
    <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        if (!bl && !zzeh.zzeO().zzP(context)) {
            zzpy.zzbc("Google Play Services is not available");
            bl = true;
        }
        if (bl) {
            t = zza2.zzeL();
            if (t == null) {
                t = zza2.zzeM();
            }
        } else {
            t = zza2.zzeM();
            if (t == null) {
                t = zza2.zzeL();
            }
        }
        return t;
    }

    private void zzc(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzeh.zzeO().zza(context, null, "gmob-apps", bundle, true);
    }

    public zzep zza(final Context context, final zzec zzec2, final String string, final zzjs zzjs2) {
        return this.zza(context, false, new zza<zzep>(){

            public zzep zza(zzes zzes2) throws RemoteException {
                return zzes2.createBannerAdManager(zze.zzA((Object)context), zzec2, string, zzjs2, 10084000);
            }

            public zzep zzeD() {
                zzep zzep2 = zzeg.this.zzzt.zza(context, zzec2, string, zzjs2, 1);
                if (zzep2 != null) {
                    return zzep2;
                }
                zzeg.this.zzc(context, "banner");
                return new zzff();
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeD();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zza(zzes2);
            }
        });
    }

    public zzep zza(final Context context, final zzec zzec2, final String string) {
        return this.zza(context, false, new zza<zzep>(){

            public zzep zza(zzes zzes2) throws RemoteException {
                return zzes2.createSearchAdManager(zze.zzA((Object)context), zzec2, string, 10084000);
            }

            public zzep zzeD() {
                zzep zzep2 = zzeg.this.zzzt.zza(context, zzec2, string, null, 3);
                if (zzep2 != null) {
                    return zzep2;
                }
                zzeg.this.zzc(context, "search");
                return new zzff();
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeD();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zza(zzes2);
            }
        });
    }

    public zzep zzb(final Context context, final zzec zzec2, final String string, final zzjs zzjs2) {
        return this.zza(context, false, new zza<zzep>(){

            public zzep zza(zzes zzes2) throws RemoteException {
                return zzes2.createInterstitialAdManager(zze.zzA((Object)context), zzec2, string, zzjs2, 10084000);
            }

            public zzep zzeD() {
                zzep zzep2 = zzeg.this.zzzt.zza(context, zzec2, string, zzjs2, 2);
                if (zzep2 != null) {
                    return zzep2;
                }
                zzeg.this.zzc(context, "interstitial");
                return new zzff();
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeD();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zza(zzes2);
            }
        });
    }

    public zzen zzb(final Context context, final String string, final zzjs zzjs2) {
        return this.zza(context, false, new zza<zzen>(){

            public zzen zzc(zzes zzes2) throws RemoteException {
                return zzes2.createAdLoaderBuilder(zze.zzA((Object)context), string, zzjs2, 10084000);
            }

            public zzen zzeF() {
                zzen zzen2 = zzeg.this.zzzu.zza(context, string, zzjs2);
                if (zzen2 != null) {
                    return zzen2;
                }
                zzeg.this.zzc(context, "native_ad");
                return new zzfe();
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeF();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zzc(zzes2);
            }
        });
    }

    public zzeu zzk(final Context context) {
        return this.zza(context, false, new zza<zzeu>(){

            public zzeu zzd(zzes zzes2) throws RemoteException {
                return zzes2.getMobileAdsSettingsManagerWithClientJarVersion(zze.zzA((Object)context), 10084000);
            }

            public zzeu zzeG() {
                zzeu zzeu2 = zzeg.this.zzzv.zzl(context);
                if (zzeu2 != null) {
                    return zzeu2;
                }
                zzeg.this.zzc(context, "mobile_ads_settings");
                return new zzfg();
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeG();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zzd(zzes2);
            }
        });
    }

    public zzhb zza(final Context context, final FrameLayout frameLayout, final FrameLayout frameLayout2) {
        return this.zza(context, false, new zza<zzhb>(){

            public zzhb zze(zzes zzes2) throws RemoteException {
                return zzes2.createNativeAdViewDelegate(zze.zzA((Object)frameLayout), zze.zzA((Object)frameLayout2));
            }

            public zzhb zzeH() {
                zzhb zzhb2 = zzeg.this.zzzw.zzb(context, frameLayout, frameLayout2);
                if (zzhb2 != null) {
                    return zzhb2;
                }
                zzeg.this.zzc(context, "native_ad_view_delegate");
                return new zzfh();
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeH();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zze(zzes2);
            }
        });
    }

    public zznr zza(final Context context, final zzjs zzjs2) {
        return this.zza(context, false, new zza<zznr>(){

            public zznr zzf(zzes zzes2) throws RemoteException {
                return zzes2.createRewardedVideoAd(zze.zzA((Object)context), zzjs2, 10084000);
            }

            public zznr zzeI() {
                zznr zznr2 = zzeg.this.zzzx.zzb(context, zzjs2);
                if (zznr2 != null) {
                    return zznr2;
                }
                zzeg.this.zzc(context, "rewarded_video");
                return new zzfi();
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeI();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zzf(zzes2);
            }
        });
    }

    @Nullable
    public zzla zzb(final Activity activity) {
        boolean bl = zzeg.zza(activity, "com.google.android.gms.ads.internal.purchase.useClientJar");
        return this.zza((Context)activity, bl, new zza<zzla>(){

            public zzla zzg(zzes zzes2) throws RemoteException {
                return zzes2.createInAppPurchaseManager(zze.zzA((Object)activity));
            }

            public zzla zzeJ() {
                zzla zzla2 = zzeg.this.zzzy.zzg(activity);
                if (zzla2 != null) {
                    return zzla2;
                }
                zzeg.this.zzc((Context)activity, "iap");
                return null;
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeJ();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zzg(zzes2);
            }
        });
    }

    @Nullable
    public zzkr zzc(final Activity activity) {
        boolean bl = zzeg.zza(activity, "com.google.android.gms.ads.internal.overlay.useClientJar");
        return this.zza((Context)activity, bl, new zza<zzkr>(){

            public zzkr zzh(zzes zzes2) throws RemoteException {
                return zzes2.createAdOverlay(zze.zzA((Object)activity));
            }

            public zzkr zzeK() {
                zzkr zzkr2 = zzeg.this.zzzz.zzf(activity);
                if (zzkr2 != null) {
                    return zzkr2;
                }
                zzeg.this.zzc((Context)activity, "ad_overlay");
                return null;
            }

            @Override
            public /* synthetic */ Object zzeE() throws RemoteException {
                return this.zzeK();
            }

            @Override
            public /* synthetic */ Object zzb(zzes zzes2) throws RemoteException {
                return this.zzh(zzes2);
            }
        });
    }

    private static boolean zza(Activity activity, String string) {
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzpy.e("useClientJar flag not found in activity intent extras.");
            return false;
        }
        return intent.getBooleanExtra(string, false);
    }

    @VisibleForTesting
    abstract class zza<T> {
        zza() {
        }

        @Nullable
        protected abstract T zzb(zzes var1) throws RemoteException;

        @Nullable
        protected abstract T zzeE() throws RemoteException;

        @Nullable
        protected final T zzeL() {
            zzes zzes2 = zzeg.this.zzeC();
            if (zzes2 == null) {
                zzpy.zzbe("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zzb(zzes2);
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzeM() {
            try {
                return this.zzeE();
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

