/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzeb;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzhp;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzpy;

public class AdLoader {
    private final zzeb zzrB;
    private final Context mContext;
    private final zzem zzrC;

    AdLoader(Context context, zzem zzem2) {
        this(context, zzem2, zzeb.zzey());
    }

    AdLoader(Context context, zzem zzem2, zzeb zzeb2) {
        this.mContext = context;
        this.zzrC = zzem2;
        this.zzrB = zzeb2;
    }

    private void zza(zzey zzey2) {
        try {
            this.zzrC.zzf(this.zzrB.zza(this.mContext, zzey2));
        }
        catch (RemoteException remoteException) {
            zzpy.zzb("Failed to load ad.", remoteException);
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzbq());
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzbq());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zzrC.getMediationAdapterClassName();
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzrC.isLoading();
        }
        catch (RemoteException remoteException) {
            zzpy.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzen zzrD;

        public Builder(Context context, String string) {
            this((Context)zzac.zzb((Object)context, (Object)"context cannot be null"), zzeh.zzeP().zzb(context, string, new zzjr()));
        }

        Builder(Context context, zzen zzen2) {
            this.mContext = context;
            this.zzrD = zzen2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzrD.zza(new zzhp(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzrD.zza(new zzho(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzrD.zza(string, new zzhr(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzhq(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzrD.zzb(new zzdv(adListener));
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzrD.zza(new zzgw(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzac.zzw((Object)correlator);
            try {
                this.zzrD.zzb(correlator.zzbr());
            }
            catch (RemoteException remoteException) {
                zzpy.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzrD.zzci());
            }
            catch (RemoteException remoteException) {
                zzpy.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

