/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzf;
import com.google.firebase.iid.zzg;
import com.google.firebase.iid.zzh;
import java.io.IOException;

public class FirebaseInstanceIdService
extends zzb {
    private static BroadcastReceiver zzciU;
    @VisibleForTesting
    static final Object zzciV;
    @VisibleForTesting
    static boolean zzciW;
    private boolean zzciX = false;

    @Override
    public boolean zzH(Intent intent) {
        this.zzciX = Log.isLoggable((String)"FirebaseInstanceId", (int)3);
        if (intent.getStringExtra("error") != null || intent.getStringExtra("registration_id") != null) {
            String string = this.zzJ(intent);
            if (this.zzciX) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            this.zzjx(string).zzaah().zzv(intent);
            return true;
        }
        return false;
    }

    @Override
    public void zzm(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "ACTION_TOKEN_REFRESH_RETRY": {
                this.zza(intent, false, false);
                return;
            }
        }
        this.zzI(intent);
    }

    @Override
    protected Intent zzF(Intent intent) {
        return zzg.zzaaj().zzaak();
    }

    public void zzI(Intent intent) {
        String string = this.zzJ(intent);
        zzd zzd2 = this.zzjx(string);
        String string2 = intent.getStringExtra("CMD");
        if (this.zzciX) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append(string2).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            zzd2.zzaag().zzeO(string == null ? "" : string);
            zzd2.zzaah().zzv(intent);
            return;
        }
        if ("gcm.googleapis.com/refresh".equals(intent.getStringExtra("from"))) {
            zzd2.zzaag().zzeO(string);
            this.zza(intent, false, true);
            return;
        }
        if ("RST".equals(string2)) {
            zzd2.zzGu();
            this.zza(intent, true, true);
        } else if ("RST_FULL".equals(string2)) {
            if (!zzd2.zzaag().isEmpty()) {
                zzd2.zzGu();
                zzd2.zzaag().zzGA();
                this.zza(intent, true, true);
            }
        } else if ("SYNC".equals(string2)) {
            zzd2.zzaag().zzeO(string);
            this.zza(intent, false, true);
        } else if ("PING".equals(string2)) {
            this.zza(zzd2.zzaah(), intent.getExtras());
        }
    }

    private String zzJ(Intent intent) {
        String string = intent.getStringExtra("subtype");
        return string == null ? "" : string;
    }

    private zzd zzjx(String string) {
        if (string == null) {
            return zzd.zzb((Context)this, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("subtype", string);
        return zzd.zzb((Context)this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Intent intent, boolean bl, boolean bl2) {
        Object object = zzciV;
        synchronized (object) {
            zzciW = false;
        }
        if (zzf.zzbi((Context)this) == null) {
            return;
        }
        object = FirebaseInstanceId.getInstance();
        zzh.zza zza2 = ((FirebaseInstanceId)object).zzaad();
        if (zza2 == null || zza2.zzjC(zzd.zzbhg)) {
            try {
                String string = ((FirebaseInstanceId)object).zzaae();
                if (string != null) {
                    if (this.zzciX) {
                        Log.d((String)"FirebaseInstanceId", (String)"get master token succeeded");
                    }
                    FirebaseInstanceIdService.zza((Context)this, (FirebaseInstanceId)object);
                    if (bl2 || zza2 == null || zza2 != null && !string.equals(zza2.zzbwP)) {
                        this.onTokenRefresh();
                    }
                    return;
                }
                this.zzd(intent, "returned token is null");
            }
            catch (IOException iOException) {
                this.zzd(intent, iOException.getMessage());
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseInstanceId", (String)"Unable to get master token", (Throwable)securityException);
                return;
            }
            return;
        }
        zze zze2 = ((FirebaseInstanceId)object).zzaaf();
        String string = zze2.zzaai();
        while (string != null) {
            String[] stringArray = string.split("!");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                try {
                    switch (string2) {
                        case "S": {
                            FirebaseInstanceId.getInstance().zzjv(string3);
                            if (!this.zzciX) break;
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                            break;
                        }
                        case "U": {
                            FirebaseInstanceId.getInstance().zzjw(string3);
                            if (!this.zzciX) break;
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        }
                    }
                }
                catch (IOException iOException) {
                    this.zzd(intent, iOException.getMessage());
                    return;
                }
            }
            zze2.zzjy(string);
            string = zze2.zzaai();
        }
        Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzd(Intent intent, String string) {
        boolean bl = FirebaseInstanceIdService.zzbW((Context)this);
        final int n = this.zza(intent, bl);
        Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(47 + String.valueOf(string).length()).append("background sync failed: ").append(string).append(", retry in ").append(n).append("s").toString());
        Object object = zzciV;
        synchronized (object) {
            this.zzpS(n);
            zzciW = true;
        }
        if (!bl) {
            if (this.zzciX) {
                Log.d((String)"FirebaseInstanceId", (String)"device not connected. Connectivity change received registered");
            }
            if (zzciU == null) {
                zzciU = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (FirebaseInstanceIdService.zzbW(context)) {
                            if (FirebaseInstanceIdService.this.zzciX) {
                                Log.d((String)"FirebaseInstanceId", (String)"connectivity changed. starting background sync.");
                            }
                            FirebaseInstanceIdService.this.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
                            zzg.zzaaj().zzf(context, FirebaseInstanceIdService.zzpR(n));
                        }
                    }
                };
            }
            this.getApplicationContext().registerReceiver(zzciU, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Context context, FirebaseInstanceId firebaseInstanceId) {
        Object object = zzciV;
        synchronized (object) {
            if (zzciW) {
                return;
            }
        }
        object = firebaseInstanceId.zzaad();
        if (object == null || ((zzh.zza)object).zzjC(zzd.zzbhg) || firebaseInstanceId.zzaaf().zzaai() != null) {
            FirebaseInstanceIdService.zzbV(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzbV(Context context) {
        if (zzf.zzbi(context) == null) {
            return;
        }
        Object object = zzciV;
        synchronized (object) {
            if (!zzciW) {
                zzg.zzaaj().zzf(context, FirebaseInstanceIdService.zzpR(0));
                zzciW = true;
            }
        }
    }

    private static Intent zzpR(int n) {
        Intent intent = new Intent("ACTION_TOKEN_REFRESH_RETRY");
        intent.putExtra("next_retry_delay_in_seconds", n);
        return intent;
    }

    private void zzpS(int n) {
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        PendingIntent pendingIntent = zzg.zza((Context)this, 0, FirebaseInstanceIdService.zzpR(n * 2), 0x8000000);
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)(n * 1000), pendingIntent);
    }

    private int zza(Intent intent, boolean bl) {
        int n = intent == null ? 10 : intent.getIntExtra("next_retry_delay_in_seconds", 0);
        if (n < 10 && !bl) {
            n = 30;
        } else if (n < 10) {
            n = 10;
        } else if (n > 28800) {
            n = 28800;
        }
        return n;
    }

    private static boolean zzbW(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private void zza(zzf zzf2, Bundle bundle) {
        String string = zzf.zzbi((Context)this);
        if (string == null) {
            Log.w((String)"FirebaseInstanceId", (String)"Unable to respond to ping due to missing target package");
            return;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.setPackage(string);
        intent.putExtras(bundle);
        zzf2.zzs(intent);
        intent.putExtra("google.to", "google.com/iid");
        intent.putExtra("google.message_id", zzf.zzGz());
        this.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @WorkerThread
    public void onTokenRefresh() {
    }

    static {
        zzciV = new Object();
        zzciW = false;
    }
}

