/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzcz;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzma;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzqp;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
@TargetApi(value=14)
public class zzdb
extends Thread {
    private boolean mStarted = false;
    private boolean zzxD = false;
    private boolean zzak = false;
    private final Object zzrN;
    private final zzcz zzxE;
    private final zzma zzxF;
    private final int zzxG;
    private final int zzxe;
    private final int zzxH;
    private final int zzxg;
    private final int zzxI;
    private final int zzxJ;
    private final int zzxK;
    private final int zzxL;
    private final String zzxM;

    public zzdb(zzcz zzcz2, zzma zzma2) {
        this.zzxE = zzcz2;
        this.zzxF = zzma2;
        this.zzrN = new Object();
        this.zzxe = zzfx.zzBP.get();
        this.zzxH = zzfx.zzBQ.get();
        this.zzxg = zzfx.zzBR.get();
        this.zzxI = zzfx.zzBS.get();
        this.zzxJ = zzfx.zzBV.get();
        this.zzxK = zzfx.zzBX.get();
        this.zzxL = zzfx.zzBY.get();
        this.zzxG = zzfx.zzBT.get();
        this.zzxM = zzfx.zzCa.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzee() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.mStarted) {
                zzpe.zzbc((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            try {
                if (this.zzef()) {
                    object = zzv.zzcM().getActivity();
                    if (object == null) {
                        zzpe.zzbc((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzeh();
                    } else {
                        this.zza((Activity)object);
                    }
                } else {
                    zzpe.zzbc((String)"ContentFetchTask: sleeping");
                    this.zzeh();
                }
                Thread.sleep(this.zzxG * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzpe.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Throwable throwable) {
                zzpe.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzxF.zza(throwable, "ContentFetchTask.run");
            }
            object = this.zzrN;
            synchronized (object) {
                while (this.zzxD) {
                    try {
                        zzpe.zzbc((String)"ContentFetchTask: waiting");
                        this.zzrN.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzh(final @Nullable View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzdb.this.zzi(view);
            }
        });
        return true;
    }

    void zzi(View view) {
        try {
            zzcy zzcy2 = new zzcy(this.zzxe, this.zzxH, this.zzxg, this.zzxI, this.zzxJ, this.zzxK, this.zzxL);
            zza zza2 = this.zza(view, zzcy2);
            zzcy2.zzeb();
            if (zza2.zzxU == 0 && zza2.zzxV == 0) {
                return;
            }
            if (zza2.zzxV == 0 && zzcy2.zzec() == 0) {
                return;
            }
            if (zza2.zzxV == 0 && this.zzxE.zza(zzcy2)) {
                return;
            }
            this.zzxE.zzc(zzcy2);
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzxF.zza(exception, "ContentFetchTask.fetchContent");
        }
    }

    boolean zzh(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzef() {
        try {
            Context context = zzv.zzcM().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzh(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        try {
            if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                view = activity.getWindow().getDecorView().findViewById(0x1020002);
            }
        }
        catch (Throwable throwable) {
            zzpe.zzbc((String)"Failed getting root view of activity. Content not extracted.");
        }
        if (view == null) {
            return;
        }
        this.zzh(view);
    }

    zza zza(@Nullable View view, zzcy zzcy2) {
        if (view == null) {
            return new zza(this, 0, 0);
        }
        Context context = zzv.zzcM().getContext();
        if (context != null) {
            int n = context.getResources().getIdentifier(zzfx.zzBZ.get(), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzxM) && string2 != null && string2.equals(this.zzxM)) {
                return new zza(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzcy2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zza(this, 1, 0);
            }
            return new zza(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzqp)) {
            zzcy2.zzea();
            if (this.zza((WebView)view, zzcy2, bl)) {
                return new zza(this, 0, 1);
            }
            return new zza(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzcy2);
                n += zza2.zzxU;
                n2 += zza2.zzxV;
            }
            return new zza(this, n, n2);
        }
        return new zza(this, 0, 0);
    }

    @TargetApi(value=19)
    boolean zza(final WebView webView, final zzcy zzcy2, final boolean bl) {
        if (!zzs.zzyF()) {
            return false;
        }
        zzcy2.zzea();
        webView.post(new Runnable(){
            ValueCallback<String> zzxP = new ValueCallback<String>(){

                public void zzE(String string2) {
                    zzdb.this.zza(zzcy2, webView, string2, bl);
                }

                public /* synthetic */ void onReceiveValue(Object object) {
                    this.zzE((String)object);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzxP);
                    }
                    catch (Throwable throwable) {
                        this.zzxP.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzcy zzcy2, WebView webView, String string2, boolean bl) {
        zzcy2.zzdZ();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzcy2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzcy2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzcy2.zzdU()) {
                this.zzxE.zzb(zzcy2);
            }
        }
        catch (JSONException jSONException) {
            zzpe.zzbc((String)"Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzpe.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzxF.zza(throwable, "ContentFetchTask.processWebViewContent");
        }
    }

    public zzcy zzeg() {
        return this.zzxE.zzed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzxD = false;
            this.zzrN.notifyAll();
            zzpe.zzbc((String)"ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzeh() {
        Object object = this.zzrN;
        synchronized (object) {
            boolean bl = this.zzxD = true;
            zzpe.zzbc((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
        }
    }

    public boolean zzei() {
        return this.zzxD;
    }

    @zzmb
    class zza {
        final int zzxU;
        final int zzxV;

        zza(zzdb zzdb2, int n, int n2) {
            this.zzxU = n;
            this.zzxV = n2;
        }
    }
}

