/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzapt;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbut;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzzf;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzbc {
    private static final String TAG = zzbc.class.getSimpleName();
    protected Context zzqr;
    protected Context zzqs;
    private ExecutorService zzqt;
    private DexClassLoader zzqu;
    private zzax zzqv;
    private byte[] zzqw;
    private volatile AdvertisingIdClient zzqx = null;
    private volatile boolean zzpX = false;
    private Future zzqy = null;
    private volatile zzaf.zza zzqz = null;
    private Future zzqA = null;
    private volatile boolean zzqB = false;
    protected static final Object zzqC = new Object();
    private zzap zzqD;
    private GoogleApiClient zzqE = null;
    protected boolean zzqF = false;
    protected static final Object zzqG = new Object();
    protected boolean zzqH = false;
    private static zzc zzqI = null;
    protected boolean zzqJ = false;
    private Map<Pair<String, String>, zzbx> zzqK;

    public static zzbc zza(Context context, String string2, String string3, boolean bl) {
        zzbc zzbc2 = new zzbc(context);
        try {
            zzbc2.zzc(string2, string3, bl);
            return zzbc2;
        }
        catch (zzaz zzaz2) {
            return null;
        }
    }

    public Context getContext() {
        return this.zzqr;
    }

    public Context getApplicationContext() {
        return this.zzqs;
    }

    public ExecutorService zzaJ() {
        return this.zzqt;
    }

    public DexClassLoader zzaK() {
        return this.zzqu;
    }

    public zzax zzaL() {
        return this.zzqv;
    }

    public byte[] zzaM() {
        return this.zzqw;
    }

    public GoogleApiClient zzaN() {
        return this.zzqE;
    }

    public boolean zzaO() {
        return this.zzqF;
    }

    public boolean zzaP() {
        return this.zzqJ;
    }

    public zzap zzaQ() {
        return this.zzqD;
    }

    public boolean zzaR() {
        return this.zzqH;
    }

    public zzaf.zza zzaS() {
        return this.zzqz;
    }

    public Future zzaT() {
        return this.zzqA;
    }

    private zzbc(Context context) {
        this.zzqr = context;
        this.zzqs = context.getApplicationContext();
        this.zzqK = new HashMap<Pair<String, String>, zzbx>();
    }

    private boolean zzc(String string2, String string3, boolean bl) throws zzaz {
        this.zzqt = Executors.newCachedThreadPool();
        this.zzc(bl);
        this.zzaY();
        this.zzaV();
        if (zzbe.zzbd() && zzfx.zzDB.get().booleanValue()) {
            throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
        }
        this.zzo(string2);
        this.zzp(string3);
        this.zzqD = new zzap(this);
        return true;
    }

    private void zzo(String string2) throws zzaz {
        this.zzqv = new zzax(null);
        try {
            this.zzqw = this.zzqv.zzn(string2);
        }
        catch (zzax.zza zza2) {
            throw new zzaz(zza2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzp(String string2) throws zzaz {
        try {
            File file = this.zzqr.getCacheDir();
            if (file == null && (file = this.zzqr.getDir("dex", 0)) == null) {
                throw new zzaz();
            }
            String string3 = zzay.zzX();
            File file2 = this.zza(string2, file, string3);
            this.zzb(file, string3);
            try {
                this.zzqu = new DexClassLoader(file2.getAbsolutePath(), file.getAbsolutePath(), null, this.zzqr.getClassLoader());
                this.zza(file2);
                this.zza(file, string3);
            }
            catch (Throwable throwable) {
                this.zza(file2);
                this.zza(file, string3);
                this.zzq(String.format("%s/%s.dex", file, string3));
                throw throwable;
            }
            this.zzq(String.format("%s/%s.dex", file, string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new zzaz(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new zzaz(iOException);
        }
        catch (zzax.zza zza2) {
            throw new zzaz(zza2);
        }
        catch (NullPointerException nullPointerException) {
            throw new zzaz(nullPointerException);
        }
        return true;
    }

    @NonNull
    private File zza(String string2, File file, String string3) throws zzax.zza, IOException {
        File file2 = new File(String.format("%s/%s.jar", file, string3));
        if (!file2.exists()) {
            byte[] byArray = this.zzqv.zzc(this.zzqw, string2);
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zza(File file, String string2) {
        block27: {
            byte[] byArray;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            File file3;
            block26: {
                file3 = new File(String.format("%s/%s.tmp", file, string2));
                if (file3.exists()) {
                    return;
                }
                file2 = new File(String.format("%s/%s.dex", file, string2));
                if (!file2.exists()) {
                    return;
                }
                fileInputStream = null;
                fileOutputStream = null;
                long l = file2.length();
                if (l <= 0L) {
                    return;
                }
                byArray = new byte[(int)l];
                fileInputStream = new FileInputStream(file2);
                int n = fileInputStream.read(byArray);
                if (n > 0) break block26;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                this.zza(file2);
                return;
            }
            zzaf.zzd zzd2 = new zzaf.zzd();
            zzd2.zzcw = Build.VERSION.SDK.getBytes();
            zzd2.zzcv = string2.getBytes();
            byte[] byArray2 = this.zzqv.zzd(this.zzqw, byArray).getBytes();
            zzd2.data = byArray2;
            zzd2.zzcu = zzan.zzh(byArray2);
            file3.createNewFile();
            fileOutputStream = new FileOutputStream(file3);
            byte[] byArray3 = zzbut.zzf((zzbut)zzd2);
            fileOutputStream.write(byArray3, 0, byArray3.length);
            fileOutputStream.close();
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            this.zza(file2);
            break block27;
            catch (zzax.zza | IOException | NoSuchAlgorithmException exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    this.zza(file2);
                    throw throwable;
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                this.zza(file2);
            }
        }
    }

    private void zzq(String string2) {
        File file = new File(string2);
        this.zza(file);
    }

    private void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean zzb(File file, String string2) {
        block32: {
            zzaf.zzd zzd2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block31: {
                byte[] byArray;
                File file3;
                block30: {
                    long l;
                    block29: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block29;
                        this.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    int n = fileInputStream.read(byArray);
                    if (n > 0) break block30;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    this.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                zzd2 = zzaf.zzd.zze((byte[])byArray);
                if (string2.equals(new String(zzd2.zzcv)) && Arrays.equals(zzd2.zzcu, zzan.zzh(zzd2.data)) && Arrays.equals(zzd2.zzcw, Build.VERSION.SDK.getBytes())) break block31;
                this.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzqv.zzc(this.zzqw, new String(zzd2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block32;
            catch (zzax.zza | IOException | NoSuchAlgorithmException exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
        }
        return true;
    }

    public boolean zza(String string2, String string3, List<Class> list) {
        if (!this.zzqK.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzqK.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzbx(this, string2, string3, list));
            return true;
        }
        return false;
    }

    public Method zzc(String string2, String string3) {
        zzbx zzbx2 = this.zzqK.get(new Pair((Object)string2, (Object)string3));
        if (zzbx2 == null) {
            return null;
        }
        return zzbx2.zzbn();
    }

    private void zzc(boolean bl) {
        this.zzpX = bl;
        if (!bl) {
            return;
        }
        this.zzqy = this.zzqt.submit(new Runnable(){

            @Override
            public void run() {
                zzbc.this.zzaU();
            }
        });
    }

    private void zzaU() {
        try {
            if (this.zzqx == null && this.zzqs != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzqs);
                advertisingIdClient.start();
                this.zzqx = advertisingIdClient;
            }
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzqx = null;
        }
    }

    private void zzaV() {
        if (!zzfx.zzDD.get().booleanValue()) {
            return;
        }
        this.zzaW();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaW() {
        Object object = zzqC;
        synchronized (object) {
            if (!this.zzqB) {
                this.zzqA = this.zzqt.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        zzbc.this.zzaX();
                        Object object = zzqC;
                        synchronized (object) {
                            zzbc.this.zzqB = false;
                        }
                    }
                });
                this.zzqB = true;
            }
        }
    }

    private void zzaX() {
        if (this.zzqH) {
            try {
                PackageInfo packageInfo = this.zzqr.getPackageManager().getPackageInfo(this.zzqr.getPackageName(), 0);
                this.zzqz = zzapt.zzi((Context)this.zzqr, (String)this.zzqr.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
    }

    private void zzaY() {
        this.zzqt.execute(new Runnable(){

            @Override
            public void run() {
                zzfx.initialize(zzbc.this.zzqr);
            }
        });
        zzqI = zzc.zzuz();
        this.zzqF = zzqI.zzak(this.zzqr) > 0;
        boolean bl = this.zzqH = zzqI.isGooglePlayServicesAvailable(this.zzqr) == 0;
        if (this.zzqr.getApplicationContext() != null) {
            this.zzqE = new GoogleApiClient.Builder(this.zzqr).addApi(zzzf.API).build();
        }
    }

    public AdvertisingIdClient zzaZ() {
        if (!this.zzpX) {
            return null;
        }
        if (this.zzqx != null) {
            return this.zzqx;
        }
        if (this.zzqy != null) {
            try {
                this.zzqy.get(2000L, TimeUnit.MILLISECONDS);
                this.zzqy = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzqy.cancel(true);
            }
        }
        return this.zzqx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzba() {
        Object object = zzqG;
        synchronized (object) {
            if (this.zzqJ) {
                return;
            }
            if (this.zzqH && this.zzqE != null) {
                this.zzqE.connect();
                this.zzqJ = true;
            } else {
                this.zzqJ = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbb() {
        Object object = zzqG;
        synchronized (object) {
            if (this.zzqJ && this.zzqE != null) {
                this.zzqE.disconnect();
                this.zzqJ = false;
            }
        }
    }

    public int zzT() {
        int n = Integer.MIN_VALUE;
        zzap zzap2 = this.zzaQ();
        if (zzap2 != null) {
            n = zzap2.zzT();
        }
        return n;
    }
}

