/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzqp;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzmu
extends zzpd {
    static final long zzSs = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zztU = new Object();
    static boolean zzSt = false;
    private static zzja zzPU = null;
    private static zzhy zzSu = null;
    private static zzic zzSv = null;
    private static zzhx zzSw = null;
    private final zzmc.zza zzQQ;
    private final zzmh.zza zzQR;
    private final Object zzPr = new Object();
    private final Context mContext;
    private zzja.zzc zzSx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzmu(Context context, zzmh.zza zza2, zzmc.zza zza3) {
        super(true);
        this.zzQQ = zza3;
        this.mContext = context;
        this.zzQR = zza2;
        Object object = zztU;
        synchronized (object) {
            if (!zzSt) {
                zzSv = new zzic();
                zzSu = new zzhy(context.getApplicationContext(), zza2.zzvf);
                zzSw = new zzc();
                zzPU = new zzja(this.mContext.getApplicationContext(), this.zzQR.zzvf, zzfx.zzAR.get(), new zzb(), new zza());
                zzSt = true;
            }
        }
    }

    protected static void zzb(zzix zzix2) {
        zzix2.zza("/loadAd", zzSv);
        zzix2.zza("/fetchHttpRequest", zzSu);
        zzix2.zza("/invalidRequest", zzSw);
    }

    protected static void zzc(zzix zzix2) {
        zzix2.zzb("/loadAd", zzSv);
        zzix2.zzb("/fetchHttpRequest", zzSu);
        zzix2.zzb("/invalidRequest", zzSw);
    }

    @Override
    public void zzcm() {
        zzpe.zzbc((String)"SdkLessAdLoaderBackgroundTask started.");
        zzmh zzmh2 = new zzmh(this.zzQR, null, -1L);
        zzmk zzmk2 = this.zze(zzmh2);
        long l = zzv.zzcP().elapsedRealtime();
        final zzov.zza zza2 = new zzov.zza(zzmh2, zzmk2, null, null, zzmk2.errorCode, l, zzmk2.zzRO, null);
        zzpx.zzXU.post(new Runnable(){

            @Override
            public void run() {
                zzmu.this.zzQQ.zza(zza2);
                if (zzmu.this.zzSx != null) {
                    zzmu.this.zzSx.release();
                    zzmu.this.zzSx = null;
                }
            }
        });
    }

    private zzmk zze(zzmh zzmh2) {
        JSONObject jSONObject;
        final String string2 = zzv.zzcJ().zzkk();
        final JSONObject jSONObject2 = this.zza(zzmh2, string2);
        if (jSONObject2 == null) {
            return new zzmk(0);
        }
        long l = zzv.zzcP().elapsedRealtime();
        Future<JSONObject> future = zzSv.zzab(string2);
        zzpx.zzXU.post(new Runnable(){

            @Override
            public void run() {
                zzmu.this.zzSx = zzPU.zzgv();
                zzmu.this.zzSx.zza(new zzqi.zzc<zzjb>(){

                    public void zzb(zzjb zzjb2) {
                        try {
                            zzjb2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzpe.zzb((String)"Error requesting an ad url", (Throwable)exception);
                            zzSv.zzac(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzd(Object object) {
                        this.zzb((zzjb)object);
                    }
                }, new zzqi.zza(){

                    @Override
                    public void run() {
                        zzSv.zzac(string2);
                    }
                });
            }
        });
        long l2 = zzSs - (zzv.zzcP().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new zzmk(-1);
        }
        catch (TimeoutException timeoutException) {
            return new zzmk(2);
        }
        catch (ExecutionException executionException) {
            return new zzmk(0);
        }
        if (jSONObject == null) {
            return new zzmk(-1);
        }
        zzmk zzmk2 = zzna.zza(this.mContext, zzmh2, jSONObject.toString());
        if (zzmk2.errorCode != -3 && TextUtils.isEmpty((CharSequence)zzmk2.body)) {
            return new zzmk(3);
        }
        return zzmk2;
    }

    private JSONObject zza(zzmh zzmh2, String string2) {
        Bundle bundle = zzmh2.zzRd.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzna.zza(this.mContext, new zzmx().zzf(zzmh2).zza(zzv.zzcS().zzv(this.mContext)));
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzpe.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzv.zzcJ().zzP(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzPr;
        synchronized (object) {
            zzpx.zzXU.post(new Runnable(){

                @Override
                public void run() {
                    if (zzmu.this.zzSx != null) {
                        zzmu.this.zzSx.release();
                        zzmu.this.zzSx = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzpn<zzix> {
        public void zza(zzix zzix2) {
            zzmu.zzc(zzix2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzix)object);
        }
    }

    public static class zzb
    implements zzpn<zzix> {
        public void zza(zzix zzix2) {
            zzmu.zzb(zzix2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzix)object);
        }
    }

    public static class zzc
    implements zzhx {
        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            String string4 = String.valueOf(string3);
            zzpe.zzbe((String)(string4.length() != 0 ? "Invalid request: ".concat(string4) : new String("Invalid request: ")));
            zzSv.zzac(string2);
        }
    }
}

