/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzco;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqp;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzcq
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzrN = new Object();
    private final WeakReference<zzov> zzwb;
    private WeakReference<ViewTreeObserver> zzwc;
    private final zzcx zzwd;
    protected final zzco zzwe;
    private final Context zzvZ;
    private final WindowManager zzwf;
    private final PowerManager zzwg;
    private final KeyguardManager zzwh;
    @Nullable
    private zzcr zzwi;
    private boolean zzwj;
    private boolean zzui = false;
    private boolean zzwk = false;
    private boolean zzwl;
    private boolean zzwm;
    private boolean zzwn;
    @Nullable
    BroadcastReceiver zzwo;
    private final HashSet<Object> zzwp = new HashSet();
    private zzpt zzvK;
    private final HashSet<zzcu> zzwq = new HashSet();

    public zzcq(Context context, zzec zzec2, zzov zzov2, zzqa zzqa2, zzcx zzcx2) {
        this.zzwb = new WeakReference<zzov>(zzov2);
        this.zzwd = zzcx2;
        this.zzwc = new WeakReference<Object>(null);
        this.zzwl = true;
        this.zzwn = false;
        this.zzvK = new zzpt(200L);
        this.zzwe = new zzco(UUID.randomUUID().toString(), zzqa2, zzec2.zzzk, zzov2.zzVp, zzov2.zzdz(), zzec2.zzzn);
        this.zzwf = (WindowManager)context.getSystemService("window");
        this.zzwg = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzwh = (KeyguardManager)context.getSystemService("keyguard");
        this.zzvZ = context;
    }

    protected void zzj(boolean bl) {
        Iterator<Object> iterator = this.zzwp.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdB() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzwo != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzwo = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzcq.this.zzk(3);
                }
            };
            this.zzvZ.registerReceiver(this.zzwo, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdC() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzwo != null) {
                try {
                    this.zzvZ.unregisterReceiver(this.zzwo);
                }
                catch (IllegalStateException illegalStateException) {
                    zzpe.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    zzv.zzcN().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                }
                this.zzwo = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzdH();
            this.zzdC();
            this.zzwl = false;
            this.zzdE();
            this.zzdJ();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzdD() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzwl) {
                this.zzwm = true;
                try {
                    JSONObject jSONObject = this.zzdM();
                    this.zza(jSONObject, true);
                }
                catch (JSONException jSONException) {
                    zzpe.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzpe.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzwe.zzdy());
                zzpe.zzbc((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzk(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzk(int n) {
        Object object = this.zzrN;
        synchronized (object) {
            boolean bl;
            if (!this.zzdK() || !this.zzwl) {
                return;
            }
            View view = this.zzwd.zzdO();
            boolean bl2 = view != null && zzv.zzcJ().zza(view, this.zzwg, this.zzwh) && view.getGlobalVisibleRect(new Rect(), null);
            boolean bl3 = this.zzwd.zzdP();
            if (bl3) {
                this.zzdD();
                return;
            }
            boolean bl4 = bl = n == 1;
            if (bl && !this.zzvK.tryAcquire() && bl2 == this.zzwn) {
                return;
            }
            if (!bl2 && !this.zzwn && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject, false);
                this.zzwn = bl2;
            }
            catch (RuntimeException | JSONException throwable) {
                zzpe.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            this.zzdG();
            this.zzdE();
        }
    }

    protected void zzdE() {
        if (this.zzwi != null) {
            this.zzwi.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzdF() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzwl;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzdG() {
        zzcx zzcx2 = this.zzwd.zzdQ();
        View view = zzcx2.zzdO();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzwc.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzdH();
        if (!this.zzwj || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzwj = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzwc = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzwe.zzdy());
    }

    void zzb(zzqp zzqp2, Map<String, String> map) {
        this.zza(zzqp2.getView(), map);
    }

    void zza(zzcu zzcu2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzwe.zzdy());
        zzpe.zzbc((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzcu2);
    }

    void zzc(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
        this.zzj(bl);
    }

    protected void zzdH() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzwc.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzdI() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzwe.zzdw()).put("activeViewJSON", (Object)this.zzwe.zzdx()).put("timestamp", zzv.zzcP().elapsedRealtime()).put("adFormat", (Object)this.zzwe.zzdv()).put("hashCode", (Object)this.zzwe.zzdy()).put("isMraid", this.zzwe.zzdz()).put("isStopped", this.zzwk).put("isPaused", this.zzui).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzwe.zzdA()).put("appMuted", zzv.zzcJ().zzcq()).put("appVolume", (double)zzv.zzcJ().zzco()).put("deviceVolume", (double)zzv.zzcJ().zzH(this.zzvZ));
        return jSONObject;
    }

    JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    protected void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = this.zza(jSONObject);
            this.zzb(jSONObject2, bl);
        }
        catch (Throwable throwable) {
            zzpe.zzb((String)"Skipping active view message.", (Throwable)throwable);
        }
    }

    public void zza(zzcu zzcu2) {
        if (this.zzwq.isEmpty()) {
            this.zzdB();
            this.zzk(3);
        }
        this.zzwq.add(zzcu2);
        try {
            JSONObject jSONObject = this.zzd(this.zzwd.zzdO());
            JSONObject jSONObject2 = this.zza(jSONObject);
            zzcu2.zzc(jSONObject2, false);
        }
        catch (JSONException jSONException) {
            zzpe.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
        }
    }

    public void zzb(zzcu zzcu2) {
        this.zzwq.remove(zzcu2);
        zzcu2.zzdS();
        if (this.zzwq.isEmpty()) {
            this.destroy();
        }
    }

    protected void zzdJ() {
        ArrayList<zzcu> arrayList = new ArrayList<zzcu>(this.zzwq);
        for (zzcu zzcu2 : arrayList) {
            this.zzb(zzcu2);
        }
    }

    protected void zzb(JSONObject jSONObject, boolean bl) {
        ArrayList<zzcu> arrayList = new ArrayList<zzcu>(this.zzwq);
        for (zzcu zzcu2 : arrayList) {
            zzcu2.zzc(jSONObject, bl);
        }
    }

    protected boolean zzdK() {
        for (zzcu zzcu2 : this.zzwq) {
            if (!zzcu2.zzdR()) continue;
            return true;
        }
        return false;
    }

    protected JSONObject zzdL() throws JSONException {
        return this.zzdI().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(@Nullable View view) throws JSONException {
        if (view == null) {
            return this.zzdL();
        }
        boolean bl = zzv.zzcL().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzpe.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzwf.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzwf.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzdI();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzv.zzcJ().zza(view, this.zzwg, this.zzwh));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzwg.isScreenOn();
    }

    protected JSONObject zzdM() throws JSONException {
        JSONObject jSONObject = this.zzdI();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzk(1);
    }

    public void onGlobalLayout() {
        this.zzk(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzcr zzcr2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzwi = zzcr2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzwk = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzui = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzui = false;
            this.zzk(3);
        }
    }

    public zzco zzdN() {
        return this.zzwe;
    }

    public static class zzb
    implements zzcx {
        private zzgu zzwt;

        public zzb(zzgu zzgu2) {
            this.zzwt = zzgu2;
        }

        @Override
        public View zzdO() {
            return this.zzwt != null ? this.zzwt.zzfV() : null;
        }

        @Override
        public boolean zzdP() {
            return this.zzwt == null;
        }

        @Override
        public zzcx zzdQ() {
            return this;
        }
    }

    public static class zza
    implements zzcx {
        private WeakReference<zzgu> zzws;

        public zza(zzgu zzgu2) {
            this.zzws = new WeakReference<zzgu>(zzgu2);
        }

        @Override
        @Nullable
        public View zzdO() {
            zzgu zzgu2 = (zzgu)this.zzws.get();
            return zzgu2 != null ? zzgu2.zzfV() : null;
        }

        @Override
        public boolean zzdP() {
            return this.zzws.get() == null;
        }

        @Override
        public zzcx zzdQ() {
            return new zzb((zzgu)this.zzws.get());
        }
    }

    public static class zzc
    implements zzcx {
        @Nullable
        private final View mView;
        @Nullable
        private final zzov zzwu;

        public zzc(View view, zzov zzov2) {
            this.mView = view;
            this.zzwu = zzov2;
        }

        @Override
        public View zzdO() {
            return this.mView;
        }

        @Override
        public boolean zzdP() {
            return this.zzwu == null || this.mView == null;
        }

        @Override
        public zzcx zzdQ() {
            return this;
        }
    }

    public static class zzd
    implements zzcx {
        private final WeakReference<View> zzwv;
        private final WeakReference<zzov> zzww;

        public zzd(View view, zzov zzov2) {
            this.zzwv = new WeakReference<View>(view);
            this.zzww = new WeakReference<zzov>(zzov2);
        }

        @Override
        public View zzdO() {
            return (View)this.zzwv.get();
        }

        @Override
        public boolean zzdP() {
            return this.zzwv.get() == null || this.zzww.get() == null;
        }

        @Override
        public zzcx zzdQ() {
            return new zzc((View)this.zzwv.get(), (zzov)this.zzww.get());
        }
    }
}

