/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.util.zzv;

public final class FirebaseOptions {
    private final String zzbUL;
    private final String zzalR;
    private final String zzbUM;
    private final String zzbUN;
    private final String zzbUO;
    private final String zzbUP;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzac.zza((!zzv.zzdD((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzalR = string;
        this.zzbUL = string2;
        this.zzbUM = string3;
        this.zzbUN = string4;
        this.zzbUO = string5;
        this.zzbUP = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzam zzam2 = new zzam(context);
        String string = zzam2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzam2.getString("google_api_key"), zzam2.getString("firebase_database_url"), zzam2.getString("ga_trackingId"), zzam2.getString("gcm_defaultSenderId"), zzam2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.zzbUL;
    }

    public String getApplicationId() {
        return this.zzalR;
    }

    public String getDatabaseUrl() {
        return this.zzbUM;
    }

    public String getGcmSenderId() {
        return this.zzbUO;
    }

    public String getStorageBucket() {
        return this.zzbUP;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzaa.equal((Object)this.zzalR, (Object)firebaseOptions.zzalR) && zzaa.equal((Object)this.zzbUL, (Object)firebaseOptions.zzbUL) && zzaa.equal((Object)this.zzbUM, (Object)firebaseOptions.zzbUM) && zzaa.equal((Object)this.zzbUN, (Object)firebaseOptions.zzbUN) && zzaa.equal((Object)this.zzbUO, (Object)firebaseOptions.zzbUO) && zzaa.equal((Object)this.zzbUP, (Object)firebaseOptions.zzbUP);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzalR, this.zzbUL, this.zzbUM, this.zzbUN, this.zzbUO, this.zzbUP});
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("applicationId", (Object)this.zzalR).zzg("apiKey", (Object)this.zzbUL).zzg("databaseUrl", (Object)this.zzbUM).zzg("gcmSenderId", (Object)this.zzbUO).zzg("storageBucket", (Object)this.zzbUP).toString();
    }

    public static final class Builder {
        private String zzbUL;
        private String zzalR;
        private String zzbUM;
        private String zzbUN;
        private String zzbUO;
        private String zzbUP;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzalR = firebaseOptions.zzalR;
            this.zzbUL = firebaseOptions.zzbUL;
            this.zzbUM = firebaseOptions.zzbUM;
            this.zzbUN = firebaseOptions.zzbUN;
            this.zzbUO = firebaseOptions.zzbUO;
            this.zzbUP = firebaseOptions.zzbUP;
        }

        public Builder setApiKey(@NonNull String string) {
            this.zzbUL = zzac.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.zzalR = zzac.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.zzbUM = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.zzbUO = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.zzbUP = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.zzalR, this.zzbUL, this.zzbUM, this.zzbUN, this.zzbUO, this.zzbUP);
        }
    }
}

