/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.internal.zzabp;
import com.google.android.gms.internal.zzabq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzzx<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzayN = new ThreadLocal<Boolean>(){

        protected Boolean zzvg() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.zzvg();
        }
    };
    private final Object zzayO = new Object();
    protected final zza<R> zzayP;
    protected final WeakReference<GoogleApiClient> zzayQ;
    private final CountDownLatch zzth = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzayR = new ArrayList();
    private ResultCallback<? super R> zzayS;
    private final AtomicReference<zzabq.zzb> zzayT = new AtomicReference();
    private R zzayd;
    private zzb zzayU;
    private volatile boolean zzayV;
    private boolean zzJ;
    private boolean zzayW;
    private zzs zzayX;
    private volatile zzabp<R> zzayY;
    private boolean zzayZ = false;

    @Deprecated
    zzzx() {
        this.zzayP = new zza(Looper.getMainLooper());
        this.zzayQ = new WeakReference<Object>(null);
    }

    protected zzzx(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzayP = new zza(looper);
        this.zzayQ = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzzx(Looper looper) {
        this.zzayP = new zza(looper);
        this.zzayQ = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzth.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzac.zza((this.zzayY == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzth.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzB(Status.zzayi);
        }
        zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzac.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzac.zza((this.zzayY == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzth.await(l, timeUnit);
            if (!bl) {
                this.zzB(Status.zzayk);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzB(Status.zzayi);
        }
        zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzayO;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzayS = null;
                return;
            }
            zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((this.zzayY == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzayP.zza(resultCallback, (R)this.get());
            } else {
                this.zzayS = resultCallback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzayO;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzayS = null;
                return;
            }
            zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((this.zzayY == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzayP.zza(resultCallback, (R)this.get());
            } else {
                this.zzayS = resultCallback;
                this.zzayP.zza(this, timeUnit.toMillis(l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzac.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzayO;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzx(this.zzayd.getStatus());
            } else {
                this.zzayR.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzayO;
        synchronized (object) {
            if (this.zzJ || this.zzayV) {
                return;
            }
            if (this.zzayX != null) {
                try {
                    this.zzayX.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzzx.zzd(this.zzayd);
            this.zzJ = true;
            this.zzc(this.zzc(Status.zzayl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzvc() {
        Object object = this.zzayO;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.zzayQ.get();
            if (googleApiClient == null || !this.zzayZ) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzayO;
        synchronized (object) {
            return this.zzJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzayO;
        synchronized (object) {
            zzac.zza((this.zzayY == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzac.zza((this.zzayS == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            this.zzayZ = true;
            this.zzayY = new zzabp(this.zzayQ);
            TransformedResult<? extends S> transformedResult = this.zzayY.then(resultTransform);
            if (this.isReady()) {
                this.zzayP.zza(this.zzayY, this.get());
            } else {
                this.zzayS = this.zzayY;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(R r) {
        Object object = this.zzayO;
        synchronized (object) {
            if (!this.zzayW && !this.zzJ) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzzx.zzd(r);
                return;
            }
            zzac.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzB(Status status) {
        Object object = this.zzayO;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzb(this.zzc(status));
                this.zzayW = true;
            }
        }
    }

    @NonNull
    protected abstract R zzc(Status var1);

    private void zzvd() {
        zzabq.zzb zzb2 = this.zzayT.getAndSet(null);
        if (zzb2 != null) {
            zzb2.zzc(this);
        }
    }

    public void zza(zzabq.zzb zzb2) {
        this.zzayT.set(zzb2);
    }

    public void zzve() {
        this.setResultCallback(null);
    }

    @Override
    public Integer zzuR() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzs zzs2) {
        Object object = this.zzayO;
        synchronized (object) {
            this.zzayX = zzs2;
        }
    }

    public void zzvf() {
        this.zzayZ = this.zzayZ || zzayN.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.zzayO;
        synchronized (object) {
            zzac.zza((!this.zzayV ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzayd;
            this.zzayd = null;
            this.zzayS = null;
            this.zzayV = true;
        }
        this.zzvd();
        return r;
    }

    private void zzc(R r) {
        this.zzayd = r;
        this.zzayX = null;
        this.zzth.countDown();
        Status status = this.zzayd.getStatus();
        if (this.zzJ) {
            this.zzayS = null;
        } else if (this.zzayS == null) {
            if (this.zzayd instanceof Releasable) {
                this.zzayU = new zzb();
            }
        } else {
            this.zzayP.zzvh();
            this.zzayP.zza(this.zzayS, (R)this.get());
        }
        for (PendingResult.zza zza2 : this.zzayR) {
            zza2.zzx(status);
        }
        this.zzayR.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zzb {
        private zzb() {
        }

        protected void finalize() throws Throwable {
            zzzx.zzd(zzzx.this.zzayd);
            super.finalize();
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzzx<R> zzzx2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzzx2), l);
        }

        public void zzvh() {
            this.removeMessages(2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzzx zzzx2 = (zzzx)message.obj;
                    zzzx2.zzB(Status.zzayk);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzzx.zzd(r);
                throw runtimeException;
            }
        }
    }
}

