/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content.res;

import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.res.ConfigurationHelperGingerbread;
import android.support.v4.content.res.ConfigurationHelperHoneycombMr2;
import android.support.v4.content.res.ConfigurationHelperJellybeanMr1;

public final class ConfigurationHelper {
    private static final ConfigurationHelperImpl IMPL;

    private ConfigurationHelper() {
    }

    public static int getScreenHeightDp(@NonNull Resources resources) {
        return IMPL.getScreenHeightDp(resources);
    }

    public static int getScreenWidthDp(@NonNull Resources resources) {
        return IMPL.getScreenWidthDp(resources);
    }

    public static int getSmallestScreenWidthDp(@NonNull Resources resources) {
        return IMPL.getSmallestScreenWidthDp(resources);
    }

    public static int getDensityDpi(@NonNull Resources resources) {
        return IMPL.getDensityDpi(resources);
    }

    static {
        int sdk = Build.VERSION.SDK_INT;
        IMPL = sdk >= 17 ? new JellybeanMr1Impl() : (sdk >= 13 ? new HoneycombMr2Impl() : new GingerbreadImpl());
    }

    private static class JellybeanMr1Impl
    extends HoneycombMr2Impl {
        JellybeanMr1Impl() {
        }

        @Override
        public int getDensityDpi(@NonNull Resources resources) {
            return ConfigurationHelperJellybeanMr1.getDensityDpi(resources);
        }
    }

    private static class HoneycombMr2Impl
    extends GingerbreadImpl {
        HoneycombMr2Impl() {
        }

        @Override
        public int getScreenHeightDp(@NonNull Resources resources) {
            return ConfigurationHelperHoneycombMr2.getScreenHeightDp(resources);
        }

        @Override
        public int getScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperHoneycombMr2.getScreenWidthDp(resources);
        }

        @Override
        public int getSmallestScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperHoneycombMr2.getSmallestScreenWidthDp(resources);
        }
    }

    private static class GingerbreadImpl
    implements ConfigurationHelperImpl {
        GingerbreadImpl() {
        }

        @Override
        public int getScreenHeightDp(@NonNull Resources resources) {
            return ConfigurationHelperGingerbread.getScreenHeightDp(resources);
        }

        @Override
        public int getScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperGingerbread.getScreenWidthDp(resources);
        }

        @Override
        public int getSmallestScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperGingerbread.getSmallestScreenWidthDp(resources);
        }

        @Override
        public int getDensityDpi(@NonNull Resources resources) {
            return ConfigurationHelperGingerbread.getDensityDpi(resources);
        }
    }

    private static interface ConfigurationHelperImpl {
        public int getScreenHeightDp(@NonNull Resources var1);

        public int getScreenWidthDp(@NonNull Resources var1);

        public int getSmallestScreenWidthDp(@NonNull Resources var1);

        public int getDensityDpi(@NonNull Resources var1);
    }
}

