/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzqp;
import java.util.Map;

@zzmb
public class zzki
extends zzko {
    private final Map<String, String> zzFs;
    private final Context mContext;
    private String zzLk;
    private long zzLl;
    private long zzLm;
    private String zzLn;
    private String zzLo;

    public zzki(zzqp zzqp2, Map<String, String> map) {
        super(zzqp2, "createCalendarEvent");
        this.zzFs = map;
        this.mContext = zzqp2.zzkR();
        this.zzgO();
    }

    private void zzgO() {
        this.zzLk = this.zzav("description");
        this.zzLn = this.zzav("summary");
        this.zzLl = this.zzaw("start_ticks");
        this.zzLm = this.zzaw("end_ticks");
        this.zzLo = this.zzav("location");
    }

    private String zzav(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzFs.get(string2)) ? "" : this.zzFs.get(string2);
    }

    private long zzaw(String string2) {
        String string3 = this.zzFs.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzay("Activity context is not available.");
            return;
        }
        zzfp zzfp2 = zzv.zzcJ().zzC(this.mContext);
        if (!zzfp2.zzfk()) {
            this.zzay("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzv.zzcJ().zzB(this.mContext);
        Resources resources = zzv.zzcN().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_title) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_message) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Intent intent = zzki.this.createIntent();
                zzv.zzcJ().zzb(zzki.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzki.this.zzay("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzLk);
        intent.putExtra("eventLocation", this.zzLo);
        intent.putExtra("description", this.zzLn);
        if (this.zzLl > -1L) {
            intent.putExtra("beginTime", this.zzLl);
        }
        if (this.zzLm > -1L) {
            intent.putExtra("endTime", this.zzLm);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

