/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzbqj;
import com.google.android.gms.internal.zzbqk;
import com.google.android.gms.internal.zzbql;
import com.google.android.gms.internal.zzbqm;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzbUy = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzbUz = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzbUA = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzbUB = Arrays.asList(new String[0]);
    private static final Set<String> zzbUC = Collections.emptySet();
    private static final Object zztU = new Object();
    static final Map<String, FirebaseApp> zzbha = new ArrayMap();
    private final Context zzvZ;
    private final String mName;
    private final FirebaseOptions zzbUD;
    private final AtomicBoolean zzbUE = new AtomicBoolean(false);
    private final AtomicBoolean zzbUF = new AtomicBoolean();
    private final List<zza> zzbUG = new CopyOnWriteArrayList<zza>();
    private final List<zzb> zzbUH = new CopyOnWriteArrayList<zzb>();
    private final List<Object> zzbUI = new CopyOnWriteArrayList<Object>();
    private zzbql zzbUJ;

    @NonNull
    public Context getApplicationContext() {
        this.zzTs();
        return this.zzvZ;
    }

    @NonNull
    public String getName() {
        this.zzTs();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzTs();
        return this.zzbUD;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzbUD).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzbqk zzbqk2 = zzbqk.zzbZ(context);
        Object object = zztU;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzbha.values());
            Set<String> set = zzbqk.zzaap().zzaaq();
            set.removeAll(zzbha.keySet());
            for (String string : set) {
                zzbqk2.zzjD(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zztU;
        synchronized (object) {
            FirebaseApp firebaseApp = zzbha.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = String.valueOf(zzt.zzyK());
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zztU;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzbha.get(FirebaseApp.zzit(string));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzTv();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string2);
            throw new IllegalStateException(string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zztU;
        synchronized (object) {
            if (zzbha.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzbqk zzbqk2 = zzbqk.zzbZ(context);
        FirebaseApp.zzbQ(context);
        String string2 = FirebaseApp.zzit(string);
        Context context2 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = zztU;
        synchronized (object) {
            zzac.zza((!zzbha.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzac.zzb((Object)context2, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context2, string2, firebaseOptions);
            zzbha.put(string2, firebaseApp);
        }
        zzbqk2.zzg(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbUy);
        if (firebaseApp.zzTt()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbUz);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzbUA);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzaQ(boolean bl) {
        Object object = zztU;
        synchronized (object) {
            for (FirebaseApp firebaseApp : new ArrayList<FirebaseApp>(zzbha.values())) {
                if (!firebaseApp.zzbUE.get()) continue;
                firebaseApp.zzaR(bl);
            }
        }
    }

    public void zza(@NonNull zzbql zzbql2) {
        this.zzbUJ = (zzbql)zzac.zzw((Object)zzbql2);
    }

    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzTs();
        if (this.zzbUJ == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzbUJ.zzaS(bl);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzTs();
        boolean bl2 = this.zzbUE.compareAndSet(!bl, bl);
        if (bl2) {
            boolean bl3 = zzbqj.zzaan().zzaao();
            if (bl && bl3) {
                this.zzaR(true);
            } else if (!bl && bl3) {
                this.zzaR(false);
            }
        }
    }

    protected FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zzvZ = (Context)zzac.zzw((Object)context);
        this.mName = zzac.zzdv((String)string);
        this.zzbUD = (FirebaseOptions)zzac.zzw((Object)firebaseOptions);
    }

    private void zzTs() {
        zzac.zza((!this.zzbUF.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public boolean zzTt() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public void zza(@NonNull zzbqm zzbqm2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        for (zza zza2 : this.zzbUG) {
            zza2.zzb(zzbqm2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private void zzaR(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        for (zzb zzb2 : this.zzbUH) {
            zzb2.zzaQ(bl);
        }
    }

    public void zza(@NonNull zza zza2) {
        this.zzTs();
        zzac.zzw((Object)zza2);
        this.zzbUG.add(zza2);
    }

    public void zza(zzb zzb2) {
        this.zzTs();
        if (this.zzbUE.get() && zzbqj.zzaan().zzaao()) {
            zzb2.zzaQ(true);
        }
        this.zzbUH.add(zzb2);
    }

    public String zzTu() {
        String string = String.valueOf(com.google.android.gms.common.util.zzc.zzs((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(com.google.android.gms.common.util.zzc.zzs((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzTv() {
        com.google.android.gms.common.util.zza zza2 = new com.google.android.gms.common.util.zza();
        ArrayList<String> arrayList = zztU;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzbha.values()) {
                zza2.add(firebaseApp.getName());
            }
            zzbqk zzbqk2 = zzbqk.zzaap();
            if (zzbqk2 != null) {
                zza2.addAll(zzbqk2.zzaaq());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zza2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private void zzTw() {
        this.zza(FirebaseApp.class, this, zzbUy);
        if (this.zzTt()) {
            this.zza(FirebaseApp.class, this, zzbUz);
            this.zza(Context.class, this.zzvZ, zzbUA);
        }
    }

    private <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.zzvZ);
        if (bl) {
            zzc.zzbR(this.zzvZ);
        }
        for (String string : iterable) {
            try {
                Class<?> clazz2;
                Method method;
                int n;
                if (bl && !zzbUB.contains(string) || !Modifier.isPublic(n = (method = (clazz2 = Class.forName(string)).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzbUC.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    private static String zzit(@NonNull String string) {
        return string.trim();
    }

    @TargetApi(value=14)
    private static void zzbQ(Context context) {
        if (zzs.zzyA() && context.getApplicationContext() instanceof Application) {
            Application application = (Application)context.getApplicationContext();
            zzbqj.zza(application);
        }
    }

    @TargetApi(value=24)
    private static class zzc
    extends BroadcastReceiver {
        private static AtomicReference<zzc> zzbUK = new AtomicReference();
        private final Context zzvZ;

        public zzc(Context context) {
            this.zzvZ = context;
        }

        private static void zzbR(Context context) {
            zzc zzc2;
            if (zzbUK.get() == null && zzbUK.compareAndSet(null, zzc2 = new zzc(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzc2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = zztU;
            synchronized (object) {
                for (FirebaseApp firebaseApp : zzbha.values()) {
                    firebaseApp.zzTw();
                }
            }
            this.unregister();
        }

        public void unregister() {
            this.zzvZ.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public static interface zzb {
        public void zzaQ(boolean var1);
    }

    public static interface zza {
        public void zzb(@NonNull zzbqm var1);
    }
}

