/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.iid.MessengerCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzd;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class zzf {
    static String zzbhq = null;
    static int zzbhr = 0;
    static int zzbhs = 0;
    static int zzbht = 0;
    Context zzqr;
    Map<String, Object> zzbhu = new HashMap<String, Object>();
    Messenger zzbge;
    Messenger zzbhv;
    MessengerCompat zzbhw;
    PendingIntent zzbga;
    long zzbhx;
    long zzbhy;
    int zzbhz;
    int zzbhA;
    long zzbhB;

    public zzf(Context context) {
        this.zzqr = context;
    }

    public static String zzbi(Context context) {
        ApplicationInfo applicationInfo;
        if (zzbhq != null) {
            return zzbhq;
        }
        zzbhr = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string;
            if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", resolveInfo.serviceInfo.packageName)) {
                try {
                    string = packageManager.getApplicationInfo(resolveInfo.serviceInfo.packageName, 0);
                    int n = ((ApplicationInfo)string).uid;
                    Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(17).append("Found ").append(n).toString());
                    zzbhs = ((ApplicationInfo)string).uid;
                    zzbhq = resolveInfo.serviceInfo.packageName;
                    return zzbhq;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    continue;
                }
            }
            string = String.valueOf(resolveInfo.serviceInfo.packageName);
            String string2 = String.valueOf("com.google.android.c2dm.intent.REGISTER");
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve REGISTER intent, falling back");
        try {
            applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            zzbhq = applicationInfo.packageName;
            zzbhs = applicationInfo.uid;
            return zzbhq;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                applicationInfo = packageManager.getApplicationInfo("com.google.android.gsf", 0);
                zzbhq = applicationInfo.packageName;
                zzbhs = applicationInfo.uid;
                return zzbhq;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                Log.w((String)"InstanceID/Rpc", (String)"Both Google Play Services and legacy GSF package are missing");
                return null;
            }
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return FirebaseInstanceId.zzv(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzGy() {
        if (this.zzbge != null) {
            return;
        }
        zzf.zzbi(this.zzqr);
        this.zzbge = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                zzf.this.zze(message);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzbhw = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzbhv = (Messenger)parcelable;
                }
            }
            this.zzv((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzs(Intent intent) {
        if (this.zzbga == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzbga = PendingIntent.getBroadcast((Context)this.zzqr, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzbga);
    }

    public void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzbhB != 0L && l <= this.zzbhB) {
            long l2 = this.zzbhB - l;
            int n = this.zzbhA;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
            throw new IOException("RETRY_LATER");
        }
        this.zzGy();
        if (zzbhq == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.zzbhx = SystemClock.elapsedRealtime();
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzbhq);
        bundle.putString("gmsv", Integer.toString(FirebaseInstanceId.zzK(this.zzqr, zzf.zzbi(this.zzqr))));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(FirebaseInstanceId.zzbU(this.zzqr)));
        bundle.putString("app_ver_name", FirebaseInstanceId.zzbg(this.zzqr));
        bundle.putString("cliv", "fiid-10084000");
        bundle.putString("appid", FirebaseInstanceId.zza(keyPair));
        String string2 = FirebaseInstanceId.zzbT(this.zzqr);
        if (string2 != null) {
            bundle.putString("gmp_app_id", string2);
        }
        String string3 = FirebaseInstanceId.zzv(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string3);
        bundle.putString("sig", zzf.zza(keyPair, this.zzqr.getPackageName(), string3));
        intent.putExtras(bundle);
        this.zzs(intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        block7: {
            String string2;
            this.zzbhx = SystemClock.elapsedRealtime();
            intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            boolean bl = "com.google.android.gsf".equals(zzbhq);
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                string2 = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            if (bl) {
                this.zzqr.startService(intent);
                return;
            }
            intent.putExtra("google.messenger", (Parcelable)this.zzbge);
            if (this.zzbhv != null || this.zzbhw != null) {
                string2 = Message.obtain();
                ((Message)string2).obj = intent;
                try {
                    if (this.zzbhv != null) {
                        this.zzbhv.send((Message)string2);
                    } else {
                        this.zzbhw.send((Message)string2);
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block7;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        this.zzqr.startService(intent);
    }

    String zzt(Intent intent) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzu(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        String string4 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            if (stringArray.length > 2) {
                string4 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        if (null == string4) {
            this.zzG(string);
        } else {
            this.zzi(string4, string);
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.zzbhy = SystemClock.elapsedRealtime();
            this.zzbhA = (int)l * 1000;
            this.zzbhB = SystemClock.elapsedRealtime() + (long)this.zzbhA;
            int n = this.zzbhA;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzeJ(string);
        }
    }

    private void zzeJ(String string) {
        if (!"com.google.android.gsf".equals(zzbhq)) {
            return;
        }
        ++this.zzbhz;
        if (this.zzbhz < 3) {
            return;
        }
        if (this.zzbhz == 3) {
            this.zzbhA = 1000 + new Random().nextInt(1000);
        }
        this.zzbhA *= 2;
        this.zzbhB = SystemClock.elapsedRealtime() + (long)this.zzbhA;
        int n = this.zzbhA;
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Backoff due to ").append(string).append(" for ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzG(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.zzbhu.keySet()) {
                Object object2 = this.zzbhu.get(string);
                this.zzbhu.put(string, object);
                this.zzh(object2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzbhu.get(string);
            this.zzbhu.put(string, object);
            this.zzh(object2, object);
        }
    }

    private void zzh(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            message.obj = object2;
            try {
                messenger.send(message);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    void zzv(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            this.zzu(intent);
            return;
        }
        this.zzbhx = SystemClock.elapsedRealtime();
        this.zzbhB = 0L;
        this.zzbhz = 0;
        this.zzbhA = 0;
        String string4 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string3);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            string4 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    FirebaseInstanceId.zzbh(this.zzqr);
                } else if ("RST".equals(stringArray[3])) {
                    FirebaseInstanceId.zza(this.zzqr, zzd.zzb(this.zzqr, null).zzaag());
                    intent.removeExtra("registration_id");
                    this.zzi(string4, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (string4 == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Ignoring response without a request ID");
            }
            return;
        }
        this.zzi(string4, intent);
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger") && (intent = this.zzb(bundle, keyPair)) != null && intent.hasExtra("google.messenger")) {
            intent = null;
        }
        return intent;
    }

    public static synchronized String zzGz() {
        return Integer.toString(zzbht++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string = zzf.zzGz();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.zzbhu.put(string, conditionVariable);
        }
        this.zza(bundle, keyPair, string);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.zzbhu.remove(string);
            if (object instanceof Intent) {
                return (Intent)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            String string2 = String.valueOf(object);
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(12 + String.valueOf(string2).length()).append("No response ").append(string2).toString());
            throw new IOException("TIMEOUT");
        }
    }
}

