/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.iid.zzg;

public final class FirebaseInstanceIdReceiver
extends WakefulBroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String string;
        if (this.isOrderedBroadcast()) {
            this.setResultCode(500);
        }
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ((string = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        String string2 = null;
        String string3 = intent.getStringExtra("from");
        if ("com.google.android.c2dm.intent.REGISTRATION".equals(intent.getAction()) || "google.com/iid".equals(string3) || "gcm.googleapis.com/refresh".equals(string3)) {
            string2 = "com.google.firebase.INSTANCE_ID_EVENT";
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(intent.getAction())) {
            string2 = "com.google.firebase.MESSAGING_EVENT";
        } else {
            Log.d((String)"FirebaseInstanceId", (String)"Unexpected intent");
        }
        int n = -1;
        if (string2 != null) {
            n = this.zza(context, string2, intent);
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(n);
        }
    }

    public int zza(Context context, String string, Intent intent) {
        return zzg.zzaaj().zzb(context, string, intent);
    }
}

